/*
 * Decompiled with CFR 0.152.
 */
package Serpent;

import Serpent.Serpent_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class Serpent_Standard {
    static final String NAME = "Serpent_Standard";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err = null;
    static final boolean TRACE = Serpent_Properties.isTraceable("Serpent_Algorithm");
    static final int BLOCK_SIZE = 16;
    static final int ROUNDS = 32;
    static final int PHI = -1640531527;
    static final byte[][] Sbox;
    static final byte[][] SboxInverse;
    static final byte[] IPtable;
    static final byte[] FPtable;
    static final byte xFF = -1;
    static final byte[][] LTtable;
    static final byte[][] LTtableInverse;
    private static final char[] HEX_DIGITS;

    static void debug(String string) {
        ((PrintWriter)null).println(">>> Serpent_Standard: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> Serpent_Standard." + string);
        }
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        int n;
        int[] nArray = new int[132];
        int n2 = 0;
        int n3 = byArray.length / 4;
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
            ++n4;
        }
        if (n4 < 8) {
            nArray[n4++] = 1;
        }
        n4 = 8;
        int n5 = 0;
        while (n4 < 16) {
            n = nArray[n5] ^ nArray[n4 - 5] ^ nArray[n4 - 3] ^ nArray[n4 - 1] ^ 0x9E3779B9 ^ n5++;
            nArray[n4] = n << 11 | n >>> 21;
            ++n4;
        }
        n4 = 0;
        n5 = 8;
        while (n4 < 8) {
            nArray[n4++] = nArray[n5++];
        }
        n3 = 132;
        while (n4 < n3) {
            n = nArray[n4 - 8] ^ nArray[n4 - 5] ^ nArray[n4 - 3] ^ nArray[n4 - 1] ^ 0x9E3779B9 ^ n4;
            nArray[n4] = n << 11 | n >>> 21;
            ++n4;
        }
        int[] nArray2 = new int[n3];
        n4 = 0;
        while (n4 < 33) {
            int n6 = (35 - n4) % 32;
            int n7 = nArray[n4];
            int n8 = nArray[n4 + 33];
            int n9 = nArray[n4 + 66];
            int n10 = nArray[n4 + 99];
            n5 = 0;
            while (n5 < 32) {
                int n11 = n7 >>> n5 & 1 | (n8 >>> n5 & 1) << 1 | (n9 >>> n5 & 1) << 2 | (n10 >>> n5 & 1) << 3;
                int n12 = Sbox[n6][n11] & 0xF;
                int n13 = n4;
                nArray2[n13] = nArray2[n13] | (n12 & 1) << n5;
                int n14 = n4 + 33;
                nArray2[n14] = nArray2[n14] | (n12 >>> 1 & 1) << n5;
                int n15 = n4 + 66;
                nArray2[n15] = nArray2[n15] | (n12 >>> 2 & 1) << n5;
                int n16 = n4 + 99;
                nArray2[n16] = nArray2[n16] | (n12 >>> 3 & 1) << n5;
                ++n5;
            }
            ++n4;
        }
        int[][] nArray3 = new int[33][4];
        n4 = 0;
        n2 = 0;
        while (n4 < 33) {
            nArray3[n4][0] = nArray2[n2++];
            nArray3[n4][1] = nArray2[n2++];
            nArray3[n4][2] = nArray2[n2++];
            nArray3[n4][3] = nArray2[n2++];
            ++n4;
        }
        n4 = 0;
        while (n4 < 33) {
            int[] nArray4 = nArray3[n4];
            nArray3[n4] = Serpent_Standard.permutate(IPtable, nArray4);
            ++n4;
        }
        return nArray3;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        int[][] nArray = (int[][])object;
        int[] nArray2 = new int[]{byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24};
        int[] nArray3 = Serpent_Standard.permutate(IPtable, nArray2);
        int n2 = 0;
        while (n2 < 32) {
            nArray3 = Serpent_Standard.R(n2, nArray3, nArray);
            ++n2;
        }
        nArray2 = Serpent_Standard.permutate(FPtable, nArray3);
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        byte[] byArray2 = new byte[]{(byte)n3, (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24), (byte)n4, (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)n5, (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24), (byte)n6, (byte)(n6 >>> 8), (byte)(n6 >>> 16), (byte)(n6 >>> 24)};
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        int[][] nArray = (int[][])object;
        int[] nArray2 = new int[]{byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24, byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24};
        int[] nArray3 = Serpent_Standard.permutate(IPtable, nArray2);
        int n2 = 31;
        while (n2 >= 0) {
            nArray3 = Serpent_Standard.Rinverse(n2, nArray3, nArray);
            --n2;
        }
        nArray2 = Serpent_Standard.permutate(FPtable, nArray3);
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        byte[] byArray2 = new byte[]{(byte)n3, (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24), (byte)n4, (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)n5, (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24), (byte)n6, (byte)(n6 >>> 8), (byte)(n6 >>> 16), (byte)(n6 >>> 24)};
        return byArray2;
    }

    private static int getBit(int n, int n2) {
        return n >>> n2 & 1;
    }

    private static int getBit(int[] nArray, int n) {
        return nArray[n / 32] >>> n % 32 & 1;
    }

    private static void setBit(int[] nArray, int n, int n2) {
        if ((n2 & 1) == 1) {
            int n3 = n / 32;
            nArray[n3] = nArray[n3] | 1 << n % 32;
            return;
        }
        int n4 = n / 32;
        nArray[n4] = nArray[n4] & ~(1 << n % 32);
    }

    private static int getNibble(int n, int n2) {
        return n >>> 4 * n2 & 0xF;
    }

    private static int[] IP(int[] nArray) {
        return Serpent_Standard.permutate(IPtable, nArray);
    }

    private static int[] IPinverse(int[] nArray) {
        return Serpent_Standard.permutate(FPtable, nArray);
    }

    private static int[] FP(int[] nArray) {
        return Serpent_Standard.permutate(FPtable, nArray);
    }

    private static int[] FPinverse(int[] nArray) {
        return Serpent_Standard.permutate(IPtable, nArray);
    }

    private static int[] permutate(byte[] byArray, int[] nArray) {
        int[] nArray2 = new int[4];
        int n = 0;
        while (n < 128) {
            int n2 = byArray[n] & 0x7F;
            Serpent_Standard.setBit(nArray2, n, nArray[n2 / 32] >>> n2 % 32 & 1);
            ++n;
        }
        return nArray2;
    }

    private static int[] xor128(int[] nArray, int[] nArray2) {
        return new int[]{nArray[0] ^ nArray2[0], nArray[1] ^ nArray2[1], nArray[2] ^ nArray2[2], nArray[3] ^ nArray2[3]};
    }

    private static int S(int n, int n2) {
        return Sbox[n][n2] & 0xF;
    }

    private static int Sinverse(int n, int n2) {
        return SboxInverse[n][n2] & 0xF;
    }

    private static int[] Shat(int n, int[] nArray) {
        int[] nArray2 = new int[4];
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 8) {
                int n4 = n2;
                int n5 = nArray[n2];
                n5 = n5 >>> 4 * n3 & 0xF;
                nArray2[n4] = nArray2[n4] | (Sbox[n][n5] & 0xF) << n3 * 4;
                ++n3;
            }
            ++n2;
        }
        return nArray2;
    }

    private static int[] ShatInverse(int n, int[] nArray) {
        int[] nArray2 = new int[4];
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 8) {
                int n4 = n2;
                int n5 = nArray[n2];
                n5 = n5 >>> 4 * n3 & 0xF;
                nArray2[n4] = nArray2[n4] | (SboxInverse[n][n5] & 0xF) << n3 * 4;
                ++n3;
            }
            ++n2;
        }
        return nArray2;
    }

    private static int[] LT(int[] nArray) {
        return Serpent_Standard.transform(LTtable, nArray);
    }

    private static int[] LTinverse(int[] nArray) {
        return Serpent_Standard.transform(LTtableInverse, nArray);
    }

    private static int[] transform(byte[][] byArray, int[] nArray) {
        int[] nArray2 = new int[4];
        int n = 0;
        while (n < 128) {
            int n2 = 0;
            int n3 = 0;
            while (byArray[n][n3] != -1) {
                int n4 = byArray[n][n3] & 0x7F;
                n2 ^= nArray[n4 / 32] >>> n4 % 32 & 1;
                ++n3;
            }
            Serpent_Standard.setBit(nArray2, n, n2);
            ++n;
        }
        return nArray2;
    }

    private static int[] R(int n, int[] nArray, int[][] nArray2) {
        int[] nArray3;
        int[] nArray4 = Serpent_Standard.xor128(nArray, nArray2[n]);
        int[] nArray5 = Serpent_Standard.Shat(n, nArray4);
        if (n >= 0 && n <= 30) {
            nArray3 = Serpent_Standard.transform(LTtable, nArray5);
        } else if (n == 31) {
            nArray3 = Serpent_Standard.xor128(nArray5, nArray2[32]);
        } else {
            throw new RuntimeException("Round " + n + " is out of 0.." + 31 + " range");
        }
        return nArray3;
    }

    private static int[] Rinverse(int n, int[] nArray, int[][] nArray2) {
        int[] nArray3 = new int[4];
        if (n >= 0 && n <= 30) {
            nArray3 = Serpent_Standard.transform(LTtableInverse, nArray);
        } else if (n == 31) {
            nArray3 = Serpent_Standard.xor128(nArray, nArray2[32]);
        } else {
            throw new RuntimeException("Round " + n + " is out of 0.." + 31 + " range");
        }
        int[] nArray4 = Serpent_Standard.ShatInverse(n, nArray3);
        int[] nArray5 = Serpent_Standard.xor128(nArray4, nArray2[n]);
        return nArray5;
    }

    public static String intToString(int n) {
        char[] cArray = new char[8];
        int n2 = 7;
        while (n2 >= 0) {
            cArray[n2] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    private static String toString(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n * 8];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = nArray[n2];
            cArray[n3++] = HEX_DIGITS[n4 >>> 28 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 24 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 20 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 16 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 12 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 8 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 & 0xF];
            ++n2;
        }
        return new String(cArray);
    }

    public static String toReversedString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            byte by = byArray[n2--];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    private static String toReversedString(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n * 8];
        int n2 = n - 1;
        int n3 = 0;
        while (n2 >= 0) {
            int n4 = nArray[n2];
            cArray[n3++] = HEX_DIGITS[n4 >>> 28 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 24 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 20 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 16 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 12 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 8 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 & 0xF];
            --n2;
        }
        return new String(cArray);
    }

    /*
     * Opcode count of 14700 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        byte[][] byArrayArray = new byte[32][];
        byte[] byArray = new byte[16];
        byArray[0] = 14;
        byArray[1] = 4;
        byArray[2] = 13;
        byArray[3] = 1;
        byArray[4] = 2;
        byArray[5] = 15;
        byArray[6] = 11;
        byArray[7] = 8;
        byArray[8] = 3;
        byArray[9] = 10;
        byArray[10] = 6;
        byArray[11] = 12;
        byArray[12] = 5;
        byArray[13] = 9;
        byArray[15] = 7;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[1] = 15;
        byArray2[2] = 7;
        byArray2[3] = 4;
        byArray2[4] = 14;
        byArray2[5] = 2;
        byArray2[6] = 13;
        byArray2[7] = 1;
        byArray2[8] = 10;
        byArray2[9] = 6;
        byArray2[10] = 12;
        byArray2[11] = 11;
        byArray2[12] = 9;
        byArray2[13] = 5;
        byArray2[14] = 3;
        byArray2[15] = 8;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = 4;
        byArray3[1] = 1;
        byArray3[2] = 14;
        byArray3[3] = 8;
        byArray3[4] = 13;
        byArray3[5] = 6;
        byArray3[6] = 2;
        byArray3[7] = 11;
        byArray3[8] = 15;
        byArray3[9] = 12;
        byArray3[10] = 9;
        byArray3[11] = 7;
        byArray3[12] = 3;
        byArray3[13] = 10;
        byArray3[14] = 5;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[16];
        byArray4[0] = 15;
        byArray4[1] = 12;
        byArray4[2] = 8;
        byArray4[3] = 2;
        byArray4[4] = 4;
        byArray4[5] = 9;
        byArray4[6] = 1;
        byArray4[7] = 7;
        byArray4[8] = 5;
        byArray4[9] = 11;
        byArray4[10] = 3;
        byArray4[11] = 14;
        byArray4[12] = 10;
        byArray4[14] = 6;
        byArray4[15] = 13;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[16];
        byArray5[0] = 15;
        byArray5[1] = 1;
        byArray5[2] = 8;
        byArray5[3] = 14;
        byArray5[4] = 6;
        byArray5[5] = 11;
        byArray5[6] = 3;
        byArray5[7] = 4;
        byArray5[8] = 9;
        byArray5[9] = 7;
        byArray5[10] = 2;
        byArray5[11] = 13;
        byArray5[12] = 12;
        byArray5[14] = 5;
        byArray5[15] = 10;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[16];
        byArray6[0] = 3;
        byArray6[1] = 13;
        byArray6[2] = 4;
        byArray6[3] = 7;
        byArray6[4] = 15;
        byArray6[5] = 2;
        byArray6[6] = 8;
        byArray6[7] = 14;
        byArray6[8] = 12;
        byArray6[10] = 1;
        byArray6[11] = 10;
        byArray6[12] = 6;
        byArray6[13] = 9;
        byArray6[14] = 11;
        byArray6[15] = 5;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[16];
        byArray7[1] = 14;
        byArray7[2] = 7;
        byArray7[3] = 11;
        byArray7[4] = 10;
        byArray7[5] = 4;
        byArray7[6] = 13;
        byArray7[7] = 1;
        byArray7[8] = 5;
        byArray7[9] = 8;
        byArray7[10] = 12;
        byArray7[11] = 6;
        byArray7[12] = 9;
        byArray7[13] = 3;
        byArray7[14] = 2;
        byArray7[15] = 15;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[16];
        byArray8[0] = 13;
        byArray8[1] = 8;
        byArray8[2] = 10;
        byArray8[3] = 1;
        byArray8[4] = 3;
        byArray8[5] = 15;
        byArray8[6] = 4;
        byArray8[7] = 2;
        byArray8[8] = 11;
        byArray8[9] = 6;
        byArray8[10] = 7;
        byArray8[11] = 12;
        byArray8[13] = 5;
        byArray8[14] = 14;
        byArray8[15] = 9;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[16];
        byArray9[0] = 10;
        byArray9[2] = 9;
        byArray9[3] = 14;
        byArray9[4] = 6;
        byArray9[5] = 3;
        byArray9[6] = 15;
        byArray9[7] = 5;
        byArray9[8] = 1;
        byArray9[9] = 13;
        byArray9[10] = 12;
        byArray9[11] = 7;
        byArray9[12] = 11;
        byArray9[13] = 4;
        byArray9[14] = 2;
        byArray9[15] = 8;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[16];
        byArray10[0] = 13;
        byArray10[1] = 7;
        byArray10[3] = 9;
        byArray10[4] = 3;
        byArray10[5] = 4;
        byArray10[6] = 6;
        byArray10[7] = 10;
        byArray10[8] = 2;
        byArray10[9] = 8;
        byArray10[10] = 5;
        byArray10[11] = 14;
        byArray10[12] = 12;
        byArray10[13] = 11;
        byArray10[14] = 15;
        byArray10[15] = 1;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[16];
        byArray11[0] = 13;
        byArray11[1] = 6;
        byArray11[2] = 4;
        byArray11[3] = 9;
        byArray11[4] = 8;
        byArray11[5] = 15;
        byArray11[6] = 3;
        byArray11[8] = 11;
        byArray11[9] = 1;
        byArray11[10] = 2;
        byArray11[11] = 12;
        byArray11[12] = 5;
        byArray11[13] = 10;
        byArray11[14] = 14;
        byArray11[15] = 7;
        byArrayArray[10] = byArray11;
        byte[] byArray12 = new byte[16];
        byArray12[0] = 1;
        byArray12[1] = 10;
        byArray12[2] = 13;
        byArray12[4] = 6;
        byArray12[5] = 9;
        byArray12[6] = 8;
        byArray12[7] = 7;
        byArray12[8] = 4;
        byArray12[9] = 15;
        byArray12[10] = 14;
        byArray12[11] = 3;
        byArray12[12] = 11;
        byArray12[13] = 5;
        byArray12[14] = 2;
        byArray12[15] = 12;
        byArrayArray[11] = byArray12;
        byte[] byArray13 = new byte[16];
        byArray13[0] = 7;
        byArray13[1] = 13;
        byArray13[2] = 14;
        byArray13[3] = 3;
        byArray13[5] = 6;
        byArray13[6] = 9;
        byArray13[7] = 10;
        byArray13[8] = 1;
        byArray13[9] = 2;
        byArray13[10] = 8;
        byArray13[11] = 5;
        byArray13[12] = 11;
        byArray13[13] = 12;
        byArray13[14] = 4;
        byArray13[15] = 15;
        byArrayArray[12] = byArray13;
        byte[] byArray14 = new byte[16];
        byArray14[0] = 13;
        byArray14[1] = 8;
        byArray14[2] = 11;
        byArray14[3] = 5;
        byArray14[4] = 6;
        byArray14[5] = 15;
        byArray14[7] = 3;
        byArray14[8] = 4;
        byArray14[9] = 7;
        byArray14[10] = 2;
        byArray14[11] = 12;
        byArray14[12] = 1;
        byArray14[13] = 10;
        byArray14[14] = 14;
        byArray14[15] = 9;
        byArrayArray[13] = byArray14;
        byte[] byArray15 = new byte[16];
        byArray15[0] = 10;
        byArray15[1] = 6;
        byArray15[2] = 9;
        byArray15[4] = 12;
        byArray15[5] = 11;
        byArray15[6] = 7;
        byArray15[7] = 13;
        byArray15[8] = 15;
        byArray15[9] = 1;
        byArray15[10] = 3;
        byArray15[11] = 14;
        byArray15[12] = 5;
        byArray15[13] = 2;
        byArray15[14] = 8;
        byArray15[15] = 4;
        byArrayArray[14] = byArray15;
        byte[] byArray16 = new byte[16];
        byArray16[0] = 3;
        byArray16[1] = 15;
        byArray16[3] = 6;
        byArray16[4] = 10;
        byArray16[5] = 1;
        byArray16[6] = 13;
        byArray16[7] = 8;
        byArray16[8] = 9;
        byArray16[9] = 4;
        byArray16[10] = 5;
        byArray16[11] = 11;
        byArray16[12] = 12;
        byArray16[13] = 7;
        byArray16[14] = 2;
        byArray16[15] = 14;
        byArrayArray[15] = byArray16;
        byte[] byArray17 = new byte[16];
        byArray17[0] = 2;
        byArray17[1] = 12;
        byArray17[2] = 4;
        byArray17[3] = 1;
        byArray17[4] = 7;
        byArray17[5] = 10;
        byArray17[6] = 11;
        byArray17[7] = 6;
        byArray17[8] = 8;
        byArray17[9] = 5;
        byArray17[10] = 3;
        byArray17[11] = 15;
        byArray17[12] = 13;
        byArray17[14] = 14;
        byArray17[15] = 9;
        byArrayArray[16] = byArray17;
        byte[] byArray18 = new byte[16];
        byArray18[0] = 14;
        byArray18[1] = 11;
        byArray18[2] = 2;
        byArray18[3] = 12;
        byArray18[4] = 4;
        byArray18[5] = 7;
        byArray18[6] = 13;
        byArray18[7] = 1;
        byArray18[8] = 5;
        byArray18[10] = 15;
        byArray18[11] = 10;
        byArray18[12] = 3;
        byArray18[13] = 9;
        byArray18[14] = 8;
        byArray18[15] = 6;
        byArrayArray[17] = byArray18;
        byte[] byArray19 = new byte[16];
        byArray19[0] = 4;
        byArray19[1] = 2;
        byArray19[2] = 1;
        byArray19[3] = 11;
        byArray19[4] = 10;
        byArray19[5] = 13;
        byArray19[6] = 7;
        byArray19[7] = 8;
        byArray19[8] = 15;
        byArray19[9] = 9;
        byArray19[10] = 12;
        byArray19[11] = 5;
        byArray19[12] = 6;
        byArray19[13] = 3;
        byArray19[15] = 14;
        byArrayArray[18] = byArray19;
        byte[] byArray20 = new byte[16];
        byArray20[0] = 11;
        byArray20[1] = 8;
        byArray20[2] = 12;
        byArray20[3] = 7;
        byArray20[4] = 1;
        byArray20[5] = 14;
        byArray20[6] = 2;
        byArray20[7] = 13;
        byArray20[8] = 6;
        byArray20[9] = 15;
        byArray20[11] = 9;
        byArray20[12] = 10;
        byArray20[13] = 4;
        byArray20[14] = 5;
        byArray20[15] = 3;
        byArrayArray[19] = byArray20;
        byte[] byArray21 = new byte[16];
        byArray21[0] = 12;
        byArray21[1] = 1;
        byArray21[2] = 10;
        byArray21[3] = 15;
        byArray21[4] = 9;
        byArray21[5] = 2;
        byArray21[6] = 6;
        byArray21[7] = 8;
        byArray21[9] = 13;
        byArray21[10] = 3;
        byArray21[11] = 4;
        byArray21[12] = 14;
        byArray21[13] = 7;
        byArray21[14] = 5;
        byArray21[15] = 11;
        byArrayArray[20] = byArray21;
        byte[] byArray22 = new byte[16];
        byArray22[0] = 10;
        byArray22[1] = 15;
        byArray22[2] = 4;
        byArray22[3] = 2;
        byArray22[4] = 7;
        byArray22[5] = 12;
        byArray22[6] = 9;
        byArray22[7] = 5;
        byArray22[8] = 6;
        byArray22[9] = 1;
        byArray22[10] = 13;
        byArray22[11] = 14;
        byArray22[13] = 11;
        byArray22[14] = 3;
        byArray22[15] = 8;
        byArrayArray[21] = byArray22;
        byte[] byArray23 = new byte[16];
        byArray23[0] = 9;
        byArray23[1] = 14;
        byArray23[2] = 15;
        byArray23[3] = 5;
        byArray23[4] = 2;
        byArray23[5] = 8;
        byArray23[6] = 12;
        byArray23[7] = 3;
        byArray23[8] = 7;
        byArray23[10] = 4;
        byArray23[11] = 10;
        byArray23[12] = 1;
        byArray23[13] = 13;
        byArray23[14] = 11;
        byArray23[15] = 6;
        byArrayArray[22] = byArray23;
        byte[] byArray24 = new byte[16];
        byArray24[0] = 4;
        byArray24[1] = 3;
        byArray24[2] = 2;
        byArray24[3] = 12;
        byArray24[4] = 9;
        byArray24[5] = 5;
        byArray24[6] = 15;
        byArray24[7] = 10;
        byArray24[8] = 11;
        byArray24[9] = 14;
        byArray24[10] = 1;
        byArray24[11] = 7;
        byArray24[12] = 6;
        byArray24[14] = 8;
        byArray24[15] = 13;
        byArrayArray[23] = byArray24;
        byte[] byArray25 = new byte[16];
        byArray25[0] = 4;
        byArray25[1] = 11;
        byArray25[2] = 2;
        byArray25[3] = 14;
        byArray25[4] = 15;
        byArray25[6] = 8;
        byArray25[7] = 13;
        byArray25[8] = 3;
        byArray25[9] = 12;
        byArray25[10] = 9;
        byArray25[11] = 7;
        byArray25[12] = 5;
        byArray25[13] = 10;
        byArray25[14] = 6;
        byArray25[15] = 1;
        byArrayArray[24] = byArray25;
        byte[] byArray26 = new byte[16];
        byArray26[0] = 13;
        byArray26[2] = 11;
        byArray26[3] = 7;
        byArray26[4] = 4;
        byArray26[5] = 9;
        byArray26[6] = 1;
        byArray26[7] = 10;
        byArray26[8] = 14;
        byArray26[9] = 3;
        byArray26[10] = 5;
        byArray26[11] = 12;
        byArray26[12] = 2;
        byArray26[13] = 15;
        byArray26[14] = 8;
        byArray26[15] = 6;
        byArrayArray[25] = byArray26;
        byte[] byArray27 = new byte[16];
        byArray27[0] = 1;
        byArray27[1] = 4;
        byArray27[2] = 11;
        byArray27[3] = 13;
        byArray27[4] = 12;
        byArray27[5] = 3;
        byArray27[6] = 7;
        byArray27[7] = 14;
        byArray27[8] = 10;
        byArray27[9] = 15;
        byArray27[10] = 6;
        byArray27[11] = 8;
        byArray27[13] = 5;
        byArray27[14] = 9;
        byArray27[15] = 2;
        byArrayArray[26] = byArray27;
        byte[] byArray28 = new byte[16];
        byArray28[0] = 6;
        byArray28[1] = 11;
        byArray28[2] = 13;
        byArray28[3] = 8;
        byArray28[4] = 1;
        byArray28[5] = 4;
        byArray28[6] = 10;
        byArray28[7] = 7;
        byArray28[8] = 9;
        byArray28[9] = 5;
        byArray28[11] = 15;
        byArray28[12] = 14;
        byArray28[13] = 2;
        byArray28[14] = 3;
        byArray28[15] = 12;
        byArrayArray[27] = byArray28;
        byte[] byArray29 = new byte[16];
        byArray29[0] = 13;
        byArray29[1] = 2;
        byArray29[2] = 8;
        byArray29[3] = 4;
        byArray29[4] = 6;
        byArray29[5] = 15;
        byArray29[6] = 11;
        byArray29[7] = 1;
        byArray29[8] = 10;
        byArray29[9] = 9;
        byArray29[10] = 3;
        byArray29[11] = 14;
        byArray29[12] = 5;
        byArray29[14] = 12;
        byArray29[15] = 7;
        byArrayArray[28] = byArray29;
        byte[] byArray30 = new byte[16];
        byArray30[0] = 1;
        byArray30[1] = 15;
        byArray30[2] = 13;
        byArray30[3] = 8;
        byArray30[4] = 10;
        byArray30[5] = 3;
        byArray30[6] = 7;
        byArray30[7] = 4;
        byArray30[8] = 12;
        byArray30[9] = 5;
        byArray30[10] = 6;
        byArray30[11] = 11;
        byArray30[13] = 14;
        byArray30[14] = 9;
        byArray30[15] = 2;
        byArrayArray[29] = byArray30;
        byte[] byArray31 = new byte[16];
        byArray31[0] = 7;
        byArray31[1] = 11;
        byArray31[2] = 4;
        byArray31[3] = 1;
        byArray31[4] = 9;
        byArray31[5] = 12;
        byArray31[6] = 14;
        byArray31[7] = 2;
        byArray31[9] = 6;
        byArray31[10] = 10;
        byArray31[11] = 13;
        byArray31[12] = 15;
        byArray31[13] = 3;
        byArray31[14] = 5;
        byArray31[15] = 8;
        byArrayArray[30] = byArray31;
        byte[] byArray32 = new byte[16];
        byArray32[0] = 2;
        byArray32[1] = 1;
        byArray32[2] = 14;
        byArray32[3] = 7;
        byArray32[4] = 4;
        byArray32[5] = 10;
        byArray32[6] = 8;
        byArray32[7] = 13;
        byArray32[8] = 15;
        byArray32[9] = 12;
        byArray32[10] = 9;
        byArray32[12] = 3;
        byArray32[13] = 5;
        byArray32[14] = 6;
        byArray32[15] = 11;
        byArrayArray[31] = byArray32;
        Sbox = byArrayArray;
        byte[][] byArrayArray2 = new byte[32][];
        byte[] byArray33 = new byte[16];
        byArray33[0] = 14;
        byArray33[1] = 3;
        byArray33[2] = 4;
        byArray33[3] = 8;
        byArray33[4] = 1;
        byArray33[5] = 12;
        byArray33[6] = 10;
        byArray33[7] = 15;
        byArray33[8] = 7;
        byArray33[9] = 13;
        byArray33[10] = 9;
        byArray33[11] = 6;
        byArray33[12] = 11;
        byArray33[13] = 2;
        byArray33[15] = 5;
        byArrayArray2[0] = byArray33;
        byte[] byArray34 = new byte[16];
        byArray34[1] = 7;
        byArray34[2] = 5;
        byArray34[3] = 14;
        byArray34[4] = 3;
        byArray34[5] = 13;
        byArray34[6] = 9;
        byArray34[7] = 2;
        byArray34[8] = 15;
        byArray34[9] = 12;
        byArray34[10] = 8;
        byArray34[11] = 11;
        byArray34[12] = 10;
        byArray34[13] = 6;
        byArray34[14] = 4;
        byArray34[15] = 1;
        byArrayArray2[1] = byArray34;
        byte[] byArray35 = new byte[16];
        byArray35[0] = 15;
        byArray35[1] = 1;
        byArray35[2] = 6;
        byArray35[3] = 12;
        byArray35[5] = 14;
        byArray35[6] = 5;
        byArray35[7] = 11;
        byArray35[8] = 3;
        byArray35[9] = 10;
        byArray35[10] = 13;
        byArray35[11] = 7;
        byArray35[12] = 9;
        byArray35[13] = 4;
        byArray35[14] = 2;
        byArray35[15] = 8;
        byArrayArray2[2] = byArray35;
        byte[] byArray36 = new byte[16];
        byArray36[0] = 13;
        byArray36[1] = 6;
        byArray36[2] = 3;
        byArray36[3] = 10;
        byArray36[4] = 4;
        byArray36[5] = 8;
        byArray36[6] = 14;
        byArray36[7] = 7;
        byArray36[8] = 2;
        byArray36[9] = 5;
        byArray36[10] = 12;
        byArray36[11] = 9;
        byArray36[12] = 1;
        byArray36[13] = 15;
        byArray36[14] = 11;
        byArrayArray2[3] = byArray36;
        byte[] byArray37 = new byte[16];
        byArray37[0] = 13;
        byArray37[1] = 1;
        byArray37[2] = 10;
        byArray37[3] = 6;
        byArray37[4] = 7;
        byArray37[5] = 14;
        byArray37[6] = 4;
        byArray37[7] = 9;
        byArray37[8] = 2;
        byArray37[9] = 8;
        byArray37[10] = 15;
        byArray37[11] = 5;
        byArray37[12] = 12;
        byArray37[13] = 11;
        byArray37[14] = 3;
        byArrayArray2[4] = byArray37;
        byte[] byArray38 = new byte[16];
        byArray38[0] = 9;
        byArray38[1] = 10;
        byArray38[2] = 5;
        byArray38[4] = 2;
        byArray38[5] = 15;
        byArray38[6] = 12;
        byArray38[7] = 3;
        byArray38[8] = 6;
        byArray38[9] = 13;
        byArray38[10] = 11;
        byArray38[11] = 14;
        byArray38[12] = 8;
        byArray38[13] = 1;
        byArray38[14] = 7;
        byArray38[15] = 4;
        byArrayArray2[5] = byArray38;
        byte[] byArray39 = new byte[16];
        byArray39[1] = 7;
        byArray39[2] = 14;
        byArray39[3] = 13;
        byArray39[4] = 5;
        byArray39[5] = 8;
        byArray39[6] = 11;
        byArray39[7] = 2;
        byArray39[8] = 9;
        byArray39[9] = 12;
        byArray39[10] = 4;
        byArray39[11] = 3;
        byArray39[12] = 10;
        byArray39[13] = 6;
        byArray39[14] = 1;
        byArray39[15] = 15;
        byArrayArray2[6] = byArray39;
        byte[] byArray40 = new byte[16];
        byArray40[0] = 12;
        byArray40[1] = 3;
        byArray40[2] = 7;
        byArray40[3] = 4;
        byArray40[4] = 6;
        byArray40[5] = 13;
        byArray40[6] = 9;
        byArray40[7] = 10;
        byArray40[8] = 1;
        byArray40[9] = 15;
        byArray40[10] = 2;
        byArray40[11] = 8;
        byArray40[12] = 11;
        byArray40[14] = 14;
        byArray40[15] = 5;
        byArrayArray2[7] = byArray40;
        byte[] byArray41 = new byte[16];
        byArray41[0] = 1;
        byArray41[1] = 8;
        byArray41[2] = 14;
        byArray41[3] = 5;
        byArray41[4] = 13;
        byArray41[5] = 7;
        byArray41[6] = 4;
        byArray41[7] = 11;
        byArray41[8] = 15;
        byArray41[9] = 2;
        byArray41[11] = 12;
        byArray41[12] = 10;
        byArray41[13] = 9;
        byArray41[14] = 3;
        byArray41[15] = 6;
        byArrayArray2[8] = byArray41;
        byte[] byArray42 = new byte[16];
        byArray42[0] = 2;
        byArray42[1] = 15;
        byArray42[2] = 8;
        byArray42[3] = 4;
        byArray42[4] = 5;
        byArray42[5] = 10;
        byArray42[6] = 6;
        byArray42[7] = 1;
        byArray42[8] = 9;
        byArray42[9] = 3;
        byArray42[10] = 7;
        byArray42[11] = 13;
        byArray42[12] = 12;
        byArray42[14] = 11;
        byArray42[15] = 14;
        byArrayArray2[9] = byArray42;
        byte[] byArray43 = new byte[16];
        byArray43[0] = 7;
        byArray43[1] = 9;
        byArray43[2] = 10;
        byArray43[3] = 6;
        byArray43[4] = 2;
        byArray43[5] = 12;
        byArray43[6] = 1;
        byArray43[7] = 15;
        byArray43[8] = 4;
        byArray43[9] = 3;
        byArray43[10] = 13;
        byArray43[11] = 8;
        byArray43[12] = 11;
        byArray43[14] = 14;
        byArray43[15] = 5;
        byArrayArray2[10] = byArray43;
        byte[] byArray44 = new byte[16];
        byArray44[0] = 3;
        byArray44[2] = 14;
        byArray44[3] = 11;
        byArray44[4] = 8;
        byArray44[5] = 13;
        byArray44[6] = 4;
        byArray44[7] = 7;
        byArray44[8] = 6;
        byArray44[9] = 5;
        byArray44[10] = 1;
        byArray44[11] = 12;
        byArray44[12] = 15;
        byArray44[13] = 2;
        byArray44[14] = 10;
        byArray44[15] = 9;
        byArrayArray2[11] = byArray44;
        byte[] byArray45 = new byte[16];
        byArray45[0] = 4;
        byArray45[1] = 8;
        byArray45[2] = 9;
        byArray45[3] = 3;
        byArray45[4] = 14;
        byArray45[5] = 11;
        byArray45[6] = 5;
        byArray45[8] = 10;
        byArray45[9] = 6;
        byArray45[10] = 7;
        byArray45[11] = 12;
        byArray45[12] = 13;
        byArray45[13] = 1;
        byArray45[14] = 2;
        byArray45[15] = 15;
        byArrayArray2[12] = byArray45;
        byte[] byArray46 = new byte[16];
        byArray46[0] = 6;
        byArray46[1] = 12;
        byArray46[2] = 10;
        byArray46[3] = 7;
        byArray46[4] = 8;
        byArray46[5] = 3;
        byArray46[6] = 4;
        byArray46[7] = 9;
        byArray46[8] = 1;
        byArray46[9] = 15;
        byArray46[10] = 13;
        byArray46[11] = 2;
        byArray46[12] = 11;
        byArray46[14] = 14;
        byArray46[15] = 5;
        byArrayArray2[13] = byArray46;
        byte[] byArray47 = new byte[16];
        byArray47[0] = 3;
        byArray47[1] = 9;
        byArray47[2] = 13;
        byArray47[3] = 10;
        byArray47[4] = 15;
        byArray47[5] = 12;
        byArray47[6] = 1;
        byArray47[7] = 6;
        byArray47[8] = 14;
        byArray47[9] = 2;
        byArray47[11] = 5;
        byArray47[12] = 4;
        byArray47[13] = 7;
        byArray47[14] = 11;
        byArray47[15] = 8;
        byArrayArray2[14] = byArray47;
        byte[] byArray48 = new byte[16];
        byArray48[0] = 2;
        byArray48[1] = 5;
        byArray48[2] = 14;
        byArray48[4] = 9;
        byArray48[5] = 10;
        byArray48[6] = 3;
        byArray48[7] = 13;
        byArray48[8] = 7;
        byArray48[9] = 8;
        byArray48[10] = 4;
        byArray48[11] = 11;
        byArray48[12] = 12;
        byArray48[13] = 6;
        byArray48[14] = 15;
        byArray48[15] = 1;
        byArrayArray2[15] = byArray48;
        byte[] byArray49 = new byte[16];
        byArray49[0] = 13;
        byArray49[1] = 3;
        byArray49[3] = 10;
        byArray49[4] = 2;
        byArray49[5] = 9;
        byArray49[6] = 7;
        byArray49[7] = 4;
        byArray49[8] = 8;
        byArray49[9] = 15;
        byArray49[10] = 5;
        byArray49[11] = 6;
        byArray49[12] = 1;
        byArray49[13] = 12;
        byArray49[14] = 14;
        byArray49[15] = 11;
        byArrayArray2[16] = byArray49;
        byte[] byArray50 = new byte[16];
        byArray50[0] = 9;
        byArray50[1] = 7;
        byArray50[2] = 2;
        byArray50[3] = 12;
        byArray50[4] = 4;
        byArray50[5] = 8;
        byArray50[6] = 15;
        byArray50[7] = 5;
        byArray50[8] = 14;
        byArray50[9] = 13;
        byArray50[10] = 11;
        byArray50[11] = 1;
        byArray50[12] = 3;
        byArray50[13] = 6;
        byArray50[15] = 10;
        byArrayArray2[17] = byArray50;
        byte[] byArray51 = new byte[16];
        byArray51[0] = 14;
        byArray51[1] = 2;
        byArray51[2] = 1;
        byArray51[3] = 13;
        byArray51[5] = 11;
        byArray51[6] = 12;
        byArray51[7] = 6;
        byArray51[8] = 7;
        byArray51[9] = 9;
        byArray51[10] = 4;
        byArray51[11] = 3;
        byArray51[12] = 10;
        byArray51[13] = 5;
        byArray51[14] = 15;
        byArray51[15] = 8;
        byArrayArray2[18] = byArray51;
        byte[] byArray52 = new byte[16];
        byArray52[0] = 10;
        byArray52[1] = 4;
        byArray52[2] = 6;
        byArray52[3] = 15;
        byArray52[4] = 13;
        byArray52[5] = 14;
        byArray52[6] = 8;
        byArray52[7] = 3;
        byArray52[8] = 1;
        byArray52[9] = 11;
        byArray52[10] = 12;
        byArray52[12] = 2;
        byArray52[13] = 7;
        byArray52[14] = 5;
        byArray52[15] = 9;
        byArrayArray2[19] = byArray52;
        byte[] byArray53 = new byte[16];
        byArray53[0] = 8;
        byArray53[1] = 1;
        byArray53[2] = 5;
        byArray53[3] = 10;
        byArray53[4] = 11;
        byArray53[5] = 14;
        byArray53[6] = 6;
        byArray53[7] = 13;
        byArray53[8] = 7;
        byArray53[9] = 4;
        byArray53[10] = 2;
        byArray53[11] = 15;
        byArray53[13] = 9;
        byArray53[14] = 12;
        byArray53[15] = 3;
        byArrayArray2[20] = byArray53;
        byte[] byArray54 = new byte[16];
        byArray54[0] = 12;
        byArray54[1] = 9;
        byArray54[2] = 3;
        byArray54[3] = 14;
        byArray54[4] = 2;
        byArray54[5] = 7;
        byArray54[6] = 8;
        byArray54[7] = 4;
        byArray54[8] = 15;
        byArray54[9] = 6;
        byArray54[11] = 13;
        byArray54[12] = 5;
        byArray54[13] = 10;
        byArray54[14] = 11;
        byArray54[15] = 1;
        byArrayArray2[21] = byArray54;
        byte[] byArray55 = new byte[16];
        byArray55[0] = 9;
        byArray55[1] = 12;
        byArray55[2] = 4;
        byArray55[3] = 7;
        byArray55[4] = 10;
        byArray55[5] = 3;
        byArray55[6] = 15;
        byArray55[7] = 8;
        byArray55[8] = 5;
        byArray55[10] = 11;
        byArray55[11] = 14;
        byArray55[12] = 6;
        byArray55[13] = 13;
        byArray55[14] = 1;
        byArray55[15] = 2;
        byArrayArray2[22] = byArray55;
        byte[] byArray56 = new byte[16];
        byArray56[0] = 13;
        byArray56[1] = 10;
        byArray56[2] = 2;
        byArray56[3] = 1;
        byArray56[5] = 5;
        byArray56[6] = 12;
        byArray56[7] = 11;
        byArray56[8] = 14;
        byArray56[9] = 4;
        byArray56[10] = 7;
        byArray56[11] = 8;
        byArray56[12] = 3;
        byArray56[13] = 15;
        byArray56[14] = 9;
        byArray56[15] = 6;
        byArrayArray2[23] = byArray56;
        byte[] byArray57 = new byte[16];
        byArray57[0] = 5;
        byArray57[1] = 15;
        byArray57[2] = 2;
        byArray57[3] = 8;
        byArray57[5] = 12;
        byArray57[6] = 14;
        byArray57[7] = 11;
        byArray57[8] = 6;
        byArray57[9] = 10;
        byArray57[10] = 13;
        byArray57[11] = 1;
        byArray57[12] = 9;
        byArray57[13] = 7;
        byArray57[14] = 3;
        byArray57[15] = 4;
        byArrayArray2[24] = byArray57;
        byte[] byArray58 = new byte[16];
        byArray58[0] = 1;
        byArray58[1] = 6;
        byArray58[2] = 12;
        byArray58[3] = 9;
        byArray58[4] = 4;
        byArray58[5] = 10;
        byArray58[6] = 15;
        byArray58[7] = 3;
        byArray58[8] = 14;
        byArray58[9] = 5;
        byArray58[10] = 7;
        byArray58[11] = 2;
        byArray58[12] = 11;
        byArray58[14] = 8;
        byArray58[15] = 13;
        byArrayArray2[25] = byArray58;
        byte[] byArray59 = new byte[16];
        byArray59[0] = 12;
        byArray59[2] = 15;
        byArray59[3] = 5;
        byArray59[4] = 1;
        byArray59[5] = 13;
        byArray59[6] = 10;
        byArray59[7] = 6;
        byArray59[8] = 11;
        byArray59[9] = 14;
        byArray59[10] = 8;
        byArray59[11] = 2;
        byArray59[12] = 4;
        byArray59[13] = 3;
        byArray59[14] = 7;
        byArray59[15] = 9;
        byArrayArray2[26] = byArray59;
        byte[] byArray60 = new byte[16];
        byArray60[0] = 10;
        byArray60[1] = 4;
        byArray60[2] = 13;
        byArray60[3] = 14;
        byArray60[4] = 5;
        byArray60[5] = 9;
        byArray60[7] = 7;
        byArray60[8] = 3;
        byArray60[9] = 8;
        byArray60[10] = 6;
        byArray60[11] = 1;
        byArray60[12] = 15;
        byArray60[13] = 2;
        byArray60[14] = 12;
        byArray60[15] = 11;
        byArrayArray2[27] = byArray60;
        byte[] byArray61 = new byte[16];
        byArray61[0] = 13;
        byArray61[1] = 7;
        byArray61[2] = 1;
        byArray61[3] = 10;
        byArray61[4] = 3;
        byArray61[5] = 12;
        byArray61[6] = 4;
        byArray61[7] = 15;
        byArray61[8] = 2;
        byArray61[9] = 9;
        byArray61[10] = 8;
        byArray61[11] = 6;
        byArray61[12] = 14;
        byArray61[14] = 11;
        byArray61[15] = 5;
        byArrayArray2[28] = byArray61;
        byte[] byArray62 = new byte[16];
        byArray62[0] = 12;
        byArray62[2] = 15;
        byArray62[3] = 5;
        byArray62[4] = 7;
        byArray62[5] = 9;
        byArray62[6] = 10;
        byArray62[7] = 6;
        byArray62[8] = 3;
        byArray62[9] = 14;
        byArray62[10] = 4;
        byArray62[11] = 11;
        byArray62[12] = 8;
        byArray62[13] = 2;
        byArray62[14] = 13;
        byArray62[15] = 1;
        byArrayArray2[29] = byArray62;
        byte[] byArray63 = new byte[16];
        byArray63[0] = 8;
        byArray63[1] = 3;
        byArray63[2] = 7;
        byArray63[3] = 13;
        byArray63[4] = 2;
        byArray63[5] = 14;
        byArray63[6] = 9;
        byArray63[8] = 15;
        byArray63[9] = 4;
        byArray63[10] = 10;
        byArray63[11] = 1;
        byArray63[12] = 5;
        byArray63[13] = 11;
        byArray63[14] = 6;
        byArray63[15] = 12;
        byArrayArray2[30] = byArray63;
        byte[] byArray64 = new byte[16];
        byArray64[0] = 11;
        byArray64[1] = 1;
        byArray64[3] = 12;
        byArray64[4] = 4;
        byArray64[5] = 13;
        byArray64[6] = 14;
        byArray64[7] = 3;
        byArray64[8] = 6;
        byArray64[9] = 10;
        byArray64[10] = 5;
        byArray64[11] = 15;
        byArray64[12] = 9;
        byArray64[13] = 7;
        byArray64[14] = 2;
        byArray64[15] = 8;
        byArrayArray2[31] = byArray64;
        SboxInverse = byArrayArray2;
        byte[] byArray65 = new byte[128];
        byArray65[1] = 32;
        byArray65[2] = 64;
        byArray65[3] = 96;
        byArray65[4] = 1;
        byArray65[5] = 33;
        byArray65[6] = 65;
        byArray65[7] = 97;
        byArray65[8] = 2;
        byArray65[9] = 34;
        byArray65[10] = 66;
        byArray65[11] = 98;
        byArray65[12] = 3;
        byArray65[13] = 35;
        byArray65[14] = 67;
        byArray65[15] = 99;
        byArray65[16] = 4;
        byArray65[17] = 36;
        byArray65[18] = 68;
        byArray65[19] = 100;
        byArray65[20] = 5;
        byArray65[21] = 37;
        byArray65[22] = 69;
        byArray65[23] = 101;
        byArray65[24] = 6;
        byArray65[25] = 38;
        byArray65[26] = 70;
        byArray65[27] = 102;
        byArray65[28] = 7;
        byArray65[29] = 39;
        byArray65[30] = 71;
        byArray65[31] = 103;
        byArray65[32] = 8;
        byArray65[33] = 40;
        byArray65[34] = 72;
        byArray65[35] = 104;
        byArray65[36] = 9;
        byArray65[37] = 41;
        byArray65[38] = 73;
        byArray65[39] = 105;
        byArray65[40] = 10;
        byArray65[41] = 42;
        byArray65[42] = 74;
        byArray65[43] = 106;
        byArray65[44] = 11;
        byArray65[45] = 43;
        byArray65[46] = 75;
        byArray65[47] = 107;
        byArray65[48] = 12;
        byArray65[49] = 44;
        byArray65[50] = 76;
        byArray65[51] = 108;
        byArray65[52] = 13;
        byArray65[53] = 45;
        byArray65[54] = 77;
        byArray65[55] = 109;
        byArray65[56] = 14;
        byArray65[57] = 46;
        byArray65[58] = 78;
        byArray65[59] = 110;
        byArray65[60] = 15;
        byArray65[61] = 47;
        byArray65[62] = 79;
        byArray65[63] = 111;
        byArray65[64] = 16;
        byArray65[65] = 48;
        byArray65[66] = 80;
        byArray65[67] = 112;
        byArray65[68] = 17;
        byArray65[69] = 49;
        byArray65[70] = 81;
        byArray65[71] = 113;
        byArray65[72] = 18;
        byArray65[73] = 50;
        byArray65[74] = 82;
        byArray65[75] = 114;
        byArray65[76] = 19;
        byArray65[77] = 51;
        byArray65[78] = 83;
        byArray65[79] = 115;
        byArray65[80] = 20;
        byArray65[81] = 52;
        byArray65[82] = 84;
        byArray65[83] = 116;
        byArray65[84] = 21;
        byArray65[85] = 53;
        byArray65[86] = 85;
        byArray65[87] = 117;
        byArray65[88] = 22;
        byArray65[89] = 54;
        byArray65[90] = 86;
        byArray65[91] = 118;
        byArray65[92] = 23;
        byArray65[93] = 55;
        byArray65[94] = 87;
        byArray65[95] = 119;
        byArray65[96] = 24;
        byArray65[97] = 56;
        byArray65[98] = 88;
        byArray65[99] = 120;
        byArray65[100] = 25;
        byArray65[101] = 57;
        byArray65[102] = 89;
        byArray65[103] = 121;
        byArray65[104] = 26;
        byArray65[105] = 58;
        byArray65[106] = 90;
        byArray65[107] = 122;
        byArray65[108] = 27;
        byArray65[109] = 59;
        byArray65[110] = 91;
        byArray65[111] = 123;
        byArray65[112] = 28;
        byArray65[113] = 60;
        byArray65[114] = 92;
        byArray65[115] = 124;
        byArray65[116] = 29;
        byArray65[117] = 61;
        byArray65[118] = 93;
        byArray65[119] = 125;
        byArray65[120] = 30;
        byArray65[121] = 62;
        byArray65[122] = 94;
        byArray65[123] = 126;
        byArray65[124] = 31;
        byArray65[125] = 63;
        byArray65[126] = 95;
        byArray65[127] = 127;
        IPtable = byArray65;
        byte[] byArray66 = new byte[128];
        byArray66[1] = 4;
        byArray66[2] = 8;
        byArray66[3] = 12;
        byArray66[4] = 16;
        byArray66[5] = 20;
        byArray66[6] = 24;
        byArray66[7] = 28;
        byArray66[8] = 32;
        byArray66[9] = 36;
        byArray66[10] = 40;
        byArray66[11] = 44;
        byArray66[12] = 48;
        byArray66[13] = 52;
        byArray66[14] = 56;
        byArray66[15] = 60;
        byArray66[16] = 64;
        byArray66[17] = 68;
        byArray66[18] = 72;
        byArray66[19] = 76;
        byArray66[20] = 80;
        byArray66[21] = 84;
        byArray66[22] = 88;
        byArray66[23] = 92;
        byArray66[24] = 96;
        byArray66[25] = 100;
        byArray66[26] = 104;
        byArray66[27] = 108;
        byArray66[28] = 112;
        byArray66[29] = 116;
        byArray66[30] = 120;
        byArray66[31] = 124;
        byArray66[32] = 1;
        byArray66[33] = 5;
        byArray66[34] = 9;
        byArray66[35] = 13;
        byArray66[36] = 17;
        byArray66[37] = 21;
        byArray66[38] = 25;
        byArray66[39] = 29;
        byArray66[40] = 33;
        byArray66[41] = 37;
        byArray66[42] = 41;
        byArray66[43] = 45;
        byArray66[44] = 49;
        byArray66[45] = 53;
        byArray66[46] = 57;
        byArray66[47] = 61;
        byArray66[48] = 65;
        byArray66[49] = 69;
        byArray66[50] = 73;
        byArray66[51] = 77;
        byArray66[52] = 81;
        byArray66[53] = 85;
        byArray66[54] = 89;
        byArray66[55] = 93;
        byArray66[56] = 97;
        byArray66[57] = 101;
        byArray66[58] = 105;
        byArray66[59] = 109;
        byArray66[60] = 113;
        byArray66[61] = 117;
        byArray66[62] = 121;
        byArray66[63] = 125;
        byArray66[64] = 2;
        byArray66[65] = 6;
        byArray66[66] = 10;
        byArray66[67] = 14;
        byArray66[68] = 18;
        byArray66[69] = 22;
        byArray66[70] = 26;
        byArray66[71] = 30;
        byArray66[72] = 34;
        byArray66[73] = 38;
        byArray66[74] = 42;
        byArray66[75] = 46;
        byArray66[76] = 50;
        byArray66[77] = 54;
        byArray66[78] = 58;
        byArray66[79] = 62;
        byArray66[80] = 66;
        byArray66[81] = 70;
        byArray66[82] = 74;
        byArray66[83] = 78;
        byArray66[84] = 82;
        byArray66[85] = 86;
        byArray66[86] = 90;
        byArray66[87] = 94;
        byArray66[88] = 98;
        byArray66[89] = 102;
        byArray66[90] = 106;
        byArray66[91] = 110;
        byArray66[92] = 114;
        byArray66[93] = 118;
        byArray66[94] = 122;
        byArray66[95] = 126;
        byArray66[96] = 3;
        byArray66[97] = 7;
        byArray66[98] = 11;
        byArray66[99] = 15;
        byArray66[100] = 19;
        byArray66[101] = 23;
        byArray66[102] = 27;
        byArray66[103] = 31;
        byArray66[104] = 35;
        byArray66[105] = 39;
        byArray66[106] = 43;
        byArray66[107] = 47;
        byArray66[108] = 51;
        byArray66[109] = 55;
        byArray66[110] = 59;
        byArray66[111] = 63;
        byArray66[112] = 67;
        byArray66[113] = 71;
        byArray66[114] = 75;
        byArray66[115] = 79;
        byArray66[116] = 83;
        byArray66[117] = 87;
        byArray66[118] = 91;
        byArray66[119] = 95;
        byArray66[120] = 99;
        byArray66[121] = 103;
        byArray66[122] = 107;
        byArray66[123] = 111;
        byArray66[124] = 115;
        byArray66[125] = 119;
        byArray66[126] = 123;
        byArray66[127] = 127;
        FPtable = byArray66;
        byte[][] byArrayArray3 = new byte[128][];
        byArrayArray3[0] = new byte[]{16, 52, 56, 70, 83, 94, 105, -1};
        byArrayArray3[1] = new byte[]{72, 114, 125, -1, -1, -1, -1, -1};
        byArrayArray3[2] = new byte[]{2, 9, 15, 30, 76, 84, 126, -1};
        byArrayArray3[3] = new byte[]{36, 90, 103, -1, -1, -1, -1, -1};
        byArrayArray3[4] = new byte[]{20, 56, 60, 74, 87, 98, 109, -1};
        byArrayArray3[5] = new byte[]{1, 76, 118, -1, -1, -1, -1, -1};
        byArrayArray3[6] = new byte[]{2, 6, 13, 19, 34, 80, 88, -1};
        byArrayArray3[7] = new byte[]{40, 94, 107, -1, -1, -1, -1, -1};
        byArrayArray3[8] = new byte[]{24, 60, 64, 78, 91, 102, 113, -1};
        byArrayArray3[9] = new byte[]{5, 80, 122, -1, -1, -1, -1, -1};
        byArrayArray3[10] = new byte[]{6, 10, 17, 23, 38, 84, 92, -1};
        byArrayArray3[11] = new byte[]{44, 98, 111, -1, -1, -1, -1, -1};
        byArrayArray3[12] = new byte[]{28, 64, 68, 82, 95, 106, 117, -1};
        byArrayArray3[13] = new byte[]{9, 84, 126, -1, -1, -1, -1, -1};
        byArrayArray3[14] = new byte[]{10, 14, 21, 27, 42, 88, 96, -1};
        byArrayArray3[15] = new byte[]{48, 102, 115, -1, -1, -1, -1, -1};
        byArrayArray3[16] = new byte[]{32, 68, 72, 86, 99, 110, 121, -1};
        byArrayArray3[17] = new byte[]{2, 13, 88, -1, -1, -1, -1, -1};
        byArrayArray3[18] = new byte[]{14, 18, 25, 31, 46, 92, 100, -1};
        byArrayArray3[19] = new byte[]{52, 106, 119, -1, -1, -1, -1, -1};
        byArrayArray3[20] = new byte[]{36, 72, 76, 90, 103, 114, 125, -1};
        byArrayArray3[21] = new byte[]{6, 17, 92, -1, -1, -1, -1, -1};
        byArrayArray3[22] = new byte[]{18, 22, 29, 35, 50, 96, 104, -1};
        byArrayArray3[23] = new byte[]{56, 110, 123, -1, -1, -1, -1, -1};
        byArrayArray3[24] = new byte[]{1, 40, 76, 80, 94, 107, 118, -1};
        byArrayArray3[25] = new byte[]{10, 21, 96, -1, -1, -1, -1, -1};
        byArrayArray3[26] = new byte[]{22, 26, 33, 39, 54, 100, 108, -1};
        byArrayArray3[27] = new byte[]{60, 114, 127, -1, -1, -1, -1, -1};
        byArrayArray3[28] = new byte[]{5, 44, 80, 84, 98, 111, 122, -1};
        byArrayArray3[29] = new byte[]{14, 25, 100, -1, -1, -1, -1, -1};
        byArrayArray3[30] = new byte[]{26, 30, 37, 43, 58, 104, 112, -1};
        byArrayArray3[31] = new byte[]{3, 118, -1, -1, -1, -1, -1, -1};
        byArrayArray3[32] = new byte[]{9, 48, 84, 88, 102, 115, 126, -1};
        byArrayArray3[33] = new byte[]{18, 29, 104, -1, -1, -1, -1, -1};
        byArrayArray3[34] = new byte[]{30, 34, 41, 47, 62, 108, 116, -1};
        byArrayArray3[35] = new byte[]{7, 122, -1, -1, -1, -1, -1, -1};
        byArrayArray3[36] = new byte[]{2, 13, 52, 88, 92, 106, 119, -1};
        byArrayArray3[37] = new byte[]{22, 33, 108, -1, -1, -1, -1, -1};
        byArrayArray3[38] = new byte[]{34, 38, 45, 51, 66, 112, 120, -1};
        byArrayArray3[39] = new byte[]{11, 126, -1, -1, -1, -1, -1, -1};
        byArrayArray3[40] = new byte[]{6, 17, 56, 92, 96, 110, 123, -1};
        byArrayArray3[41] = new byte[]{26, 37, 112, -1, -1, -1, -1, -1};
        byArrayArray3[42] = new byte[]{38, 42, 49, 55, 70, 116, 124, -1};
        byArrayArray3[43] = new byte[]{2, 15, 76, -1, -1, -1, -1, -1};
        byArrayArray3[44] = new byte[]{10, 21, 60, 96, 100, 114, 127, -1};
        byArrayArray3[45] = new byte[]{30, 41, 116, -1, -1, -1, -1, -1};
        byte[] byArray67 = new byte[8];
        byArray67[1] = 42;
        byArray67[2] = 46;
        byArray67[3] = 53;
        byArray67[4] = 59;
        byArray67[5] = 74;
        byArray67[6] = 120;
        byArray67[7] = -1;
        byArrayArray3[46] = byArray67;
        byArrayArray3[47] = new byte[]{6, 19, 80, -1, -1, -1, -1, -1};
        byArrayArray3[48] = new byte[]{3, 14, 25, 100, 104, 118, -1, -1};
        byArrayArray3[49] = new byte[]{34, 45, 120, -1, -1, -1, -1, -1};
        byArrayArray3[50] = new byte[]{4, 46, 50, 57, 63, 78, 124, -1};
        byArrayArray3[51] = new byte[]{10, 23, 84, -1, -1, -1, -1, -1};
        byArrayArray3[52] = new byte[]{7, 18, 29, 104, 108, 122, -1, -1};
        byArrayArray3[53] = new byte[]{38, 49, 124, -1, -1, -1, -1, -1};
        byte[] byArray68 = new byte[8];
        byArray68[1] = 8;
        byArray68[2] = 50;
        byArray68[3] = 54;
        byArray68[4] = 61;
        byArray68[5] = 67;
        byArray68[6] = 82;
        byArray68[7] = -1;
        byArrayArray3[54] = byArray68;
        byArrayArray3[55] = new byte[]{14, 27, 88, -1, -1, -1, -1, -1};
        byArrayArray3[56] = new byte[]{11, 22, 33, 108, 112, 126, -1, -1};
        byte[] byArray69 = new byte[8];
        byArray69[1] = 42;
        byArray69[2] = 53;
        byArray69[3] = -1;
        byArray69[4] = -1;
        byArray69[5] = -1;
        byArray69[6] = -1;
        byArray69[7] = -1;
        byArrayArray3[57] = byArray69;
        byArrayArray3[58] = new byte[]{4, 12, 54, 58, 65, 71, 86, -1};
        byArrayArray3[59] = new byte[]{18, 31, 92, -1, -1, -1, -1, -1};
        byArrayArray3[60] = new byte[]{2, 15, 26, 37, 76, 112, 116, -1};
        byArrayArray3[61] = new byte[]{4, 46, 57, -1, -1, -1, -1, -1};
        byArrayArray3[62] = new byte[]{8, 16, 58, 62, 69, 75, 90, -1};
        byArrayArray3[63] = new byte[]{22, 35, 96, -1, -1, -1, -1, -1};
        byArrayArray3[64] = new byte[]{6, 19, 30, 41, 80, 116, 120, -1};
        byArrayArray3[65] = new byte[]{8, 50, 61, -1, -1, -1, -1, -1};
        byArrayArray3[66] = new byte[]{12, 20, 62, 66, 73, 79, 94, -1};
        byArrayArray3[67] = new byte[]{26, 39, 100, -1, -1, -1, -1, -1};
        byArrayArray3[68] = new byte[]{10, 23, 34, 45, 84, 120, 124, -1};
        byArrayArray3[69] = new byte[]{12, 54, 65, -1, -1, -1, -1, -1};
        byArrayArray3[70] = new byte[]{16, 24, 66, 70, 77, 83, 98, -1};
        byArrayArray3[71] = new byte[]{30, 43, 104, -1, -1, -1, -1, -1};
        byte[] byArray70 = new byte[8];
        byArray70[1] = 14;
        byArray70[2] = 27;
        byArray70[3] = 38;
        byArray70[4] = 49;
        byArray70[5] = 88;
        byArray70[6] = 124;
        byArray70[7] = -1;
        byArrayArray3[72] = byArray70;
        byArrayArray3[73] = new byte[]{16, 58, 69, -1, -1, -1, -1, -1};
        byArrayArray3[74] = new byte[]{20, 28, 70, 74, 81, 87, 102, -1};
        byArrayArray3[75] = new byte[]{34, 47, 108, -1, -1, -1, -1, -1};
        byte[] byArray71 = new byte[8];
        byArray71[1] = 4;
        byArray71[2] = 18;
        byArray71[3] = 31;
        byArray71[4] = 42;
        byArray71[5] = 53;
        byArray71[6] = 92;
        byArray71[7] = -1;
        byArrayArray3[76] = byArray71;
        byArrayArray3[77] = new byte[]{20, 62, 73, -1, -1, -1, -1, -1};
        byArrayArray3[78] = new byte[]{24, 32, 74, 78, 85, 91, 106, -1};
        byArrayArray3[79] = new byte[]{38, 51, 112, -1, -1, -1, -1, -1};
        byArrayArray3[80] = new byte[]{4, 8, 22, 35, 46, 57, 96, -1};
        byArrayArray3[81] = new byte[]{24, 66, 77, -1, -1, -1, -1, -1};
        byArrayArray3[82] = new byte[]{28, 36, 78, 82, 89, 95, 110, -1};
        byArrayArray3[83] = new byte[]{42, 55, 116, -1, -1, -1, -1, -1};
        byArrayArray3[84] = new byte[]{8, 12, 26, 39, 50, 61, 100, -1};
        byArrayArray3[85] = new byte[]{28, 70, 81, -1, -1, -1, -1, -1};
        byArrayArray3[86] = new byte[]{32, 40, 82, 86, 93, 99, 114, -1};
        byArrayArray3[87] = new byte[]{46, 59, 120, -1, -1, -1, -1, -1};
        byArrayArray3[88] = new byte[]{12, 16, 30, 43, 54, 65, 104, -1};
        byArrayArray3[89] = new byte[]{32, 74, 85, -1, -1, -1, -1, -1};
        byArrayArray3[90] = new byte[]{36, 90, 103, 118, -1, -1, -1, -1};
        byArrayArray3[91] = new byte[]{50, 63, 124, -1, -1, -1, -1, -1};
        byArrayArray3[92] = new byte[]{16, 20, 34, 47, 58, 69, 108, -1};
        byArrayArray3[93] = new byte[]{36, 78, 89, -1, -1, -1, -1, -1};
        byArrayArray3[94] = new byte[]{40, 94, 107, 122, -1, -1, -1, -1};
        byte[] byArray72 = new byte[8];
        byArray72[1] = 54;
        byArray72[2] = 67;
        byArray72[3] = -1;
        byArray72[4] = -1;
        byArray72[5] = -1;
        byArray72[6] = -1;
        byArray72[7] = -1;
        byArrayArray3[95] = byArray72;
        byArrayArray3[96] = new byte[]{20, 24, 38, 51, 62, 73, 112, -1};
        byArrayArray3[97] = new byte[]{40, 82, 93, -1, -1, -1, -1, -1};
        byArrayArray3[98] = new byte[]{44, 98, 111, 126, -1, -1, -1, -1};
        byArrayArray3[99] = new byte[]{4, 58, 71, -1, -1, -1, -1, -1};
        byArrayArray3[100] = new byte[]{24, 28, 42, 55, 66, 77, 116, -1};
        byArrayArray3[101] = new byte[]{44, 86, 97, -1, -1, -1, -1, -1};
        byArrayArray3[102] = new byte[]{2, 48, 102, 115, -1, -1, -1, -1};
        byArrayArray3[103] = new byte[]{8, 62, 75, -1, -1, -1, -1, -1};
        byArrayArray3[104] = new byte[]{28, 32, 46, 59, 70, 81, 120, -1};
        byArrayArray3[105] = new byte[]{48, 90, 101, -1, -1, -1, -1, -1};
        byArrayArray3[106] = new byte[]{6, 52, 106, 119, -1, -1, -1, -1};
        byArrayArray3[107] = new byte[]{12, 66, 79, -1, -1, -1, -1, -1};
        byArrayArray3[108] = new byte[]{32, 36, 50, 63, 74, 85, 124, -1};
        byArrayArray3[109] = new byte[]{52, 94, 105, -1, -1, -1, -1, -1};
        byArrayArray3[110] = new byte[]{10, 56, 110, 123, -1, -1, -1, -1};
        byArrayArray3[111] = new byte[]{16, 70, 83, -1, -1, -1, -1, -1};
        byte[] byArray73 = new byte[8];
        byArray73[1] = 36;
        byArray73[2] = 40;
        byArray73[3] = 54;
        byArray73[4] = 67;
        byArray73[5] = 78;
        byArray73[6] = 89;
        byArray73[7] = -1;
        byArrayArray3[112] = byArray73;
        byArrayArray3[113] = new byte[]{56, 98, 109, -1, -1, -1, -1, -1};
        byArrayArray3[114] = new byte[]{14, 60, 114, 127, -1, -1, -1, -1};
        byArrayArray3[115] = new byte[]{20, 74, 87, -1, -1, -1, -1, -1};
        byArrayArray3[116] = new byte[]{4, 40, 44, 58, 71, 82, 93, -1};
        byArrayArray3[117] = new byte[]{60, 102, 113, -1, -1, -1, -1, -1};
        byArrayArray3[118] = new byte[]{3, 18, 72, 114, 118, 125, -1, -1};
        byArrayArray3[119] = new byte[]{24, 78, 91, -1, -1, -1, -1, -1};
        byArrayArray3[120] = new byte[]{8, 44, 48, 62, 75, 86, 97, -1};
        byArrayArray3[121] = new byte[]{64, 106, 117, -1, -1, -1, -1, -1};
        byArrayArray3[122] = new byte[]{1, 7, 22, 76, 118, 122, -1, -1};
        byArrayArray3[123] = new byte[]{28, 82, 95, -1, -1, -1, -1, -1};
        byArrayArray3[124] = new byte[]{12, 48, 52, 66, 79, 90, 101, -1};
        byArrayArray3[125] = new byte[]{68, 110, 121, -1, -1, -1, -1, -1};
        byArrayArray3[126] = new byte[]{5, 11, 26, 80, 122, 126, -1, -1};
        byArrayArray3[127] = new byte[]{32, 86, 99, -1, -1, -1, -1, -1};
        LTtable = byArrayArray3;
        byte[][] byArrayArray4 = new byte[128][];
        byArrayArray4[0] = new byte[]{53, 55, 72, -1, -1, -1, -1, -1};
        byArrayArray4[1] = new byte[]{1, 5, 20, 90, -1, -1, -1, -1};
        byArrayArray4[2] = new byte[]{15, 102, -1, -1, -1, -1, -1, -1};
        byArrayArray4[3] = new byte[]{3, 31, 90, -1, -1, -1, -1, -1};
        byArrayArray4[4] = new byte[]{57, 59, 76, -1, -1, -1, -1, -1};
        byArrayArray4[5] = new byte[]{5, 9, 24, 94, -1, -1, -1, -1};
        byArrayArray4[6] = new byte[]{19, 106, -1, -1, -1, -1, -1, -1};
        byArrayArray4[7] = new byte[]{7, 35, 94, -1, -1, -1, -1, -1};
        byArrayArray4[8] = new byte[]{61, 63, 80, -1, -1, -1, -1, -1};
        byArrayArray4[9] = new byte[]{9, 13, 28, 98, -1, -1, -1, -1};
        byArrayArray4[10] = new byte[]{23, 110, -1, -1, -1, -1, -1, -1};
        byArrayArray4[11] = new byte[]{11, 39, 98, -1, -1, -1, -1, -1};
        byArrayArray4[12] = new byte[]{65, 67, 84, -1, -1, -1, -1, -1};
        byArrayArray4[13] = new byte[]{13, 17, 32, 102, -1, -1, -1, -1};
        byArrayArray4[14] = new byte[]{27, 114, -1, -1, -1, -1, -1, -1};
        byArrayArray4[15] = new byte[]{1, 3, 15, 20, 43, 102, -1, -1};
        byArrayArray4[16] = new byte[]{69, 71, 88, -1, -1, -1, -1, -1};
        byArrayArray4[17] = new byte[]{17, 21, 36, 106, -1, -1, -1, -1};
        byArrayArray4[18] = new byte[]{1, 31, 118, -1, -1, -1, -1, -1};
        byArrayArray4[19] = new byte[]{5, 7, 19, 24, 47, 106, -1, -1};
        byArrayArray4[20] = new byte[]{73, 75, 92, -1, -1, -1, -1, -1};
        byArrayArray4[21] = new byte[]{21, 25, 40, 110, -1, -1, -1, -1};
        byArrayArray4[22] = new byte[]{5, 35, 122, -1, -1, -1, -1, -1};
        byArrayArray4[23] = new byte[]{9, 11, 23, 28, 51, 110, -1, -1};
        byArrayArray4[24] = new byte[]{77, 79, 96, -1, -1, -1, -1, -1};
        byArrayArray4[25] = new byte[]{25, 29, 44, 114, -1, -1, -1, -1};
        byArrayArray4[26] = new byte[]{9, 39, 126, -1, -1, -1, -1, -1};
        byArrayArray4[27] = new byte[]{13, 15, 27, 32, 55, 114, -1, -1};
        byArrayArray4[28] = new byte[]{81, 83, 100, -1, -1, -1, -1, -1};
        byArrayArray4[29] = new byte[]{1, 29, 33, 48, 118, -1, -1, -1};
        byArrayArray4[30] = new byte[]{2, 13, 43, -1, -1, -1, -1, -1};
        byArrayArray4[31] = new byte[]{1, 17, 19, 31, 36, 59, 118, -1};
        byArrayArray4[32] = new byte[]{85, 87, 104, -1, -1, -1, -1, -1};
        byArrayArray4[33] = new byte[]{5, 33, 37, 52, 122, -1, -1, -1};
        byArrayArray4[34] = new byte[]{6, 17, 47, -1, -1, -1, -1, -1};
        byArrayArray4[35] = new byte[]{5, 21, 23, 35, 40, 63, 122, -1};
        byArrayArray4[36] = new byte[]{89, 91, 108, -1, -1, -1, -1, -1};
        byArrayArray4[37] = new byte[]{9, 37, 41, 56, 126, -1, -1, -1};
        byArrayArray4[38] = new byte[]{10, 21, 51, -1, -1, -1, -1, -1};
        byArrayArray4[39] = new byte[]{9, 25, 27, 39, 44, 67, 126, -1};
        byArrayArray4[40] = new byte[]{93, 95, 112, -1, -1, -1, -1, -1};
        byArrayArray4[41] = new byte[]{2, 13, 41, 45, 60, -1, -1, -1};
        byArrayArray4[42] = new byte[]{14, 25, 55, -1, -1, -1, -1, -1};
        byArrayArray4[43] = new byte[]{2, 13, 29, 31, 43, 48, 71, -1};
        byArrayArray4[44] = new byte[]{97, 99, 116, -1, -1, -1, -1, -1};
        byArrayArray4[45] = new byte[]{6, 17, 45, 49, 64, -1, -1, -1};
        byArrayArray4[46] = new byte[]{18, 29, 59, -1, -1, -1, -1, -1};
        byArrayArray4[47] = new byte[]{6, 17, 33, 35, 47, 52, 75, -1};
        byArrayArray4[48] = new byte[]{101, 103, 120, -1, -1, -1, -1, -1};
        byArrayArray4[49] = new byte[]{10, 21, 49, 53, 68, -1, -1, -1};
        byArrayArray4[50] = new byte[]{22, 33, 63, -1, -1, -1, -1, -1};
        byArrayArray4[51] = new byte[]{10, 21, 37, 39, 51, 56, 79, -1};
        byArrayArray4[52] = new byte[]{105, 107, 124, -1, -1, -1, -1, -1};
        byArrayArray4[53] = new byte[]{14, 25, 53, 57, 72, -1, -1, -1};
        byArrayArray4[54] = new byte[]{26, 37, 67, -1, -1, -1, -1, -1};
        byArrayArray4[55] = new byte[]{14, 25, 41, 43, 55, 60, 83, -1};
        byte[] byArray74 = new byte[8];
        byArray74[1] = 109;
        byArray74[2] = 111;
        byArray74[3] = -1;
        byArray74[4] = -1;
        byArray74[5] = -1;
        byArray74[6] = -1;
        byArray74[7] = -1;
        byArrayArray4[56] = byArray74;
        byArrayArray4[57] = new byte[]{18, 29, 57, 61, 76, -1, -1, -1};
        byArrayArray4[58] = new byte[]{30, 41, 71, -1, -1, -1, -1, -1};
        byArrayArray4[59] = new byte[]{18, 29, 45, 47, 59, 64, 87, -1};
        byArrayArray4[60] = new byte[]{4, 113, 115, -1, -1, -1, -1, -1};
        byArrayArray4[61] = new byte[]{22, 33, 61, 65, 80, -1, -1, -1};
        byArrayArray4[62] = new byte[]{34, 45, 75, -1, -1, -1, -1, -1};
        byArrayArray4[63] = new byte[]{22, 33, 49, 51, 63, 68, 91, -1};
        byArrayArray4[64] = new byte[]{8, 117, 119, -1, -1, -1, -1, -1};
        byArrayArray4[65] = new byte[]{26, 37, 65, 69, 84, -1, -1, -1};
        byArrayArray4[66] = new byte[]{38, 49, 79, -1, -1, -1, -1, -1};
        byArrayArray4[67] = new byte[]{26, 37, 53, 55, 67, 72, 95, -1};
        byArrayArray4[68] = new byte[]{12, 121, 123, -1, -1, -1, -1, -1};
        byArrayArray4[69] = new byte[]{30, 41, 69, 73, 88, -1, -1, -1};
        byArrayArray4[70] = new byte[]{42, 53, 83, -1, -1, -1, -1, -1};
        byArrayArray4[71] = new byte[]{30, 41, 57, 59, 71, 76, 99, -1};
        byArrayArray4[72] = new byte[]{16, 125, 127, -1, -1, -1, -1, -1};
        byArrayArray4[73] = new byte[]{34, 45, 73, 77, 92, -1, -1, -1};
        byArrayArray4[74] = new byte[]{46, 57, 87, -1, -1, -1, -1, -1};
        byArrayArray4[75] = new byte[]{34, 45, 61, 63, 75, 80, 103, -1};
        byArrayArray4[76] = new byte[]{1, 3, 20, -1, -1, -1, -1, -1};
        byArrayArray4[77] = new byte[]{38, 49, 77, 81, 96, -1, -1, -1};
        byArrayArray4[78] = new byte[]{50, 61, 91, -1, -1, -1, -1, -1};
        byArrayArray4[79] = new byte[]{38, 49, 65, 67, 79, 84, 107, -1};
        byArrayArray4[80] = new byte[]{5, 7, 24, -1, -1, -1, -1, -1};
        byArrayArray4[81] = new byte[]{42, 53, 81, 85, 100, -1, -1, -1};
        byArrayArray4[82] = new byte[]{54, 65, 95, -1, -1, -1, -1, -1};
        byArrayArray4[83] = new byte[]{42, 53, 69, 71, 83, 88, 111, -1};
        byArrayArray4[84] = new byte[]{9, 11, 28, -1, -1, -1, -1, -1};
        byArrayArray4[85] = new byte[]{46, 57, 85, 89, 104, -1, -1, -1};
        byArrayArray4[86] = new byte[]{58, 69, 99, -1, -1, -1, -1, -1};
        byArrayArray4[87] = new byte[]{46, 57, 73, 75, 87, 92, 115, -1};
        byArrayArray4[88] = new byte[]{13, 15, 32, -1, -1, -1, -1, -1};
        byArrayArray4[89] = new byte[]{50, 61, 89, 93, 108, -1, -1, -1};
        byArrayArray4[90] = new byte[]{62, 73, 103, -1, -1, -1, -1, -1};
        byArrayArray4[91] = new byte[]{50, 61, 77, 79, 91, 96, 119, -1};
        byArrayArray4[92] = new byte[]{17, 19, 36, -1, -1, -1, -1, -1};
        byArrayArray4[93] = new byte[]{54, 65, 93, 97, 112, -1, -1, -1};
        byArrayArray4[94] = new byte[]{66, 77, 107, -1, -1, -1, -1, -1};
        byArrayArray4[95] = new byte[]{54, 65, 81, 83, 95, 100, 123, -1};
        byArrayArray4[96] = new byte[]{21, 23, 40, -1, -1, -1, -1, -1};
        byArrayArray4[97] = new byte[]{58, 69, 97, 101, 116, -1, -1, -1};
        byArrayArray4[98] = new byte[]{70, 81, 111, -1, -1, -1, -1, -1};
        byArrayArray4[99] = new byte[]{58, 69, 85, 87, 99, 104, 127, -1};
        byArrayArray4[100] = new byte[]{25, 27, 44, -1, -1, -1, -1, -1};
        byArrayArray4[101] = new byte[]{62, 73, 101, 105, 120, -1, -1, -1};
        byArrayArray4[102] = new byte[]{74, 85, 115, -1, -1, -1, -1, -1};
        byArrayArray4[103] = new byte[]{3, 62, 73, 89, 91, 103, 108, -1};
        byArrayArray4[104] = new byte[]{29, 31, 48, -1, -1, -1, -1, -1};
        byArrayArray4[105] = new byte[]{66, 77, 105, 109, 124, -1, -1, -1};
        byArrayArray4[106] = new byte[]{78, 89, 119, -1, -1, -1, -1, -1};
        byArrayArray4[107] = new byte[]{7, 66, 77, 93, 95, 107, 112, -1};
        byArrayArray4[108] = new byte[]{33, 35, 52, -1, -1, -1, -1, -1};
        byte[] byArray75 = new byte[8];
        byArray75[1] = 70;
        byArray75[2] = 81;
        byArray75[3] = 109;
        byArray75[4] = 113;
        byArray75[5] = -1;
        byArray75[6] = -1;
        byArray75[7] = -1;
        byArrayArray4[109] = byArray75;
        byArrayArray4[110] = new byte[]{82, 93, 123, -1, -1, -1, -1, -1};
        byArrayArray4[111] = new byte[]{11, 70, 81, 97, 99, 111, 116, -1};
        byArrayArray4[112] = new byte[]{37, 39, 56, -1, -1, -1, -1, -1};
        byArrayArray4[113] = new byte[]{4, 74, 85, 113, 117, -1, -1, -1};
        byArrayArray4[114] = new byte[]{86, 97, 127, -1, -1, -1, -1, -1};
        byArrayArray4[115] = new byte[]{15, 74, 85, 101, 103, 115, 120, -1};
        byArrayArray4[116] = new byte[]{41, 43, 60, -1, -1, -1, -1, -1};
        byArrayArray4[117] = new byte[]{8, 78, 89, 117, 121, -1, -1, -1};
        byArrayArray4[118] = new byte[]{3, 90, -1, -1, -1, -1, -1, -1};
        byArrayArray4[119] = new byte[]{19, 78, 89, 105, 107, 119, 124, -1};
        byArrayArray4[120] = new byte[]{45, 47, 64, -1, -1, -1, -1, -1};
        byArrayArray4[121] = new byte[]{12, 82, 93, 121, 125, -1, -1, -1};
        byArrayArray4[122] = new byte[]{7, 94, -1, -1, -1, -1, -1, -1};
        byte[] byArray76 = new byte[8];
        byArray76[1] = 23;
        byArray76[2] = 82;
        byArray76[3] = 93;
        byArray76[4] = 109;
        byArray76[5] = 111;
        byArray76[6] = 123;
        byArray76[7] = -1;
        byArrayArray4[123] = byArray76;
        byArrayArray4[124] = new byte[]{49, 51, 68, -1, -1, -1, -1, -1};
        byArrayArray4[125] = new byte[]{1, 16, 86, 97, 125, -1, -1, -1};
        byArrayArray4[126] = new byte[]{11, 98, -1, -1, -1, -1, -1, -1};
        byArrayArray4[127] = new byte[]{4, 27, 86, 97, 113, 115, 127, -1};
        LTtableInverse = byArrayArray4;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

