/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.test.BaseTest;
import cryptix.util.core.BI;
import cryptix.util.core.Hex;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ElGamalPrivateKey;
import java.security.interfaces.ElGamalPublicKey;

class TestElGamal
extends BaseTest {
    private static final byte[] message = "Je ne veux que du magnifique, et je ne travaille pas pour le vulgaire des lecteurs --Giambattista BODONI (1740-1813)".getBytes();
    private static byte[] signature;
    private static final SecureRandom prng;

    public static void main(String[] stringArray) {
        new TestElGamal().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ElGamal");
        Signature signature = Signature.getInstance("MD2/ElGamal/PKCS#1");
        Signature signature2 = Signature.getInstance("MD5/ElGamal/PKCS#1");
        Signature signature3 = Signature.getInstance("SHA-1/ElGamal/PKCS#1");
        Signature signature4 = Signature.getInstance("RIPEMD160/ElGamal/PKCS#1");
        this.setExpectedPasses(9);
        this.out.println("\nTest #1 (384-bit modulus + parameter generation)\n");
        this.test(384, keyPairGenerator, signature3);
        int n = 0;
        while (n < 2) {
            int n2 = 512 + 256 * n;
            this.out.println("\nTest #" + (n + 2) + " (" + n2 + "-bit modulus)\n");
            this.test(n2, keyPairGenerator, signature);
            this.test(n2, keyPairGenerator, signature2);
            this.test(n2, keyPairGenerator, signature3);
            this.test(n2, keyPairGenerator, signature4);
            ++n;
        }
    }

    private void test(int n, KeyPairGenerator keyPairGenerator, Signature signature) {
        try {
            this.out.println("1. Generating keypair...\n");
            keyPairGenerator.initialize(n, prng);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            this.out.println("2. Using keypair for signature...");
            this.out.println("2.1 Signing with a " + n + "-bit key using " + signature.getAlgorithm() + "...");
            signature.initSign(privateKey);
            signature.update(message);
            TestElGamal.signature = signature.sign();
            this.out.println("2.2 Verifying with same " + n + "-bit key using " + signature.getAlgorithm() + "...\n");
            signature.initVerify(publicKey);
            signature.update(message);
            boolean bl = signature.verify(TestElGamal.signature);
            this.passIf(bl, "Signature verification");
            if (!bl) {
                this.out.println("---- begin debugging -----\n");
                this.out.println("Computed signature: " + Hex.dumpString((byte[])TestElGamal.signature));
                this.out.println("ElGamal parameters:");
                BigInteger bigInteger = ((ElGamalPublicKey)publicKey).getP();
                BigInteger bigInteger2 = ((ElGamalPublicKey)publicKey).getG();
                BigInteger bigInteger3 = ((ElGamalPublicKey)publicKey).getY();
                this.out.println("   Public key material:");
                this.out.println("   p: " + BI.dumpString((BigInteger)bigInteger));
                this.out.println("   g: " + BI.dumpString((BigInteger)bigInteger2));
                this.out.println("   y: " + BI.dumpString((BigInteger)bigInteger3));
                BigInteger bigInteger4 = ((ElGamalPrivateKey)privateKey).getX();
                this.out.println("   Private key material:");
                this.out.println("   x: " + BI.dumpString((BigInteger)bigInteger4));
                BigInteger bigInteger5 = new BigInteger(TestElGamal.signature);
                this.out.println("   The signature as a BigInteger:");
                this.out.println(" sig: " + BI.dumpString((BigInteger)bigInteger5));
                this.out.println("---- end debugging -----");
                throw new RuntimeException("PANIC...");
            }
        }
        catch (Exception exception) {
            this.fail("Unexpected exception");
            exception.printStackTrace();
        }
    }

    TestElGamal() {
    }

    static {
        prng = new SecureRandom();
    }
}

