/*
 * Decompiled with CFR 0.152.
 */
package tcl.bean;

import com.sun.jpropub.vj.vjcomp.InputDataTransfer;
import com.sun.jpropub.vj.vjcomp.OutputDataTransfer;
import com.sun.jpropub.vj.vjcomp.VJComponent;
import com.sun.jpropub.vj.vjcomp.VJDynamicPortDescriptor;
import com.sun.jpropub.vj.vjcomp.VJPort;
import com.sun.jpropub.vj.vjcomp.VJPortDescriptor;
import com.sun.jpropub.vj.vjcomp.util.BasicToBooleanInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToDoubleInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToFloatInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToIntegerInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToLongInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BasicToStringInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.BooleanToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.DoubleToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.FloatToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.IntegerToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.LongToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.NumberToDoubleInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.NumberToFloatInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.NumberToIntegerInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.NumberToLongInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.ObjectInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.ObjectOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.StringToBasicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.VJDynamicInputTransfer;
import com.sun.jpropub.vj.vjcomp.util.VJDynamicOutputTransfer;
import com.sun.jpropub.vj.vjcomp.util.VJTriggerInputTransfer;
import java.io.Serializable;
import tcl.bean.StudioTclInterp;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclObject;
import tcl.lang.VarTrace;

class StudioTclPort
implements VarTrace,
Serializable {
    private static final String[] inTransfers = new String[]{"basicToDouble", "basicToFloat", "basicToInteger", "basicToLong", "basicToString", "basicToBoolean", "numberToDouble", "numberToFloat", "numberToInteger", "numberToLong", "object", "trigger", "dynamic"};
    private static final String[] outTransfers = new String[]{"doubleToBasic", "floatToBasic", "integerToBasic", "longToBasic", "object", "stringToBasic", "booleanToBasic", "dynamic"};
    private static final String[] locationStrings = new String[]{"anywhere", "north", "northLeft", "northCenter", "northRight", "south", "southLeft", "southCenter", "southRight", "west", "westTop", "westCenter", "westBottom", "east", "eastTop", "eastCenter", "eastBottom"};
    int pinType = -1;
    int location = -1;
    String inVarName;
    String outVarName;
    String portName;
    String description;
    String inTransfer;
    String outTransfer;
    boolean added = false;
    VJPort port;
    VJDynamicPortDescriptor newDesc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StudioTclPort(StudioTclInterp studioInterp, int newPinType, TclObject locObj, TclObject newPortName, TclObject descObj, TclObject inVar, TclObject outVar, TclObject inputType, TclObject outputType) throws TclException {
        this.pinType = newPinType;
        this.inVarName = null;
        this.outVarName = null;
        if (inVar == null && outVar == null) {
            throw new TclException(studioInterp.getInterp(), "null values cannot be passed for inVar and outVar");
        }
        if (inVar != null) {
            this.inVarName = inVar.toString();
        }
        if (outVar != null) {
            this.outVarName = outVar.toString();
        }
        this.portName = newPortName != null ? newPortName.toString() : (inVar != null ? this.inVarName : this.outVarName);
        if (locObj == null) {
            if (this.pinType == VJPortDescriptor.IN_ONLY) {
                this.location = 9;
            } else if (this.pinType == VJPortDescriptor.OUT_ONLY) {
                this.location = 13;
            } else {
                if (this.pinType != VJPortDescriptor.TWO_WAY) throw new TclException(studioInterp.getInterp(), "invalid pin type");
                this.location = 1;
            }
        } else {
            this.location = StudioTclPort.ParseLocation(studioInterp, locObj);
        }
        this.description = descObj == null ? " : variable value in the formula" : descObj.toString();
        try {
            if (this.pinType == VJPortDescriptor.IN_ONLY) {
                InputDataTransfer inputTransfer = this.ParseInputType(studioInterp, inputType);
                this.port = new VJPort((VJComponent)studioInterp, inputTransfer);
            } else if (this.pinType == VJPortDescriptor.OUT_ONLY) {
                OutputDataTransfer outputTransfer = this.ParseOutputType(studioInterp, outputType);
                this.port = new VJPort((VJComponent)studioInterp, outputTransfer);
            } else {
                if (this.pinType != VJPortDescriptor.TWO_WAY) throw new TclException(studioInterp.getInterp(), "invalid pin type: must be in, out or twoway");
                InputDataTransfer inputTransfer = this.ParseInputType(studioInterp, inputType);
                OutputDataTransfer outputTransfer = this.ParseOutputType(studioInterp, outputType);
                this.port = new VJPort((VJComponent)studioInterp, outputTransfer, inputTransfer);
            }
        }
        catch (TclException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TclException(studioInterp.getInterp(), e.toString());
        }
        if (this.port == null) {
            throw new TclException(studioInterp.getInterp(), "port object is null");
        }
        this.newDesc = new VJDynamicPortDescriptor(this.port, this.portName, this.description, this.pinType, this.location, ((Object)((Object)studioInterp)).getClass());
        if (this.newDesc != null) return;
        throw new TclException(studioInterp.getInterp(), "newDesc is null: VJDynamicPortDescriptor instantion error");
    }

    private OutputDataTransfer ParseOutputType(StudioTclInterp studioInterp, TclObject transferType) throws TclException {
        if (transferType == null) {
            this.outTransfer = "dynamic";
            return new VJDynamicOutputTransfer();
        }
        int type = TclIndex.get((Interp)studioInterp.getInterp(), (TclObject)transferType, (String[])outTransfers, (String)"option", (int)0);
        this.outTransfer = transferType.toString();
        switch (type) {
            case 0: {
                return new DoubleToBasicOutputTransfer();
            }
            case 1: {
                return new FloatToBasicOutputTransfer();
            }
            case 2: {
                return new IntegerToBasicOutputTransfer();
            }
            case 3: {
                return new LongToBasicOutputTransfer();
            }
            case 4: {
                return new ObjectOutputTransfer();
            }
            case 5: {
                return new StringToBasicOutputTransfer();
            }
            case 6: {
                return new BooleanToBasicOutputTransfer();
            }
            case 7: {
                return new VJDynamicOutputTransfer();
            }
        }
        return null;
    }

    private InputDataTransfer ParseInputType(StudioTclInterp studioInterp, TclObject transferType) throws TclException {
        if (transferType == null) {
            this.inTransfer = "dynamic";
            return new VJDynamicInputTransfer();
        }
        int type = TclIndex.get((Interp)studioInterp.getInterp(), (TclObject)transferType, (String[])inTransfers, (String)"option", (int)0);
        this.inTransfer = transferType.toString();
        switch (type) {
            case 0: {
                return new BasicToDoubleInputTransfer();
            }
            case 1: {
                return new BasicToFloatInputTransfer();
            }
            case 2: {
                return new BasicToIntegerInputTransfer();
            }
            case 3: {
                return new BasicToLongInputTransfer();
            }
            case 4: {
                return new BasicToStringInputTransfer();
            }
            case 5: {
                return new BasicToBooleanInputTransfer();
            }
            case 6: {
                return new NumberToDoubleInputTransfer();
            }
            case 7: {
                return new NumberToFloatInputTransfer();
            }
            case 8: {
                return new NumberToIntegerInputTransfer();
            }
            case 9: {
                return new NumberToLongInputTransfer();
            }
            case 10: {
                return new ObjectInputTransfer();
            }
            case 11: {
                return new VJTriggerInputTransfer();
            }
            case 12: {
                return new VJDynamicInputTransfer();
            }
        }
        return null;
    }

    private static int ParseLocation(StudioTclInterp studioInterp, TclObject loc) throws TclException {
        int index = TclIndex.get((Interp)studioInterp.getInterp(), (TclObject)loc, (String[])locationStrings, (String)"option", (int)0);
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
        }
        return -1;
    }

    public void initWithInterp(Interp interp) {
        block2: {
            if (this.pinType != VJPortDescriptor.OUT_ONLY && this.pinType != VJPortDescriptor.TWO_WAY) break block2;
            try {
                interp.traceVar(this.outVarName, (VarTrace)this, 33);
            }
            catch (TclException tclException) {
                System.out.println("trace creation error");
            }
        }
    }

    public void traceProc(Interp interp, String part1, String part2, int flags) {
        TclObject tclObj = null;
        try {
            tclObj = interp.getVar(this.outVarName, 1);
        }
        catch (Exception exception) {
            return;
        }
        try {
            Object javaObj = ReflectObject.get((Interp)interp, (TclObject)tclObj);
            this.port.sendMessage(javaObj);
        }
        catch (Exception exception) {
            String strMsg = tclObj.toString();
            try {
                this.port.sendMessage((Object)strMsg);
            }
            catch (Exception e2) {
                System.out.println("error 2: " + e2);
            }
        }
    }

    public boolean equals(Object portObject) {
        StudioTclPort port = (StudioTclPort)portObject;
        if (port == null) {
            return false;
        }
        if (!this.portName.equals(port.portName)) {
            return false;
        }
        if (this.inVarName != null ? !this.inVarName.equals(port.inVarName) : port.inVarName != null) {
            return false;
        }
        if (this.outVarName != null ? !this.outVarName.equals(port.outVarName) : port.outVarName != null) {
            return false;
        }
        if (!this.description.equals(port.description)) {
            return false;
        }
        if (this.pinType != port.pinType) {
            return false;
        }
        if (this.location != port.location) {
            return false;
        }
        if (this.inTransfer != null ? !this.inTransfer.equals(port.inTransfer) : port.inTransfer != null) {
            return false;
        }
        return !(this.outTransfer != null ? !this.outTransfer.equals(port.outTransfer) : port.outTransfer != null);
    }
}

