/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: vadm_symname.c[3.22] Fri Mar 13 18:15:25 1992 shape@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>
#include <atfs.h>
#include <atfsapp.h>

#include "vadm.h"


extern unsigned options, actions;
extern int def_vnum;
extern struct Transaction ThisTransaction;
/* locals */
static char buf[MSGLEN];

/**/
DoSymname (vlist, ac, av, sym)
     struct vc_vlist *vlist;
     int ac;
     char **av;
     char *sym;
{
  Af_set set;
  char **erroneous;
  int i, errs;
  char version[MSGLEN];
  char symname[SYMNAMLEN];
  
  if (SymnameInUse (ac, av, sym, &erroneous)) {
    (void)sprintf (buf, 
	"symbolic name %s already in use for: ", sym);
    i = 0; 
    while (erroneous[i]) {
      if (strlen (buf) + strlen (erroneous[i]) < 74) 
	strcat (buf, erroneous[i]);
      else {
	logerr (buf);
	strcpy (buf, "  ");
	strcat (buf, erroneous[i]);
      }
      if (erroneous[i+1])
	strcat (buf, ", ");
      i++;
    }
    logerr (buf);
    return 1;
  }
  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, &erroneous);
  }
  else {
    if (!vlist->from_version_set || !vlist->to_version_set) {
      if (IsOptionSet (Vopt_binary))
	errs = GetKeysByGenRev 
	  (ac,av, AF_BUSYVERS, AF_BUSYVERS, &set, &erroneous);
      else
	errs = GetKeysByGenRev 
	  (ac,av, AF_LASTVERS, AF_LASTVERS, &set, &erroneous);
    }
    else
      errs = GetKeysByName (ac, av, vlist, &set, &erroneous);
  }

  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && !ask_confirm ("Continue ?", "yes"))
    return 1;

  (void)sprintf (symname, "%s=%s", SYMNAME, sym);
  
  for (i = 0; i < set.af_nkeys; i++) {
    mkvstring (version, &set.af_klist[i]);
    if (setjmp (ThisTransaction.tr_env)) continue; 
    if (af_sudattr (&set.af_klist[i], AF_ADD, symname) == -1) {
      af_perror ("DoSymname: af_sudattr");
      return 1;
    }
    (void)sprintf (buf, "Symbolic name %s attached to %s.", sym, version);
    logmsg (buf);
  }
  return 0;
}

DoSetCommentSymbol (ac, av, sym)
     int ac;
     char **av;
     char *sym;
{
  Af_set set;
  char **erroneous, c_symbol[CLEADMAXLEN];
  int i, errs;
  
  errs = GetKeysByName (ac, av, (struct vc_vlist *)NULL, &set, 
			&erroneous);

  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && !ask_confirm ("Continue ?", "yes"))
    return 1;

  (void)sprintf (c_symbol, "%s=%s", CLEAD, sym);
  
  for (i = 0; i < set.af_nkeys; i++) {

    if (setjmp (ThisTransaction.tr_env)) continue;
    if (af_sudattr (&set.af_klist[i], AF_REPLACE, c_symbol) == -1) {
      if (af_sudattr (&set.af_klist[i], AF_ADD, c_symbol) == -1) {
	af_perror ("DoSetCommentSymbol: af_suadttr");
	return 1;
      }
    }
  }
  return 0;
}

DoSetUda (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  extern char *TakeFromFile, udaname[], udaval[];

  Af_set set;
  char **erroneous;
  int i, errs, udamemlen;
  char version[MSGLEN], *hook, *udamem, *cp, messg[MSGLEN], *malloc(), *realloc();
  FILE *tff;
  struct stat sbuf;

  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, &erroneous);
  }
  else {
    if (!vlist->from_version_set || !vlist->to_version_set)
      errs = GetKeysByGenRev 
	(ac,av, AF_BUSYVERS, AF_BUSYVERS, &set, &erroneous);
    else
      errs = GetKeysByName (ac, av, vlist, &set, &erroneous);
  }
  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && !ask_confirm ("Continue ?", "yes"))
    return 1;

  if (TakeFromFile) {
    if (strcmp (TakeFromFile, "-")) {
      if ((tff = fopen (TakeFromFile, "r")) == NULL) {
	(void)sprintf (messg, "Can't open attribute value file %s.", TakeFromFile);
	logerr (messg);
	return 1;
      }
      if (fstat (fileno (tff), &sbuf) < 0) {
	perror ("fstat");
	return 1;
      }
      udamem = 
	malloc ((unsigned)(udamemlen=(strlen (udaname) + sbuf.st_size + 2)));
      if (udamem == NULL) {
	logerr ("Not enough memory to build attribute");
	return 1;
      }
      (void)sprintf (udamem, "%s=", udaname);
      cp = udamem + strlen (udamem);
      (void)fread (cp, sizeof (char), (Size_t)sbuf.st_size, tff); 
      (void)fclose (tff);
      udamem[udamemlen-1] = '\0';
    }
    else { /* read attribute value from stdin */
#     define STDINBUFSIZ 4095
      int chrd, c=1;
      udamem = malloc ((unsigned)(udamemlen=(strlen (udaname) + 
					     STDINBUFSIZ+1)));
      if (udamem == NULL) {
	logerr ("Not enough memory to build attribute");
	return 1;
      }
      (void)sprintf (udamem, "%s=", udaname);
      cp = udamem + strlen (udamem);
      chrd = fread (cp, sizeof (char), (Size_t)STDINBUFSIZ-1, stdin);
      cp[chrd] = '\0';
      while (chrd+c == STDINBUFSIZ) {
	c = 0;
	udamem = realloc (udamem, 
			      (unsigned)(udamemlen=strlen (udamem) + 
					 STDINBUFSIZ + 1));
	if (udamem == NULL) {
	  logerr ("Not enough memory to build attribute");
	  return 1;
	}
	cp = udamem + strlen (udamem);
	chrd = fread (cp, sizeof (char), (Size_t)STDINBUFSIZ, stdin);
	cp[chrd] = '\0';
      }
    }	  
  }
  else { /* udaval not taken from file */
    udamem = 
      malloc ((unsigned)(udamemlen=(strlen (udaname) + strlen (udaval) + 2)));
    if (udamem == NULL) {
      logerr ("Not enough memory to build attribute");
      return 1;
    }
    (void)sprintf (udamem, "%s=%s", udaname, udaval);
  }  
  for (i = 0; i < set.af_nkeys; i++) {
    if (setjmp (ThisTransaction.tr_env)) continue;
    mkvstring (version, &set.af_klist[i]);

    if (at_setuda (&set.af_klist[i], udamem) == 0) {
      return 1;
    }
  }
  free (udamem);
  return 0;
}

DoUnsetUda (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  extern char *TakeFromFile, udaname[], udaval[];

  Af_set set;
  char **erroneous;
  int i, errs, udamemlen;
  char version[MSGLEN], messg[MSGLEN], *hook, *udamem, *cp, *malloc();
  FILE *tff;
  struct stat sbuf;
  int cplng, gotit;
  char *ds, *newuda;

  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, &erroneous);
  }
  else {
    if (!vlist->from_version_set || !vlist->to_version_set)
      errs = GetKeysByGenRev 
	(ac,av, AF_BUSYVERS, AF_BUSYVERS, &set, &erroneous);
    else
      errs = GetKeysByName (ac, av, vlist, &set, &erroneous);
  }
  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && !ask_confirm ("Continue ?", "yes"))
    return 1;
  
  if (IsActionSet(Varg_remuda)) {
    if (TakeFromFile) {
      if ((tff = fopen (TakeFromFile, "r")) == NULL) {
	(void)sprintf (messg, "can't open attribute value file %s.", TakeFromFile);
	logerr (messg);
	return 1;
      }
      if (fstat (fileno (tff), &sbuf) < 0) {
	perror ("fstat");
	return 1;
      }
      udamem = 
	malloc ((unsigned)(udamemlen=(strlen (udaname) + sbuf.st_size + 2)));
      if (udamem == NULL) {
	logerr ("Not enough memory to build attribute");
	return 1;
      }
      (void)sprintf (udamem, "%s=", udaname);
      cp = udamem + strlen (udamem);
      (void)fread (cp, sizeof (char), (Size_t)sbuf.st_size, tff); 
      (void)fclose (tff);
      udamem[udamemlen-1] = '\0';
    }
    else { /* udaval not taken from file */
      udamem = 
	malloc ((unsigned)(udamemlen=(strlen (udaname) + strlen (udaval) + 2)));
      if (udamem == NULL) {
	logerr ("Not enough memory to build attribute");
	return 1;
      }
      (void)sprintf (udamem, "%s=%s", udaname, udaval);
    }  
  }
  else { /* action is Varg_unsetuda */
    udamem = malloc ((unsigned)strlen (udaname) + 1);
    if (udamem == NULL) {
      logerr ("Not enough memory to hold attribute name");
      return 1;
    }
  }
  for (i = 0; i < set.af_nkeys; i++) {
    mkvstring (version, &set.af_klist[i]);
    if (setjmp (ThisTransaction.tr_env)) continue; 
    if (hook=af_rudattr (&set.af_klist[i], udaname)) {
      if (IsActionSet(Varg_remuda)) {
	cp = index (udamem, '=') + 1; /* must succeed */
	cplng = strlen (cp);
	gotit = FALSE;  /* search for particular attr-val is init to FALSE */

	for (ds = hook; *ds;) {
	  if (!strncmp (cp, ds, cplng)) {
	    char *ts = (char *)((unsigned int)ds+cplng);
	    strcpy (ds == hook ? ds : (char *)((unsigned int)ds-1), 
		    *ts ? ts++ : ts);
	    gotit = TRUE;
	    break;
	  }
	  while (*ds && (*ds++ != '\n')); /* advance to next attr-val (line) */
	}
	if (gotit) {
	  newuda = malloc (strlen (udaname) + strlen (hook) + 2);
	  if (newuda == NULL) {
	    logerr ("Not enough memory to build attribute");
	    free (hook); free (udamem);
	    return 1;
	  }
	  (void)sprintf (newuda, "%s=%s\0", udaname, hook);
	  if (af_sudattr (&set.af_klist[i], AF_REPLACE, newuda) == -1) {
	    af_perror ("af_sudattr");
	    free (newuda); free (hook); free (udamem);
	    return 1;
	  }
	  free (newuda);
	}
      }
      else { /* IsActionSet(Varg_unsetuda) == TRUE */
	if (af_sudattr (&set.af_klist[i], AF_REMOVE, udaname) == -1) {
	  af_perror ("af_sudattr");
	  return 1;
	}
      }
      free (hook);
    }
  } /* end for */
  free (udamem);
  return 0;
}

int DoSetAttrs (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  extern char Attrfile[];

  char *as, **erroneous, *getattr(), version[MSGLEN];
  Af_set set;
  register int i;
  int errs;

  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, &erroneous);
  }
  else {
    if (!vlist->from_version_set || !vlist->to_version_set)
      errs = GetKeysByGenRev 
	(ac,av, AF_BUSYVERS, AF_BUSYVERS, &set, &erroneous);
    else
      errs = GetKeysByName (ac, av, vlist, &set, &erroneous);
  }
  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && !ask_confirm ("Continue ?", "yes"))
    return 1;

  for (i = 0; i < set.af_nkeys; i++) {
    mkvstring (version, &set.af_klist[i]);
    if (setjmp (ThisTransaction.tr_env)) continue; 
    if (as = getattr (Attrfile, (Project *)NULL, (char *)NULL, REWIND))
      at_setuda (&set.af_klist[i], as);
    af_transaction ();
    while (as=getattr (Attrfile, (Project *)NULL, (char *)NULL, NEXT)) {
      at_setuda (&set.af_klist[i], as);
    }
    af_commit ();
  }
  return FALSE;
}

static int SymnameInUse (ac, av, sym, errs) int ac; char **av, *sym, ***errs; {
  /*
   * Function yields TRUE, if any version of any object named in 'av'
   * has the name 'sym' assigned as value of the user-defined attribute
   * SYMNAME.
   */
  
  Af_attrs warrant;
  Af_set hits;
  int i, rc, bad;
  char symname[SYMNAMLEN], cname[MAXPATHLEN+1], vstring[MSGLEN], **erroneous,
  *malloc();

  (void)sprintf (symname, "%s=%s", SYMNAME, sym);
  af_initattrs (&warrant);
  af_initset (&hits);
  warrant.af_udattrs[0] = symname;
  warrant.af_udattrs[1] = (char *)NULL;
  if ((erroneous = (char **) 
       malloc ((unsigned)(sizeof (char *) * (ac + 1)))) == (char **)NULL)
    vctl_abort ("SymnameInUse(): can't malloc");
 
  bad = 0;

  for (i = 0; i < ac; i++) {
    if (BoundVersion (av[i], cname, vstring))
      initwarrant (&warrant, cname);
    else
      initwarrant (&warrant, av[i]);
    if ((rc=af_find (&warrant, &hits)) > 0) { 
      af_dropset (&hits);
      erroneous[bad++] = av[i];
    }
    else if (rc < 0)
      af_perror ("af_find (in SymnameInUse)");
  }
  erroneous[bad] = NULL;
  *errs = erroneous;
  return bad;
}

initwarrant (warrant, fname) Af_attrs *warrant; char *fname; {
  (void)strcpy (warrant->af_syspath, af_afpath (fname));
  (void)strcpy (warrant->af_name, af_afname (fname));
  (void)strcpy (warrant->af_type, af_aftype (fname));
}

