/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: vadm_gkeys.c[3.15] Fri Feb  7 20:28:22 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>
#include <atfs.h>
#include <atfsapp.h>

#include "vadm.h"

extern char *malloc();
extern unsigned int options;

static char *variant = NULL;

int between_versions (this_gen, this_rev, from_gen, from_rev, to_gen, to_rev)
     int this_gen, this_rev, from_gen, from_rev, to_gen, to_rev;
{
  if (this_gen < from_gen)
    return 0;
  if (this_gen > to_gen)
    return 0;
  if (this_rev < from_rev)
    return 0;
  if (this_rev > to_rev)
    return 0;

  return 1;
}

GetKeys (file, versions, set)
     char *file;
     struct vc_vlist *versions;
     Af_set *set;
{
  Af_set tset, btset, stset;
  Af_attrs attrbuf;
  Af_key key;
  
  struct vc_vlist *tvs;
  char *syspath, *name, *type, cstring[MAXPATHLEN+1], vstring[16];
  int nhits, bnhits, i, vno;
  
  if (BoundVersion (file, cstring, vstring)) {
    vno = mkvno (vstring);
    syspath = af_afpath (cstring);
    name = af_afname (cstring);
    type = af_aftype (cstring);
    if (af_getkey (syspath, name, type, gen(vno), rev(vno), &key) < 0)
      return NULL;
/*    af_setaddkey (set, AF_LASTPOS, &key); *//* should look like this line */
    af_setaddkey (set, 0, &key);
    return 1;
  }
  /* subsequent stuff handles non-explicit queries.... */
  syspath = af_afpath (file);
  name = af_afname (file);
  type = af_aftype (file);

  af_initattrs (&attrbuf);
  
  if (syspath)
    (void)strcpy (attrbuf.af_syspath, syspath);
  
  (void)strcpy (attrbuf.af_name, name);
  if (type)
    (void)strcpy (attrbuf.af_type, type);
  
  nhits = af_find (&attrbuf, &stset);
  if (IsOptionSet (Vopt_binary)) {
    bnhits = af_bpfind (&attrbuf, &btset);
  }
  else {
    af_initset (&btset);
  }
  if (af_union (&stset, &btset, &tset) < 0) {
    af_perror ("af_union");
    return NULL;
  }
  af_dropset (&stset);
  af_dropset (&btset);
  nhits += bnhits;
  if (nhits < 0) {
    return NULL;
  }
  
  if (nhits == 0) {
    return NULL;
  }
  
  for (i = 0; i < nhits; i++) {
    if (versions) {
      for (tvs = versions; tvs; tvs = tvs->next) {
	if (between_versions (af_rgen (&tset.af_klist[i]),
			      af_rrev (&tset.af_klist[i]),	    
			      tvs->from_generation, tvs->from_revision,
			      tvs->to_generation, tvs->to_revision)) {
	  af_setaddkey (set, 0, &tset.af_klist[i]); 
	  /*	af_setaddkey (set, AF_LASTPOS, &tset.af_klist[i]); */
	  break;
	}
      }
    }
    else { /* versions == NULL */
      af_setaddkey (set, 0, &tset.af_klist[i]); 
    }
  }
  af_dropset (&tset);
  return 1;
}

/**/
GetKeysByName (nums, af_files, versions, set, err_files)
     int nums;
     char **af_files;
     struct vc_vlist *versions;
     Af_set *set;
     char ***err_files;
{
  Af_key thiskey;
  int i, bad, vno;
  char **erroneous, cstring[MAXPATHLEN+1], vstring[16];
  struct vc_vlist vdesc;

  vdesc.from_version_set = NULL;
  vdesc.to_version_set = NULL;
  af_initset (set);	/* needed for the first af_union */

  if ((erroneous = (char **) 
       malloc ((unsigned)(sizeof (char *) * (nums + 1)))) == (char **)NULL)
    vctl_abort ("GetKeysByName(): can't malloc");
 
  bad = 0;
  for (i = 0; i < nums; i++) {
    if (*af_files[i] == '\0') continue; /* skip null names */
    if (BoundVersion (af_files[i], cstring, vstring)) {
      vno = mkvno (vstring);
      vdesc.from_generation = gen(vno);
      vdesc.from_revision = rev(vno);
      vdesc.to_generation = gen(vno);
      vdesc.to_revision = rev(vno);
      vdesc.next = NULL;
      if (!GetKeys (af_files[i], &vdesc, set))
	erroneous[bad++] = af_files[i];
    }
    else {
      if (versions) {
	if (!(versions->from_version_set) || !(versions->to_version_set)) {
	  /* no version range given -- try find busy version */
	  if (!fail(af_getkey (af_afpath(af_files[i]), af_afname(af_files[i]),
			       af_aftype(af_files[i]), AF_BUSYVERS,
			       AF_BUSYVERS, &thiskey)))
	    af_setaddkey (set, 0, &thiskey);
	  else erroneous[bad++] = af_files[i];
	}
	else
	  if (!GetKeys (af_files[i], versions, set))
	    erroneous[bad++] = af_files[i];
      }
      else
	if (!GetKeys (af_files[i], versions, set))
	  erroneous[bad++] = af_files[i];
    }
  }
  erroneous[bad] = NULL;
  *err_files = erroneous;
  return bad;
}

/**/
int GetKeysByGenRev (ac, av, generation, revision, set, err_files)
     int ac;
     char **av;
     int generation, revision;
     Af_set *set;
     char ***err_files;
{
  Af_key key;
  char **erroneous;		/* busy version' name that has no saved vers */
  char cfname[MAXPATHLEN+1], vstring[16];
  int bad, retcode;
  int i, vno;
  
  if ((erroneous = (char **) malloc ((unsigned)(sizeof (char *) * (ac + 1))))
      == (char **)NULL) {
    perror ("get_by_versnum: can't malloc,2");
    exit (1);
  }

  af_initset (set);
  
  /* collect all AtFS files and record error for later use */
  bad = 0;
  for (i = 0; av[i]; i++) {
    if (BoundVersion (av[i], cfname, vstring)) {
      vno = mkvno (vstring);
      retcode = af_getkey (af_afpath (cfname), af_afname(cfname),
			 af_aftype(cfname), gen(vno),
			 rev(vno), &key);
    }
    else {
      switch (generation) {
      case AF_BUSYVERS:
	retcode = af_getkey (af_afpath (av[i]), af_afname(av[i]),
			     af_aftype(av[i]), generation,
			     revision, &key);
	if (!fail(retcode)) break;
	/* we go to next label if no busyversion is there */
      case AF_LASTVERS:
	retcode = af_getkey (af_afpath (av[i]), af_afname(av[i]),
			     af_aftype(av[i]), AF_LASTVERS,
			     AF_LASTVERS, &key);
	break;
      case AF_FIRSTVERS:
      default: 
	retcode = af_getkey (af_afpath (av[i]), af_afname(av[i]),
			     af_aftype(av[i]), generation,
			     revision, &key);
	break;
      }
    }
    if (retcode == -1)
      erroneous[bad++] = av[i];	/* must we record af_errno ? */
    else {
      af_setaddkey (set, 0, &key); /* should be AF_LASTPOS */
/*      af_setaddkey (set, AF_LASTPOS, &key); */
    }
  }

  erroneous[bad] = NULL;
  *err_files = erroneous;
  return bad;
}
