/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: save.c[3.33] Fri Feb  7 20:19:38 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <signal.h>
#include <stdio.h>
#include <ctype.h>
#include <atfs.h>
#include <atfsapp.h>
#include <ParseArgs.h>

#include "save.h"
/* #include "project.h" now in afsapp.h> */

extern struct Transaction ThisTransaction;
extern int nfnms;

char *progname, vcomment[MSGLEN], tfname[MAXPATHLEN+1], 
  atr_fname[MAXPATHLEN+1], symname[SYMNAMLEN], projname[80],
  fix_base[SYMNAMLEN];
int newvnum, ins_generation;

/* forward decls for option handlers */
extern handle_R_switch ();
extern handle_f_switch ();
extern handle_q_switch ();
extern handle_l_switch ();
extern handle_newgen_switch ();
extern handle_setattrs_opt ();
extern handle_m_opt ();
extern handle_n_opt ();
extern handle_p_opt ();
extern handle_svnum_opt ();
extern handle_fix_opt ();
extern handle_t_opt ();
extern usage ();

unsigned int options;
int StdinFlag = 0;		/* -stdin option */

OptDesc argdesc[] = {
  { "version", PSWITCH, handle_R_switch, NULL, NULL },
  { "f", PSWITCH, handle_f_switch, NULL, NULL },
  { "q", PSWITCH, handle_q_switch, NULL, NULL },
  { "setattrs", PARG, handle_setattrs_opt, NULL, NULL }, 
  { "l", PSWITCH, handle_l_switch, NULL, NULL },
  { "lock", PSWITCH, handle_l_switch, NULL, NULL },
  { "m", PARG, handle_m_opt, NULL, NULL }, 
  { "n", PARG, handle_n_opt, NULL, NULL }, 
  { "setvnum", PARG, handle_svnum_opt, NULL, NULL },
  { "fix", PARG, handle_fix_opt, NULL, NULL },
  { "newgen", PSWITCH, handle_newgen_switch, NULL, NULL },
  { "t", PARG, handle_t_opt, NULL, NULL },
  { "h", PSWITCH, usage, NULL, NULL },
  { "stdin", PSWITCH|PSET, NULL, &StdinFlag, NULL}, /* read note from tty */
  { "?", PARG, usage, NULL, NULL },
  { (char *)  NULL, NULL, NULL, NULL, NULL }
};

main (ac, av) int ac; char **av; {
  register int i;
  int nac, rc = 0, bound_vid = 0;
  unsigned int options_bak = 0, newvnum_bak = 0;
  char projname[80], **nav, messg[MSGLEN], *es, *getenv(), vstring[MAXPATHLEN],
       symname_bak[SYMNAMLEN];
  Project pdesc;

  if (!rindex (av[0], '/')) progname = av[0];
  else progname = rindex (av[0], '/') + 1;
  /* make prog-name available to entire program */

  if (ac < 2) {
    usage ();
    exit (1);
  }

  (void) strcpy (symname, "");
  (void) strcpy (symname_bak, "");

  if (isupper(progname[0])) rc = handle_newgen_switch ("foo", "bar");
  if (rc) exit (rc);

  if (ParseArgs (ac, av, &nac, &nav, argdesc)) {
    usage ();
  }

  if (!(options & ATTRDEF)) {
    es = getenv (SVATTR);
    if ((es) && (es[0] != '\0')) {
      options |= ATTRDEF;
      (void)strcpy (atr_fname, es);
    }
  }

  if (GetProject (projname, &pdesc) < 0) {
    (void)sprintf (messg, "%s %s", EINVALPROJ, projname);
    logmsg (messg);
    exit (1);
  }

  CatchSigs ();
  nfnms = nac;

  if (!(options & QUIETPLEASE))
    if (checkForAtfsDirs (nac, nav))
      exit (1);
      
  ThisTransaction.tr_rc = 0;
  for (i = 0; i < nfnms; i++) {
    if (!setjmp (ThisTransaction.tr_env)) {
      if (bound_vid) {
	bound_vid = FALSE;
	options = options_bak;
	newvnum = newvnum_bak;
	if (symname_bak) (void) strcpy (symname, symname_bak);
      }
      ThisTransaction.tr_seqno = i;
      if (splitBVN (nav[i], ThisTransaction.tr_fname, vstring)) {
	newvnum_bak = newvnum;
	options_bak = options;
	if (symname) (void) strcpy (symname_bak, symname);
	bound_vid = TRUE;

	if (!(newvnum = mkvno (vstring))) {
	  newvnum = newvnum_bak;
	  options |= SYMNSET;
	  (void) strcpy (symname, vstring);
	}
	else {
	  if (options & FIX) {
	    logerr ("\"-fix\" is incompatible with \"-setvnum\".");
	    rc++;
	    continue;
	  }
	  
	  if (options & NEWGEN) {
	    logmsg ("WARNING: -setvnum overrides -newgen (Save).");
	    options &= ~NEWGEN;
	  }
	  options |= SETVNUM;
	}
      }
      else {
	(void)strcpy (ThisTransaction.tr_fname, nav[i]);
      }
      ThisTransaction.tr_done = FALSE;
      SaveAFile (ThisTransaction.tr_fname, &pdesc);
    }
    else { /* ThisTransaction was aborted */
      rc += ThisTransaction.tr_rc;
    }
  }
  if (nfnms > 1) logmsg ("done.");
  return (rc);
}

int splitBVN (in, out1, out2) char *in, *out1, *out2; {
	char *b1, *b2;
	int vno;

	if ((b1=rindex (in, '[')) && (b2 = rindex (in, ']'))
	    && (b1 < b2)) {
	  *b1 = *b2 = '\0'; /* make 'em separate strings */
	  (void)strcpy (out1, in);
	  (void)strcpy (out2, b1+1);
	  *b1 = '['; *b2 = ']';
	  return TRUE;
	}
	else
	  return FALSE;
      }

Sfunc_t interrupt_action () { /* is executed by appropriate signal handler */
  char messg[MSGLEN];
  
  disableSig (SIGINT);
  if ((nfnms - ThisTransaction.tr_seqno) > 1) { 
    (void)sprintf (messg, "\ncompletely stop saving (%d files unsaved) ?", 
		   nfnms - ThisTransaction.tr_seqno);
    if (ask_confirm (messg, "no")) {
      if (ThisTransaction.tr_done) {
	(void)sprintf (messg, "\ntoo late, %s already saved", 
		       ThisTransaction.tr_fname);
	logmsg (messg);
	return; /* continue where we've been interrupted */
      }
      (void)sprintf (messg, "%s not saved", ThisTransaction.tr_fname);
      logmsg (messg);
      enableSig();
      CatchSigs (); /* mostly to deal with %^%$#$ Sys V signal-handling */
      af_cleanup ();
      longjmp (ThisTransaction.tr_env, 1);
    }
    else {
      (void)sprintf (messg, "%s not saved", ThisTransaction.tr_fname);
      logmsg (messg);
      exit (1);
    }
  }
  else {
    (void)sprintf (messg, "\n%s not saved", ThisTransaction.tr_fname);
    logmsg (messg);
    exit (1);
  }
}

logmsg (msg) char *msg; {
  if (!(options & QUIETPLEASE)) {
    (void) fprintf (stdout, "%s\n", msg);
  }
}

logwarn (msg) char *msg; {
  (void) fflush(stdout);
  if (!(options & QUIETPLEASE)) {
    (void) fprintf (stderr, "%s\n", msg);
  }
}

logerr (msg) char *msg; {
  (void) fflush(stdout);
  (void) fprintf (stderr, "%s: %s\n", progname, msg);
}

/*ARGSUSED*/
int handle_R_switch (o, a) char *o, *a; {
  extern char *af_version(), *at_version(), *saveversion();
  (void) printf ("This is %s version %s.\n", progname, saveversion());
  (void) printf ("AtFS toolkit lib version %s.\n", at_version());
  (void) printf ("AtFS version %s.\n", af_version());
  exit (0);
}

/*ARGSUSED*/
int handle_setattrs_opt (o, a) char *o, *a; {
  options |= ATTRDEF;
  (void)strcpy (atr_fname, a);
  return 0;
}

/*ARGSUSED*/
int handle_f_switch (o, a) char *o, *a; {
  options |= FORCE;
  return 0;
}

/*ARGSUSED*/
int handle_m_opt (o, a) char *o, *a; {
  if (!(options & TXTFSET)) {
    options |= MSGSET;
    (void)strcpy (vcomment, a);
    return 0;
  }
  return 0;
}

/*ARGSUSED*/
int handle_n_opt (o, a) char *o, *a; {
  if (a && a[0]) {
    options |= SYMNSET;
    (void)strcpy (symname, a);
  }
  return 0;
}

/*ARGSUSED*/
int handle_q_switch (o, a) char *o, *a; {
  options |= QUIETPLEASE;
  return 0;
}

/*ARGSUSED*/
int handle_p_opt (o, a) char *o, *a; {
  options |= OTHERPROJ;
  (void)strcpy (projname, a);
  return 0;
}

/*ARGSUSED*/
int handle_newgen_switch (o, a) char *o, *a; {
  if (options & FIX) {
    logerr ("\"-fix\" is incompatible with \"-newgen\" (Save).");
    exit (1);
  }
  if (options & SETVNUM) 
    logmsg ("WARNING: -setvnum overrides -newgen (Save).");
  else
    options |= NEWGEN;
  return (0);
}

/*ARGSUSED*/
int handle_svnum_opt (o, a) char *o, *a; {
  char messg[MSGLEN];
  if (options & FIX) {
    logerr ("\"-fix\" is incompatible with \"-setvnum\".");
    exit (1);
  }
  if (!(newvnum = mkvno (a))) {
    (void)sprintf (messg, "bad version number \"%s\"", a);
    logerr (messg);
    return 1;
  }
  if (options & NEWGEN) {
    logmsg ("WARNING: -setvnum overrides -newgen (Save).");
    options &= ~NEWGEN;
  }
  options |= SETVNUM;
  return 0;
}

/*ARGSUSED*/
int handle_fix_opt (o, a) char *o, *a; {
  char messg[MSGLEN];
  if (options & (NEWGEN | SETVNUM)) {
    logerr 
      ("Incompatible options: \"-fix\" and \"-newgen\" or \"-setvnum\".");
    exit (1);
  }
  if (!(ins_generation = atoi (a))) {
    (void) strcpy (fix_base, a);
  }
  options |= FIX;
  return 0;
}

/*ARGSUSED*/
int handle_t_opt (o, a) char *o, *a; {
  if (options & MSGSET) {
    options &= ~MSGSET;
  }
  options |= TXTFSET;
  (void)strcpy (tfname, a);
  return 0;
}

/*ARGSUSED*/
int handle_l_switch (o, a) char *o, *a; {
  options |= KEEPLOCK;
  return 0;
}

usage () {
  pa_ShortUsage (progname, argdesc, "files ...");
  exit (1);
}

