/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: doretrv.c[3.35] Mon Mar  9 16:43:18 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include "retrv.h"
#include <sys/file.h>
#include <stdio.h>
#include <atfs.h>
#include <atfsapp.h>

/* #include "project.h" now in afsapp.h */
/* #include "locks.h" now in afsapp.h */

extern struct Transaction ThisTransaction;
extern unsigned int options;
extern int StdinFlag;
extern int NoExpandFlag;
extern Af_key *NewLock;
extern char intent_fname[], *progname;

extern int af_errno;
#define checkAtFSerr(obj) \
  if (af_errno != AF_ENOREV) { \
      char messg[MSGLEN]; \
      (void)sprintf (messg, "%s", obj); \
      af_perror (messg); \
      abort_this (TRUE); \
    }

#ifndef ERROR
#define ERROR -1
#endif

void RetrieveAFile (fname, vdesc, proj, destpath)
     char *fname, *destpath;
     struct Vdesc *vdesc;
     Project *proj; {
       /*
	*  NOTE: use of variant attribute in af_getkey is not yet functional.
	*        The parameter, however, is necessary to occupy the slot.
	*        Implementation of variant selection may make it necessary
	*        to add another parameter to this procedure.
	*/
       char spath[MAXPATHLEN+1], origpath[MAXPATHLEN+1], name[MAXPATHLEN+1],
       *afname, *aftype, *afvariant = NULL, messg[MAXPATHLEN+80], 
       vsymname[SYMNAMLEN], *lbuf, *busyloc, tname[MAXPATHLEN+1], 
       tmpfnam[MAXPATHLEN+1], *as, *getattr(), *vnum(), *mktemp(), *malloc(),
       destname[MAXPATHLEN+1], lockdir[MAXPATHLEN+1], lockfn[MAXPATHLEN+1], 
       *intent, *getintent(), *lockerid(), *gettxt(), 
       destination[MAXPATHLEN+1];
       FILE *vfil, *bfile, *tfil;
       Af_attrs reqattrs, fattrs;
       Af_set hits;
       Af_key busy, tkey, tmpkey, busyfile,
       *busykey = &busyfile, *thiskey = &tkey;
       Af_user *locker;
       int nudattr = 0, nhits, nbytes;
       unsigned int pstat = 0;
       register int i;
       void mkBusyName();
       struct utimbuf old_date;

       
       destination[0] = '\0';
       if (!fname) return;
       if ((options & TYPEOUT) && !strcmp (fname, "-")) {
#        define IOBUFLEN 2048
	 char iobuf[IOBUFLEN];
	 int cr, cw;

	 logdiag ("stdin");
	 while ((cr=fread (iobuf, sizeof (char), IOBUFLEN, stdin))) {
	   cw=fwrite (iobuf, sizeof (char), cr, stdout);
	   (void)fflush (stdout);
	   if (cw != cr) logerr ("Oops! Write error on stdout");
	 }
	 (void)clearerr(stdin);
	 return;
       }
       af_initattrs (&reqattrs);
       busykey = &busyfile;
       getsyspath (fname, proj, spath, origpath, name);
       afname = af_afname (name);
       aftype = af_aftype (name);
       /* start fill out the warrant -- first 3 items may differ */
       (void)strcpy (reqattrs.af_name, afname);
       (void)strcpy (reqattrs.af_type, aftype);
       (void)strcpy (reqattrs.af_syspath, spath);
       
       /* ... the following settings will remain constant */
       if (options & VSPECSET) {
	 if (vdesc->v_vno) {
	   reqattrs.af_gen = gen(vdesc->v_vno);
	   reqattrs.af_rev = rev(vdesc->v_vno);
	 }
	 else {
	   (void)sprintf (vsymname, "%s=%s", SYMNAME, vdesc->v_spec);
	   reqattrs.af_udattrs[nudattr] = vsymname;
	   nudattr++;
	 }
       }
       if (options & ATTRDEF) {
	 reqattrs.af_udattrs[nudattr] = 
	   getattr (vdesc->v_attrf, proj, aftype, REWIND);
	 if (reqattrs.af_udattrs[nudattr]) nudattr++;
	 while (reqattrs.af_udattrs[nudattr] = getattr (vdesc->v_attrf, 
							proj, aftype, NEXT))
	   nudattr++;
       }
       if ((options & GENSET) && (!(options & VSPECSET))) {
	 reqattrs.af_gen = vdesc->v_genno;
       }
       if (options & AUNSET) {
	 (void)strcpy (reqattrs.af_author.af_username, vdesc->v_aunam);
	 (void)strcpy (reqattrs.af_author.af_userhost, vdesc->v_auhost);
       }
       if (options & STATSET) {
	 reqattrs.af_state = vdesc->v_state;
       }
       /* descriptive attributes are filled in now. 
	* lets try to find something 
	*/
       if (fail(af_find(&reqattrs, &hits))) {
	 if (!(options & QUIETPLEASE)) af_perror (fname);
	 abort_this(TRUE);
       }
       Register ((char *)&hits, AFSET);
       
       /* Now lets see what kind of deed needs to be done */
       nhits = af_nrofkeys (&hits);
       if (nhits == 0) {
	 (void)sprintf (messg, "No appropriate version of %s.", fname);
	 logerr (messg);
	 (void)sprintf (messg, NORESTORE, fname);
	 logerr (messg);
	 abort_this(FALSE);
       }
       if (nhits == 1) {
	 if (af_setgkey (&hits, 0, &tkey) == ERROR) {
	   af_perror ("af_setgkey");
	   abort_this (TRUE);
	 }
       }
       else if (nhits > 1) {
	 if (fail(af_sortset(&hits, AF_ATTVERSION))) {
	   af_perror ("af_sortset");
	   abort_this (TRUE);
	 }
	 if (!(options & DATESET)) {
	   if (af_setgkey (&hits, nhits-1, &tkey) == ERROR) {
	     af_perror ("af_setgkey");
	     abort_this (TRUE);
	   }
	 }
	 else { /* some cutoff-date was specified */
	   /* Don't consider busy version here */
	   af_setgkey (&hits, 0, &tmpkey);
	   if (af_rstate (&tmpkey) == AF_BUSY) {
	     af_setrmkey (&hits, &tmpkey);
	     nhits--;
	   }
	   for (i = nhits; i > 0; i--) {
	     if (af_setgkey (&hits, i-1, &tkey) == ERROR) {
	       af_perror ("af_setgkey");
	       abort_this (TRUE);
	     }
	     if (fail(af_gattrs(thiskey, &fattrs))) {
	       af_perror ("af_gattrs");
	       abort_this (FALSE);
	     }
	     if (fattrs.af_stime >= vdesc->v_time) {
	       af_setrmkey (&hits, thiskey);
	       udafree (&fattrs);
	     }
	     else {
	       udafree (&fattrs);
	       break;
	     }
	   } /* end loop */
	   if ((nhits = af_nrofkeys (&hits)) == 0) {
	     (void)sprintf (messg, "No appropriate version of %s.", fname);
	     logerr (messg);
	     abort_this (FALSE);
	   }
	 } /* end of else (some cut-off date) */
	 if ((options & XACT) && (nhits > 1)) {
	   if (!strcmp (progname, TONAME)) {
	     /*
	      * If argument was given in bound-notation, we'd had a more
	      * specific warrant, and would never come here. It's a different
	      * story regarding "vcat" in conjunction with other sort of 
	      * unsharp version description and "-x"
	      */
	     
	     if (af_sortset (&hits, AF_ATTVERSION) == ERROR) {
	       af_perror ("af_sortset");
	     }
	     /*
	      * try to get busy-version. if it doesn't exist, get most
	      * recent version. this means take af_keys from different
	      * ends of the set.
	      */
	     if (af_setgkey (&hits, 0, &tkey) == ERROR) {
	       af_perror ("af_setgkey");
	       abort_this (TRUE);
	     }
	     if (af_rstate (&tkey) != AF_BUSY) {
	       af_dropkey (&tkey);
	       if (af_setgkey (&hits, nhits-1, &tkey) == ERROR) {
		 af_perror ("af_setgkey");
		 abort_this (TRUE);
	       }
	     }
	   }
	   else {
	     (void)sprintf (messg, "No exact hit for %s. (got %d)", 
			    fname, nhits);
	     logerr (messg);
	     (void)sprintf (messg, NORESTORE, fname);
	     logerr (messg);
	     abort_this (FALSE);
	   }
	 }
       }
       else {
	 (void)sprintf (messg, "%d is an unreasonble number of hits.", nhits);
	 logerr (messg);
	 abort_this (TRUE);
       }
       
       /*
	* "thiskey" is a pointer to the (key of the) version that was
	* referenced by the user.
	*/
       
       if (fail(af_gattrs(thiskey, &fattrs))) {
	 af_perror ("af_gattrs");
	 abort_this (FALSE);
       }
       mkBusyName (thiskey, name);
       Register ((char *)&fattrs, AFATTRS);
       /* at this point we do have a single af_key and 'thiskey' points 
	* at it. now decide what 
	* to do with it. fattrs contains its attributes.
	*/
       switch (options & (TYPEOUT | COPY | LOCKIT)) {
       case TYPEOUT:
	 if (!(vfil = af_open (thiskey, "r"))) {
	   af_perror ("af_open");
	   abort_this (TRUE);
	 }
	 mkvstring (messg, thiskey);
	 logdiag (messg);
	 if ((lbuf = malloc ((unsigned)fattrs.af_size)) == (char *) NULL) {
	   logerr("Out of memory.");
	   abort_this(TRUE);	/* Uli */
	 }
	 nbytes=fread (lbuf, sizeof (*lbuf), (Size_t)fattrs.af_size, vfil);
	 if (NoExpandFlag) /* added by uli@coma */
	   fwrite(lbuf, sizeof(*lbuf), (Size_t) nbytes, stdout);
	 else
	   WriteXPand (lbuf, nbytes, stdout, thiskey);
	 free (lbuf);
	 af_close (vfil);
	 UnRegister ((char *)&hits, AFSET);
	 af_dropset (&hits);
	 UnRegister ((char *)&fattrs, AFATTRS);
	 udafree (&fattrs);
	 return;
	 break;
       case COPY:
	 /* This option creates a plain UNIX file from the specified
	  * AtFS file. The created copy is - in general - an object without
	  * history. If, however, the copy happens to go into the 
	  * history-directory (the one containing the archive) it will
	  * 'automatically' be considered the busy-version.
	  * If - in this case - a copy replaces a formerly locked busy-version,
	  * the lock will be released.
	  */
	 busyloc = destpath ? destpath : spath ;
	 (void)strcpy (destination, busyloc);
	 (void)sprintf (destname, "%s%s%s", destination[0] ? destination : "", 
			destination[0] ? "/" : "", name);
	 if ((tfil = fopen (destname, "r")) == NULL) {
	   /* take this as test for presence */
	   if (access (busyloc, W_OK) == 0) { /* may we create ? */
	     pstat |= DOIT; /* No scruples if no busyvers current */
	   }
	   else {
	     (void)sprintf (messg, "write permission for directory %s denied.",
			    busyloc);
	     logerr (messg);
	     pstat |= DENIED;
	   }
	 }
	 else { /* file exists */
	   (void)fclose (tfil);
	   if (access (destname, W_OK) < 0) {
	     if (access (busyloc, W_OK) == 0) {
	       (void)sprintf (messg, "%s write-protected, re-create it ?",
			      destname);
	       if (options & QUIETPLEASE) {
		 pstat |= (options & FORCE) ? (RECREATE | DOIT) : DENIED;
	       }
	       else {
		 if (ask_confirm (messg, "no")) {
		   pstat |= DENIED;
		 }
		 else {
		   pstat |= (RECREATE | DOIT);
		 }
	       }
	     }
	     else { 
	       (void)sprintf (messg, "no write permission for %s", destname);
	       logerr (messg);
	       pstat |= DENIED;
	     }
	   }
	   else { /* write access on destfile */
	     if (strcmp (busyloc, ".")) {
	       (void)sprintf (messg, "%s exists and is writable. Overwrite it ?",
			      destname);
	       if (options & QUIETPLEASE) {
		 pstat |= (options & FORCE) ? DOIT : 0;
	       }
	       else {
		 if (!ask_confirm (messg, "no")) {
		   pstat |= DOIT;
		 }
	       }
	     }
	     else { /* current dir! - test for lock */
	       if (fail (af_getkey (spath, afname, aftype, AF_BUSYVERS,
				    AF_BUSYVERS, &busy)))
		 /*
		  * "busy" is (normally) the key of a busy-version 
		  * i.e. a file that relates to a referenced version 
		  * in the archive.
		  */
		 
		 { /* No busy-key -- no lock, this is impossible here */
		   checkAtFSerr(fname);
		   pstat |= DOIT;
		 }
	       else {
		 if (lockeruid (vc_testlock (&busy)) == geteuid ()) {
		   (void)sprintf (messg, "Give up lock on %s and overwrite it ?",
				  destname);
		   if (options & QUIETPLEASE) {
		     pstat |= (options & FORCE) ? DOIT : 0;
		   }
		   else {
		     if (!ask_confirm (messg, "no")) {
		       pstat |= DOIT;
		       (void)vc_unlock (&busy);
		     }
		     else {
		       pstat |= DENIED;
		     }
		   }
		 }
		 else {
		   pstat |= DOIT;
		 }
	       }
	     }
	   }
	 }
	 if (pstat & DOIT) {
	   if ((vfil=af_open(thiskey, "r")) == NULL) {
	     af_perror ("af_open");
	     abort_this (TRUE);
	   } 
	   (void)strcpy (tmpfnam, "retrvXXXXXX");
	   (void)sprintf (tname, "%s%s%s", destpath ? destpath : "",
			  destpath ? "/" : "", mktemp(tmpfnam));
	   if ((bfile = fopen (tname, "w")) == NULL) {
	     (void)sprintf (messg, "cannot create tmp-file (%s) for writing.",
			    tname);
	     logerr (messg);
	     abort_this (TRUE);
	   }
	   Register (tname, TYPEF);
	   (void)sprintf (messg, "%s%s%s[%s] -> %s", spath[0] ? spath : "",
			  spath[0] ? "/" : "", name, vnum (thiskey), destname);
	   logdiag (messg);
	   if ((lbuf = malloc ((unsigned)fattrs.af_size)) == (char *) NULL){
	     logerr("Out of memory");
	     abort_this(TRUE);	/* Uli */
	   }
	   nbytes=fread (lbuf, sizeof (*lbuf), (Size_t)fattrs.af_size, vfil);
	   if (NoExpandFlag) /* added by uli@coma */
	     fwrite(lbuf, sizeof(*lbuf), (Size_t) nbytes, bfile);
	   else
	     WriteXPand (lbuf, nbytes, bfile, thiskey);
	   free (lbuf);
	   (void)fclose (bfile); (void)fclose (vfil);
	   old_date.actime = fattrs.af_atime;
	   old_date.modtime = fattrs.af_mtime;
	   (void) utime (tname, &old_date);
	   (void)unlink (destname);
	   if (link (tname, destname) < 0) {
	     perror (destname);
	     abort_this (TRUE);
	   }
	   chmod (destname, fattrs.af_mode & ~0222);
	   UnRegister (tname, TYPEF);
	   (void)unlink (tname);
	 }
	 else {
	   (void)sprintf (messg, "%s not retrieved", fname);
	   logerr (messg);
	   ThisTransaction.tr_rc += 1;
	 }
	 UnRegister ((char *)&hits, AFSET);
	 af_dropset (&hits);
	 UnRegister ((char *)&fattrs, AFATTRS);
	 udafree (&fattrs);
	 return;
	 break;
       case LOCKIT:
	 /*
	  *  Before a version is retrieved, set-busy, and locked, the
	  *  following preconditions must be fulfilled:
	  *  - the retrieve must go to the directory containing the 
	  *    archive directory. -> current directory
	  *  - the retrieved version must not be locked by anybody but
	  *    the calling user.
	  *  - the current directory must grant write access to the 
	  *    calling user.
	  *  - if some busy-version would be overwritten by the retrieve,
	  *    the user is asked if she wants that
	  */
	 if ((destpath) && (destpath[0])) {
	   (void)sprintf (messg, "can't checkout (with lock) to %s.", destpath);
	   logerr (messg);
	   abort_this (FALSE);
	 }
	 (void)sprintf (lockfn, "%s%s%s", spath[0] ? spath : "", 
			spath[0] ? "/" : "", name);
	 (void)sprintf (lockdir, "%s", spath[0] ? spath : ".");
	 /*
	  *  The following checks are based on the permission information
	  *  stored in the archive files. It is unclear how
	  *  to properly handle vanilla filesystem related inquiries.
 	  */
	 if (fail (af_getkey (spath, afname, aftype,
			      (options & FIX) ? 
			         (vdesc->v_vno ? gen(vdesc->v_vno) : 
				    (vdesc->v_genno ? vdesc->v_genno :
				       AF_LASTVERS)) :
			      AF_LASTVERS, AF_LASTVERS, &busy))) {
	   /*
	    * "busy" is in this case the key where a (generation) lock
	    * is attached to. This is the last version in a generation.
	    * It also is the key that holds the intent
	    * description for a given change transaction. That we use the 
	    * name "busy" for this key has historical reasons. It is
	    * IMPORTANT to avoid confusion with the "busykey" that is 
	    * introduced later.
	    */
	   
	   af_perror (name);
	   abort_this (TRUE);
	 }
	 else { /* there is a version */
	   if (((lockeruid (locker = vc_testlock (&busy))) 
		== geteuid ()) || !(locked (locker))) {
#ifdef AFACCOK
	     if (af_access (spath[0] ? spath : ".", afname, 
			    aftype, W_OK) == 0) {
#else
	       if (access (fname, W_OK) == 0) {
#endif
		 (void)sprintf (messg, "Writable %s exists, overwrite it ?", lockfn);
		 if (options & QUIETPLEASE) {
		   pstat |= (options & FORCE) ? DOIT : DENIED;
		 }
		 else {
		   pstat |= (ask_confirm (messg, "no")) ? DENIED : DOIT;
		 }
	       }
	       else if (access (lockdir, W_OK) == 0) {
		 if (access (lockfn, F_OK) == 0) {
		   (void)sprintf (messg, 
				  "Write access on %s denied. Overwrite it anyway ?",
				  lockfn);
		   if (options & QUIETPLEASE) {
		     pstat |= (options & FORCE) ? DOIT : DENIED;
		   }
		   else {
		     pstat |= (ask_confirm (messg, "no")) ? DENIED : DOIT;
		   }
		 }
		 else pstat |= DOIT;
	       }
	       else { /* no write access on current dir */
		 (void)sprintf (messg, "Can't create in %s", lockdir);
		 logerr(messg);
		 abort_this (TRUE);
	       }
	       if (!locked(locker)) {
		 if (!vc_lock (&busy, geteuid())) {
		   af_perror ("af_lock");
		   abort_this (TRUE);
		 }
		 NewLock = &busy;
	       }
	     }
	     else { /* busy version locked by someone else */
	       pstat |= DENIED;
	       (void)sprintf (messg, "%s already locked by %s.", lockfn, 
			      lockerid(locker));
	       logerr (messg);
	       (void)sprintf (messg, NORESTORE, fname);
	       logerr (messg);
	       abort_this (FALSE);
	     }
	   } 
	   /* now all the checks are done. set retrieved version busy and 
	    * create it in lockdir.
	    */
	   if ((pstat & DOIT) && (!(pstat & DENIED))) {
	     
	     /*
	      * Try to get a description of intended changes.
	      */
	     
	     if (options & INTENTSET) {
	       intent = gettxt (intent_fname);
	     }
	     else if (!((options & QUIETPLEASE) || (options & FORCE))
		      || StdinFlag) {
	       (void) sprintf(messg, "Describe intended changes of %s ?",
			      name);
	       intent = getintent (messg, (char *)NULL, StdinFlag, name);
	     }
	     else intent = (char *)NULL;
	     
	     
	     /*
	      * Create the file, containing the retrieved version.
	      * "busykey" is set up to be the AtFS reference to the file.
	      */
	     
	     /* setbusy sets just the attributes. data must be moved manually */
	     if ((vfil=af_open(thiskey, "r")) == NULL) {
	       af_perror ("af_open");
	       abort_this (TRUE);
	     } 
	     (void) strcpy (tmpfnam, "retrvXXXXXX");
	     (void)sprintf (tname, "%s/%s", lockdir, mktemp(tmpfnam));
	     if ((bfile = fopen (tname, "w")) == NULL) {
	       (void)sprintf (messg, "cannot create tmp-file (%s) for writing.",
			      tname);
	       logerr (messg);
	       af_close (vfil);
	       abort_this (TRUE);
	     }
	     Register (tname, TYPEF);
	     (void)sprintf (messg, "%s%s%s[%s] -> %s%s%s", spath[0] ? spath : "", 
			    spath[0] ? "/" : "", name,
			    vnum (thiskey), spath[0] ? spath : "", 
			    spath[0] ? "/" : "",
			    name);
	     logdiag (messg);
	     
	     /* there's no attribute citation for locked busy versions .... */
	     if ((lbuf = malloc ((unsigned)fattrs.af_size)) == (char *) NULL){
	       logerr("Out of memory");
	       abort_this(TRUE);	/* Uli */
	     }
	     nbytes=fread (lbuf, sizeof (*lbuf), (Size_t)fattrs.af_size, vfil);
	     if (fwrite (lbuf, sizeof (*lbuf), nbytes, bfile) != nbytes) {
	       logerr ("fatal: couldn't write busy file.");
	       abort_this (TRUE);
	     }
	     free (lbuf);
	     (void)fclose (bfile);
	     old_date.actime = fattrs.af_atime;
	     old_date.modtime = fattrs.af_mtime;
	     (void) utime (tname, &old_date);
	     (void)chmod (tname, (int) fattrs.af_mode);
	     af_close (vfil);
	     (void)unlink (fname);
	     (void)link (tname, fname);
	     ThisTransaction.tr_done = TRUE;
	     UnRegister (tname, TYPEF);
	     (void)unlink (tname);
	     
	     (void) af_dropkey (busykey);
	     if (af_crkey (spath, afname, aftype, busykey) < 0) {
	       af_perror ("af_crkey");
	       abort_this (TRUE);
	     }
	     /*
	      * "busykey" points to the key of a newly created file, which 
	      * has been retrieved from the version archive in case no 
	      * file was present.
	      */
	     
	     /*
	      * Register the busyversion appropriately: set busy if
	      * needed, attach (most of) the user-defined attributes
	      * of the original version, attach intent-description.
	      */
	     
	     if (!(options & FIX)) {
	       Af_key previous_busy;

	       if (fail(af_setbusy(busykey, thiskey, &previous_busy))) {
		 af_perror ("af_setbusy");
		 abort_this (TRUE); /* check out what happens in abort_this */
	       }
	     }
	     
	     i = 0;
	     while (as = fattrs.af_udattrs[i++]) {
	       if (fail(af_sudattr (busykey, AF_REPLACE, as)))
		 af_sudattr (busykey, AF_ADD, as);
	     }
	     af_sudattr (busykey, AF_REMOVE, "__SymbolicName__");
	     {
	       char *today = af_asctime(), *lockdate, *c;
	       if (c = rindex (today, '\n')) *c = '\0';
	       lockdate = malloc ((unsigned) (strlen (RESERVED_ON) + 
					      strlen (today) + 2));
	       if (lockdate) {
		 (void)sprintf (lockdate, "%s=%s", RESERVED_ON, today);
		 if (fail(af_sudattr (busykey, AF_REPLACE, lockdate)) &&
		     fail(af_sudattr (busykey, AF_ADD, lockdate))) {
		   (void)sprintf (messg, "Can't set reservation date for %s.",
				  name);
		   af_perror (messg);
		 }
		 free (lockdate);
	       }
	     }
	     
	     if (intent) {
	       char *intattr, *todaystr = af_asctime(), *c, *is;
	       /* af_asctime is an unofficial AtFS-function -- should be public */
	       
	       if (c = rindex (todaystr, '\n')) *c = '\0';
	       
	       intattr = malloc ((unsigned)(strlen (intent)+strlen (INTENT)+ 
					    strlen (todaystr) + 3 + 1));
	       if (intattr == (char *) NULL) {
		 logerr("Out of memory");
		 abort_this(TRUE); /* Uli */
	       }
	       else {
		 is = malloc ((unsigned)(strlen(INTENT)+1));
		 if (is) {
		   strcpy (is, INTENT);
		   c = index (is, '=');
		   *c = '\0';
		   (void)sprintf (intattr, "%s=[%s] %s%s", is, todaystr, ++c, 
				  intent);
		   free (is);
		 }
		 else
		   (void)sprintf (intattr, "%s%s", INTENT, intent);
		 
		 if (fail(af_sudattr (&busy, AF_REPLACE, intattr)) &&
		     fail(af_sudattr (&busy, AF_ADD, intattr))) {
		   (void)sprintf (messg, "Can't set change intent for %s.",
				  name);
		   af_perror (messg);
		   free (intattr);
		 }
	       }
	     }
	   }
	   else { /* denied or not doit */
	     (void)sprintf (messg, NORESTORE, ThisTransaction.tr_fname);
	     logerr (messg);
	     ThisTransaction.tr_rc += 1;
	   }
	   UnRegister ((char *)&fattrs, AFATTRS);
	   udafree (&fattrs);
	   UnRegister ((char *)&hits, AFSET);
	   af_dropset (&hits);
	   break;
	 default:
	   logerr ("fatal: illegal action switch in doretrv.c");
	   break;
	 }
       }

void mkBusyName (key, name) 
  Af_key *key; char *name; {
    char *n, *t;

    if (!key) return;

    n = af_rname (key);
    t = af_rtype (key);
    t = t ? t : "";

    sprintf (name, "%s%s%s", n ? n : "", n ? t[0] ? "." : "" : ".", t[0] ? t : "");
  }

char *gettxt (fname) char *fname; {
  static char *txt = EMPTYINTENT;
  FILE *txtfil;
  struct stat statbuf;
  static int firsttime = TRUE;

  if (firsttime) {
    firsttime = FALSE;
    if ((txtfil = fopen (fname, "r")) == NULL) {
      logwarn ("no intention text file");
    }
    else {
      if (fstat (fileno(txtfil), &statbuf) == -1) {
	perror ("fname");
      }
      else {
	txt = malloc ((unsigned)(statbuf.st_size+1));
	if (!txt) {
	  logwarn ("not enough memory for intention text.");
	  txt = EMPTYINTENT;
	}
	else {
	  bzero(txt, (int) statbuf.st_size+1);
	  (void)fread (txt, sizeof (char), (Size_t)statbuf.st_size, txtfil);
	  (void)fclose (txtfil);
	}
      }
    }
  }
  return txt;
}
