/*
  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

 *
 * $Header: utime.c[1.11] Wed Mar 11 20:09:55 1992 nickel@cs.tu-berlin.de accessed $
 * set access time and mdification time of files
 */

#include "config.h"
#include <stdio.h>

void usage() ;

int main(argc, argv)
int argc ;
char **argv ;
{
    struct utimbuf utb ;
    int errors = 0 ;

    if (argc < 4) {		/* Test number of arguments */
	if (argc == 2 && ! strcmp(argv[1], "-version")) {
	    (void) fputs("$Header: utime.c[1.11] Wed Mar 11 20:09:55 1992 nickel@cs.tu-berlin.de accessed $\n", stdout) ;
	    (void) exit(0) ;
	}
	usage() ;
	(void) exit(1) ;
    }

				/* Check and read time arguments */
    if (sscanf(*++argv, "%ld", &utb.actime)  != 1 ||
	sscanf(*++argv, "%ld", &utb.modtime) != 1)
    {
	usage() ;
	(void) exit(1) ;
    }

				/* Set times of file arguments */
    while (*++argv) {
	if (utime(*argv, &utb)) {
	    (void) perror(*argv) ;
	    errors++ ;
	}
    }
				/* return error code */
    return errors ;
}

void usage()
{
    fputs("Usage: utime atime mtime file ...\n", stderr) ;
}
