/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: varsec.c[1.16] Mon Apr  6 22:04:36 1992 axel@cs.tu-berlin.de accessed $";
#endif


#include "shape.h"

struct vardef variantDefs[MAXVARDEFS];

static int lastVariantDef = 0;

struct varclass variantClasses[MAXVCLASS];

char *curvar[MAXACTVAR] = {"","","","","","","","",
			     "","","","","","","","",
			     "","","","","","","","",
			     "","","","","","","",""};

varsec_name(string)
     char *string;
{
  register char *p;
  register int k = 0;

  if (( p = index(string,':')) == 0)
    errexit(14, string);

  *p = '\0';
  while (variantDefs[k].name)
    {
      if (!strcmp (variantDefs[k].name, string))
	errexit (33, string);
      k++;
      if (k == MAXVARDEFS)
	errexit (27, "variant definitions");
    }

  if ((variantDefs[k].name = malloc((unsigned) (strlen(string) + sizeof(char)))) == NIL)
    errexit(10,"malloc");
  (void) strcpy (variantDefs[k].name, string);

  lastVariantDef = k;
  variantDefs[k+1].name = NIL;

  variantDefs[k].vpath = NIL;
  variantDefs[k].vflags = NIL;
  
  for(k = 0; k < MAXVMACROS; k++)
    variantDefs[lastVariantDef].vmacros[k] = NIL;
}


varmacrodef(string)
     char *string;
{
  register char *p;
  register int k = 0;
  char vpath_name[MYMAXNAMLEN];

  if (string[strlen(string) - 1] == '\n')
    string[strlen(string) - 1] = '\0';

  while((*string == '\t') || (*string == ' '))
    string++;

  if(!strncmp(string,"vpath",5))
    {
      if ((p = index(string,'=')) == NIL)
	errexit(7, string);
      p++;
      while((*p == ' ') || (*p == '\t'))
	p++;

      if(strcmp(p,".."))
	(void) strcpy(vpath_name,p);
      else
	(void) strcpy(vpath_name,prev_dir);
            
      if ((variantDefs[lastVariantDef].vpath = malloc((unsigned) (strlen(vpath_name)+sizeof(char)))) == NIL)
	errexit(10,"malloc");
      (void) strcpy(variantDefs[lastVariantDef].vpath, vpath_name);
      return;
    }

  if(!strncmp(string,"vflags",6))
    {
      if ((p = index(string,'=')) == NIL)
	errexit(7, string);
      p++;
      while((*p == ' ') || (*p == '\t'))
	p++;
      
      if ((variantDefs[lastVariantDef].vflags = malloc((unsigned) (strlen(p)+sizeof(char)))) == NIL)
	errexit(10,"malloc");
      (void) strcpy(variantDefs[lastVariantDef].vflags, p);
      return;
    }

  while(variantDefs[lastVariantDef].vmacros[k])
    k++;
  
  if ((variantDefs[lastVariantDef].vmacros[k] = malloc((unsigned) (strlen(string) + sizeof(char)))) == NIL)
    errexit(10,"malloc");
  (void) strcpy(variantDefs[lastVariantDef].vmacros[k], string);
}
  


int vardump(fd)
     FILE *fd;
{
register int i = 0, k = 0;

if (variantDefs[i].name)
  {

    fprintf(fd,"#%% VARIANT-SECTION\n");

    for(i = 0; variantDefs[i].name; i++)
      {
	fprintf(fd,"\n");

	fprintf(fd,"%s:\n", variantDefs[i].name);

	if(variantDefs[i].vflags != NIL)
	  fprintf(fd,"\tvflags = %s\n", variantDefs[i].vflags);

	if(variantDefs[i].vpath != NIL)
	  fprintf(fd,"\tvpath = %s\n", variantDefs[i].vpath);

	while(variantDefs[i].vmacros[k] != NIL)
	  {
	    fprintf(fd,"\t%s\n",variantDefs[i].vmacros[k]);
	    k++;
	  }
	k = 0;
      }
    fprintf(fd,"\n");

    fprintf(fd,"#%% END-VARIANT-SECTION\n");
    
    (void) fflush(fd);
  }
}

	    
int vclassdef (string)
     char *string;
{
  register char *p;
  char *vclassName, *varName;
  register int k=0, l=0;
  int endDef=FALSE;


  p = &string[6]; /* this is a bit dangerous: depends on keyword "vclass" */

  while ((*p == ' ') || (*p == '\t')) p++; /* skip whitespace */

  vclassName = p;
  while ((*p != ' ') & (*p != '\t')) /* goto end of vclass name */
    {
      if (!*p) errexit (14, string); /* end of line */
      p++;
    }
  *p = '\0';
  p++;

  while (variantClasses[k].name)
    {
      if (!strcmp (variantClasses[k].name, vclassName))
	errexit (39, vclassName);
      k++;
      if (k == MAXVCLASS)
	errexit (27, "vclass definitions");
    }
      
  if ((variantClasses[k].name = malloc((unsigned) (strlen(vclassName) + sizeof(char)))) == NIL)
    errexit(10,"malloc");
  (void) strcpy (variantClasses[k].name, vclassName);
  variantClasses[k].active = -1;

  while (*p != ':') /* search "::=" */
    {
      if (!*p) errexit (14, string); /* end of line */
      p++;
    }

  while (*p != '(')
    {
      if (!*p) errexit (14, string); /* end of line */
      p++;
    }
  p++;

  while(*p != ')')
    {
      while((*p == ' ') || (*p == '\t')) p++; /* skip layout */
      varName = p;

      while ((*p != ',') && (*p != ')') && (*p != ' ') && (*p != '\t'))
	{
	  if (!*p) errexit (14, string); /* end of line */
	  p++;
	}
      if (*p == ')') endDef = TRUE;

      *p = '\0';
      if ((variantClasses[k].variants[l] = malloc((unsigned) (strlen(varName) + sizeof(char)))) == NIL)
	errexit(10,"malloc");
      (void) strcpy(variantClasses[k].variants[l], varName);
      l++;

      if (endDef)
	*p = ')';
      else
	p++;

      while((*p == ' ') || (*p == '\t') || (*p == ',')) p++; /* skip layout */
    }
  variantClasses[k].variants[l] = NIL;
  return (0);
}

	
Bool check_vclass(varname)
     char *varname;
{
  register int i = 0, j = 0;
  
  while(variantClasses[i].name)
    {
      j = 0;
      while(variantClasses[i].variants[j] != NIL)
	{
	  if(strcmp(variantClasses[i].variants[j],varname) == 0)
	    {
	      if((variantClasses[i].active != -1) && (variantClasses[i].active != j))
		return(FALSE);
	      variantClasses[i].active = j;
	      return(TRUE);
	    }
	  j++;
	}
      i++;
    }
  if(!variantClasses[i].name)
    return(TRUE);
/*NOTREACHED*/
return(FALSE);
}

reset_vclass()
{
  register int i = 0;

  while( variantClasses[i].name)
    {
      variantClasses[i].active = -1;
      i++;
    }
}


    
Bool is_varname(string)
     char *string;
{
  register char *p;
  register int k = 0;

  if(string == NIL)
    return(FALSE);

  if(string[0] != '+')
    return(FALSE);
  else
    if (string[1] == '\0')
      return(TRUE);

  p = &string[1];

  while ((k < MAXVARDEFS) && variantDefs[k].name)
    {
      if(!strcmp(variantDefs[k].name,p))
	return(TRUE);
      k++;
    }
  return(FALSE);
}
