/*  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: sighand.c[1.13] Sat Feb  8 15:38:22 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include <signal.h>
#include <stdio.h>
#include "shape.h"

extern int cleanup_links();
extern struct linkreg *link_reg;
extern int errexit();

catch_sigs () {
/*
 * Setup signal handlers for various signals. Previous handlers
 * are saved. On receipt of a signal, the 
 * original handler for this signal will be invoked after specified
 * action has been taken.
 */
Sigret_t
  die1(), die2(), die3(), die4(), die5(), die6(), 
  die7(), die8(), die9(), die10(),
  die11(), die12(), die13(), die14(), die15();

  (void) signal (SIGINT, die2);
  (void) signal (SIGBUS, die10);
  (void) signal (SIGSEGV, die11);
  (void) signal (SIGFPE, die8);
  (void) signal (SIGTERM, die15);
}


Sigret_t die2 () {
  (void) signal(SIGINT,SIG_IGN);
  errexit(23,"\0");
}

Sigret_t die8 () {
  (void) signal(SIGINT,SIG_IGN);
  fprintf(stderr, "Oh! Oh! .... this was a floating exception -- goodbye.\n"); 
  af_cleanup ();
  cleanup_links(link_reg);
  exit (1);
}

Sigret_t die10 () {
  fprintf(stderr, "Oh! Oh! .... this was a buserror -- goodbye.\n");
  fprintf(stderr, "Dumping core.\n");
  af_cleanup ();
  cleanup_links(link_reg);
  (void) kill (getpid(), SIGQUIT);
}

Sigret_t die11 () {
  (void) signal(SIGINT,SIG_IGN);
  fprintf(stderr, 
	  "Oh! Oh! .... this was a segmentation violation -- goodbye.\n");
  fprintf(stderr, "Dumping core.\n");
  af_cleanup ();
  cleanup_links(link_reg);
  (void) kill (getpid(), SIGQUIT);
}

Sigret_t die15 () {
  (void) signal(SIGINT,SIG_IGN);
  af_cleanup();
  cleanup_links(link_reg);
  exit(1);
}

