/*  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */

/* Thanks to Steve Emerson (steve@unidata.ucar.edu) for the 
   reimplementation of expandmacro() */

#ifndef lint
static char *AtFSid = "$Header: macro.c[1.43] Thu Apr 23 22:15:29 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include <stdio.h>
#include <ctype.h>
#include "macro.h"
#include "shape.h"

extern FILE *vmfopen(), *popen();
extern void addHash();
extern char *getHash();
extern char *get_variant_macro(), *call_popen(), *cleaned();
extern char *curvar[], *newarg[];
extern Bool no_comm_subst;
extern int newargc;
extern struct vardef variantDefs[];
char *environment_vars = NIL;
FILE *temp;
Bool shape_command = FALSE;

char *curvpath[MAXVPATH] = {NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,
		      NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL};
int macdepth;
int variants_active = 0;
Bool command_line_seen = FALSE;

char *get_next_item(string)
     char *string;
{
  register char *p1;

  if ((p1 = index(string,' ')) != NIL)
    {
      *p1 = '\0';
      return string;
    }
  else
    return string;
}


char *getlin(file)
     FILE *file;
{
  static char line[MAXLINELENGTH];
  char line2[MAXLINELENGTH];
  register int len = 0, off;

  if (fgets(line, MAXLINELENGTH, file))
    {
      len = strlen(line);
      while (len >= 2 && (line[len-2] == '\\') && (line[len-1] == '\n'))
	{
	  off = 3;
	  while((line[len-off] == ' ') || (line[len-off] == '\t'))
	    off++;
	  line[len-off+1] = ' ';
	  line[len-off+2] = '\0';
	  (void) fgets(line2, MAXLINELENGTH, file);
	  if(line2[0] == '\t')
	    {
	      off = 0;
	      while((line2[off] == '\t') || (line2[off] == ' '))
		off++;
	      (void) strcat(line,&line2[off]);
	    }
	  else
	    (void) strcat(line,line2);
	  len = strlen(line);
	}
      len = strlen(line);
      line[len-1] = '\0';
      return (line);
    }
  return(NIL);
}


get_macros(file)
     FILE *file;
{
  FILE *incfile;
  register char *line, *incp;
  register int inck;
  char incfilename[MYMAXNAMLEN];
  extern char *expandmacro(), *include_macro();

  while((line = getlin(file)) != NIL)
    {
      if (!*line) continue;

      if(((strncmp(line,INCLUDE1,8)) == 0) || (strncmp(line,INCLUDE2,8) == 0))
	{
	  inck = 8;
	  while ((line[inck] == '\t') || (line[inck] == ' '))
	    inck++;
	  if ((incp = rindex(line+inck,' ')) != NIL)
	    *incp = '\0';
	  if ((incp = rindex(line+inck,'\t')) != NIL)
	    *incp = '\0';
	  if (index(line+inck,'$') != NIL)
	    (void) strcpy(incfilename,include_macro(line+inck));
	  else
	    (void) strcpy(incfilename,line+inck);
	  if ((incfile = vmfopen(incfilename,"r",AF_BUSYVERS,AF_BUSYVERS)) == NULL)
	    errexit(24,incfilename);
	  else
	    {
	      get_macros(incfile);
	      (void) fclose(incfile);
	    }
	}
      else
	{
	  handle_comments(line);
	  if (!echoflg) {
	    fputs(line,temp);
	    fputs("\n",temp);
	  }
	  macrodef(line);
	}
    }
}


macrodef(line)
     char *line;
{
  char *name, *value, *enventry;
  char line2[2048];
  register char *p1, *p2;
  int appendMacro = FALSE;

  if (!line)
    return;

  for (p1 = line + strlen(line); p1-- > line && isspace(*p1); *p1 = 0); /* empty loop body */

  if (*line != '\t')
    {
      p1 = index(line,'=');
      p2 = index(line,':');

      if((p2 != NIL) && (p2 < p1))
	return;
      
      if ((p1 != NIL) && 
	(p1 < line+1 || *(p1-1) != ':') && 
	(p1 < line+2 || *(p1-2) != ':'))
	{
	  if ((p2 == NIL) || (p1 < p2))
	    {
	      *p1 = '\0';
	      p2 = p1;
	      p2--;
	      if (*p2 == '+')
		{
		  *p2-- = '\0';
		  appendMacro = TRUE;
		}
	      
	      while((*line == '\t') || (*line == ' '))
		line++;
	      while((*p2 == ' ') || (*p2 == '\t'))
		*p2-- = '\0';
	      name = line;
	    }
	  p1++;
	  while((*p1 == '\t') || (*p1 == ' '))
	    p1++;
	  value = p1;
	  if (!strcmp(name,"RECDEPTH"))
	    {
	      rec_do_depth = atoi(value);
	    }
	  if (strcmp(name,IMPORT))
	    {
	      addHash (name, value, appendMacro);
              if (!strcmp(name,"VPATH"))
		insertvpath(value);
            }
	  else
	    { 
	      /* get environment variables */
	      if (environment_vars == NIL)
		{
		  if((environment_vars = malloc((unsigned) (strlen(value) +
							    (sizeof (char)))))
		     == NIL)
		    errexit(10,"malloc");
		  (void) strcpy(environment_vars,value);
		}
	      else
		{
		  if((environment_vars =
		      realloc(environment_vars, (unsigned) (strlen(environment_vars)) + strlen(value) + 3)) == NIL)
		    errexit(10,"realloc");
		  (void) strcat(environment_vars," ");
		  (void) strcat(environment_vars,value);
		}

	      while((envflg == TRUE) &&
		    ((name = get_next_item(value)) != NIL))
		{
		  if (strcmp(value,"") == 0)
		    break;
		  value = index(value,'\0');
		  value++;
		  if ((enventry = getenv(name)) != NIL)
		    {
		      (void) strcpy(line2,name);
		      (void) strcat(line2,"=");
		      (void) strcat(line2,enventry);
		      macrodef(line2);
		    }
		}
	    }
	}
    }
}



#define	LEFT_PAREN	'('
#define	RIGHT_PAREN	')'
#define	LEFT_BRACE	'{'
#define RIGHT_BRACE	'}'

#include "strbuf.h"

    char*
expandmacro(inpstring)
    char		*inpstring;	/* Input string to be command- and
					 * macro-expanded */
{
    char		*p;			/* Position in cmd_buf */
    char		*base;			/* Scan start in string */
    sb_ptr		cmd_buf	= sbnew(1024);	/* Cmd-expansion buffer */
    sb_ptr		mac_buf	= sbnew(1024);	/* Mac-expansion buffer */
    sb_ptr		name	= sbnew(64);	/* Macro name */
    static sb_ptr	fin_buf	= 0;		/* Final string-buffer */
    Bool                shape_macro_xp = FALSE;

    if (mac_buf == 0 ||
	cmd_buf == 0 ||
	name == 0)
	errexit(10, "sbnew");

    /*
     * Allocate final string-buffer if necessary.
     */
    if (fin_buf == 0)
	if ((fin_buf = sbnew(1024)) == 0)
	    errexit(10, "sbnew");

    /*
     * Terminate if macro nested too deeply.
     */
    if (++macdepth > 50)
	errexit(25, inpstring);

    if (no_comm_subst) {
	/*
	 * No command-expansion allowed, just copy input string to
	 * command-expansion buffer.
	 */
	if (sbcpy(cmd_buf, inpstring, strlen(inpstring)) == 0)
	    errexit(10, "sbcpy");

    } else {
	/*
	 * Command-expand input string into command-expansion buffer.
	 */
	char	*p1;		/* Points to initial '`' in input string */

	/*
	 * Loop through input string -- expanding each command-invocation
	 * in turn.
	 */
	for (base = inpstring; (p1 = index(base, '`')) != 0; ) {
	    char	*p2	= index(p1+1, '`');

	    if (p2 == 0) {
		int	len	= strlen(base);
		if (sbcat(cmd_buf, base, len) == 0)
		    errexit(10, "sbcat");
		base	+= len;
	    } else if ((p1 > base && p1[-1] == '\\') ||
			p2[-1] == '\\') {
		if (sbcat(cmd_buf, base, p2+1-base) == 0)
		    errexit(10, "sbcat");
		base	= p2 + 1;
	    } else {
		char	*call_popen();
		char	*expcomm	= call_popen(p1+1);

		if (sbcat(cmd_buf, base, p1-base) == 0)
		    errexit(10, "sbcat");
		if (sbcat(cmd_buf, expcomm, strlen(expcomm)) == 0)
		    errexit(10, "sbcat");
		base	= p2 + 1;
	    }
	}					/* command-subst loop */

	if (sbcat(cmd_buf, base, strlen(base)) == 0)
	    errexit(10, "sbcat");
    }						/* command-subst enabled */

    /*
     * Loop through command-expanded string -- expanding each macro in turn.
     */
    for (base = sbstr(cmd_buf); (p = index(base, '$')) != 0; ) {

	/*
	 * Place head of string (up to current position) in macro-expansion
	 * buffer.
	 */
	if (sbcat(mac_buf, base, p-base) == 0)
	    errexit(10, "sbcat");

	if (p[1] == '@' || 			/* Special macro found */
	    p[1] == '?' ||
	    p[1] == '<' ||
	    p[1] == '*' ||
	    p[1] == '$' ||
	    p[1] == '+') {

	    /*
	     * Special macro: just copy to buffer.
	     */
	    if (sbcat(mac_buf, p, 2) == 0)
		errexit(10, "sbcat");
	    base	= p + 2;

	} else {				/* single '$' found */

	    /*
	     * Extract name of non-special macro.
	     */
	    if (p[1] == LEFT_PAREN || p[1] == LEFT_BRACE) {
		/*
		 * ()- or {}-enclosed macro:
		 */
		char	*start	= p + 2;
		char	klazu	= p[1] == LEFT_PAREN 
						? RIGHT_PAREN
						: RIGHT_BRACE;

		for (p = start; *p && *p != klazu; ++p)
		    ;				/* EMPTY */

		if (sbcpy(name, start, p-start) == 0)
		    errexit(10, "sbcpy");
		if (strcmp(sbstr(name), "SHAPE") == 0 || 
		    strcmp(sbstr(name), "MAKE") == 0) {
		  shape_macro_xp = TRUE;
		  shape_command	= TRUE;
		}

		if (*p == 0) {
		    base	= p;
		} else {
		    base	= p + 1;
		}

	    } else {
		/*
		 * Single-character macro:
		 */
		(void)sbcpy(name, p+1, 1);
		base	= p + 2;
	    }

	    /*
	     * Expand non-empty, non-special macro.
	     */
	    if (sblen(name) > 0) {
		char	*variant_macro	= 0;

		if (curvar[0] != 0) {
		    char		*get_variant_macro();
		    variant_macro	= get_variant_macro(sbstr(name));

		    if (strcmp(variant_macro, "bLuMeNkOhL") != 0) {
			char	*mist	= expandmacro(variant_macro);

			if (sbcat(mac_buf, mist, strlen(mist)) == 0)
			    errexit(10, "sbcat");
		    }
		}

		if (variant_macro == 0 || !strcmp(variant_macro,"bLuMeNkOhL"))
		  {
		    char *value, *expandedValue;

		    if (!visitedHash (sbstr(name))) {
		      if (value = getHash (sbstr(name))) {
			expandedValue = expandmacro (value);
			clearHashVisited (sbstr(name));
			
			if (sbcat(mac_buf, expandedValue, 
				  strlen(expandedValue)) == 0)
			  errexit(10, "sbcat");
			if (shape_macro_xp && noexflg) {
			  char *shapeflags = expandmacro ("$(SHAPEFLAGS)");
			  shape_macro_xp = FALSE;
			  if (sbcat (mac_buf, " ", 1) == 0)
			    errexit (10, "sbcat");
			  if (sbcat (mac_buf, shapeflags, 
				     strlen (shapeflags)) == 0)
			    errexit (10, "sbcat");
			}
		      }
		    }
		    else { /* recursive macro */
		      errexit (25, sbstr (name));
		    }
		  }
	      }					/* non-empty macro name */
	  }					/* single '$' found */
      }						/* macro substitution loop */

    /*
     * Append remaining, trailing stuff to macro-expansion buffer.
     */
    if (sbcat(mac_buf, base, strlen(base)) == 0)
	errexit(10, "sbcat");

    /*
     * Copy macro-expansion buffer to final string-buffer.
     */
    if (sbcpy(fin_buf, sbstr(mac_buf), sblen(mac_buf)) == 0)
	errexit(10, "sbcpy");

    /*
     * Free temporary string-buffers.
     */
    sbfree(cmd_buf);
    sbfree(mac_buf);
    sbfree(name);

    macdepth--;

    return sbstr(fin_buf);
}




handle_comments(line)
     char *line;
{
  register char *p;
  register int i;
  int q = 0, dq = 0;

  if (( p = index(line,'#')) == NIL)
    /* no comment */
    return;
  
  if ((line[0] == '#') && (line[1] != '%'))
    {
      /* comment, starting at beginning of line */
      line[0] = '\0';
      return;
    }

  if (((line[0] == '#') && (line[1] == '%')) &&
      ((line[2] == ' ') || (line[2] == '\t')))
    return;
  
  if (p != NIL)
    {
      if((index(line,'\'') == NIL) && (index(line,'\"') == NIL))
	/* the # is not in quotes */
	{
	  *p = '\0';
	  return;
	}
      else
	/* maybe no comment */
	{
	  for(i = 0; line[i] != '\0'; i++)
	    {
	      if(line[i] == '\'')
		q++;
	      if(line[i] == '\"')
		dq++;
	      if((line[i] == '#') && ((q % 2) == 0) && ((dq % 2) == 0))
		{
		  line[i] = '\0';
		  return;
		}
	    }
	}
    }
}


char *get_variant_macro(name)
     char *name;

     /* get macro value for variant */
{
Bool macro_defined = FALSE;
register int i = 0, k = 0, j = 0;
char *p, *p1, *p2, *p3;
char macro[2048];
static char retval[1024];
static char *BLUMENKOHL="bLuMeNkOhL";

retval[0] = '\0';

while(strcmp(curvar[i],""))
  {
    k = 0;
    while (variantDefs[k].name)
      {
	if (strcmp(variantDefs[k].name, curvar[i]))
	  k++;
	else
	  break;
      }

    if (variantDefs[k].name)
      {
	if ((!strcmp(name,"vpath")) && (variantDefs[k].vpath != NIL))
	  {
	    if (retval[0] == '\0')
	      {
		(void) strcat(retval, variantDefs[k].vpath);
		macro_defined = TRUE;
	      }
	    else
	      {
		(void) strcat(retval," ");
		(void) strcat(retval, variantDefs[k].vpath);
	      }
	  }
    
	if ((!strcmp(name,"vflags")) && (variantDefs[k].vflags != NIL))
	  {
	    if (retval[0] == '\0')
	      {
		(void) strcat(retval,variantDefs[k].vflags);
		macro_defined = TRUE;
	      }
	    else
	      {
		(void) strcat(retval," ");
		(void) strcat(retval,variantDefs[k].vflags);
	      }
	  }

	for(j = 0; j < MAXVMACROS; j++)
	  {
	    if (variantDefs[k].vmacros[j] == NIL)
	      {
		i++;
		break;
	      }
	    (void) strcpy (macro, variantDefs[k].vmacros[j]);
	    if (!strcmp (macro,""))
	      {
		i++;
		break;
	      }
	    p1 = index(macro,'=');
	    p2 = index(macro,' ');
	    p3 = index(macro,'\t');
    
	    if (p2 == NIL)
	      p2 = p1 + 1;
    
	    if (p3 == NIL)
	      p3 = p1 + 1;

	    if (( p1 < p2) && (p1 < p3))
	      p = p1;
	    if (( p2 < p1) && (p2 < p3))
	      p = p2;
	    if (( p3 < p2) && (p3 < p1))
	      p = p3;

	    *p = '\0';
	    p1++;
	    
	    if (!strcmp(name,macro))
	      {
		while((*p1 == ' ') || (*p1 == '\t') || (*p1 == '='))
		  p1++;
		if(retval[0] == '\0')
		  {
		    (void) strcat(retval,p1);
		    macro_defined = TRUE;
		  }
		else
		  {
		    (void) strcat(retval," ");
		    (void) strcat(retval,p1);
		  }
	      }
	  }
      }
    else
      i++;
  }
if(macro_defined)
  return(retval);
else
  return(BLUMENKOHL);
}


void echo_macro(name)
     char *name;
{
  char macr[32];
  (void) strcpy(&macr[0],"$(");
  (void) strcat(&macr[0],name);
  (void) strcat(&macr[0],")");
  printf("%s\n", expandmacro(macr));
}


char *call_popen(str)
     char *str;
{
  char *x, result[10240];
  char *p, *y, *new_y;
  FILE *fd;
  register int i,j;
  int size_str = strlen(str) + 1;

  if((y = malloc((unsigned)size_str)) == NIL)
    errexit(10,"malloc");
  (void) strcpy(y,str);
  p = index(y,'`');
  *p = '\0';
  if(index(str,'$') != NIL)
    {
      char *cp = expandmacro(y);
      int size_x = strlen(cp) + 1;

      if((x = malloc((unsigned)size_x)) == NIL)
	errexit(10,"malloc");
      (void) strcpy(x,cp);
    }
  else
    {
      if((x = malloc((unsigned)size_str)) == NIL)
	errexit(10,"malloc");
    (void) strcpy(x,y);
    }
  j = 0;
  i = 0;

  if (new_y = (char *) realloc (y, strlen (x) +1))
    y = new_y;
  else 
    errexit (10, "realloc");
  
  while(x[i] != '\0')
    {
      if((x[i] == '$') && (x[i+1] == '$'))
	i++;
      else
	{
	  y[j] = x[i];
	  i++;
	  j++;
	}
    }
  y[j] = '\0';
  if((fd = popen(y,"r")) == (FILE *) NIL)
    errexit(10,"popen");

  if (fgets(result,sizeof(result),fd) == NIL) {
    result[0] = '\0';
  } else if (strlen(result) >= 10240) {
    (void)fputs("Result of command expansion is too long\n", stderr);
    errexit(10,y);
    }
  
  (void) pclose(fd);
  free(x);
  free(y);
  return(cleaned(result));
}

char *cleaned(string)
     char *string;
{
  static char *result_str = NIL;
  char *p;
  register int i;
  p = string;
  i = 0;
  
  if (result_str != NIL)
    free(result_str);

  if((result_str = malloc((unsigned)(strlen(string)+1))) == NIL)
    errexit(10,"malloc");
  
  while((*p == '\n') || (*p == '\t') || (*p == ' '))
    p++;
  while(*p != '\0')
    {
      if((*p == ' ') || (*p == '\t') || (*p == '\n'))
	{
	  result_str[i] = (*p == '\n' && !*p+1) ? '\0' : ' ';
	  while((*p == ' ') || (*p == '\t') || (*p == '\n'))
	    p++;
	  i++;
	}
      else
	{
	  result_str[i] = *p;
	  p++;
	  i++;
	}
    }
  result_str[i--] = '\0';
  while((result_str[i] == ' ') || (result_str[i] == '\n')
	|| (result_str[i] == '\t'))
    {
      result_str[i] = '\0';
      i--;
    }

  return(&result_str[0]);
}

char *include_macro(inc_file)
     char *inc_file;
{
  register int i;
  char macro_arg[1024];
  extern Bool cmd_line_macro_def; /* from main.c */

  if(envflg)
    get_env_vals();

    for(i = 0; i < newargc; i++)
      {
	char *eqptr;

	if(eqptr=index(newarg[i],'='))
	  {
	    if (*(eqptr-1) == '+')
	      continue;
	    (void) strcpy(macro_arg,newarg[i]);
	    macrodef(macro_arg);
	    command_line_seen = TRUE;
	  }
      }
  cmd_line_macro_def = command_line_seen;
  
  return(expandmacro(inc_file));
}
