/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: inherit.c[1.34] Fri Apr 24 18:01:08 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include "shape.h"
#include <ctype.h>
extern char *get_dep(), *expandmacro();
extern int error();
extern void warning();
extern Af_attrs buft;
extern int depth;
extern Bool error_occ;
extern Bool finddep(), forbidden(), mysubstring();
extern struct rules *get_target();

struct linked_list *done_list;

save_targets (dep_rule, primary_target_name, do_key, 
	      primary_target_key, touch_time)
     struct rules *dep_rule;
     char *primary_target_name;
     char *do_key;
     BKey *primary_target_key;
     struct timeval *touch_time;
{
  Af_key busykey, savekey;
  Af_attrs attrbuf;
  struct rules *this_rule = dep_rule;
  char *syspath, name[MAXNAMLEN], type[MAXNAMLEN], *p;
  int major_version = AF_BUSYVERS, minor_version = AF_BUSYVERS, retcode;
  char savepath[MYMAXNAMLEN], *derivation_key;

  primary_target_key->bk_isdefined = FALSE;

  if (noexflg)
    return;

  if (rindex (primary_target_name, '/')) {
    (void) strcpy (savepath, primary_target_name);
    p = rindex (savepath, '/');
    *p = '\0';
    p++;
    primary_target_name = p;
    syspath = savepath;
  }
  else
    syspath = curvpath[0];

  (void) strcpy (name, primary_target_name);

  strcpy (type, af_aftype (name));
  strcpy (name, af_afname (name));

  if((derivation_key = malloc((unsigned) (strlen(do_key) + 
					  strlen (ATTRNAME) + 1))) == NIL)
    errexit(10,"malloc");
  (void) strcpy (derivation_key, ATTRNAME);
  (void) strcat (derivation_key, "=");
  (void) strcat (derivation_key, do_key);
  
  while (this_rule && !this_rule->saved) {
    this_rule->saved = TRUE;

    if (error_occ) {
      error_occ = FALSE;
      goto next_spin;
    }

    if (is_pattern (this_rule->name)) {
      strcpy (name, af_afname (name));
      (void) strcat(name, suffix (dep_rule->name));
      strcpy (type, af_aftype (name));
      strcpy (name, af_afname (name));
      (void) add_to_done_list (name, type);
    }

    if (af_getkey (syspath, name, type, major_version, minor_version, &busykey) == -1)
      goto next_spin;

    /*
     * I hope this is right. Should we return the key from 
     * the bpool instead (if possible) ?
     */
    if (!primary_target_key->bk_isdefined) {
      primary_target_key->bk_isdefined = TRUE;
      primary_target_key->bk_key = busykey;
    }

    if (af_gattrs (&busykey, &attrbuf) < 0) {
      af_perror ("save_targets");
    }
    else if (attrbuf.af_mtime < touch_time->tv_sec) {
      /*
       * This case happens if an implicit rule specifies multiple 
       * targets but not all of them are actually made, perhaps due
       * to optimizations in the tool script (e.g. the well-known
       * "yacc -d"-problem). We want to prevent caching of identical
       * derived (actually *not* re-derived) versions.
       */
      udafree (&attrbuf);
      goto next_spin;
    }
    udafree (&attrbuf);
    
    retcode = at_setcachekey (&busykey);
    if ((retcode == -1) && (af_errno == AF_ENOATFSDIR)) {
      af_initattrs (&buft);
      af_dropkey (&busykey);
      goto next_spin;
    }

    if ((af_sudattr (&busykey, AF_REPLACE, derivation_key)) == -1) {
      if ((af_sudattr (&busykey,AF_ADD,derivation_key)) == -1) {
	af_perror ("save_targets");
	goto next_spin;
      }
    }

    if ((bpoolflg) || (nobpoolflg)) {
      if (!forbidden (syspath, name, type)) {
	if ((at_savebinary (&busykey, &savekey)) == -1)
	  switch (af_errno) {
	  case AF_ENOATFSDIR:
	    warning (1,NIL);
	    break;
	  case AF_EBPFULL:
	    warning (5,NIL);
	    break;
	  case AF_ETOOLONG:
	    warning (6, NIL);
	    break;
	  default:
	    af_perror ("save_targets");
	    goto next_spin;
	  }
	else {
	  if (buft.af_gen != -1) {
	    if ((af_svnum (&savekey, buft.af_gen, buft.af_rev)) == -1) {
	      af_perror ("save_targets");
	      goto next_spin;
	    }
	  }
	  else {
	    if ((af_svnum (&savekey, AF_BUSYVERS, AF_BUSYVERS)) == -1)
	      af_perror ("save_targets");
	    af_dropkey (&savekey);
	  }
	}
      }
    }
  next_spin:
    this_rule = this_rule->next;
    free (derivation_key);
  }
  /*
   * We have to clean up our flags if "dep_rule" is a pattern rule.
   */
  if (is_pattern (dep_rule->name))
    for (this_rule = dep_rule; this_rule && this_rule->saved; 
	 this_rule = this_rule->next)
      this_rule->saved = FALSE;
}

Bool forbidden(syspath,name,type)
     char *syspath;
     char *name;
     char *type;
{
  char fullname[MYMAXNAMLEN];
  Bool bp = FALSE, nobp = FALSE;
  struct selection_rules *sel_name_to_rule(), 
  *def_rule = sel_name_to_rule ("-STD-");
  register struct rules *bpool, *nobpool;
  
  fullname[0] = '\0';
  if (strcmp(syspath,curvpath[0]))
    {
      (void) strcpy(fullname,syspath);
      (void) strcat(fullname,"/");
      (void) strcat(fullname,name);
    }
  else
    {
      (void) strcpy(fullname,name);
    }

  if (type != NIL)
    {
      (void) strcat(fullname,".");
      (void) strcat(fullname,type);
    }

  bpool = get_target (".BPOOL");
  nobpool = get_target (".NOBPOOL");

  if (bpool != (struct rules *) NIL)
    {
      bp = finddep(bpool,fullname);
    }
  else
    bp = TRUE;
  
  if (nobpool != (struct rules *) NIL)
    {
      nobp = finddep(nobpool,fullname);
    }

  if (bp && nobp)
    return(TRUE);

  if (bp && (!nobp))
    return(FALSE);

  if ((!bp) && nobp)
    return(TRUE);
  
  if ((!bp) && (!nobp))
    return(TRUE);
/*NOTREACHED*/
return(FALSE);
}

Bool finddep(rule,name)
     struct rules *rule;
     char *name;
{
  register int i = 0;
  char *dependent;
  while((dependent = get_dep(rule,i,1)) != NIL)
    {
      if (!strcmp(dependent,name))
	return(TRUE);
      i++;
    }
  return(FALSE);
}

add_to_done_list(name,type)
     char *name, *type;
{
  struct linked_list *c;
  static struct linked_list *l;
 
  if(done_list == (struct linked_list *) NIL)
    {
      if((done_list = (struct linked_list *)
	  malloc(sizeof(struct linked_list))) == (struct linked_list *) NIL)
	errexit(10,"malloc");
      c = l = done_list;
      done_list->nextstring = (struct linked_list *) NIL;
    }
  else
    {
      if((l->nextstring = (struct linked_list *)
	  malloc(sizeof(struct linked_list))) == (struct linked_list *) NIL)
	errexit(10,"malloc");
      c = l->nextstring;
      l = c;
    }
  c->nextstring = (struct linked_list *) NIL;

  if((c->string = malloc((unsigned) (strlen(name) + 1 +
				     strlen(type) + sizeof(char)))) == NIL)
    errexit(10,"malloc");
  (void) strcpy(c->string,name);
  if(type != NIL)
    {
      (void)strcat(c->string,".");
      (void)strcat(c->string,type);
    }
}

Bool already_in_done_list(targetname)
     char *targetname;
{
  struct linked_list *c;
  
  c = done_list;

  while(c != (struct linked_list *) NIL)
    {
      if(!strcmp(c->string,targetname))
	return(TRUE);
      else
	c = c->nextstring;
    }
  return(FALSE);
}
