/*  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: hash.c[1.16] Thu Apr  9 00:55:43 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include "shape.h"

#define HASHSIZE 257

struct hash
{
  unsigned short visited;
  char *name;
  char *entry;
  struct hash *next;
};


static struct hash hashTable[HASHSIZE];

hashval(name)
     char *name;
{
  register int hash = 0, i = 0;
  
  for(; name[i] != '\0'; i++)
    hash = hash + name[i];
  return(hash % HASHSIZE);
} /* end hashval */


void addHash (name, value, mode)
     char *name;
     char *value;
     int  mode;  /* 0 - set value, 1 - append Value */
{
  int  hashValue = hashval (name);
  register struct hash *current;
  
  current = &hashTable[hashValue];

  if (current->name == NIL) /* entry is still empty */
    {
      if ((current->entry = malloc ( (unsigned) strlen(value) + sizeof(char))) == NIL)
	errexit(10,"malloc");
      (void) strcpy(current->entry, value);
      if((current->name = malloc ( (unsigned) strlen(name) + sizeof(char))) == NIL)
	errexit(10,"malloc");
      (void) strcpy(current->name, name);
    }
  else
    {
      while (1)
	{
	  if (!strcmp (current->name, name)) /* found it */
	    {
	      if (mode)
		{
		  current->entry = realloc (current->entry, (unsigned) (strlen(current->entry) + strlen(value) + 2 * sizeof(char)));
		  (void) strcat(current->entry, " ");
		  (void) strcat(current->entry, value);
		}
	      else
		{
		  current->entry = realloc (current->entry, (unsigned) (strlen(value) + sizeof(char)));
		  (void) strcpy(current->entry, value);
		}
	      return;
	    }
	  if (current->next)
	    current = current->next;
	  else
	    break;
	}

      if ((current->next = (struct hash *) malloc(sizeof (struct hash))) == (struct hash *) NIL)
	errexit(10,"malloc");
      current = current->next;
      if((current->name = malloc ((unsigned) strlen (name) + sizeof(char))) == NIL)
	errexit(10,"malloc");
      (void) strcpy(current->name, name);
      if((current->entry = malloc ( (unsigned) strlen (value) + sizeof(char))) == NIL)
	errexit(10,"malloc");
      (void) strcpy(current->entry, value);
      current->next = (struct hash *) NIL;
    }
  return;
} /* end addHash */

static struct hash *current_hash;
static char lastname[128], *lastentry = (char *)NIL;

char *getHash (name)
     char *name;
{
  int  hashValue = hashval (name);

  if (!name || !*name)
    return NIL;

  if (name && !strcmp (lastname ? lastname : "", name))
    return lastentry;
  else 
    (void) strcpy (lastname, name);

  if (!hashTable[hashValue].name) { /* nothing found */
    lastentry = NIL;
    return lastentry;
  }

  current_hash = &hashTable[hashValue];
  while (current_hash)
    {
      if (!strcmp (current_hash->name, name)) { /* found it */
	lastentry = current_hash->entry;
	current_hash->visited = TRUE;
	return lastentry;
      }
      current_hash = current_hash->next;
    }
  lastentry = NIL;
  return lastentry;
}

Bool visitedHash (name) char *name; {
  if (!name || !lastname)
    return FALSE;
  return ((name && !strcmp (lastname, name)) && 
	  lastentry && current_hash->visited);
}

void clearHashVisited (name) char *name; {
  if (!name || !lastname)
    return;
  if ((name && !strcmp (lastname, name)) && lastentry)
    current_hash->visited = FALSE;
  return;
}
     
dump(fd)
     FILE *fd;
{
  register int i;
  register struct hash *current;
  
  fprintf(fd,"# Macros:\n");

  for(i = 0; i < HASHSIZE; i++)
    {
      if (hashTable[i].name)
	{
	  current = &hashTable[i];
	  while(current != (struct hash *) NIL)
	    {

	      if((current->name[0] != '$') &&
		 (current->name[0] != '*') &&
		 (current->name[0] != '+') &&
		 (current->name[0] != '<') &&
		 (current->name[0] != '?') &&
		 (current->name[0] != '@'))
		{
		  if(fd != stdout)
		    {
		      fprintf(fd,"%s = %s\n", current->name, current->entry);
		    }
		  else
		    {
		      fprintf(fd,"\t%s = %s\n", current->name, current->entry);
		    }
		}
	      current = current->next;
	      
	    }
	}
    }
} /* end dump */
