/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * vc_kbdIo.c
 *
 * $Header: vc_kbdIo.c[1.4] Wed Feb  5 18:11:31 1992 axel@cs.tu-berlin.de accessed $
 */

#ifndef lint
static char *ATFSid = "$Header: vc_kbdIo.c[1.4] Wed Feb  5 18:11:31 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>
#include <atfs.h>
#include "atfsapp.h"

extern char *malloc();

char *get_from_stdin (termchar)
     int termchar;
{
  /*
   * Reads from stdin a text terminated by ^D or by a specified
   * single charcter "termchar" at the beginning of a new line.
   * If term_char is -1 text is terminated  by ^D.
   */
  char *note;
  int lnote, c;			/* length of note */
  int Bflag = 0, Tflag = 0, Lflag = 0;	/* lookhead enabled iff Lflag == 1 */
  char tfile[MAXPATHLEN+1];
  char *prompt = "";
  char *emptynote;
  char message[MSGLEN];
  FILE *fid;
  struct stat buf;
  extern char *mktemp();

  if ((emptynote = malloc((unsigned) 1)) == (char *) NULL) {
    (void) fprintf(stderr, "Out of memory.\n");
    exit(1);
  }
  *emptynote = '\0';
  
  if (isatty(fileno(stdin))) {
    prompt = "> ";
    if (termchar == -1)
      *message = '\0';
    else 
      (void) sprintf(message, " or '%c'", termchar);
    (void) printf ("Enter text, terminated with your EOF character%s:\n",
	    message);
    Tflag++;
  }
  
  (void) strcpy(tfile, "/tmp/vadmnXXXXXX");
  (void) mktemp(tfile);
  (void) unlink(tfile);
  (void) Register(tfile, TYPEF);
  if ((fid = fopen(tfile, "w")) == NULL) {
    (void) fprintf (stderr, "Can't open %s\n", tfile);
    return emptynote;
  }

  (void) printf(prompt);
  while ((c = getchar()) != -1) {
    if (c == termchar)
      Lflag++;			/* lookahead */
    else {
      if (Lflag) {
	if ((c == '\n') && !Bflag) break;	/* terminate */
	Lflag = 0;
	(void) fputc(termchar, fid);
      }
      (void) fputc(c, fid);
      Bflag++;
      if (c == '\n') {
	(void) printf(prompt);
	Bflag = 0;
      }
    }
  }
  if (Tflag && (c == -1)) (void) putchar('\n');
  (void) fclose(fid);

  if (stat(tfile, &buf) == -1) {
    (void) fprintf (stderr, "Can't stat %s\n", tfile);
    return emptynote;
  }
  
  fid = fopen(tfile, "r");
  (void) unlink(tfile);
  (void) UnRegister(tfile, TYPEF);
  if ((note = malloc((unsigned)(buf.st_size + 1))) == NULL) {
    (void) fprintf (stderr, "Out of memory\n");
    return emptynote;
  }
  lnote = fread (note, sizeof (char), (Size_t)buf.st_size, fid);
  note[lnote] = '\0';
  (void) fclose(fid);
  if (lnote != buf.st_size)
    (void) fprintf (stderr, "Note truncated to %d size\n", lnote);
  return note;
}
