/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * vc_files.c
 *
 * $Header: vc_files.c[1.2] Wed Feb  5 18:11:15 1992 axel@cs.tu-berlin.de accessed $
 */

#ifndef lint
static char *ATFSid = "$Header: vc_files.c[1.2] Wed Feb  5 18:11:15 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

/*
 *
 * Functions to find, check for permission, and remote files.
 * This functions are highly operation system dependend.
 *
 * Currently this function are BSD43- and Ultrix1.0-proof. 
 *
 * Exports:
 *
 *   All functions described below return 1 for success or
 *   0 on failure. If return type is not "int" then on failure
 *   "(type-cast) NULL" is returned. See also descriptions below.
 *
 *   int GroupMember (gid)     WARNING: NOT ULTRIX COMPATIBLE
 *       int gid;
 *
 *         Checks if user is member of group gid.
 *
 *   int FileExecutable (file)
 *       char *file;
 *
 *   char *FindFile (file)
 *        char *file;
 *
 *        Returns the full absolute path name of file "file", if
 *        "file" exists. NULL otherwise. Searches the directories
 *        given in environment variable PATH. If path is not set,
 *        current working directory and "/bin" are checked.
 *
 *   char *FindProgram (file)
 *        char *file;
 *
 *        Acts as function FindFile(), but file must also be
 *        executable for caller.
 *
 *   RemoveFile (file)
 *        char *file;
 *
 *   int FileExists (file)
 *       char *file;
 */

#include <atfs.h>
#include "atfsapp.h"
#include <sys/param.h>
#include <sys/file.h>
#include <stdio.h>
/* #include "locks.h" now in atfsapp.h */

extern char *malloc(), *getenv();

/**/
int FileExecutable (file)
     char *file;
{
  return access (file, (X_OK | F_OK)) == -1 ? 0 : 1;
}

/**/
char *FindFile (file)
     char *file;
{
  char *path;
  char *dir, *edir;
  char *this;
  int flen;			/* length of "file" */
  flen = strlen (file) + 2;	/* for the good old null byte */
  this = NULL;

  /* get path from enivronment */
  if (!(path = getenv ("PATH")))
    path = DEFAULT_PATH;

  while (1) {
    
    if ((dir = path) == NULL)
      return NULL;

    /* find end of dir in string */
    if (edir = index(path, ':')) {
      *edir = '\0';		/* make "dir" null terminated */
      path = edir + 1;		/* path points to next dir */
    }
    else
      path = NULL;		/* end of path reached */

    if (this) free (this);	/* no longer needed */

    if ((this = malloc ((unsigned)(strlen (dir) + flen))) == NULL) {
      fprintf (stderr, "FindFile(): can't malloc\n");
      exit (1);
    }

    /* file found ? */
    (void)sprintf (this, "%s/%s", dir, file);	/* construct new filename */
    if (FileExists (this))
      return this;		/* found */
  }
}
  
char *FindProgram (program)
     char *program;
{
  /*
   * returns the full pathname of "program", iff program is found
   * and executable (for world). Otherwise NULL.
   */

  /* if program has already a '/' in it, asume existence */
  if (!index (program, '/'))
    if ((program = FindFile (program)) == NULL)
      return NULL;		/* not found */

  /* prg contains the absolute file name and file exists.*/
  if (FileExecutable (program))
    return program;
  else
    return NULL;
}

RemoveFile (file)
     char *file;
{
  (void)unlink (file);
}

FileExists (file)
     char *file;
{
  /*
   * Returns 1 iff file exists, 0 otherwise.
   */
  struct stat sbuf;
  
  return !stat (file, &sbuf);
}

