/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * mkattr.c
 *
 * $Header: mkattr.c[3.17] Fri Feb  7 19:35:17 1992 axel@cs.tu-berlin.de accessed $
 */

#ifndef lint
static char *ATFSid = "$Header: mkattr.c[3.17] Fri Feb  7 19:35:17 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

/*LINTLIBRARY*/

#include <stdio.h>

#include <atfs.h>
#include "atfsapp.h"

#ifdef lint
char *st_table[] = {
  "This is a fake definition. The real thing is in libutil (see 'misc')."
  };
#else
extern char *st_table[];
#endif 

mkvno (vstring) char *vstring; {
  /*
   *  converts a string of the form 'gen.rev' (e.g. 12.23) into an
   *  integer value with the generation part stored in the hiword
   *  and the revision part in the loword. In case 'vstring'
   *  is a symbolic version name, which is assumed if the 'gen.rev'
   *  pattern does not match, a value of zero is returned (0.0 = no vers).
   */
  char *emsg, *re_comp();
  int genno, revno, rc;

  if (emsg = re_comp("^[0-9][0-9]*\\.[0-9][0-9]*$")) { /* quite liberal RE */
    logerr (emsg);
    return 0;
  }
  if (fail((rc=re_exec (vstring)))) {
    logerr ("internal error in matching RE (mkvno)");
  }
  if (rc) {
    (void)sscanf (vstring, "%d.%d", &genno, &revno);
    return (genno << 16) | (0x0000FFFF & revno);

  }
  else return 0;
}

BoundVersion (rawname, cookedname, vstring) 
     char *rawname, *cookedname, *vstring; {
/*
 *  This function returns nonzero if 'rawname' is of the form
 *  'foo[1.4]'. In this case 'foo' will be written into 'cookedname'
 *  and 'vstring' will become '1.4'. Otherwise, both are left unchanged
 *  and the funtion returns zero.
 */
       char *b1, *b2;
       int vno;

       if ((b1=rindex (rawname, '[')) && (b2 = rindex (rawname, ']'))
	   && (b1 < b2)) {
	 *b1 = *b2 = '\0'; /* make 'em separate strings */
	 if (mkvno (b1+1)) {
	   (void)strcpy (cookedname, rawname);
	   (void)strcpy (vstring, b1+1);
	   *b1 = '['; *b2 = ']';
	   return TRUE;
	 }
	 else {
	   if (vno=Symn2Vno (rawname, b1+1)) {
	     (void)sprintf (vstring, "%d.%d", gen(vno), rev(vno));
	     (void)strcpy (cookedname, rawname);
	     *b1 = '['; *b2 = ']';
	     return TRUE;
	   }
	   *b1 = '['; *b2 = ']';
	 }
       }
       return FALSE;
     }
       
mkgenno (gstring) char *gstring; {
  int genno;

  genno = atoi (gstring);
  if (genno < 0)
    return 0;
  else 
    return (genno < 1000) ? genno : 0;
}

at_rvno (key) Af_key *key; {
  int vnum;
  vnum = ((af_rgen (key) << 16) | (0x0000FFFF & af_rrev (key)));
  return vnum;
}

int Symn2Vno (fname, sym) char *fname, *sym; {
  Af_attrs warrant;
  Af_set   hits;
  Af_key   key;
  char symname[SYMNAMLEN], messg[MSGLEN];
  int rc, vnum;

  af_initattrs (&warrant);
  (void)sprintf (symname, "%s=%s", SYMNAME, sym);
  warrant.af_udattrs[0] = symname;
  warrant.af_udattrs[1] = (char *)NULL;
  (void)strcpy (warrant.af_syspath, af_afpath(fname)); 
  (void)strcpy (warrant.af_name, af_afname(fname));
  (void)strcpy (warrant.af_type, af_aftype(fname));
  if ((rc=af_find (&warrant, &hits)) > 1) { 
    /* this shouldn't happen, as symbolic names are supposed to be */
    /* within one ASO's history */
    af_dropset (&hits);
    (void)sprintf (messg, 
     "%s's history inconsistent.\nSymbolic name \"%s\" multiply assigned.",
	     fname, sym);
    logerr (messg);
    return FALSE;
  }
  else if (rc < 0) {
    af_perror ("af_find (in SymnameInUse)");
    return FALSE;
  }
  else if (rc == 0) {
    af_dropset (&hits);
    return FALSE;
  }
  else { /* rc must be 1 -- thats just fine */
    af_setgkey (&hits, 0, &key);
    af_dropset (&hits);
    vnum = ((af_rgen (&key) << 16) | (0x0000FFFF & af_rrev (&key)));
    return vnum;
  }
}

  
mkstate (sstring) char *sstring; {
  int i;
  register char *cp;

  cp = sstring;
  while (*cp ? (*cp++ |= ' ') : 0); /* convert to lowercase */
  for (i = AF_BUSY; i <= AF_FROZEN; i++)
    if (!strcmp (st_table[i], sstring))
      return i;
  return -1;
}
