/* LINTLIBRARY */
/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * at_setops.c
 *
 * $Header: at_setops.c[1.5] Wed Feb  5 18:09:40 1992 axel@cs.tu-berlin.de accessed $
 */
#ifndef lint
static char *ATFSid = "$Header: at_setops.c[1.5] Wed Feb  5 18:09:40 1992 axel@cs.tu-berlin.de accessed $";
static char *ConfFlg = "$__CFLAGS";
static char *Objfile = "Object file derived from: $__name[$__version]";
#ifdef CFFLGS
static char *Cflags = CFFLGS;
#endif
#endif

#include <atfs.h>

void at_revset (set)
     Af_set *set;
{
  Af_set tmpset;
  Af_key key;
  int i;
  
  (void) af_initset(&tmpset);

  for (i = (set->af_nkeys - 1); i >= 0; i--) {
    (void) af_setgkey(set, i, &key);
    (void) af_setaddkey(&tmpset, AF_LASTPOS, &key);
    (void) af_dropkey(&key);
    }

  (void) af_dropset(set);
  (void) af_copyset(&tmpset, set);
  (void) af_dropset(&tmpset);
}

int at_last (set, newset)
     Af_set *set, *newset;
{
  /*
   * returns in newset the set containing the versions with the
   * highest gen.rev number. Returns also the number of keys in the
   * resulting set.
   */
  
  Af_set tmpset;
  Af_key key;
  Af_attrs attrs;
  int j, hits, nhits;
  char this[MAXNAMLEN+1], that[MAXNAMLEN+1];

  extern char *at_getfilename();
  
  if (!(hits = af_nrofkeys(set))) return 0;

  (void) af_initset(&tmpset);
  (void) af_sortset(set, AF_ATTHUMAN);
  at_revset(set);

  j = 0; nhits = 0; this[0] = '\0'; that[0] = '\0';
  while (j < hits) {
    (void) af_setgkey(set, j, &key);
    (void) af_gattrs(&key, &attrs);
    (void) strcpy(this, at_getfilename(&attrs));

    if (strcmp(this, that) && attrs.af_state > AF_BUSY) {
      nhits++;
      (void) af_setaddkey(&tmpset, AF_LASTPOS, &key);
      (void) strcpy(that, this);
    }

    (void) af_dropkey(&key);
    j++;
  }

  if (set == newset)		/* i.e. af_last(&set,&set) */
    (void) af_dropset(set);
  
  (void) af_copyset(&tmpset, newset);
  (void) af_dropset(&tmpset);

  return nhits;
}
