/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * $Header: at_find.c[1.8] Wed Feb  5 18:10:00 1992 axel@cs.tu-berlin.de accessed $
 */
/* LINTLIBRARY */
/*
 * exports:		at_ispattern(cp) char *cp;
 *			at_parseargs(ac, av, nac, nav);
 *			at_find(attr, fullname, path, name, type, set);
 */
#ifndef lint
static char *ATFSid = "$Header: at_find.c[1.8] Wed Feb  5 18:10:00 1992 axel@cs.tu-berlin.de accessed $";
static char *ConfFlg = "$__CFLAGS$";
static char *Objfile = "at_find.c[$__version] accessed";
#ifdef CFFLGS
  static char *Cflags = CFFLGS;
#endif
#endif

#include <atfs.h>
#include "ParseArgs.h"

#define MAXVSPEC 10
#define PATTERN "*?[]"

extern char *malloc(), *re_comp(), *at_mkedpat(), *at_getasoname();

/* exported variables */
int at_Bflag;			/* binary pool selected */
int at_Udaflag;			/* uda specified */
int at_udapattern;		/* uda contains a pattern */
char *at_udas[AF_MAXUDAS+1];	/* user defined attrs */
int at_nuda;			/* # of specified at_udas */

static int at_Bonlyflag, at_Lockflag, at_Lastflag;
static int at_Versionflag, at_Stateflag, at_Authorflag;
static int at_Lockerflag, at_Ownerflag;
static int at_higherstate;
static int at_state;
static int at_nvspecs;		/* # of version specifications */
static struct {			/* version specifications */
  int gen, rev;
} at_vspec[MAXVSPEC];
static Af_user at_author, at_owner, at_locker;
static char msg[2048];

static int version_spec_option (opt, arg)
/* ARGSUSED */
     char *opt, *arg;
{
  char *gen, *rev = (char *)NULL;
  int igen, irev;

  if (!*arg) {
    (void) fprintf(stderr, "version number expected.\n");
    return 1;
  }

  gen = arg;
  if (rev = index(arg, '.')) {
    *rev = '\0';
    rev++;
  }

  igen = irev = -1;
  if (*gen) igen = atoi(gen);
  if (rev && *rev) irev = atoi(rev);

  if ((igen == -1) && (irev == -1)) {
    (void) fprintf(stderr, "invalid version number specified.\n");
    return 1;
  }

  if (at_nvspecs == MAXVSPEC) {
    (void) fprintf(stderr, "Too many version numbers specified.\n");
    return 1;
  }

  at_vspec[at_nvspecs].gen = igen ;
  at_vspec[at_nvspecs++].rev = irev;
  at_Versionflag++;
  return 0;
}

static int name_option (arg, opt)
     char *arg, *opt;
{
  switch (arg[0]) {
  case 'a':
    at_Authorflag++;
    if (opt[0] == '\0') {
      (void) fprintf(stderr, "author specification expected.\n");
      return 1;
    }
    at_mkuser(&at_author, opt);
    break;
  case 'l':
    at_Lockerflag++;
    if (opt[0] == '\0') {
      (void) fprintf(stderr, "locker specification expected.\n");
      return 1;
    }
    at_mkuser(&at_locker, opt);
    break;
  case 'o':
    at_Ownerflag++;
    if (opt[0] == '\0') {
      (void) fprintf(stderr, "owner specification expected.\n");
      return 1;
    }
    at_mkuser(&at_owner, opt);
    break;
  }

  return 0;
}

int at_ispattern (arg)
     char *arg;
{
  while (arg && *arg)
    if (index(PATTERN, *(arg++))) return 1;

  return 0;
}

static int uda_option (opt, arg)
     char *opt, *arg;
{
  char *cp;

  if (!*arg) {
    if (*opt == 'n')
      (void) fprintf(stderr, "symbolic name expected.\n");
    else
      (void) fprintf(stderr, "uda name expected.\n");
    return 1;
  }

  if (*opt == 'n') {
    if ((cp = malloc((unsigned) (strlen(arg) + 20))) == (char *) NULL) {
      (void) fprintf(stderr, "Out of memory.\n");
      exit(1);
    }
    (void) strcpy(cp, "__SymbolicName__=");
    (void) strcat(cp, arg);
    arg = cp;
  }

  if (at_nuda == AF_MAXUDAS) {
    (void) fprintf(stderr, "Too many at_udas specified.\n");
    return 1;
  }

  at_udas[at_nuda++] = arg;
  at_udas[at_nuda] = (char *) NULL;
  at_Udaflag = 1;

  at_udapattern = at_ispattern(arg);  
  return 0;
}

static int at_state_option (opt, arg)
/* ARGSUSED */
     char *opt, *arg;
{
  int len = strlen(arg);

  if (!len) {
    (void) fprintf(stderr, "-s option requires a state.\n");
    return 1;
  }

  if (arg[len-1] == '+') {
    at_higherstate++;
    arg[len-1] = '\0'; len--;
  }

  if (!strncmp(arg, "busy", len))
    at_state = AF_BUSY;
  else if (!strncmp(arg, "saved", len))	/* should be "save" */
    at_state = AF_SAVED;
  else if (!strncmp(arg, "proposed", len))
    at_state = AF_PROPOSED;
  else if (!strncmp(arg, "published", len))
    at_state = AF_PUBLISHED;
  else if (!strncmp(arg, "Published", len)) /* upward compatibility */
    at_state = AF_PUBLISHED;
  else if (!strncmp(arg, "accessed", len))
    at_state = AF_ACCESSED;
  else if (!strncmp(arg, "frozen", len))
    at_state = AF_FROZEN;
  else {
    (void) fprintf(stderr, "Unknown state %s.\n", arg);
    return 1;
  }
  at_Stateflag++;
  return 0;
}

static OptDesc at_odesc[] = {
  { "B", PSWITCH|PSET, NULL, &at_Bonlyflag, NULL}, /* only bpool */
  { "V", PARG, version_spec_option, NULL, NULL}, /* specify version number */
  { "author", PARG, name_option, NULL, NULL}, /* check against author */
  { "b", PSWITCH|PSET, NULL, &at_Bflag, NULL}, /* binay bool also */
  { "last", PSWITCH|PSET, NULL, &at_Lastflag, NULL}, /* select last */
  { "y", PSWITCH|PHIDDEN|PSET, NULL, &at_Lastflag, NULL}, /* for compatiblity */
  { "locked", PSWITCH|PSET, NULL, &at_Lockflag, NULL }, /* check for locked asos */
  { "locker", PARG, name_option, NULL, NULL }, /* check against locker */
  { "n", PARG, uda_option, NULL, NULL }, /* specify symbolic name */
  { "symbolic", PARG, uda_option, NULL, NULL }, /* specify symbolic name */
  { "owner", PARG, name_option, NULL, NULL }, /* check against owner */
  { "s", PARG, at_state_option, NULL, NULL }, /* specify at_state */
  { "uda", PARG, uda_option, NULL, NULL }, /* specify uda */
  { NULL, NULL, NULL, NULL, NULL }
};

int at_ParseArgs(ac, av, nac, nav, optdesc)
     int ac;
     char **av;
     int *nac;
     char *(*nav)[];
     OptDesc optdesc[];
{
  int retval, i, j;
  OptDesc *totdesc;

  for (i = 0; optdesc[i].OptName; i++)
    ;
  
  totdesc = (OptDesc *) malloc((unsigned)(sizeof(OptDesc) * (i + 1) +
					   sizeof(at_odesc)));
  if (totdesc == (OptDesc *) NULL) {
    (void) fprintf(stderr, "Out of memory.\n");
    exit(1);
  }

  for (i = 0; optdesc[i].OptName; i++) {
    totdesc[i].OptName = optdesc[i].OptName;
    totdesc[i].OptKind = optdesc[i].OptKind;
    totdesc[i].OptFunc = optdesc[i].OptFunc;
    totdesc[i].OptVar = optdesc[i].OptVar;
    totdesc[i].OptStr = optdesc[i].OptStr;
  }

  for (j = 0; at_odesc[j].OptName; j++) {
    totdesc[i].OptName = at_odesc[j].OptName;
    totdesc[i].OptKind = at_odesc[j].OptKind;
    totdesc[i].OptFunc = at_odesc[j].OptFunc;
    totdesc[i].OptVar = at_odesc[j].OptVar;
    totdesc[i].OptStr = at_odesc[j].OptStr;
    i++;
  }

  totdesc[i].OptName = (char *) NULL;
  totdesc[i].OptKind = NULL;
  totdesc[i].OptFunc = NULL;
  totdesc[i].OptVar = NULL;
  totdesc[i].OptStr = NULL;
  
  
  retval = ParseArgs(ac, av, nac, nav, totdesc);

  (void) free((char *) totdesc);
  
  if (at_Bonlyflag) at_Bflag++;
  
  if (at_udapattern)
    for (i = 0; i < at_nuda; i++)
      at_udas[i] = at_mkedpat(at_udas[i]);

  return retval;
}

static void at_initattrs (attrs, path, name, type)
     Af_attrs *attrs;
     char *path, *name, *type;
{
  register int j, i = 0;

  (void) strncpy(attrs->af_syspath, path, MAXPATHLEN);
  if (name) (void) strncpy(attrs->af_name, name, MAXNAMLEN);
  if (type) (void) strncpy(attrs->af_type, type, MAXTYPLEN);

  if (at_Udaflag && !at_udapattern) {
    while (attrs->af_udattrs[i]) i++;
    
    for (j = i; i < at_nuda && i < AF_MAXUDAS; i++) 
      if (!at_is_stdattr (at_udas[i]))
	attrs->af_udattrs[j++] = at_udas[i];
    if (j < AF_MAXUDAS) attrs->af_udattrs[j] = (char *) NULL;
  }

  /* if exactly one at_state */
  if (at_Stateflag && !at_higherstate)
    attrs->af_state = at_state;

  if (at_Authorflag) {
    (void) strcpy(attrs->af_author.af_username, at_author.af_username);
    (void) strcpy(attrs->af_author.af_userdomain, at_author.af_userdomain);
  }

  if (at_Ownerflag) {
    (void) strcpy(attrs->af_owner.af_username, at_owner.af_username);
    (void) strcpy(attrs->af_owner.af_userdomain, at_owner.af_userdomain);
  }

  if (at_Lockerflag) {
    (void) strcpy(attrs->af_locker.af_username, at_locker.af_username);
    (void) strcpy(attrs->af_locker.af_userdomain, at_locker.af_userdomain);
  }
}

int at_find(attr, fullname, path, name, type, resultset)
     Af_attrs *attr;
     char *fullname, *path, *name, *type;
     Af_set *resultset;
{
  char *cp;
  int i, j, pattern;
  Af_set at_set1, at_set2;
  Af_key at_key;
  Af_attrs at_attr;
  
  (void) bcopy((char *)attr, (char *) &at_attr, sizeof(at_attr));

  /* release any existing keys in resultset */
  if (af_nrofkeys(resultset) > 0) {
    if (af_dropset(resultset) == -1) {
      af_perror("at_find: af_dropset:");
      exit(1);
    }
  }

  if (pattern = at_ispattern(fullname))
    at_initattrs(&at_attr, path, (char *) NULL, (char *) NULL);
  else
    at_initattrs(&at_attr, path, name, type);
  
  (void) af_initset(&at_set1);
  (void) af_initset(&at_set2);

  /* get set from bound version */
  if (at_gsbndvers(fullname, &at_set1, &at_attr)) {
    pattern = 0;
    goto select;
  }
  
  if (at_Lastflag && !pattern && name && name[0]) {
    if (af_getkey(path, name ,type, AF_LASTVERS, AF_LASTVERS, &at_key) == -1)
      return -1;

    (void) af_setaddkey(&at_set1, AF_LASTPOS, &at_key);
    (void) af_dropkey(&at_key);
    goto select;
  }

  if (at_Bflag) {
    if (af_bpfind(&at_attr, &at_set2) == -1) {
      (void) sprintf(msg, "at_find: af_bpfind(%s)", fullname);
      af_perror(msg);
      return -1;
    }
    (void) af_union(&at_set1, &at_set2, &at_set1);
    (void) af_dropset(&at_set2);
    (void) af_initset(&at_set2);
  }

  if (!at_Bonlyflag) {
    if (af_find(&at_attr, &at_set2) == -1) {
      (void) sprintf(msg, "at_find: af_find(%s)", fullname);
      af_perror(msg);
      return -1;
    }
    (void) af_union(&at_set1, &at_set2, &at_set1);
    (void) af_dropset(&at_set2);
  }

 select:

  if (at_Lastflag) (void) at_last(&at_set1, &at_set1);

  if (pattern)
    if (cp = re_comp(at_mkedpat(fullname))) {
      (void) fprintf(stderr, "%s\n", cp);
      return -1;
    }

  for (i = af_nrofkeys(&at_set1) - 1; i >= 0; i--) {
    if (af_setgkey(&at_set1, i, &at_key) == -1) {
      af_perror("at_find: af_setgkey:");
      return -1;
    }
    if (af_gattrs(&at_key, &at_attr) == -1) {
      af_perror("at_find: af_gattrs:");
      return -1;
    }
    (void) af_dropkey(&at_key);
    
    if (pattern && re_exec(at_getasoname(&at_attr, path && *path)) == 0) {
      (void) af_setposrmkey(&at_set1, i);
      continue;
    }

    if (at_Versionflag) {
      for (j = 0; j < at_nvspecs; j++) {
	if ((at_attr.af_gen == at_vspec[j].gen) &&
	    (at_attr.af_rev == at_vspec[j].rev))
	  break;
	if ((at_vspec[j].gen == -1) &&
	    (at_attr.af_rev == at_vspec[j].rev))
	  break;
	if ((at_vspec[j].rev == -1) &&
	    (at_attr.af_gen == at_vspec[j].gen))
	  break;
      }
      if (j == at_nvspecs) {
	(void) af_setposrmkey(&at_set1, i);
	continue;
      }
    }

    if (at_Stateflag && at_higherstate && at_attr.af_state < at_state) {
      (void) af_setposrmkey(&at_set1, i);
      continue;
    }

    if (at_Lockflag && at_attr.af_locker.af_username[0] == '\0') {
      (void) af_setposrmkey(&at_set1, i);
      continue;
    }

    if (at_udapattern && !at_matchregex(at_udas, at_nuda, &at_attr)) {
      (void) af_setposrmkey(&at_set1, i);
      continue;
    }
  }

  (void) af_copyset(&at_set1, resultset);
  (void) af_dropset(&at_set1);
  return af_nrofkeys(resultset);
}
