/*
  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

*/
/*
 * Shape/AtFS
 *
 * s-bsd_4_3.h -- general definitions for BSD 4.3
 *
 * $Header: config.h[1.9] Mon Mar 30 20:05:12 1992 nickel@cs.tu-berlin.de accessed $
 */

/* do only once */
#ifndef _defs_
#define _defs_

/* identify operating system flavor */
#define BSD_4_3

/* general includes */
#include <sys/types.h>
#include <sys/stat.h>
#ifndef MAXNAMLEN
#include <sys/dir.h>
#endif
#include <sys/param.h>
#include <strings.h>
#include <pwd.h>
#include <sys/time.h>

struct  utimbuf {
        time_t  actime;         /* set the access time */
        time_t  modtime;        /* set the modification time */
};

#include <sys/wait.h>

#define MAXDOMAIN 255

/* general type definitions */
#define Sfunc_t  int       /* type of function argument to signal call */
#define Sigret_t int       /* return type of signal system call */
#define Size_t   int       /* used for args to fread() etc. */
#define Uid_t    uid_t     /* used for user-id types */
#define Gid_t    gid_t     /* used for group-id types */
#define Wait_t   union wait
#define Pid_t    int

typedef int mode_t;

/* How long can names be */
#define MAXTYPLEN 256

#endif /* _defs_ */
