/*
  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

*/
/*
 * Shape/AtFS
 *
 * s-aix/config.c -- function mappings for AIX
 *
 * $Header: config.c[1.1] Wed Mar 11 12:34:35 1992 andy@cs.tu-berlin.de accessed $
 *
 */

#ifndef lint
static char *AtFSid = "$Header: config.c[1.1] Wed Mar 11 12:34:35 1992 andy@cs.tu-berlin.de accessed $";
#endif

#include "config.h"

/* strings */
char *index (s, c) char *s, c; { return (strchr (s, c)); }
char *rindex (s, c) char *s, c; { return (strrchr (s, c)); }

/* miscellaneous */
lstat (p, b) char *p; struct stat *b; { return (stat (p, b)); }

/* syscall wait() return status */
int wretcode (status)
     union wait *status;
{
  return status->w_status >> 8;
}

/* regular expressions */

extern char *regcmp(), *regex();

static char *re_pat;            /* previously compiled pattern */

char *re_comp (s)
     char *s;
{
  if (re_pat && *re_pat) (void) free(re_pat);

  if ((re_pat = regcmp(s, (char *) NULL)) == (char *) NULL)
    return "Invalid argument";

  return (char *) NULL;
}

int re_exec(s)
     char *s;
{
  if (re_pat && *re_pat)
    return regex(re_pat, s) == (char *) NULL ? 0 : 1;
  else
    return 0;
}

void disableSig (signo) {
  (void)sigblock (signo);
}

void enableSig () {
  (void)sigsetmask (0);
  /* this is a real dummy ... */
}

/* Some fake syscall definitions */
sigblock (signo) {
  sigset (signo, SIG_IGN);
  return signo;
}

sigsetmask (signo) {
  return signo;
}

#include <stdio.h>
int symlink (origpath, name) char *origpath, *name; {
  /*
   * This is a faked BSD-type system-call to create a symbolic link.
   * What actually happens is that a file "name" will be created that
   * contains "origpath". This type of pseudo symbolic link is supported
   * by AtFS.
   */
  FILE *slink;

  if ((slink = fopen (name, "w")) != NULL) {
    (void) fprintf (slink, "%s", origpath);
    (void) fclose (slink);
    return 0;
  }
  return -1;
}
