/*
** EXECUTE.C - This is the module containing the code for SQL for
** executing SQL Commands.
**
** (c) 1996 by Dirk Ohme - all rights reserved
*/

#include "cli.h"

/*---------------------------------------------------------------------------*/
/*  Execute a prepared SQL statement                                         */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLExecute(
        LPSTMT  lpstmt)
{
        /*
        ** check parameter
        */
        LogEntry( LOG_STATUS, "[SQLExecute] lpstmt = $%08lX", lpstmt );
        if( NULL == lpstmt )
        {
                LogEntry( LOG_ERROR,      "[SQLExecute] NULL == lpstmt" );
                LogEntry( LOG_RETURNCODE, "[SQLExecute] SQL_INVALID_HANDLE" );
                return SQL_INVALID_HANDLE;
        }

        /*
        ** start execution
        */
        if( NULL == lpstmt->pSqlDbc || 0 > lpstmt->pSqlDbc->hDbSocket )
        {
                strcpy( lpstmt->szSqlState, "40003" );
                lpstmt->pszSqlMsg = "[SQLExecute] no connection to database";
                LogEntry( LOG_ERROR, lpstmt->pszSqlMsg );
                LogEntry( LOG_RETURNCODE, "[SQLExecute] SQL_ERROR (%s)",
                          lpstmt->szSqlState );
                return SQL_ERROR;
        }
        if( NULL == lpstmt->pszQuery )
        {
                strcpy( lpstmt->szSqlState, "S1010" );
                lpstmt->pszSqlMsg = "[SQLExecute] no prepared statement";
                LogEntry( LOG_ERROR, lpstmt->pszSqlMsg );
                LogEntry( LOG_RETURNCODE, "[SQLExecute] SQL_ERROR (%s)",
                          lpstmt->szSqlState );
                return SQL_ERROR;
        }
        if( 0 != msqlQuery(lpstmt->pSqlDbc->hDbSocket, lpstmt->pszQuery) )
        {
                /*---| get mSQL error message |---*/
                msqlGetErrMsg( lpstmt->szMsqlErrorMsg );

                /*---| error processing |---*/
                strcpy( lpstmt->szSqlState, "08001" );
                lpstmt->pszSqlMsg = "[SQLExecute] cannot execute";
                LogEntry( LOG_ERROR, "[SQLExecute] cannot execute (%s)",
                          lpstmt->szMsqlErrorMsg );
                LogEntry( LOG_RETURNCODE, "[SQLExecute] SQL_ERROR (%s)",
                          lpstmt->szSqlState );
                return SQL_ERROR;
        }

        /*
        ** get results
        */
        lpstmt->pMsqlResult = msqlStoreResult();

        /*
        ** return success
        */
        LogEntry( LOG_RETURNCODE, "[SQLExecute] SQL_SUCCESS" );
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*  Performs the equivalent of SQLPrepare, followed by SQLExecute.           */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLExecDirect(
        LPSTMT  lpstmt,
        UCHAR FAR *szSqlStr,
        SDWORD  cbSqlStr)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*  Returns the SQL string as modified by the driver.                        */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLNativeSql(
        LPSTMT  lpstmt,
        UCHAR FAR *szSqlStrIn,
        SDWORD  cbSqlStrIn,
        UCHAR FAR *szSqlStr,
        SDWORD  cbSqlStrMax,
        SDWORD FAR *pcbSqlStr)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*  Supplies parameter data at execution time.  Used in conjuction with      */
/*  SQLPutData.                                                              */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLParamData(
        LPSTMT  lpstmt,
    PTR FAR *prbgValue)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*  Supplies parameter data at execution time.  Used in conjunction with     */
/*  SQLParamData.                                                            */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLPutData(
        LPSTMT  lpstmt,
        PTR     rgbValue,
        SDWORD  cbValue)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      Cancel Action                                                        */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLCancel(
        LPSTMT  lpstmt)                /* Statement to cancel.               */
{
        return SQL_SUCCESS;
}

/*===| end of file |=========================================================*/
