#include <OI/oi.H>	/***  HiLiteM.C  ***/

class MY_static_text : public OI_static_text {
	public:
			MY_static_text(const char *nam, char *txt);
		void	enter(OI_d_tech*, const XEvent*, const char * const*, unsigned int*);
		void	leave(OI_d_tech*, const XEvent*, const char * const*, unsigned int*);
};

MY_static_text::MY_static_text(const char *nam, char *txt) : OI_static_text(nam, txt)
{
	static OI_actions_rec myactions[] = {
		{"enter", NULL, NULL, (OI_translation_memfnp)&MY_static_text::enter},
		{"leave", NULL, NULL, (OI_translation_memfnp)&MY_static_text::leave}
	};

	push_actions(myactions, OI_count(myactions));
	disallow_cut_paste();
}

main (int argc, char **argv)
{
	OI_connection	*conp;		// the connection to the server
	OI_app_window	*wp;		// the enclosing app window
	MY_static_text	*stp;		// the text label

	if ((conp = OI_init(&argc, argv, "HiLiteM"))) {
		wp = oi_create_app_window("main", 1, 1, "HiLiteM");
		wp->set_layout(OI_layout_row);
		stp = new MY_static_text("my_text", " I have a border ");
		stp->set_bdr_width(4);
		stp->layout_associated_object(wp, 5, 5, OI_active);
		wp->set_associated_object(conp->root(), OI_def_loc, OI_def_loc, OI_active);
		stp->set_bdr_pixel(stp->bkg_pixel());
		OI_begin_interaction();
		OI_fini();
	}
}

void
MY_static_text::enter(OI_d_tech *, const XEvent *, const  char* const *, unsigned int *)
{
	set_bdr_color("black");
	return;
}

void
MY_static_text::leave(OI_d_tech *, const XEvent *, const char* const *, unsigned int *)
{
	set_bdr_pixel(bkg_pixel());
	return;
}
