/* definitions for the gs-preprocessor */

/* transition types */
#define TTY_IMM	    0
#define TTY_EXP	    1
#define	TTY_DET	    2
#define TTY_NRM	    3
#define TTY_BIM	    4

struct list_item {
    unsigned short  ind;
    struct list_item *next;
};

struct place {			    /* a place */
    char	    *name;
    unsigned	    defined:1;
    unsigned	    mdef:1;
    unsigned short  marks;
    unsigned short  n_input;
    unsigned short  n_output;

    struct list_item *input_ptr;
    struct list_item *inhib_ptr;
    struct list_item *result_ptr;
};

struct transition {		    /* a transition */
    char	    *name;
    unsigned	    type:3;
    unsigned	    def:1;
    unsigned	    ddef:1;
    double	    delay;
    unsigned	    depdef:1;
    int		    depend;			/* dependency parameter */

    unsigned short  n_input;
    unsigned short  n_output;
    unsigned short  n_inhib;

    struct list_item *input_ptr;
    struct list_item *output_ptr;
    struct list_item *inhib_ptr;
};

struct parameter {				/* a parameter definition */
    char	    *name;
    unsigned	    defined:1;
    unsigned short  used, max_used;		/* # of places used in */
    unsigned	    type:1;			/* 0: marking, 1: rate */
    
    int		    *ind;			/* usage index */
    double	    value;
};

struct result {
    char	    *name;			/* name of result variable */
    char	    *body;			/* function body */
    unsigned	    flg:1;
    unsigned	    type:2;			/* 0: undef, 1:dimensionless, 2:a time verage */
};

char *get_place(), *do_paren(), *do_or(), *do_cexp(), *concat(), *c_negate(),
     *do_prob(), *do_cmp(), *do_cmp(), *do_and(), *do_exp();

extern char	it_opr;				/* item (result) operator */
