/* $Id: utils.c,v 1.14 90/05/09 22:11:00 pturner Exp Locker: pturner $
 *
 * misc utilities
 *
 * Contents:
 *
 * void cxfree() - cfree and check for NULL pointer
 * void fswap()  - swap doubles
 * void iswap()  - swap ints
 * void lowtoupper() - convert a string to upper case
 * void convertchar() - remove commas and Fortran D format
 * int ilog2() - integer log base 2, for the fft routine
 * double comp_area() - compute the area of a polygon
 * double comp_perimeter() - compute the perimeter
 *
 */

#include <stdio.h>
#include <math.h>

/*
 * cfree and check for NULL pointer
 */
void cxfree(ptr)
    void *ptr;
{
    if (ptr != NULL) {
	cfree(ptr);
    }
}

/*
 * swap doubles and ints
 */
void fswap(x, y)
    double *x, *y;
{
    double tmp;

    tmp = *x;
    *x = *y;
    *y = tmp;
}

void iswap(x, y)
    int *x, *y;
{
    int tmp;

    tmp = *x;
    *x = *y;
    *y = tmp;
}

/*
 * convert a string from lower to upper case
 */
void lowtoupper(s)
    char *s;
{
    int i;

    for (i = 0; i < strlen(s); i++) {
	if (s[i] >= 'a' && s[i] <= 'z')
	    s[i] -= ' ';
    }
}

/*
 * remove all that fortran nastiness
 */
void convertchar(s)
    char *s;
{
    while (*s++) {
	if (*s == ',')
	    *s = ' ';
	if (*s == 'D' || *s == 'd')
	    *s = 'e';
    }
}

/*
 * log base 2
 */
int ilog2(n)
    int n;
{
    int i = 0;
    int n1 = n;

    while (n1 >>= 1)
	i++;
    if (1 << i != n)
	return -1;
    else
	return i;
}

/*
 * compute the area bounded by the polygon (xi,yi)
 */
double comp_area(n, x, y)
    int n;
    double x[], y[];

{
    int i;
    double sum = 0.0;

    for (i = 0; i < n; i++) {
	sum = sum + x[i] * y[(i + 1) % n] - y[i] * x[(i + 1) % n];
    }
    return sum * 0.5;
}

/*
 * compute the perimeter bounded by the polygon (xi,yi)
 */
double comp_perimeter(n, x, y)
    int n;
    double x[], y[];

{
    int i;
    double sum = 0.0;

    for (i = 0; i < n - 1; i++) {
	sum = sum + hypot(x[i] - x[(i + 1) % n], y[i] - y[(i + 1) % n]);
    }
    return sum;
}
