#include "upshot.h"

/* the following are includes for the pixmaps */
/*
#include "solid.bm"
*/
#include "hstripes.bm"
#include "vstripes.bm"
#include "rslant.bm"
#include "lslant.bm"
#include "check.bm"
#include "square.bm"
#include "rslant2.bm"
#include "rslant3.bm"
#include "lslant2.bm"
#include "lslant3.bm"

static int xsmallFonthHeight = 1;
static int smallFonthHeight  = 3;

void xdrawstring();

/** UTILITY ROUTINES **/

/*****************************************************************************/
/* DRAW_WATCH:  changes the icon's shape to a watch to indicate that         */
/*              processing is going on                                       */
/*****************************************************************************/
void draw_watch(draw)
     int draw;          /* idicates whether to draw or undraw the watch */
{
  int cursor_shape;     /* references cursorfont.h to obtain watch */
  Cursor cursor;

  if(draw)
    {
      cursor_shape = XC_watch;
      cursor = XCreateFontCursor(display,cursor_shape);
      XDefineCursor(display,w,cursor);
      XDefineCursor(display,bigwindow,cursor);
    }
  else
    {
      cursor_shape = XC_top_left_arrow;
      cursor = XCreateFontCursor(display,cursor_shape);
      XDefineCursor(display,w,cursor);
      XDefineCursor(display,bigwindow,cursor);
    }
}

/*****************************************************************************/
/* DESTROY WIDGET: a callback/utility routine that destroys the calling      */
/*                 widget's grand-parent.  This routine is designed to be    */
/*                 called from a button widget inside a form widget which in */
/*                 turn is the child of a shell widget (it is the shell that */
/*                 needs to be destroyed )                                   */
/*****************************************************************************/
DestroyWidget(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;

{
  Widget form = XtParent(widget);
  Widget shell = XtParent(form);

  XtDestroyWidget(shell);
}

/*****************************************************************************/
/* ERROR BOX: a popup label widget used for warnings and error messages      */
/*****************************************************************************/
void xErrorBox(message)
     char message[];
{
  Widget messageWindow,Boxw, msglabel, Button; /* POPUP shell & contents */
  Arg arg[5];
  int n;
  Position x,y,posX,posY;
    
  n = 0;                     /* acquire canvas' position in toplevel shell*/
  XtSetArg(arg[n],XtNx,&x);n++;
  XtSetArg(arg[n],XtNy,&y);n++; 
  XtGetValues(canvas,arg,n);

  /* transalate that position with respect to the root window */
  XtTranslateCoords(canvas,     
		    (Position) (x+160),
		    (Position) (y+160),
		    &posX,&posY);
/*
  printf("the position is %d %d \n",posX,posY);
*/
  /* MESSAGE WINDOW is a popup shell used to display error messages */
  n = 0;
  XtSetArg(arg[n],XtNx,posX);n++;
  XtSetArg(arg[n],XtNy,posY);n++;  
  messageWindow = XtCreatePopupShell("Message-Window",
				     transientShellWidgetClass,
				     outline,arg,n);

  n = 0;
  XtSetArg(arg[n],XtNforeground,data.back);n++;
  XtSetArg(arg[n],XtNbackground,data.fore);n++;
  Boxw = XtCreateManagedWidget("boxw",boxWidgetClass,messageWindow,
                                   arg,n);

  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNforeground,data.back);n++;
  XtSetArg(arg[n],XtNbackground,data.fore);n++;
  XtSetArg(arg[n],XtNlabel,message);n++;
  XtSetArg(arg[n],XtNfont,labelFont);n++;
  msglabel = XtCreateManagedWidget("msglabel",labelWidgetClass,Boxw,
				   arg,n);

  n = 0;
  XtSetArg(arg[n],XtNforeground,data.back);n++;
  XtSetArg(arg[n],XtNbackground,data.fore);n++;
  XtSetArg(arg[n],XtNwidth,50);n++;
  XtSetArg(arg[n],XtNlabel,"OK");n++;
  Button =  XtCreateManagedWidget("button",commandWidgetClass,Boxw,
                                   arg,n);
  XtAddCallback(Button,XtNcallback,DestroyWidget,NULL);

  XtPopup(messageWindow,XtGrabNone);
}

/*****************************************************************************/
/* DATAPOPDOWN: pops down the popupshell associated with a data box          */
/*****************************************************************************/
datapopdown(widget,client_data,call_data)
     Widget widget;
     caddr_t client_data, call_data;
{
     XtDestroyWidget(widget);
}

/*****************************************************************************/
/* EVENT DATA BOX:  creates and pops up a shell containing the log info      */
/*                  of an event in the buffer.  Called from ShowEventData    */
/*****************************************************************************/
xEventDataBox(x,y,id,event,time,cData,tasks,whichbutton)
     int x;             /* x and y coordinates of the event box on the graph */
     int y;
     int id,event,time; /* data to be printed in event data box */
     char cData[];
     int tasks;         /* indicates wether taks or processes are graphed */
                        /* the data structure is not accessible from this */
                        /* routine that is why data.tasks couldn't be used */
                        /* instead */
     int whichbutton;   /* 1, 2, or 3, depending on which button was pressed */
{
  int n;
  Position xcoord,ycoord;
  Arg arg[10];
  Widget Boxw;
  Widget NumData,CharData;
  char data[BUFLEN];
  long realTime;

  /* transalate x,y position from widget coordinates to root coordinates */
  XtTranslateCoords(canvas,(Position) x, (Position) y,&xcoord,&ycoord);

  /* Data Box is a pop-up shell, the parent window of the event data widgets */
  n = 0;
  XtSetArg(arg[n],XtNx,xcoord);n++;
  XtSetArg(arg[n],XtNy,ycoord);n++;  
  DataBox = XtCreatePopupShell("dataBox",transientShellWidgetClass,outline,
			       arg,n);

  /* attach popdown action to popupshell */
  XtAddEventHandler(DataBox,ButtonReleaseMask,FALSE,datapopdown,NULL);

  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  Boxw = XtCreateManagedWidget("boxw",formWidgetClass,DataBox,arg,n);

  if(tasks)
    sprintf(data,"TASK:  %d\nEVENT: %d\nTIME:  %d",id,event,time);
  else
    sprintf(data,"PROC:  %d\nEVENT: %d\nTIME:  %d",id,event,time);


  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNlabel,data);n++;
  XtSetArg(arg[n],XtNfont,boxFont);n++;  
  NumData = XtCreateManagedWidget("numData",labelWidgetClass,Boxw,
				     arg,n); 

  strcpy(data,"DATA:\n");
  strcat(data,cData);
  n = 0;
  XtSetArg(arg[n],XtNborderWidth,1);n++;
  XtSetArg(arg[n],XtNlabel,data);n++;
  XtSetArg(arg[n],XtNfont,boxFont);n++; 
  XtSetArg(arg[n],XtNfromHoriz,NumData);n++;
  CharData = XtCreateManagedWidget("CharData",labelWidgetClass,Boxw,
				     arg,n); 

  XtPopup(DataBox,XtGrabNone);
  DataBoxAlive = TRUE;         /*indicates a data box is being displayed and
				 may be destroyed at the button release event*/
}

/*****************************************************************************/
/* CHANGE FONT: resets the gc font according to the desired size             */
/*****************************************************************************/
void xchange_font(fontId)
     Font fontId;
{

  XSetFont(display,gc,fontId); 
} 

/*****************************************************************************/
/* CONVERT COLOR:  is an integer function that returns the pixel value of a  */
/*                 string representing a color                               */
/*****************************************************************************/
int xConvertColor(colorname)
char *colorname;
{
  XColor color,ignore;

  if(XAllocNamedColor(display,cmap,colorname,&color,&ignore))
    return (color.pixel);
  else
    {
      printf("Warning:  cannot allocate `%s'\n",colorname);
      return (BlackPixel(display, screen));
    }
}

/*****************************************************************************/
/* GIVE COLOR NAME: reflects name of chosen color in the StateColor dialog   */
/*****************************************************************************/
void GiveColorName(ColorButton,client_data,call_data)
     Widget ColorButton;
     int client_data;     /* contains index to colortable, used to reference */
                          /* the button's color */
     XtPointer call_data;
{
  Arg arg[2];
  int n;

  n = 0;
  XtSetArg(arg[n],XtNvalue,colortable[client_data].color);n++;
  XtSetValues(StateColor,arg,n);  /* StateColor is declared in the header file
				     upshot.h for access in this routine */
}

/****************************************************************************/
/* LABEL UNITS: reassigns the value of the time line units label-widget     */
/****************************************************************************/
void xlabel_units()
{
  Arg arg[25];
  int n;

  n = 0;
  if(strcmp(units_name,"Microseconds") == 0)
    {
      XtSetArg(arg[n],XtNlabel,"time in microseconds ");
      n++;
    }

  else if(strcmp(units_name,"Milliseconds") == 0)
    {
      XtSetArg(arg[n],XtNlabel,"time in milliseconds ");
      n++;
    }

  else if(strcmp(units_name,"Seconds") == 0)
    {
      XtSetArg(arg[n],XtNlabel,"time in seconds ");
      n++;
    }

  XtSetValues(Units,arg,n);
}

/*****************************************************************************/
/* CLEAN_PIXMAP:  clears the pixmap to prepare it for new drawing            */
/*****************************************************************************/
void xclean_pixmap(pixmap)
     Pixmap *pixmap;
{

  XSetForeground(display,gc,data.back);

  XFillRectangle(display,*pixmap,gc,0,0,pixmapwidth+PADDING,canvas_height);

  XSetForeground(display,gc,data.fore);

} 

/*****************************************************************************/
/* FIX THUMBLEN:  this routine comes from the Xaw manual, p37 it             */
/*                helps to keep C from truncating the float value            */
/*                and is used to set the length value of the                 */
/*                scrollbars thumb.                                          */
/* NOTE: this routine is implemented for the X version only and is called    */
/*       directly within x_graphics.c without being chaneled through         */
/*       graphics.c                                                          */
/*****************************************************************************/
void fix_thumblen(scroll,len)
     Widget scroll;
     float len;
{
  Arg arg[1];
  float thumblen;

  thumblen = len;

  if(thumblen > 1.0)
    thumblen = 1.0;

  /* the following, messy calculation computes the length of the thumb so that
     it will accurately indicate the % of the file displayed by the viewport*/

  if (sizeof(float) > sizeof(XtArgVal))
    {
      /* if a float is larger than an XtArgVal then pass this resource value
	 by reference. */

      XtSetArg(arg[0],XtNshown,&thumblen);
    }

  else
    {
      /*Convince C not to perform an automatic conversion, which would 
	truncate 0.5 to 0.1*/
      XtArgVal *l_top = (XtArgVal*)&thumblen;
      XtSetArg(arg[0],XtNshown,*l_top);
    }
  XtSetValues(scroll,arg,1);
}

/*****************************************************************************/
/* SET_UP_PIXMAP:  redefines length of buffer scroll's thumb to accurately   */
/*                 reflect amount of buffer graphed on pixmap AND cleans up  */
/*                 pixmap to prepare it for next draw                        */
/*****************************************************************************/
void set_up_pixmap()
{
  float thumblen;

  /*initialize and set thumb to correct position*/
  /*the thumblen of Bscroll reflects the percentage of the buffer visible on
    the canvas */
  thumblen = ((canvas_secs * 1.0) / (end_time * 1.0));
  fix_thumblen(Bscroll,thumblen);
  xclean_pixmap(&canvas_pixmap);
}


/*****************************************************************************/
/* CREATE PIXMAP: defines pixmap dimensions, creates pixmap, and prepares it */
/*                for first drawing                                          */
/*****************************************************************************/
void xcreate_pixmap()
{
  int frame_depth;

  /* Define pixmap width according to the number of canvases it will hold*/
  pixmapwidth =(CANVAS_TOTAL * (CANVAS_WIDTH - X_OFFSET));
  
  /* Define a pixmap to draw the file's contents on.  The stuff to be displayed
    on the canvas will be copied from it.  */
  
  frame_depth = (XDefaultDepth(display,XDefaultScreen(display)));
  canvas_pixmap = XCreatePixmap(display,w,pixmapwidth+PADDING,canvas_height,
				frame_depth); 

  set_up_pixmap();
}


/*****************************************************************************/
/* CHECK STATE DEF:  acquires data from state-def window and checks its      */
/*                   validity.                                               */
/*****************************************************************************/
void CheckStateDef(start,end,color,name,allGood)
     int *start,*end;
     char name[],color[];
     int *allGood;         /* indicates whether data is valid or not */

{
  /* obtain the entered values */
  *start = atoi(XawDialogGetValueString(StartEv));  /* atoi = ascii to int */
  *end = atoi(XawDialogGetValueString(EndEv));
  strcpy(name,XawDialogGetValueString(StateName));
  strcpy(color,XawDialogGetValueString(StateColor));

  /* check that they all have values */
  if((strcmp(name," ") == 0) || (strcmp(color," ") == 0))
    {
      xErrorBox(" ERROR:  Both name and color must be given to define a state ");
      *allGood = FALSE;
    }
    
  if((*start == -1) || (*end == -1))
    {
      xErrorBox(" ERROR:  event number -1 is out of range");
      *allGood = FALSE;
    }
}























/** CALLBACKS **/


/*****************************************************************************/
/* CLEAR STATE DEF: clears out the entries in the StateDef popup shell,      */
/*                  called by the StateDef quit routine and as a callback for*/
/*                  the clear button.                                        */
/*****************************************************************************/
void ClearStateDef()
{
  int n;
  Arg arg[2];

  n = 0;
  XtSetArg(arg[n],XtNvalue," ");n++;
  XtSetValues(StateName,arg,n);

  n = 0;
  XtSetArg(arg[n],XtNvalue," ");n++;
  XtSetValues(StateColor,arg,n);

  n = 0;
  XtSetArg(arg[n],XtNvalue,"-1");n++;
  XtSetValues(StartEv,arg,n);

  n = 0;
  XtSetArg(arg[n],XtNvalue,"-1");n++;
  XtSetValues(EndEv,arg,n);

}

/*****************************************************************************/
/* POP DOWN: brings a popup widget down without destroying it...             */
/*****************************************************************************/
void PopDown(widget,popupWindow,call_data)
     Widget widget;
     Widget popupWindow;
     XtPointer call_data;

{
  if(popupWindow == StateDefWindow)
    ClearStateDef();
  
  XtPopdown(popupWindow);
}

/*****************************************************************************/
/* POP SHELL  pops up the shell widget identified by popupWindow             */
/*****************************************************************************/
void PopShell(widget,popupWindow,call_data)
Widget widget;
Widget popupWindow;
XtPointer call_data;
{
/* disable state def popup for black and white screens until further notice 
   (originally, no guard)
*/
    if (colorScreen)
    {
	XtPopup(popupWindow,XtGrabNone);
    }
    else
    {
	printf("interactive state definitions not supported on non-color screens\n");
    }
}


/*****************************************************************************/
/* BUFFER SCROLL:        is used to move update the canvas contents with     */
/*                       respect to the position of the scrollbar's thumb    */
/*****************************************************************************/
void BufferScroll(Bscroll,client_data,call_data)
     Widget Bscroll;           /* widget that made the callback */
     XtPointer client_data,call_data;      
{
  int newX;           /*X coordinate of thumb's position with ref. to canvas*/
  int n;
  Arg arg[10];        /*arg array used to obtain Bscrollbar's resource */
  float percent;      /*refers to the thumb's position in the Bscrollbar*/ 
  int left = TRUE;   /* indicate whether scrolling unto next pixmap is to be */
  int right = FALSE;  /* done going to the left or to the right */

  n = 0;
  XtSetArg(arg[n],XtNtopOfThumb,&percent);n++;
  XtGetValues(Bscroll,arg,n);


  /* view_time is obtained by computing the piece of the file being displayed 
     in relation to the Bscrollbar's thumb_top position */

  view_time = (bufferwidth * percent) * interval;
  

  /* conditions for shift drawing: that there exist more that one pixmap per
     buffer and that the shift be made within the time span of the buffer */

  if((view_time < (left_time + canvas_secs)) && (left_time > 0)) /*LEFT*/
    shiftDrawing(left);
      
  else                                                   /* RIGHT */
    if((view_time > (left_time + pixmap_secs - canvas_secs)) &&
       (end_time > right_time))
      shiftDrawing(right);
	

  /* compute thumb's pixel position on the pixmap, this will indicate which
     portion of the pixmap to copy onto the canvas */

  newX = (view_time - left_time) / interval;

  if((newX < 0) || (newX > pixmapwidth))
    printf("View is out of range \nx = %d  left = %d view = %d\n",newX,left_time,view_time);
  
  else
    {
      XCopyArea(display,canvas_pixmap,w,gc,newX,0,CANVAS_WIDTH-X_OFFSET,
		canvas_height,X_OFFSET+1,0);

      /*update Cscroll position to reflect the view's position on the pixmap */
      percent = (newX * 1.0) / (pixmapwidth * 1.0);
      XawScrollbarSetThumb(Cscroll,percent,-1.0);
    }
}

/*****************************************************************************/
/* CANVAS SCROLL:  scrolling carried out by the canvas scrollbar shifts the  */
/*                 piece of the pixmap seen on the screen and updates the    */
/*                 buffers scrollbar                                         */
/*****************************************************************************/
void CanvasScroll(Cscroll,client_data,call_data)
     Widget Cscroll;
     XtPointer client_data,call_data;
{
  int n;
  int newX;  /* x coordinate of thumb's position with reference to the pixmap*/
  float percent;  /* refers to the thumb's position in the scrollbar */
  Arg arg[5];
  long view = 0;

  n = 0;
  XtSetArg(arg[n],XtNtopOfThumb,&percent);n++;  
  XtGetValues(Cscroll,arg,n);             /* acquires current thumb position */

  newX = pixmapwidth * percent;  /*pixel position of the thumb on the pixmap */
  
  /* copies corresponding portion of pixmap on to the canvas */
  XCopyArea(display,canvas_pixmap,w,gc,newX,0,CANVAS_WIDTH-X_OFFSET,
	    canvas_height,X_OFFSET+1,0);

  /* update the buffer scrollbar's position to reflect its position on 
     the buffer */
  view = (newX * interval) + left_time;
  percent = (view / interval) / bufferwidth;

  XawScrollbarSetThumb(Bscroll,percent,-1.0);
}

/* HISTOGRAM

   This function forks a child process and then executes "xhist" which is an
   X application which will draw the correct histogram. Written by DPN */

void Histogram(w,state_num,call_data)
Widget w;
int state_num;
caddr_t call_data;
{
    char *filename,start[10],end[10],color[50];
    int forkrtn,startnum,endnum;
    char proclist[4*MAX_EVTYPES],id[5];
    int i,n;
    Arg arg[5];

    /* Error checking for the fork() function */
    
    if((forkrtn=fork()) == -1){
	printf("Fork error!\n");
	return;
        }
    else if(forkrtn == 0){
	
	/* Obtaining the values for the call to execlp() */
	
	filename = XawDialogGetValueString(LogFile);
	strcpy(color,histohelp[state_num].color);
	startnum = histohelp[state_num].start;
	endnum = histohelp[state_num].end;
    
	sprintf(start,"%d",startnum);
	sprintf(end,"%d",endnum);

	/* Obtain the list of processes */

	strcpy(proclist,""); /* init to NULL */
	for(i=0;i<procTaskTotal;++i)
	    if(proclistflag[i] == 1){
		/* get the label of the button - process number */
		sprintf(id,"%d ",procTable[i].id);
		strcat(proclist,id);
		}

	/* printf(" ...proc list: %s\n", proclist); */

	/* Execute "xhist" with the correct parameters */

	if(strcmp(proclist,"")==0){
	    if(execlp("xhist","xhist",filename,start,end,color,
						(char *)0) == -1){
	    	printf("Execlp error!\n");
	    	return;
		}
	    }
	else{
	    if(execlp("xhist","xhist",filename,start,end,color,
					proclist,(char *)0) == -1){
	    	printf("Execlp error!\n");
	    	return;
	    	}
	    }
	}
    else{
	children[num_children] = forkrtn;
	num_children++;

	/* reset the buttons */
	for(i=0;i<procTaskTotal;++i)
	    if(proclistflag[i] == 1){
		proclistflag[i] = 0;
		n = 0;
		XtSetArg(arg[n],XtNforeground,data.fore); n++;
		XtSetArg(arg[n],XtNbackground,data.back); n++;
		XtSetValues(procbutton[i],arg,n);
	    }

	return;
        }
    
}  /* End of Function Histogram */

/* EDGEWISE

   This callback invokes xedge, the edgewise upshot viewer.  DPN */

void EdgeWise(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    char *logfilename,*statefilename;
    int forkrtn;

    if((forkrtn=fork()) == -1){
	printf("Fork error!\n");
	return;
        }
    else if(forkrtn == 0){
	logfilename = XawDialogGetValueString(LogFile);
	statefilename = XawDialogGetValueString(StateFile);
	if(execlp("xedge","xedge",logfilename,statefilename,(char *)0) == -1){
	    printf("Execlp error!\n");
	    return;
	    }
        }
    else{
	children[num_children] = forkrtn;
	num_children++;
	return;
        }

}  /* End of Function EdgeWise */

/* SUMMARY

   This callback invokes xsum */

void Summary(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    char *logfilename,*statefilename;
    int forkrtn;

    if((forkrtn=fork()) == -1){
	printf("Fork error!\n");
	return;
        }
    else if(forkrtn == 0){
	logfilename = XawDialogGetValueString(LogFile);
	statefilename = XawDialogGetValueString(StateFile);
	if(execlp("xsum","xsum",logfilename,statefilename,(char *)0) == -1){
	    printf("Execlp error!\n");
	    return;
	    }
        }
    else{
	children[num_children] = forkrtn;
	num_children++;
	return;
        }

}  /* End of Function Summary */



/**********************************************************************/
/* XGET_ZOOMSTEP : gets the value of zoomstep from the zoom dialog    */
/**********************************************************************/
int xget_zoomstep()
{
  char s[10];
  strcpy(s,XawDialogGetValueString(Zoomstep));
  return (atoi(s));
}


/*****************************************************************************/
/* ZOOMOUTCALLBACK:used by the zoomout button to redefine the present screen */
/*****************************************************************************/
void ZoomOutCallBack()
{
  int zoomstep;

  if(end_time >= canvas_secs) 
    {
      zoomstep = xget_zoomstep();
      zoom_proc(TRUE,zoomstep);  /* tells the zoom proc to perform a zoomout */
    }
  else
    xErrorBox("Cannot Zoom-out any further...");

}

/*****************************************************************************/
/* ZOOMINCALLBACK:used by the zoomin button to redefine the present screen   */
/*****************************************************************************/
void ZoomInCallBack()
{
  int zoomstep;

  /* zoom-in will not be done beyond 1 microsecond difference 'tween events */
  if (canvas_secs <= CANVAS_WIDTH)      
    xErrorBox("Cannot Zoom in any further...");
  else
    {
      zoomstep = xget_zoomstep();
      zoom_proc(FALSE,zoomstep);  /* tells the zoom proc to perform a zoomin */
    }
}



/*****************************************************************************/
/* SET EVENTS ONLY: sets drawing flag to draw states only & calls the        */
/*                  necessary routines to redraw                             */
/*****************************************************************************/
SetEventsOnly()
{
  free_pixmap();       /* this stuff should be put in a routine of their own*/
  set_up_pixmap();     /* since they get called over and over again!*/

  draw_states = FALSE;
  HideStateKey();

  draw_events = TRUE;

  next_draw(left_time,FALSE); 
  BufferScroll(Bscroll,NULL,NULL);

}


/*****************************************************************************/
/* SET BOTH: allows for drawing of both events and states & calls necessary  */
/*           routines to redraw                                              */
/*****************************************************************************/
void SetBoth()
{
  char message[250];

  free_pixmap();       /* this stuff should be put in a routine of their own*/
  set_up_pixmap();     /* since they get called over and over again!*/

  draw_states = TRUE;
  draw_events = TRUE;

  if((StatefileLoaded) || (initState_ref))/*states have either been read from*/
                                         /*a file or entered through stateDef*/
    {
      next_draw(left_time,FALSE);
      BufferScroll(Bscroll,NULL,NULL);
    }    
  else
    {
      strcpy(message,"Please load state file");
      xErrorBox(message);
    }
}

/*****************************************************************************/
/* SET STATES ONLY: verifies the name of the given states file sets the flag */
/*                  to states and starts state drawing process               */
/*****************************************************************************/
void SetStatesOnly()
{
  char message[250];

  draw_watch(TRUE);

  free_pixmap();       /* this stuff should be put in a routine of their own*/
  set_up_pixmap();     /* since they get called over and over again!*/

  draw_states = TRUE;
  draw_events = FALSE;

  if((StatefileLoaded) || (initState_ref))/*states have either been read from*/
                                         /*a file or entered through stateDef*/
    {
      next_draw(left_time,FALSE);
      BufferScroll(Bscroll,NULL,NULL);
    }    
  else
    {
      strcpy(message,"Please load state file");
      xErrorBox(message);
    }

  draw_watch(FALSE);
}


/*****************************************************************************/
/* SET STATEDEF CALLBACK:  xgraphics intermidiate routine to SetStateDef     */
/*****************************************************************************/
void SetStateDefCallback(widget,client_data,call_data)
     Widget widget;
     XtPointer client_data,call_data;
{
  int n;
  Arg arg[2];

  if(StatefileLoaded)
    {
      HideStateKey();
      XtDestroyWidget(StateKeyViewport);
    }
  
  SetStateDef();

}

/*****************************************************************************/
/* SAVE STATE DEF:  saves state definition given in the state-def window to  */
/*                  current state file                                       */
/*****************************************************************************/
void SaveStateDef(button,client_data,call_data)
     Widget button;
     XtPointer client_data,call_data;
{
  FILE *fp;
  int start,end;
  char name[50],color[50];
  int allGood = TRUE;

  /* gets data from StateDef dialogs */
  CheckStateDef(&start,&end,color,name,&allGood); 

  if(allGood)
    {
      /* Make sure that there exist an accessible state file */
      if(StatefileLoaded)
	{
	  fp = fopen(XawDialogGetValueString(StateFile),"a");
	  fprintf(fp,"%d %d %d %s %s\n",0,start,end,color,name);
	  fclose(fp);
	}
      else
	xErrorBox(" Please load state file ");
    }
}
/*****************************************************************************/
/* RESETCALLBACK:  restores the graph to the original page's display         */
/*****************************************************************************/
void ResetCallBack()
{

  XawScrollbarSetThumb(Bscroll,0.0,-1.0);
  BufferScroll(Bscroll,NULL,NULL);

  ResetGraph();
}

/*****************************************************************************/
/* QUITCALLBACK:  exits the program.                                         */
/*****************************************************************************/
void QuitCallBack()
{
  int i;

  XFreePixmap(display,canvas_pixmap);
  
  /* Loop to kill all of the child processes.  DPN */

  for(i=0;i<num_children;i++){
      kill(children[i],SIGKILL);
      }

  exit(1);
}



/***************************************************************************/
/* SHIFT PG:   shifts the file view to the page corresponding to the       */
/*             page button that invoqued the call                          */
/***************************************************************************/
void ShiftPgCallback(pgButton,pgPtr,call_data)
     Widget pgButton;
     struct page *pgPtr;
     XtPointer call_data;
{
  char logfile[250];
  int n;
  Arg arg[5];

  /* reset thumb to the begining of scrollbar */
  XawScrollbarSetThumb(Bscroll,0.0,-1.0);

  strcpy(logfile,XawDialogGetValueString(LogFile));
  ShiftPg(logfile,pgPtr);
}


/*****************************************************************************/
/* LOAD STATE FILE: obtains statefile's name and makes a call to             */
/*                  ReadStatefile to have state info read in and ready to use*/
/*****************************************************************************/
LoadStatefile(loadButton,client_data,call_data)
     Widget loadButton;
     XtPointer client_data, call_data;
{
  char fname[250];
  Widget Dialog = XtParent(loadButton);


  if((StatefileLoaded) || (initState_ref))  /* any previously defined states */
    FreeStateQueue();                       /* must be removed first */

  strcpy(fname,XawDialogGetValueString(Dialog)); 
  ReadStatefile(fname);         

}

/*****************************************************************************/
/* SHOW LOG EVENT DATA:  event handler responds to the pressing of a mouse   */
/*                       button on the canvas.  If the sprite is within an   */
/*                       event box when the button is pressed a window will  */
/*                       pop-up with logfile information about it.           */
/*****************************************************************************/
showLogEventData(canvas,client_data,event)
     Widget canvas;
     XtPointer client_data;
     XEvent *event;
{
  XButtonEvent *button_prssd;
  button_prssd = (XButtonEvent *)event; 
/*
  printf("button pressed = %d\n",button_prssd->button);
*/
  ShowEventData(event->xbutton.x,event->xbutton.y,button_prssd->button);

}

/*****************************************************************************/
/* DESTROY LOG EVENT DATA:  pops down and destroys an event data box if one  */
/*                          exists                                           */
/*****************************************************************************/
destroyLogEventData(canvas,client_data,event)
     Widget canvas;     /* widget from which routine was trigger by an event */
     XtPointer client_data;
     XEvent *event;
{
  XButtonEvent *button_prssd;

/*
  printf("event->type = %d, ButtonRelease = %d\n",event->type,ButtonRelease);
*/
  if (event->type == ButtonRelease)
    {
      button_prssd = (XButtonEvent *)event; /*assign a ptr to event structure*/

      if((DataBoxAlive) && (button_prssd->button == 1))
	{
	  XtDestroyWidget(DataBox);
	  DataBoxAlive = FALSE;
	}

    }
}


/****************************************************************************/
/*  PROCNUMBUTTON:  callback for the processor buttons;                     */
/****************************************************************************/
procnumbutton(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;
{
  Arg arg[3];
  int i,n;

  i = (int)client_data;
  proclistflag[i] = 1; /* Set */

  n = 0;
  XtSetArg(arg[n],XtNforeground,data.back); n++;
  XtSetArg(arg[n],XtNbackground,data.fore); n++;
  XtSetValues(w,arg,n);
}






















/** GRAPHICS ENVIRONMENT SETUP **/

/*****************************************************************************/
/* STATE DEF CONTENTS: definition of the stateDef popup shell                */
/*****************************************************************************/
void StateDefContents()
{
  Arg arg[25];
  int n,i;
  int colorCounter;

  Pixmap mybitmap;
  Widget StateDefForm,EntryForm,ButtonsForm;
  Widget Save,Set,SDQuit,Clear;   /* Action buttons */
  Widget ColorButtons[20];        /* list of color choices (command buttons) */
  FILE *fp;
  char color[55];
#define NUMCOLORS 20
  static char *colormenu[20] = {COLOR1,COLOR2,COLOR3,COLOR4,COLOR5,COLOR6,
                                COLOR7,COLOR8,COLOR9,COLOR10,COLOR11,COLOR12,
                                COLOR13,COLOR14,COLOR15,COLOR16,COLOR17,
                                COLOR18,COLOR19,COLOR20};


  if(colorScreen)
    {
      for (i = 0; i < NUMCOLORS; i++)
        {
	  strcpy(colortable[i].color,colormenu[i]);
          colortable[i].pixel = xConvertColor(colormenu[i]);
        }
      colorCounter = NUMCOLORS;
    }

  else
    {
      XSetFillStyle(display,gc,FillTiled); 

      strcpy(colortable[0].color,"checkerd");
      strcpy(colortable[1].color,"horizStripes");
      strcpy(colortable[2].color,"verStripes");
      strcpy(colortable[3].color,"rightSlant");
      strcpy(colortable[4].color,"leftSlant");
      strcpy(colortable[5].color,"rightSlant2");
      strcpy(colortable[6].color,"leftSlant2");
      strcpy(colortable[7].color,"rightSlant3");
      strcpy(colortable[8].color,"leftSlant3");
      
      colorCounter = totalPatterns;
    }

  /* FORM WIDGET */
  n = 0;
  StateDefForm = XtCreateManagedWidget("stateDefForm",formWidgetClass,
				       StateDefWindow,arg,n);

  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  EntryForm = XtCreateManagedWidget("entryform",formWidgetClass,
				    StateDefForm,arg,n);

  /* DIALOGS for data entry */
  n = 0;
  XtSetArg(arg[n],XtNlabel,"Name:");n++;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNvalue," ");n++;
  StateName = XtCreateManagedWidget("stateName",dialogWidgetClass,EntryForm,
				    arg,n);

  n =0;
  XtSetArg(arg[n],XtNlabel,"Start Event:");n++;
  XtSetArg(arg[n],XtNfromVert,StateName);n++;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNvalue,"-1");n++;
  StartEv = XtCreateManagedWidget("startEv",dialogWidgetClass,EntryForm,
				  arg,n);

  n =0;
  XtSetArg(arg[n],XtNlabel,"End Event:");n++;
  XtSetArg(arg[n],XtNfromVert,StartEv);n++;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNvalue,"-1");n++;
  EndEv = XtCreateManagedWidget("endEv",dialogWidgetClass,EntryForm,
				arg,n);

  n =0;
  if(colorScreen)
    {
      XtSetArg(arg[n],XtNlabel,"Color:");n++;
    }
  else
    {
      XtSetArg(arg[n],XtNlabel,"Pattern:");n++;
    }
      XtSetArg(arg[n],XtNfromVert,EndEv);n++;
      XtSetArg(arg[n],XtNborderWidth,0);n++;
      XtSetArg(arg[n],XtNvalue," ");n++;
  StateColor = XtCreateManagedWidget("stateColor",dialogWidgetClass,
				     EntryForm,arg,n);

  /* COLOR BUTTONS */
  n = 0;
  XtSetArg(arg[n],XtNfromHoriz,StartEv);n++;
  XtSetArg(arg[n],XtNhorizDistance,25);n++;
  ButtonsForm = XtCreateManagedWidget("buttonsForm",formWidgetClass,
				       EntryForm,arg,n);
  
  for(i = 0; i < colorCounter; i++)
    {
      n = 0;
      XtSetArg(arg[n],XtNlabel,"     ");n++;
      XtSetArg(arg[n],XtNwidth,30);n++;
      XtSetArg(arg[n],XtNheight,10);n++;
      XtSetArg(arg[n],XtNborderWidth,1);n++;

      if(colorScreen)
	{
	  XtSetArg(arg[n],XtNbackground,colortable[i].pixel);n++;
	}

      else
	{
	  
	  mybitmap = XCreateBitmapFromData
	    (display,RootWindowOfScreen(XtScreen(toplevel)),
	     checkerd_bits, checkerd_width, 
	     checkerd_height);
	  XtSetArg(arg[n], XtNbackgroundPixmap, (XtPointer)mybitmap); n++;
	}

      if (i > 0){
	XtSetArg(arg[n],XtNfromVert,ColorButtons[i-1]);n++;
	}
      ColorButtons[i] = XtCreateManagedWidget("colorButton",commandWidgetClass,
					       ButtonsForm,arg,n);
      XtAddCallback(ColorButtons[i],XtNcallback,GiveColorName,i);
    }


  /* SAVE */
  n = 0;
  XtSetArg(arg[n],XtNfromVert,StateColor);n++;
  XtSetArg(arg[n],XtNhorizDistance,7);n++;
  XtSetArg(arg[n],XtNvertDistance,15);n++;
  XtSetArg(arg[n],XtNlabel,"Save to file");n++;
  Save = XtCreateManagedWidget("save",commandWidgetClass,EntryForm,arg,n);
  XtAddCallback(Save,XtNcallback,SaveStateDef,NULL);


  /* SET */
  n = 0;
  XtSetArg(arg[n],XtNfromVert,Save);n++;
  XtSetArg(arg[n],XtNlabel,"Set");n++;
  XtSetArg(arg[n],XtNhorizDistance,7);n++;
  XtSetArg(arg[n],XtNwidth,103);n++;
  Set = XtCreateManagedWidget("set",commandWidgetClass,EntryForm,arg,n);
  XtAddCallback(Set,XtNcallback,SetStateDefCallback,NULL);


  /* QUIT */

  n = 0;
  XtSetArg(arg[n],XtNfromVert,EntryForm);n++;
  XtSetArg(arg[n],XtNwidth,86);n++;
  XtSetArg(arg[n],XtNlabel,"Clear");n++;
  Clear = XtCreateManagedWidget("Clear",commandWidgetClass,StateDefForm,
                                   arg,n);
  XtAddCallback(Clear,XtNcallback,ClearStateDef,NULL);

  n = 0;
  XtSetArg(arg[n],XtNfromVert,EntryForm);n++;
  XtSetArg(arg[n],XtNfromHoriz,Clear);n++;
  XtSetArg(arg[n],XtNwidth,86);n++;
  XtSetArg(arg[n],XtNlabel,"Quit");n++;
  SDQuit =  XtCreateManagedWidget("sDQuit",commandWidgetClass,StateDefForm,
                                   arg,n);
  XtAddCallback(SDQuit,XtNcallback,PopDown,StateDefWindow); 
  /*NOTE: passes StateDefWindow as client_data to its callback to indicate
    the widget to popdown */
  
  if(!colorScreen)
      XSetFillStyle(display,gc,FillSolid); 

}

/*****************************************************************************/
/* CREATE STATE KEY ENTRY:  defines a color key entry for the state key      */
/*****************************************************************************/
void CreateStateKeyEntry(statePtr,previous,stateNumber)
     struct stateNode *statePtr, *previous;
     int stateNumber;
{
  int n;
  Arg arg[10];
  Widget colorLabel,nameLabel;
  char *name;

  Pixmap mybitmap;

  /* STATE KEY ENTRY FORM */
  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNwidth,5);n++;  /* width and height are given to avoid */
  XtSetArg(arg[n],XtNheight,5);n++;  /* system error message */
  if(previous != NULL)   /* all but the first entry */
    {
      XtSetArg(arg[n],XtNfromVert,previous->colorKey);n++;
    }
  statePtr->colorKey = XtCreateManagedWidget("colorKey",formWidgetClass,
					     StateKeyform,arg,n);

  /* COLOR/PATTERN LABEL */
  n = 0;
  if(colorScreen)
    {
      XtSetArg(arg[n],XtNbackground,statePtr->color);n++;

                        /* Added so that the stateNumber would be consistent */
      stateNumber++;    /* on both color and b&w.  DPN */
    }
  else  /* monochrome */
    {
      ++stateNumber;
      switch(stateNumber)
	{
/*
	case 1:
	  mybitmap = solid;
	  break;
*/
	case 1:
	  mybitmap = checkerd;
	  break;

	case 2:
	  mybitmap = horizStripes;
	  break;
	  
	case 3:
	  mybitmap = verStripes;
	  break;

	case 4:
	  mybitmap = rightSlant;
	  break;
	  
	case 5:
	  mybitmap = leftSlant;
	  break;

        case 6:
	  mybitmap = rightSlant2;
	  break;

        case 7:
	  mybitmap = leftSlant2;
	  break;

        case 8:
	  mybitmap = rightSlant3;
	  break;

        case 9:
	  mybitmap = leftSlant3;
	  break;
	}

      XtSetArg(arg[n], XtNbackgroundPixmap, mybitmap); n++;
    }

  XtSetArg(arg[n],XtNlabel,"    ");n++;
  XtSetArg(arg[n],XtNwidth,50);n++;
  XtSetArg(arg[n],XtNheight,10);n++;
  XtSetArg(arg[n],XtNhorizDistance,25);n++;
  colorLabel = XtCreateManagedWidget("colorLabel",commandWidgetClass,
				     statePtr->colorKey,arg,n);
  XtAddCallback(colorLabel,XtNcallback,Histogram,stateNumber);

  /* NAME LABEL */
  n = 0;
  XtSetArg(arg[n],XtNlabel,statePtr->name);n++;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNfromVert,colorLabel);n++;
  XtSetArg(arg[n],XtNwidth,100);n++;
  nameLabel = XtCreateManagedWidget("nameLabel",labelWidgetClass,
                                     statePtr->colorKey,arg,n);
}

/*****************************************************************************/
/* DEFINE STATE KEY:  called by ReadStatefile, it is the definition of the   */
/*                    StateKeyform and its child widgets                     */
/* This is really a mess. It does not handle large numbers of states very    */
/* well.                                                                     */
/*****************************************************************************/
void xDefineStateKey(stateTotal)
     int stateTotal;        /* total number of states created */
{
  int n,i;
  Arg arg[10];
  Arg varg[10]; int vn;
  struct stateNode *nextState, *previous = NULL;


  /* STATE KEY form: will be managed and realized later */
  /* Notice that since the Panelform has laready been realized, the size
     of the StateKeyform won't force the Panelform to be larger if the
     StateKeyform is too large.  We should use a Paned form to hold the
     box */
  vn = 0;
  XtSetArg(varg[vn],XtNborderWidth,1);vn++;
  XtSetArg(varg[vn],XtNmappedWhenManaged,False);vn++;
  XtSetArg(varg[vn],XtNfromHoriz,Canvasform);vn++;
  XtSetArg(varg[vn],XtNhorizDistance,5);vn++;
  XtSetArg(varg[vn],XtNfromVert,Edge);vn++;
  XtSetArg(varg[vn],XtNvertDistance,15);vn++;
  XtSetArg(varg[vn],XtNwidth,160);vn++;
  XtSetArg(varg[vn],XtNheight,(300));vn++;
  XtSetArg(varg[vn],XtNallowVert,True);vn++;
  

StateKeyViewport   = XtCreateManagedWidget( "Viewport", viewportWidgetClass, 
					     Panelform, varg, vn);
  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNmappedWhenManaged,True);n++;
  XtSetArg(arg[n],XtNhorizDistance,0);n++;
  XtSetArg(arg[n],XtNvertDistance,0);n++;
  XtSetArg(arg[n],XtNwidth,160);n++;
  XtSetArg(arg[n],XtNheight,(55 * stateTotal));n++;

StateKeyform       = XtCreateManagedWidget( "stateKeyform", boxWidgetClass, 
					    StateKeyViewport, arg, n );
  /* create one entry at a time */
  nextState = states->next;
  for(i = 0; i < stateTotal; i++)
    {
      CreateStateKeyEntry(nextState,previous,i);  /* i = state number */
      previous = nextState;
      nextState = nextState->next;
    }
}



/*****************************************************************************/
/* CREATE BITMAPS                                                            */
/*****************************************************************************/
void create_bitmaps()
{
  int frame_depth = XDefaultDepth(display,screen);
  Pixel fore = data.fore;
  Pixel back = data.back;

  square = XCreatePixmapFromBitmapData(display,w,square_bits,square_width,
				       square_height,fore,back,
				       frame_depth);

  horizStripes = XCreateBitmapFromData(display,w,horizStripes_bits,
				       horizStripes_width,horizStripes_height);
  
  verStripes = XCreateBitmapFromData(display,w,verStripes_bits,
				       verStripes_width,verStripes_height); 
 
  rightSlant = XCreateBitmapFromData(display,w,rightSlant_bits,
				       rightSlant_width,rightSlant_height);  

  leftSlant = XCreateBitmapFromData(display,w,leftSlant_bits,
				       leftSlant_width,leftSlant_height);
  
  rightSlant2 = XCreateBitmapFromData(display,w,rslant2_bits,
				       rslant2_width,rslant2_height);  

  leftSlant2 = XCreateBitmapFromData(display,w,lslant2_bits,
				       lslant2_width,lslant2_height);

  rightSlant3 = XCreateBitmapFromData(display,w,rslant3_bits,
				       rslant3_width,rslant3_height);  

  leftSlant3 = XCreateBitmapFromData(display,w,lslant3_bits,
				       lslant3_width,lslant3_height);
  
  checkerd = XCreateBitmapFromData(display,w,checkerd_bits,
				   checkerd_width,checkerd_height);
/*
  solid = XCreateBitmapFromData(display,w,solid_bits,solid_width,solid_height);
*/
  totalPatterns = 9;

}


/***************************************************************************/
/* CREATE PAGE BUTTONS: initializes and realizes page buttons              */
/***************************************************************************/
void CreatePageButtons()

{
  struct page *pgPtr;
  Arg arg[10];
  int i,n;
  int width;
  char pgNumber[5];

  pgPtr = firstPg;
  
  /* if there are more than 25 pages to make buttons for arrange them into rows
     (this will be done automatically by their boxWidget parent when the 
      buttons combined lenght exceeds PGBUTTONS_WIDTH */
  if(pgTotal <= 25)
    {
      if(pgTotal <= 5)
	width = (PGBUTTONS_WIDTH/pgTotal) - 10;
      else
	  width = (PGBUTTONS_WIDTH/pgTotal);
    }
  else
    width = (PGBUTTONS_WIDTH/25);

  i = 0;
  while(i < pgTotal)
    {
      itoa((i+1),pgNumber);
      n = 0;
      XtSetArg(arg[n],XtNwidth,width);n++;
      XtSetArg(arg[n],XtNlabel,pgNumber);n++;
      XtSetArg(arg[n],XtNheight,12);n++;
      XtSetArg(arg[n],XtNborderWidth,1);n++;
      if(pgPtr->number >= 1)  /* add all buttons after the first one to the */
	{                     /* radio group and place them side to side    */
	  --pgPtr;
	  XtSetArg(arg[n],XtNradioGroup,pgPtr->button);n++;
	  XtSetArg(arg[n],XtNfromHoriz,pgPtr->button);n++;
	  ++pgPtr;
	}
      else  /* indicate that the first pg is being shown by setting it on */ 
	{
	  XtSetArg(arg[n],XtNstate,True);n++;
	}
      pgPtr->button = XtCreateManagedWidget("button",toggleWidgetClass,
					   PgButtonsform,arg,n);
      XtAddCallback(pgPtr->button,XtNcallback,ShiftPgCallback,pgPtr);


      pgPtr++;
      i++;
    }

}


/*****************************************************************************/
/* X GRAPHICS INIT:  develops basic graphics background by creating the      */
/*                   application's shell widget, parsing the command line    */
/*                   for graphics options, and determining the graphics      */
/*                   components.                                             */
/*****************************************************************************/
void x_graphics_init(argc,argv)
     int argc;
     char **argv;
{
  XtAppContext app_context;
  int frame_depth;

  /* MAKE THE SHELL/ROOT WINDOW */
#ifdef APP
  /* New applications should use XtApp rather than XtInitialize.
     The app_context needs to be put somewhere where we can access it later */
  toplevel    = XtAppInitialize( &app_context, "upshot",
                               app_options, XtNumber(app_options), 
                               argc, argv, (char *)0, (Arg *)0, 0 );
#else
  toplevel = XtInitialize("upshot","Upshot",app_options,XtNumber(app_options),
			  &argc,argv);
#endif
  data.font = NULL;

  /* Get the resourse given foreground and background */
  XtGetApplicationResources(toplevel, &data, resources, XtNumber(resources),
			    NULL, 0);

/*
printf("%d\n %d\n %s\n %s\n %d\n now: %d %d",data.fore,data.back,data.logfile,data.statefile,data.canvas_height,data.help,data.tasks);
*/

  /* The following set of steps are taken in order to get a hold of the 
     depth frame (bits per color cell) of the machine */

  display = XtDisplay(toplevel);

  screen = DefaultScreen(display);

  cmap = DefaultColormap(display,screen);

  frame_depth = XDefaultDepth(display,screen);

  /* Determine whether the screen is monochrome or color according to
     its frame depth or number of bits per color cell */

  if (frame_depth > 1)
      colorScreen = TRUE;
  else
      colorScreen = FALSE;


  /* Load fonts to be used with widgets and record their font ids when 
     necessary (used by the xchangeFont routine).  If font not in database 
     default to resource specified font. */

  labelFont = data.labelFont;
  titleFont = data.titleFont;

  boxFont = data.boxFont;
  boxFontId = boxFont->fid;

  bigFont = data.bigFont;
  bigFontId = bigFont->fid;

  smallFont = data.smallFont;
  smallFontId = smallFont->fid;

  /* Eventually, should set font width/height from actual font information */

  /* Fallback if xsmall font not available.  This is an attempt to fix a
     bug that shows up as event boxes without any text. */
  if (!xsmallFontId) {
      xsmallFont        = data.smallFont;
      xsmallFontId      = smallFont->fid;
      xsmallFonthHeight = smallFonthHeight;
      }
  else {
      xsmallFont   = data.xsmallFont;
      xsmallFontId = xsmallFont->fid;
      }

}

/*****************************************************************************/
/* SETUP WIDGETS:  defines and realizes the hiearchy of widgets.             */
/*                 A number of the widgets get their values from info in the */
/*                 log and state files, this is why widget definition has to */
/*                 wait until the files have been read.                      */
/*****************************************************************************/
setupWidgets(Lfile,Sfile,keyString)
     char Lfile[],Sfile[],keyString[];
{
  Arg arg[25], varg[15];
  XSetWindowAttributes w_attr;
  unsigned int n, vn;
  int time,len, i;
  char strng[40],ctime[10],let[1];
  float thumblen;

  /* Local widgets that need not be declared global because of their small
     roles... */
  Widget StatesOnly,EventsOnly,both,Timelabel;
  Widget StateKeyLabel,Reset,PgButtonsLabel;
  Widget BscrollLabel,CscrollLabel;

  /* the MAIN FORM widget organizes and holds all other widgets */
  n = 0;
  XtSetArg(arg[n],XtNdefaultDistance,2);n++;
  XtSetArg(arg[n],XtNborderWidth,1);n++;
  outline = XtCreateManagedWidget("outline",formWidgetClass,toplevel,arg,n);

  /* create  title */
  n = 0;
  XtSetArg(arg[n],XtNwidth,650);n++;
  XtSetArg(arg[n],XtNlabel,"    UPSHOT");n++;
  XtSetArg(arg[n],XtNfont,titleFont);n++;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  title = XtCreateManagedWidget("title",labelWidgetClass,outline,arg,n);



  /* The PANEL form organizes the screen into buttons, y-axis, canvas and
     page sections using other form and box children */
  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNdefaultDistance,3);n++;
  XtSetArg(arg[n],XtNhorizDistance,0);n++;
  XtSetArg(arg[n],XtNfromVert,title);n++;
  Panelform = XtCreateManagedWidget("Panelform",formWidgetClass,outline,
				     arg,n);

  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  Buttonform = XtCreateManagedWidget("Buttonform",formWidgetClass,Panelform,
                                     arg,n);

  /*Create widgets for zoom utilities*/
  n = 0;
  XtSetArg(arg[n],XtNfont,labelFont);n++;
  XtSetArg(arg[n],XtNwidth,105);n++;
  Zoomout = XtCreateManagedWidget("Zoom-out",commandWidgetClass,Buttonform,
				  arg,n);
  XtAddCallback(Zoomout,XtNcallback,ZoomOutCallBack,NULL);

  n = 0;
  XtSetArg(arg[n],XtNfromHoriz,Zoomout);n++;
  XtSetArg(arg[n],XtNfont,labelFont);n++;
  XtSetArg(arg[n],XtNwidth,105);n++;
  Zoomin = XtCreateManagedWidget("Zoom-in",commandWidgetClass,Buttonform,
				 arg,n);
  XtAddCallback(Zoomin,XtNcallback,ZoomInCallBack,NULL);



  /* DISPLAY MENU*/
  n = 0;
  XtSetArg(arg[n],XtNfromHoriz,Zoomin);n++;
  XtSetArg(arg[n],XtNlabel," Display Options ");n++;
  XtSetArg(arg[n],XtNfont,labelFont);n++;
  XtSetArg(arg[n],XtNmenuName,"displayMenu");n++;
  DMenuButton = XtCreateManagedWidget("dMenuButton",menuButtonWidgetClass,
				      Buttonform,arg,n);

  n = 0;
  DisplayMenu = XtCreateManagedWidget("displayMenu",simpleMenuWidgetClass,
				      outline,arg,n);

  /* Menu item 1: StatesOnly */
  n = 0;
  XtSetArg(arg[n],XtNfont,bigFont);n++;
  XtSetArg(arg[n],XtNlabel,"states only");n++;
  XtSetArg(arg[n],XtNleftMargin,12);n++;
  StatesOnly = XtCreateManagedWidget("statesOnly",smeBSBObjectClass,
				     DisplayMenu,arg,n);
  XtAddCallback(StatesOnly,XtNcallback,SetStatesOnly,NULL);

  /* Menu item 2: EventsOnly */
  n = 0;
  XtSetArg(arg[n],XtNlabel,"events only");n++;
  XtSetArg(arg[n],XtNfont,bigFont);n++;
  XtSetArg(arg[n],XtNleftMargin,12);n++;
  EventsOnly = XtCreateManagedWidget("eventsOnly",smeBSBObjectClass,
				     DisplayMenu,arg,n);
  XtAddCallback(EventsOnly,XtNcallback,SetEventsOnly,NULL);


  /* Menu item 3: Events&States */
  n = 0;
  XtSetArg(arg[n],XtNlabel,"states & events");n++;
  XtSetArg(arg[n],XtNfont,bigFont);n++;
  XtSetArg(arg[n],XtNleftMargin,12);n++;
  both = XtCreateManagedWidget("events&States",smeBSBObjectClass,DisplayMenu,
				     arg,n);
  XtAddCallback(both,XtNcallback,SetBoth,NULL);




  /* STATE DEFINITION WINDOW: popup */

  /* the popup shell is defined as a child of outline to keep all shells at
     in the "top" level */
  n = 0;
  StateDefWindow = XtCreatePopupShell("State-Definition",
				      applicationShellWidgetClass,
				      outline,arg,n);

  /* state def. command button */
  n = 0;
  XtSetArg(arg[n],XtNfromHoriz,DMenuButton);n++;
  XtSetArg(arg[n],XtNlabel," State Definition ");n++;
  XtSetArg(arg[n],XtNfont,labelFont);n++;
  StateDef = XtCreateManagedWidget("stateDef",commandWidgetClass,Buttonform,
				   arg,n);
  XtAddCallback(StateDef,XtNcallback,PopShell,StateDefWindow);


  /* RESET button */
  n = 0;
  XtSetArg(arg[n],XtNfromHoriz,StateDef);n++;
  XtSetArg(arg[n],XtNfont,labelFont);n++;  
  XtSetArg(arg[n],XtNwidth,105);n++;
  Reset = XtCreateManagedWidget("Reset",commandWidgetClass,Buttonform,arg,n);
  XtAddCallback(Reset,XtNcallback,ResetCallBack,NULL);



  /* The Quit button */
  n = 0;
  XtSetArg(arg[n],XtNfromHoriz,Reset);n++;
  XtSetArg(arg[n],XtNfont,labelFont);n++;
  XtSetArg(arg[n],XtNwidth,105);n++;
  Quit = XtCreateManagedWidget(" Quit ",commandWidgetClass,Buttonform,arg,n);
  XtAddCallback(Quit,XtNcallback,QuitCallBack,NULL);


  /* on the Panel's left add zoomstep dialog and y-axis */
  n = 0;
  XtSetArg(arg[n],XtNvalue,"2");n++;
  XtSetArg(arg[n],XtNborderWidth,0); n++;
  XtSetArg(arg[n],XtNfont,labelFont);n++;
  XtSetArg(arg[n],XtNlabel,"Zoomstep:");n++;
  XtSetArg(arg[n],XtNfromVert,Buttonform);n++;
  XtSetArg(arg[n],XtNvertDistance,53);n++;
  Zoomstep = XtCreateManagedWidget("zoomstep",dialogWidgetClass,Panelform,
				  arg,n);

  n = 0;
  XtSetArg(arg[n],XtNstring,keyString);n++;
  XtSetArg(arg[n],XtNborderWidth,1); n++;
  XtSetArg(arg[n],XtNfont,smallFont);n++;
  XtSetArg(arg[n],XtNfromVert,Zoomstep);n++;
  XtSetArg(arg[n],XtNvertDistance,10);n++;
  XtSetArg(arg[n],XtNhorizDistance,3);n++;
  XtSetArg(arg[n],XtNwidth,120);n++;
  XtSetArg(arg[n],XtNheight,canvas_height-100);n++;
  XtSetArg(arg[n],XtNresize,"height");n++;
  XtSetArg(arg[n],XtNscrollVertical,XawtextScrollWhenNeeded);n++;
  EventKey = XtCreateManagedWidget("eventKey",asciiTextWidgetClass,Panelform,
				   arg,n);
  XawTextDisplayCaret( EventKey, 0 );
  
  /* Form widget to contain y-axis label */
  if(data.tasks)
    strcpy(strng,"T\na\ns\nk\ns");
  else
    strcpy(strng,"P\nr\no\nc\ne\ns\ns\ne\ns");

  n = 0;
  XtSetArg(arg[n],XtNfromVert,Buttonform);n++;
  XtSetArg(arg[n],XtNvertDistance,canvas_height-160);n++;
  XtSetArg(arg[n],XtNfromHoriz,EventKey);n++;
  XtSetArg(arg[n],XtNhorizDistance,0);n++;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNlabel,strng);n++;
  XtSetArg(arg[n],XtNfont,labelFont);n++;
  YaxisLabel = XtCreateManagedWidget("yaxisLabel",labelWidgetClass,Panelform,
				     arg,n);


  /* CANVAS FORM contains the canvas and all of its related widgets */
  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNfromVert,Buttonform);n++;
  XtSetArg(arg[n],XtNfromHoriz,YaxisLabel);n++;
  Canvasform = XtCreateManagedWidget("Canvasform",formWidgetClass,Panelform,
				     arg,n);


  /* BUFFER SCROLLBAR */
  n = 0;
  XtSetArg(arg[n],XtNlength,CANVAS_WIDTH-X_OFFSET);n++;
  XtSetArg(arg[n],XtNthickness,10);n++;
  XtSetArg(arg[n],XtNhorizDistance,22+X_OFFSET);n++;
  XtSetArg(arg[n],XtNborderWidth,2);n++;
  XtSetArg(arg[n],XtNorientation,XtorientHorizontal);n++;
  Bscroll = XtCreateManagedWidget("scroll",scrollbarWidgetClass,Canvasform,
				 arg,n);
  XtAddCallback(Bscroll,XtNjumpProc,BufferScroll,NULL);


  /* CANVAS SCROLLBAR */
  n = 0;
  XtSetArg(arg[n],XtNlength,CANVAS_WIDTH-X_OFFSET);n++;
  XtSetArg(arg[n],XtNthickness,10);n++;
  XtSetArg(arg[n],XtNhorizDistance,22+X_OFFSET);n++;
/*
  XtSetArg(arg[n],XtNfromVert,Bscroll);n++;
*/
  XtSetArg(arg[n],XtNvertDistance,14);n++; /*same as Bscroll thickness + 4*/
  XtSetArg(arg[n],XtNborderWidth,2);n++;
  XtSetArg(arg[n],XtNorientation,XtorientHorizontal);n++;
  Cscroll = XtCreateManagedWidget("Cscroll",scrollbarWidgetClass,Canvasform,  
				 arg,n);
  XtAddCallback(Cscroll,XtNjumpProc,CanvasScroll,NULL);

  fix_thumblen(Cscroll,0.1);     /* defines the length of the thumb */


  /* Procnumform */
  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNfromVert,Cscroll);n++;
  XtSetArg(arg[n],XtNvertDistance,0);n++;
  XtSetArg(arg[n],XtNheight,canvas_height);n++;
  XtSetArg(arg[n],XtNwidth,22);n++;
  XtSetArg(arg[n],XtNdefaultDistance,0);n++;
  Procnumform = XtCreateManagedWidget("Procnumform",formWidgetClass,Canvasform,
				 arg,n);
  put_procnumbutton();
				 

  /* CANVAS */
  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNfromVert,Cscroll);n++;
  XtSetArg(arg[n],XtNvertDistance,0);n++;
  XtSetArg(arg[n],XtNfromHoriz,Procnumform);n++;
  XtSetArg(arg[n],XtNhorizDistance,0);n++;
  XtSetArg(arg[n],XtNheight,canvas_height);n++;
  XtSetArg(arg[n],XtNwidth,CANVAS_WIDTH);n++;
  /* Need to set a redraw function here */
  canvas = XtCreateManagedWidget("canvas",compositeWidgetClass,Canvasform,
				 arg,n);
  /* Need to set canvas->core_class.expose to the exposure routine, with
     form (Widget w, (XEvent *)event, Region region ) */
  SetCanvasExposure( canvas );

  /* Time units */
  n = 0;
  XtSetArg(arg[n],XtNlabel,"Time in microseconds");n++;
  XtSetArg(arg[n],XtNhorizDistance,22+X_OFFSET);n++;
  XtSetArg(arg[n],XtNfromVert,canvas);n++;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNfont,labelFont);n++;
  Units = XtCreateManagedWidget("units",labelWidgetClass,Canvasform,arg,n);


  /* PG BUTTONS FORM */
  n = 0;
  XtSetArg(arg[n],XtNfromVert,Panelform);n++;
  XtSetArg(arg[n],XtNlabel,"File pages:");n++;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  PgButtonsLabel = XtCreateManagedWidget("pgButtonsLabel",labelWidgetClass,
					 outline,arg,n);

  n = 0;
  XtSetArg(arg[n],XtNfromVert,PgButtonsLabel);n++;
  XtSetArg(arg[n],XtNdefaultDistance,0);n++;
  XtSetArg(arg[n],XtNborderWidth,0);n++;
  XtSetArg(arg[n],XtNwidth,PGBUTTONS_WIDTH);n++;
  PgButtonsform = XtCreateManagedWidget("pgButtonsForm",boxWidgetClass,
					    outline,arg,n);

  /* add the nessesary page buttons */
  CreatePageButtons();



  /* FILE INFORMATION widgets */

  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0); n++;
  XtSetArg(arg[n],XtNhorizDistance,15);n++;
  XtSetArg(arg[n],XtNfromVert,Buttonform);n++;
  XtSetArg(arg[n],XtNlabel,"Page view");n++;
  BscrollLabel = XtCreateManagedWidget("bscrollLabel",labelWidgetClass,
				       Panelform,arg,n);

  n = 0;
  XtSetArg(arg[n],XtNborderWidth,0); n++;
  XtSetArg(arg[n],XtNhorizDistance,15);n++;
  XtSetArg(arg[n],XtNfromVert,BscrollLabel);n++;
  XtSetArg(arg[n],XtNvertDistance,0);n++;
  XtSetArg(arg[n],XtNlabel,"Graph view");n++;
  CscrollLabel = XtCreateManagedWidget("CscrollLabel",labelWidgetClass,
				       Panelform,arg,n);

#ifdef NEW_FILE_HANDLING
  /* This code brings up a fileselection widget for these files */
  n = 0;
  XtSetArg(arg[n],XtNfromVert,Buttonform);n++;
  XtSetArg(arg[n],XtNfromHoriz,Canvasform);n++;
  XtSetArg(arg[n],XtNhorizDistance,5);n++;
  XtSetArg(arg[n],XtNlabel,"LogFile");n++;
  LogFile = XtCreateManagedWidget("LogFile", commandWidgetClass, Panelform,
			       arg,n);
  XtAddCallback(LogFile,XtNcallback,LoadLogFile,NULL);

  n = 0;
  XtSetArg(arg[n],XtNfromVert,LogFile);n++;
  XtSetArg(arg[n],XtNfromHoriz,Canvasform);n++;
  XtSetArg(arg[n],XtNhorizDistance,5);n++;
  XtSetArg(arg[n],XtNlabel,"StateFile");n++;
  StateFile = XtCreateManagedWidget("StateFile", commandWidgetClass, Panelform,
			       arg,n);
  XtAddCallback(StateFile,XtNcallback,LoadStateFile,NULL);

#else
  n = 0;
  XtSetArg(arg[n],XtNfromHoriz,Canvasform);n++;
  XtSetArg(arg[n],XtNhorizDistance,0);n++;
  XtSetArg(arg[n],XtNfromVert,Buttonform);n++;
  XtSetArg(arg[n],XtNvalue,Lfile);n++;
  XtSetArg(arg[n],XtNborderWidth,0); n++;
  XtSetArg(arg[n],XtNlabel,"Log file:");n++;
  LogFile = XtCreateManagedWidget("logFile",dialogWidgetClass,Panelform,arg,n);

  

  n = 0;
  XtSetArg(arg[n],XtNfromVert,LogFile);n++;
  XtSetArg(arg[n],XtNfromHoriz,Canvasform);n++;
  XtSetArg(arg[n],XtNhorizDistance,0);n++;
  XtSetArg(arg[n],XtNvalue,Sfile);n++;
  XtSetArg(arg[n],XtNborderWidth,0); n++;
  XtSetArg(arg[n],XtNlabel,"State file:");n++;
  StateFile = XtCreateManagedWidget("stateFile",dialogWidgetClass,Panelform,
				    arg,n);

  XawDialogAddButton(StateFile,"Load",LoadStatefile,(XtPointer)StateFile);
#endif
  /* Summary button */

  n = 0;
  XtSetArg(arg[n],XtNfromVert,StateFile);n++;
  XtSetArg(arg[n],XtNfromHoriz,Canvasform);n++;
  XtSetArg(arg[n],XtNhorizDistance,5);n++;
  XtSetArg(arg[n],XtNlabel,"Summary");n++;
  Summ = XtCreateManagedWidget("Summ",commandWidgetClass,Panelform,
			       arg,n);
  XtAddCallback(Summ,XtNcallback,Summary,NULL);


  /* Edge button will invoke xedge which views the processes edgewise into */
  /* the screen.  DPN */

  n = 0;
  XtSetArg(arg[n],XtNfromVert,Summ);n++;
  XtSetArg(arg[n],XtNfromHoriz,Canvasform);n++;
  XtSetArg(arg[n],XtNhorizDistance,5);n++;
  XtSetArg(arg[n],XtNlabel,"EdgeWise");n++;
  Edge = XtCreateManagedWidget("Edge",commandWidgetClass,Panelform,
			       arg,n);
  XtAddCallback(Edge,XtNcallback,EdgeWise,NULL);

  XtRealizeWidget(toplevel);     /* realizes all widgets at once */


  w = XtWindow(canvas);
  bigwindow = XtWindow(outline);


  /* GRAPHICS CONTEXT DEFINITION */
  gcv.foreground = data.fore;
  gcv.background = data.back;
  gc = XCreateGC(display,w,GCForeground | GCBackground,&gcv);

  /* Graphics context which clears the screen */

  gcv.foreground = data.back;
  gcclear = XCreateGC(display,w,GCForeground,&gcv);

  StateDefContents();   /* Defines the StateDef children */

  /* BITMAPS DEFINITION */
  create_bitmaps();
  
  /* Arrange for window to refresh itself automatically */
  w_attr.backing_store = Always;
  XChangeWindowAttributes(display,w,CWBackingStore, &w_attr);


  /* Event handler for selecting log-event on the canvas */
  XtAddEventHandler(canvas,ButtonPressMask,FALSE,showLogEventData,NULL);
  XtAddEventHandler(canvas,ButtonReleaseMask,FALSE,destroyLogEventData,NULL);

}


/****************************************************************************/
/*  PUT_PROCNUMBUTTON:  labels the y-axis with the processors;              */
/*              these labels are actually buttons used to select a          */
/*              processor list when xhist is called;                        */
/****************************************************************************/
put_procnumbutton()
{
  int i,n,inc;
  Arg arg[20];
  char buf[10];

  /* allocate an array of Widgets */
  procbutton = (Widget *)calloc(procTaskTotal,sizeof(Widget));

  /* allocate an array of int -- flags */
  proclistflag = (int *)calloc(procTaskTotal,sizeof(int));

  /* initialize inc */
  inc = procTable[1].proc_line - procTable[0].proc_line;
  inc -= 20;

  for(i=0;i<procTaskTotal;++i){

    proclistflag[i] = 0; /* initial value */

    n = 0;
    if(i==0){
      XtSetArg(arg[n],XtNvertDistance,4); n++;
      }
    else{
      XtSetArg(arg[n],XtNfromVert,procbutton[i-1]); n++;
      XtSetArg(arg[n],XtNvertDistance,inc); n++;
      }
    XtSetArg(arg[n],XtNwidth,20); n++;
    XtSetArg(arg[n],XtNheight,20); n++;
    XtSetArg(arg[n],XtNfont,bigFont); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    XtSetArg(arg[n],XtNhighlightThickness,0); n++;
    itoa(procTable[i].id,buf);
    XtSetArg(arg[n],XtNlabel,buf); n++;
    procbutton[i] = XtCreateManagedWidget(buf,
                                commandWidgetClass,Procnumform,arg,n);
    XtAddCallback(procbutton[i],XtNcallback,procnumbutton,(XtPointer)i);
    }
}










/** DRAWING ROUTINES **/


/***************************************************************************/
/* DRAW_BOX:   prints the boxes and numbers on the screen on the           */
/*             appropriate process line and at the appropriate time        */
/*             coordinate. It also undraws the boxes by using the          */
/*             single-line icon.                                           */
/***************************************************************************/
void draw_box(event_num,x,y)
     int event_num;     /*event type that is being drawn/undrawn*/
     int x,y;           /*x and y coordinates of the box*/

{
  int i;
  char s[11];               /* string which contains the event type*/
  int stringlength;
  int width = EVBOX_WIDTH;  /* width & height of event-box pixmap */
  int height, hwidth, hheight;

  itoa(event_num,s);          /*convert the event type to a string*/
  stringlength = strlen(s);

  /*draws the square icon*/

  if (event_num > 9) /* for events with more than one digit use smaller font */
    {
    /* Need to change to draw rectangle and fill in will black or background */
      height  = EVBOX_WIDTH;
      hheight = height/2;
      if (event_num > 999)     width = 2*EVBOX_WIDTH;
      else if (event_num > 99) width = (3*EVBOX_WIDTH)/2;

      hwidth = width/2;
      XSetForeground(display,gc,data.back);
      XFillRectangle(display,canvas_pixmap,gc,x-hwidth,y-hheight,width,height);
      XSetForeground(display,gc,data.fore);
      XDrawRectangle(display,canvas_pixmap,gc,x-hwidth,y-hheight,width,height);
      xchange_font(xsmallFontId);
      xdrawstring(canvas_pixmap,
		  x-hwidth+1,y+xsmallFonthHeight,s,stringlength);  
      xchange_font(smallFontId);
    }

  else
    {    
      XCopyArea(display,square,canvas_pixmap,gc,0,0,width,width,x-(width/2),
		y-(width/2));  /* place box's middle on the proc line */
      xdrawstring(canvas_pixmap,x-2,y+smallFonthHeight,s,stringlength);  
    }

/*NOTE: in placing the string "event_num" it is assumed that the box is 12
        pixels wide by 12 pixels high */
}

/*****************************************************************************/
/* DRAW_STATE: given the begining and end x-coordinates of a state along with*/
/*             y-coordinate this procedure will call the x-graphics routines */
/*             to draw a bar correspoding to the given state with its        */
/*             given color                                                   */
/*             "level" is used to manage overlapping states.                 */
/*             A level of "0" is the default; higher levels reduce the height*/
/*             of the state bar                                              */
/*****************************************************************************/
void draw_state(x1,x2,y,color,pattern,level)
     int x1,x2,y;
     int color;
     int pattern;
     int level;

{
  int leveloff = 2*level;

  /* Insure that leveloff is inrange */
  if (level < 0) leveloff = 0;
  if (leveloff >= 12) leveloff = 11;

  if (colorScreen)
    {
      XSetFunction(display,gc,GXcopy);
      XSetForeground(display,gc,color);
      XFillRectangle(display,canvas_pixmap,gc,
		     x1,y-6+leveloff,(x2-x1),12-leveloff);
      XSetForeground(display,gc,data.fore);
      /* This code draws a line along the right and left edges of the state.  
	 This helps separate states that are close together */
      XDrawLine( display, canvas_pixmap, gc, x2, y-6+leveloff, x2, y+6 );
      XDrawLine( display, canvas_pixmap, gc, x1, y-6+leveloff, x1, y+6 );
    }
  
  else
    {
      XDrawRectangle(display,canvas_pixmap,gc,
		     x1,y-6+leveloff,(x2-x1),12-leveloff);
      /* We force the patterns to wrap so that large numbers of
	 states will display somewhat properly */
      switch((pattern - 1) & 0x7)
	{
       
/*
	case 1:
          XSetTile(display,gc,solid);  
	  XSetFillStyle(display,gc,FillSolid);
	  break;
*/
	case 0:
	  XSetTile(display,gc,checkerd);
	  break;

	case 1:
	  XSetTile(display,gc,horizStripes);
	  break;
	  
	case 2:
	  XSetTile(display,gc,verStripes);
	  break;

	case 3:
	  XSetTile(display,gc,rightSlant);
	  break;
	  
	case 4:
	  XSetTile(display,gc,leftSlant);
	  break;

	case 5:
	  XSetTile(display,gc,rightSlant2);
	  break;
	  
	case 6:
	  XSetTile(display,gc,leftSlant2);
	  break;

	case 7:
	  XSetTile(display,gc,rightSlant3);
	  break;
	  
/* 	case 8:
	  XSetTile(display,gc,leftSlant3);
	  break; 
 */

	}

      XFillRectangle(display,canvas_pixmap,gc,
		      x1+1,y-5+leveloff,(x2-x1)-1,11-leveloff);
    }
}

/****************************************************************************/
/*  XLINE:  draws a line..                                                  */
/****************************************************************************/
void xline(drawable,x1, y1, x2, y2, xormode, color)
Drawable drawable; 
int x1, y1, x2, y2, xormode;
unsigned long color;
{

  XDrawLine(display, drawable, gc, x1, y1, x2, y2);
  
}
  

/****************************************************************************/
/* XENDLINE: specifies the type of line (dash or regular) to draw for       */
/*           the file's end marker                                          */
/****************************************************************************/
void xEndline()
{
  int graphEnd = time_to_pixels(right_time)+8;
  
  if(graphEnd > pixmapwidth)
    graphEnd = pixmapwidth;   /* in case of a time->pixel conversion error */

  if ((right_time + start_time) == fileEndTime)
    {
      XSetLineAttributes(display,gc,2,NULL,NULL,NULL);
      xline(canvas_pixmap,graphEnd,0,graphEnd,canvas_height-Y_OFFSET,0,0);
    }

  else
    {
      XSetLineAttributes(display,gc,2,LineDoubleDash,NULL,NULL);
      xline(canvas_pixmap,graphEnd,0,graphEnd,canvas_height-Y_OFFSET,0,0);
    }

  XSetLineAttributes(display,gc,0,LineSolid,NULL,NULL);
}

/*****************************************************************************/
/*  XCLEARBOX:  clears a rectangle given its upper left corner, length and   */
/*              width                                                        */
/*****************************************************************************/
void xclearbox(x,y,width,height)
          int x, y, width, height;
{
    XClearArea(display,w,x,y,width,height,False);
  }

/*****************************************************************************/
/* XDRAWSTRING */
/*****************************************************************************/
void xdrawstring(drawable,x,y,s,length)
     Drawable drawable;
     int x,y;
     char s[];
     int length;
{

      XDrawString(display,drawable,gc,x,y,s,length); 

}

/* For Canvas exposures.  This is ugly; we should be using a widget that
   allows us to define the redisplay routine. */
void CanvasRedisplay( wid, event, region )
Widget wid;
XEvent *event;
Region region;
{
int newX;

newX = (view_time - left_time) / interval;

if((newX < 0) || (newX > pixmapwidth))
    printf("View is out of range \nx = %d  left = %d view = %d\n",newX,left_time,view_time);

else
    {
    XCopyArea(display,canvas_pixmap,w,gc,newX,0,CANVAS_WIDTH-X_OFFSET,
	      canvas_height,X_OFFSET+1,0);
    
    }
}

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/CompositeP.h>
SetCanvasExposure()
{
CompositeRec *cr = (CompositeRec *)canvas;
cr->core.widget_class->core_class.expose = CanvasRedisplay;
}

