/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cdc/RCS/cdc_cstub.c,v $
 *
 *
 *  MODULE NAME:    cdc_cstub.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */

/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include "SPHINX-types.h"
#include "cdc.h"
#include "cdc_db.h"

static KTEXT_ST rpkt_st;
KTEXT rpkt = &rpkt_st;      /* response packet from CDC */

int read_login_cstub(fullname, flag, logininfo, len_p, cdc_server, debugflag)
char    *fullname, flag, *logininfo;
int     *len_p;
char    *cdc_server;
int     debugflag;
{
  static KTEXT_ST pkt_st;
  KTEXT pkt = &pkt_st;      /* response packet from CDC */
  int   len, status;
  char  *cp;

  if ((build_login_req_apdu(pkt, flag, fullname, NULL, 0, debugflag)) < 0) {
    return(CDC_BUILD_REQ_ERROR);
  }

  if (debugflag) {
    printf("request_pkt (len is %d) is :\n", pkt->length);
    cdc_hexdump(pkt->dat, pkt->length);
    printf("send pkt to %s's domain\n  cdc hosts are ", fullname);
  }

  if (send_to_cdc(pkt, rpkt, fullname, cdc_server) != ASUCCESS) {
    return(CDC_UNAVAILABLE);
  }

  status = check_login_res_apdu(rpkt->dat, rpkt->length, logininfo, &len, debugflag);
  if (debugflag) {
    printf("status returned is %d, logininfo (len is %d) is :\n", status, len);
    cdc_hexdump(logininfo, len);
  }
  *len_p = len;
  return(status);
}

int read_certif_cstub(pkt, fullname, resolvefrom, crossnames, certifpath, cdc_server, debugflag)
KTEXT   pkt;
char    *fullname, *resolvefrom;
CrossNameList  *crossnames;
struct type_SPHINX_CertPath **certifpath;
char    *cdc_server;
int     debugflag;
{
  int   status, i;
  char *cp;

  if ((build_certif_req_apdu(pkt, NULL, 0, resolvefrom, fullname, crossnames, debugflag)) < 0) {
    return(CDC_BUILD_REQ_ERROR);
  }

  if (debugflag) {
    printf("about to send packet to cdc_server '%s'\n", cdc_server);
    printf("try to read certif path for '%s'\n", fullname);
    for (i=0; i<pkt->length; i++) {
      if ( (i != 0) && (i % 16) == 0) printf("\n");
      printf(" %2x", pkt->dat[i]);
    }
    printf("\n");
  }

  if (send_to_cdc(pkt, rpkt, fullname, cdc_server) != ASUCCESS) {
    return(CDC_UNAVAILABLE);
  }

  status = check_certif_res_apdu(rpkt->dat, rpkt->length, certifpath, debugflag);
  if (debugflag) {
    printf("check_certif_res_apdu returns - %d ; rpkt.length is %d\n", status, rpkt->length);
    for (i=0; i< rpkt->length; i++) {
      if ((i != 0) && (i % 16) == 0) printf("\n");
      printf(" %2x", rpkt->dat[i]);
    }
    printf("\n");
  }
  return(status);
}

int read_tacertif_cstub(pkt,fullname, level, flag, ta_index, certifpath, cdc_server, debugflag)
char    *fullname;
int     level;
char    flag;
int     *ta_index;
struct type_SPHINX_CertPath **certifpath;
char    *cdc_server;
int debugflag;
{
  int   status, index;
  char *cp, i;

  index = *ta_index;

  if ((i = build_tacertif_req_apdu(pkt, flag, index, fullname, debugflag)) < 0)
    return(CDC_BUILD_REQ_ERROR);

  if (send_to_cdc(pkt, rpkt, fullname, cdc_server) != ASUCCESS)
    return(CDC_UNAVAILABLE);

  status = check_tacertif_res_apdu(rpkt->dat, rpkt->length, &index, certifpath, debugflag);

  if (debugflag) {
    printf("check_tacertif_res_apdu returns - %d\n", status);
    printf("new ta_index is %d\n", index);
  }
  *ta_index = index;
  return(status);
}

cdc_hexdump(p, l)
char *p;
int l;
{
  int i;

  for (i=0; i<l; i++)  {
    if ((i>0) && (i%16 == 0))  printf("\n");
    printf(" %02x", (unsigned char ) p[i]);
  }
  printf("\n");
}
