/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cdb_gdbm/RCS/add_princ.c,v $
 *
 *
 *  MODULE NAME:    add_princ.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include "cdc.h"
#include "cdc_db.h"
#include "BigNum.h"
#include "BigRSA.h"

int add_princ(p_name, ca_name, admin_flag)
char *p_name, *ca_name;
char admin_flag;
{
  char           relativename[FULLNAME_SZ], name_ava[ANAME_SZ];
  char           ca_ava[ANAME_SZ];
  char           uuid[UID_SZ];
  char           keybuf[PRIVATE_KEY_SIZE], pubkey[PUBLIC_KEY_SIZE];
  char           certif[CERTIF_SZ], hashkey[8];
  int            uidlen, keylen, certiflen, pubkeylen;
  char           flag;


  keylen =  0;
  bzero(keybuf, sizeof(keybuf));
  if ((read_key(p_name, 0, name_ava, uuid, &uidlen, hashkey, keybuf, &keylen))<0)
    return(-1);
  if ((read_key(ca_name, 1, ca_ava, uuid, &uidlen, hashkey, pubkey, &pubkeylen)) < 0)
    return(-1);

  strcpy(relativename, ca_ava);
  strcat(relativename, "/");
  strcat(relativename, name_ava);

  if (cdb_add_entry(relativename, ENC_PRIVKEY_ATTRIB, keybuf, keylen) < 0)
    return(-1);

  certiflen = 0;
  bzero(certif, CERTIF_SZ);
  if ((read_certif(p_name, ca_name, certif, &certiflen))<0)
    return(-1);
  if (cdb_add_entry(relativename, TA_CERTIF_ATTRIB, certif, certiflen) < 0)
    return(-1);

  certiflen = 0;
  bzero(certif, CERTIF_SZ);
  if ((read_certif(ca_name, p_name, certif, &certiflen))<0)
    return(-1);
  if (cdb_add_entry(relativename, CERTIF_ATTRIB, certif, certiflen) < 0)
    return(-1);

  if (admin_flag)  flag = '2'; else flag = '0';
  if (cdb_add_entry(relativename, FLAG_ATTRIB, &flag, 1) < 0)
    return(-1);

  return (0);
}

int replace_princ(p_name, ca_name, admin_flag, index)
char *p_name, *ca_name;
char admin_flag;
int  index;
{
  char           relativename[FULLNAME_SZ], name_ava[ANAME_SZ];
  char           ca_ava[ANAME_SZ];
  char           uuid[UID_SZ];
  char           keybuf[PRIVATE_KEY_SIZE], pubkey[PUBLIC_KEY_SIZE];
  char           certif[CERTIF_SZ], hashkey[8];
  int            uidlen, keylen, certiflen, pubkeylen;
  char           flag;

  keylen =  0;
  bzero(keybuf, sizeof(keybuf));
  if ((read_key(p_name, 0, name_ava, uuid, &uidlen, hashkey, keybuf, &keylen))<0)
    return(-1);
  if ((read_key(ca_name, 1, ca_ava, uuid, &uidlen, hashkey, pubkey, &pubkeylen)) < 0)
    return(-1);

  strcpy(relativename, ca_ava);
  strcat(relativename, "/");
  strcat(relativename, name_ava);

  if (cdb_add_entry(relativename, ENC_PRIVKEY_ATTRIB, keybuf, keylen) < 0)
    return(-1);

  certiflen = 0;
  bzero(certif, CERTIF_SZ);
  if ((read_certif(p_name, ca_name, certif, &certiflen))<0)
    return(-1);
  if (cdb_replace_entry(relativename, TA_CERTIF_ATTRIB, certif, certiflen, index) < 0)
    return(-1);

  certiflen = 0;
  bzero(certif, CERTIF_SZ);
  if ((read_certif(ca_name, p_name, certif, &certiflen))<0)
    return(-1);
  if (cdb_replace_entry(relativename, CERTIF_ATTRIB, certif, certiflen, index) < 0)
    return(-1);

  if (admin_flag)  flag = '2'; else flag = '0';
  if (cdb_add_entry(relativename, FLAG_ATTRIB, &flag, 1) < 0)
    return(-1);

  return (0);
}
