/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/stash_cred.c,v $
 *
 *
 *  MODULE NAME:    stash_cred.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <pwd.h>
#include "cdc.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "spxapi_defs.h"

extern char *rindex();

int Sphinx_stash_cred(cred_handle)
SPXCredentials *cred_handle;
{
  struct passwd    *pwd;
  ClaimantCred     *claimant_cred;
  TrustedCred      *ta_claimant_cred, empty_claimant_cred;
  char             *time_string, *cp, actual_filename[80];
  int              statuscode = SPX_S_SUCCESS;

  claimant_cred = cred_handle->clm_handle;
  ta_claimant_cred = cred_handle->ta_handle;

  pwd = getpwuid(geteuid());
  strcpy(claimant_cred->name, pwd->pw_name);

  bzero(actual_filename, sizeof(actual_filename));
  strcpy(actual_filename, TKT_ROOT);
  strcat(actual_filename, "_");
  strcat(actual_filename, claimant_cred->name);
  strcat(actual_filename, cred_handle->credential_file);

  if ((cp = rindex(cred_handle->credential_file, '_')) != NULL)
    time_string = cp+1;

  if (spx_in_tkt(claimant_cred->name, claimant_cred->name, time_string) != ASUCCESS) {
    statuscode = SPX_S_CANT_ESTAB_DELEGATED_CLAIM_CRED;
    goto done;
  }
  if (spx_tf_init(actual_filename, W_TKT_FIL) != ASUCCESS) {
    statuscode = SPX_S_CANT_ESTAB_DELEGATED_CLAIM_CRED;
    goto done;
  }

  spx_tf_save_cred(claimant_cred);
  if (claimant_cred->deleg_flag) spx_tf_save_ta(ta_claimant_cred);
  else {
    empty_claimant_cred.count = 0;
    empty_claimant_cred.head = NULL;
    spx_tf_save_ta(&empty_claimant_cred);
  }

 done:
  spx_tf_close();
  if (cred_handle->credential_file != NULL) {
    setenv("SPHINX_CLAIMANT_FILE",actual_filename, 1);
  }
  return(statuscode);
}
