
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#ifndef CDC_DB_DEFS
#define CDC_DB_DEFS

/*  DBM_FILE should be /sphinx/cdb really  */

#define	DBM_FILE		"/var/sphinx/dbase/CDB"

/* this also defines the number of queue headers */

#define CDC_DB_HASH_MODULO 64

#define CDC_DBL_SHARED          0
#define CDC_DBL_EXCLUSIVE       1

#define CDC_DBL_BLOCKING        0
#define CDC_DBL_NONBLOCKING     1

#define CDB_ERROR               -1
#define CDB_SUCCESS              1
#define CDB_UNKNOWN_KEY          2

#define ENC_PRIVKEY_ATTRIB      1     /*  E  */
#define CERTIF_ATTRIB           2     /*  C  */
#define TA_CERTIF_ATTRIB        3     /*  T  */
#define FLAG_ATTRIB             4     /*  F  */

#define         MAX_CDB_DATUM_SZ        928
#define         MAX_CDB_KEY_SZ          96

typedef struct {
    int  num;
    char names[4][FULLNAME_SZ];
} CrossNameList;

typedef struct {
    int  num;
    char data[3][CERTIF_SZ];
    int  sz[3];
} CertificateList;

typedef struct {
    char data[CERTIF_SZ];
} Certificate;

#endif /* CDC_DB_DEFS */
