/*
 * $Source: /mit/kerberos/src/kuser/RCS/kinit.c,v $
 * $Author: jtkohl $ 
 *
 * Copyright 1987, 1988 by the Massachusetts Institute of Technology. 
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>. 
 *
 * Routine to initialize user to Kerberos.  Prompts optionally for
 * user, instance and realm.  Authenticates user and gets a ticket
 * for the Kerberos ticket-granting service for future use. 
 *
 * Options are: 
 *
 *   -i[instance]
 *   -r[realm]
 *   -v[erbose]
 *   -l[ifetime]
 */

#ifndef	lint
static char rcsid_kinit_c[] =
"$Header: kinit.c,v 4.11 89/01/23 09:34:49 jtkohl Exp $";
#endif	lint

#include <mit-copyright.h>
#include <stdio.h>
#include <pwd.h>
#include <krb.h>

#ifdef	PC
#define	LEN	64		/* just guessing */
#endif	PC

#ifdef	BSD42
#include <strings.h>
#include <sys/param.h>
#if 	defined(ultrix) || defined(sun)
#define LEN	64
#else
#define	LEN	MAXHOSTNAMELEN
#endif	/* defined(ultrix) || defined(sun) */
#endif	/* BSD42 */

#define	LIFE	96	/* lifetime of ticket in 5-minute units */

char   *progname;

#ifdef SUPPORT_PUBKEY

/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */

#include "gssapi_defs.h"
#endif

main(argc, argv)
    char   *argv[];
{
    char    aname[ANAME_SZ];
    char    inst[INST_SZ];
    char    realm[REALM_SZ];
    char    buf[LEN];
    char   *username = NULL;
    int     iflag, rflag, vflag, lflag, pflag, lifetime, k_errno;
    register char *cp;
    register i;
#ifdef SUPPORT_PUBKEY
    /*
     *  GSS API support
     */
    int     using_pubkey=0, major_status, mech_status;
    gss_name_t       desired_name;
    gss_cred_id_t    cred_handle;
    gss_OID_set      actual_mechs;
    int              time_req, time_rec;
#endif

    *inst = *realm = '\0';
    iflag = rflag = vflag = lflag = pflag = 0;
    lifetime = LIFE;
    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;

#ifdef SUPPORT_PUBKEY
    desired_name = NULL;
    time_req = 5;
    major_status = gss_acquire_cred(&mech_status,
				    desired_name,
				    time_req,
				    GSS_C_NULL_OID_SET,
				    GSS_C_INIT,
				    &cred_handle,
				    &actual_mechs,
				    &time_rec);


    if (major_status == GSS_S_COMPLETE)
      using_pubkey = 1;
#endif
    while (--argc) {
	if ((*++argv)[0] != '-') {
	    if (username)
		usage();
	    username = *argv;
	    continue;
	}
	for (i = 1; (*argv)[i] != '\0'; i++)
	    switch ((*argv)[i]) {
	    case 'p':		/* Kerberos v4 (force) */
		++pflag;
		continue;
	    case 'i':		/* Instance */
		++iflag;
		continue;
	    case 'r':		/* Realm */
		++rflag;
		continue;
	    case 'v':		/* Verbose */
		++vflag;
		continue;
	    case 'l':
		++lflag;
		continue;
	    default:
		usage();
		exit(1);
	    }
    }


    if (username &&
	(k_errno = kname_parse(aname, inst, realm, username))
	!= KSUCCESS) {
	fprintf(stderr, "%s: %s\n", progname, krb_err_txt[k_errno]);
	iflag = rflag = 1;
	username = NULL;
    }
    if (k_gethostname(buf, LEN)) {
	fprintf(stderr, "%s: k_gethostname failed\n", progname);
	exit(1);
    }
    printf("MIT Project Athena (%s)\n", buf);
#ifdef SUPPORT_PUBKEY
    /*
     *  If we are not able to acquire Kerberos v4 credentials using
     *  public key authenticaiton, then we need to prompt for the
     *  user's name.
     */
    if (pflag)  using_pubkey = 0;
    if (using_pubkey == 1) {
      printf("Acquiring Kerberos V4 credentials using public key ... ");
      goto check_options;
    }
#endif
    if (username) {
	printf("Kerberos Initialization for \"%s", aname);
	if (*inst)
	    printf(".%s", inst);
	if (*realm)
	    printf("@%s", realm);
	printf("\"\n");
    } else {
	printf("Kerberos Initialization\n");
	printf("Kerberos name: ");
	gets(aname);
	if (!*aname)
	    exit(0);
	if (!k_isname(aname)) {
	    fprintf(stderr, "%s: bad Kerberos name format\n",
		    progname);
	    exit(1);
	}
    }
#ifdef SUPPORT_PUBKEY
check_options:
#endif
    /* optional instance */
    if (iflag) {
	printf("Kerberos instance: ");
	gets(inst);
	if (!k_isinst(inst)) {
	    fprintf(stderr, "%s: bad Kerberos instance format\n",
		    progname);
	    exit(1);
	}
    }
    if (rflag) {
	printf("Kerberos realm: ");
	gets(realm);
	if (!k_isrealm(realm)) {
	    fprintf(stderr, "%s: bad Kerberos realm format\n",
		    progname);
	    exit(1);
	}
    }
    if (lflag) {
	 printf("Kerberos ticket lifetime (minutes): ");
	 gets(buf);
	 lifetime = atoi(buf);
	 if (lifetime < 5)
	      lifetime = 1;
	 else
	      lifetime /= 5;
	 /* This should be changed if the maximum ticket lifetime */
	 /* changes */
	 if (lifetime > 255)
	      lifetime = 255;
    }
    if (!*realm && krb_get_lrealm(realm, 1)) {
	fprintf(stderr, "%s: krb_get_lrealm failed\n", progname);
	exit(1);
    }
#ifdef SUPPORT_PUBKEY
    /*
     *  Since we are using public key authetication to acquire Kerberos
     *  credentials, we don't need to know the user's kerberos identity.
     *  We learn this from the KDC.
     *
     *  By setting the user's name and instance to NULL, the kerberos
     *  library will include an authentication token in KDC_REQ message.
     */
    if (using_pubkey == 1) {
        *aname = NULL;
	*inst = NULL;
    }
#endif
    k_errno = krb_get_pw_in_tkt(aname, inst, realm, "krbtgt", realm,
				lifetime, 0);
#ifdef SUPPORT_PUBKEY
    if (using_pubkey)
      if (!k_errno) printf("success\n");
#endif
    if (vflag) {
	printf("Kerberos realm %s:\n", realm);
	printf("%s\n", krb_err_txt[k_errno]);
    } else if (k_errno) {
	fprintf(stderr, "%s: %s\n", progname, krb_err_txt[k_errno]);
	exit(1);
    }
}

usage()
{
    fprintf(stderr, "Usage: %s [-pirvl] [name]\n", progname);
    fprintf(stderr, "      \t-p    prompt password to acquire kerb credentials\n");
    exit(1);
}
