/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "hull.h"

matrix *
new_matrix(rows, cols)
int rows, cols;
/* return new matrix */
{
	matrix *p;
	int i;
	
	p = (matrix *) gimmy(sizeof(matrix) + (rows-1)*sizeof(long *));
	for (i=0; i<rows; ++i)
		p->v[i] = new_vector(cols);
	p->rows = rows;
	p->cols = cols;
	return p;
}

void
free_matrix(p)
matrix *p;
/* dispose of storage for matrix p */
{
	int rows, i;
	
	rows = p->rows;
	for (i=0; i<rows; ++i)
		free_vector(p->v[i]);
	ungimmy(p);
}

matrix *
copy_matrix(p)
matrix *p;
/* return copy of p */
{
	int i, rows;
	matrix *q;
	
	rows = p->rows;
	q = new_matrix(rows, p->cols);
	for (i=0; i<rows; ++i) {
		free_vector(q->v[i]);
		q->v[i] = copy_vector(p->v[i]);
	}
	return q;
}

matrix *
trans_matrix(p)
matrix *p;
/* return transpose of p */
{	
	int i, j, rows, cols;
	matrix *q;
	
	rows = p->rows;
	cols = p->cols;
	q = new_matrix(cols, rows);
	for (i=0; i<rows; ++i) 
		for (j=0; j<cols; ++j)
			q->v[j]->v[i] = p->v[i]->v[j];
	return q;
}

void
pr_matrix(p)
matrix *p;
/* print matrix p */
{
	int j, rows;
	
	rows = p->rows;
	for (j=0; j<rows; ++j)
		pr_vector(p->v[j]);
}

long
det1_matrix(p, q, row)
matrix *p;
vector *q;
int row;
/* this routine used for recursion by det_matrix */
{
	int len, i, sign;
	long sum, det;
	
	sum = 0;
	len = q->len;
	if (row == len) return 1;
	sign = 1; 
	for (i=0; i<len; ++i) {
		if (q->v[i] == 0) {
			if (p->v[row]->v[i] != 0) {
				q->v[i] = 1;
				det = det1_matrix(p,q,row+1);
				sum += sign * p->v[row]->v[i] * det;
				q->v[i] = 0;
			}
			sign = -sign;
		}
	}
	return sum;
} 

long
det_matrix(p)
matrix *p;
/* compute determinant of square matrix p */
{
	vector *q;
	
	ERROR_IF(p->rows != p->cols, "det_matrix");
	q = new_vector(p->rows);
	return det1_matrix(p,q,0);
}

vector *
mat_times_vec(p,q)
matrix *p;
vector *q;
/* return p times q */
{
	int i, rows, cols;
	vector *r;
	
	rows = p->rows;
	cols = p->cols;
	ERROR_IF(cols != q->len, "mat_times_vec");
	r = new_vector(rows);
	for (i=0; i<rows; ++i)
		r->v[i] = dot_prod(p->v[i], q);
	return r;
}

matrix *
mat_times_tmat(p,q)
matrix *p, *q;
/* return p * (q transpose) */
{
	int i, j, rows, cols, lim;
	matrix *r;
	
	rows = p->rows;
	cols = q->rows;
	lim = p->cols;
	ERROR_IF(lim != q->cols, "mat_times_tmat");
	r = new_matrix(rows, cols);
	for (i=0; i<rows; ++i)
		for (j=0; j<cols; ++j)
			r->v[i]->v[j] = dot_prod(p->v[i], q->v[j]);
	return r;
}

matrix *
adjoin_row(p, q)
matrix *p;
vector *q;
/* return p with copy of q as final row */
{
	int i, rows;
	matrix *r;
	
	rows = p->rows;
	ERROR_IF(p->cols != q->len, "adjoin_row");
	r = (matrix *) gimmy(sizeof(matrix) + rows*sizeof(long *));
	for (i=0; i<rows; ++i)
		r->v[i] = p->v[i];
	r->v[rows] = copy_vector(q);
	r->rows = rows+1;
	r->cols = p->cols;
	ungimmy(p);
	return r;
}
