 /*
  * Khoros: $Id: run_answer.c,v 1.4 1992/03/20 22:41:05 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_answer.c,v 1.4 1992/03/20 22:41:05 dkhoros Exp $";
#endif

 /*
  * $Log: run_answer.c,v $
 * Revision 1.4  1992/03/20  22:41:05  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism2.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: run_answer.c
   >>>>              
   >>>>   description: These routines drive the answerfile
   >>>>			 input and output
   >>>>                
   >>>>      routines:
   >>>>			run_answer
   >>>>			run_answer_file
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  MODULE NAME: run_answer
*
*
*      PURPOSE: Drives the Answer File subform --
*               Called after the user clicks on an action
*               button on one of the "Ans File" subform's panes.
*
*	INPUT:  form - pointer to the form tree
*		output_info - pointer to the Answer File Pane information structure
*
*       OUTPUT: none
*
*    CALLED BY: main
*
*    WRITTEN BY: Tom Sauer & John M. Salas
*
*
*************************************************************/


run_answer(form, answer_info, master, xprism2_args)

xvf_form	*form;
Master_answer	*answer_info;
Master		*master;
xprism2_struct	**xprism2_args;

{
	 /*
	  * get the form information structure indicating
	  * selections & and input provided by the user
	  */
	_xvf_get_answer(form, answer_info);
	            
	if (answer_info->ans_file_selected)
	   run_answer_file(form, answer_info->ans_file, master, xprism2_args);

}  /* end run_answer */



/************************************************************
*
*  MODULE NAME: run_answer_file
*
*
*      PURPOSE: Drives the Files pane of the Answer File subform --
*               Called after the user clicks on "OUTPUT ANSWER FILE",
*		"INPUT ANSWER FILE",
*		creates the specified output file under the filename given,
*		reads in a specified answer file.
*
*	INPUT:  form - pointer to the form tree
*		output_info - pointer to the Output Pane information structure
*
*       OUTPUT: none
*
*    CALLED BY: main
*
*    WRITTEN BY: Tom Sauer & John M. Salas
*
*
*************************************************************/

run_answer_file(form, file_info, master, xprism2_args)

xvf_form *form;
answer_ans_file *file_info;
Master *master;
xprism2_struct **xprism2_args;

{
	FILE *fp, *fopen();
	char 	temp[512], *filestring, *filename, *vfullpath(), *mesg;
	int	fd_ansr, mono_display;
	XObject	*tmp_list;
	xprism2_struct *args;

	_xvf_get_ans_file(form, file_info);

	if (file_info->out_answer_file_selected)
	{
	   if (gwin == NULL)
           {
                mesg =
	xvf_strcpy("Cannot output anything-- no graphics workspace present!\n");
                xvf_error_wait(mesg, "run_answer_file", NULL);
                free(mesg);
                return;
           }

	   if (file_info->out_answer_file == NULL)
	   {
		mesg = xvf_strcpy("\nPlease specify the name of the Answer \
file on the 'Filename' parameter for Output Answer File\n");
            	xvf_error_wait(mesg, "run_answer_file", NULL);
            	free(mesg);
            	return;
           }
	   filestring = vfullpath(file_info->out_answer_file, 
                                  global_outdir, NULL);
    
	   if ((fp = fopen(filestring,"w+")) == NULL)
	   {  
		(void) sprintf(temp, "%s: Can not open answer file %s\n",
			      program, filestring);
		xvf_error_wait(temp, "run_answer_file", NULL);
	   }
	   else
	   {
	   	make_answer_file(fp, master);
	   }

    	   sprintf(temp,"The answer file '%s' has been created.\n", filestring);
           xvf_error_wait(temp, "run_answer_file", NULL);

	   free(filestring);
	}
	else if (file_info->in_answer_file_selected)
	{
	   if (file_info->in_answer_file == NULL)
	   {
	    	mesg = xvf_strcpy("\nPlease specify the name of the Answer \
file on the 'Filename' parameter for Input Answer File\n");
		 xvf_error_wait(mesg, "run_answer_files", NULL);
		 free(mesg);
		 return;
	   }

	   filestring = vfullpath(file_info->in_answer_file, 
                                      global_indir, NULL);

	   if ((fd_ansr = open(filestring, O_RDONLY, 0666)) == -1)
	   {       /* an error trying to open answer file */
		(void) sprintf(temp, "%s: Can not open answer file %s\n",
			      program, filestring);
		xvf_error_wait(temp, "run_answer_file", NULL);
	   }
	   else
	   {
/*
   Major kludge to be able to load multiple answer files.
*/
		init_afile_args(fd_ansr);

		if (*xprism2_args != NULL)
		{
		    free(*xprism2_args);
		}

		args = (xprism2_struct *) calloc((unsigned) 1,
				          (unsigned)sizeof(xprism2_struct));

		if (gwin != NULL)
		{
		    freegwin();
		}

		init_xprism2(FALSE, fd_ansr, args);

		set_gwin_attr_2D(args);

		if ( args->plots_specified )
		{
		    start_cmd_plot_2D(args);
		    update_tics(form, master->options->tics);
		}

		if (gwin != NULL)
		{
		    if (args->annotation_in_file != NULL)
		    {
			filename = vfullpath(args->annotation_in_file,
					     global_indir, NULL);
			if (tmp_list = read_overlays(canvas, filename))
				obj_list = tmp_list;

			free(filename);
		    }
		}

/*
 *  if on monochrome display, begin with a default of linemarker
 */

		if ( XDisplayPlanes(display, screen) > 1)
		    mono_display = false;
		else
		    mono_display = true;

		if (mono_display == true)
		{

/*
 *  change default type to linemarker
 */

		   xvf_change_input(form,
			master->xprism->input_file->change_plot_type_index,
                        xvf_toggleval_chng, "4", 0);

                   master->xprism->input_file->change_plot_type_val =
			PLOT_LINEMARKER;
		   xvf_change_input(form,
			master->xprism->input_function->change_plot_type_index,
			xvf_toggleval_chng, "4", 0);
		   master->xprism->input_function->change_plot_type_val =
			PLOT_LINEMARKER;

		   xvf_change_input(form,
			    master->options->attributes->change_plot_type_index,
			      xvf_toggleval_chng, "4", 0);
		   master->options->attributes->change_plot_type_val =
			PLOT_LINEMARKER;

/*
 *  turn off "Colors" pane
 */

		   xvf_change_input(form, master->options->colors_gb_index,
				    xvf_activation_chng, "0", 0);
		}

		close_afile(fd_ansr);

		*xprism2_args = args;

	   }
	   plot_routine();
	}

	free(filestring);
}

/************************************************************
*
*  MODULE NAME: make_answer_file
*
*
*      PURPOSE: This routine will create an answer file for xprism3.
*
*       INPUT: FILE *fp;
*              Master *master;
*
*       OUTPUT: none
*
*    CALLED BY: main
*
*    WRITTEN BY: Tom Sauer & John M. Salas
*
*    MODIFICATIONS: Mar 4, 1992 changed the output of the option -np
*		    to always output 0 rather than the actual
*		    number of plots.
*
*
*************************************************************/
make_answer_file(fp, master)

FILE *fp;
Master *master;

{

  XPlot    *plotptr;
  char     *title, *xaxis, *yaxis, *zaxis;
  int      axes, grid, auto_scale, legend, box, rescale_relabel, fonts[6],
	   colors[12], numlabels, machtype, clear_labels;
  Coord    scale, minor_tics, disp_label_min, disp_label_max, disp_label_intv,
	   disp_scale_min, disp_scale_max, disp_scale_intv;

  int active, plot_type, data_type, data_format;
  char *filename, *function, *xrange, *legend_str, *func_xmin, dummy[MaxLength],
       *func_xmax, *func_xptnum, *ptr1, *ptr2, *ptr3, func[MaxLength];
  int  marker_type, line_type, plot_color, begin_point, end_point, step_size;
  int  input_type, band, cmplx;

  int number_areas, number_plots, plot_area, plot_number;

  float fdummy;

/*
   PLOT SUBFORM ENVIRONMENT PANE
*/
  if ( master->xprism->environment->input_path != NULL )
  {
    fprintf(fp,"-indir %s\n", master->xprism->environment->input_path);
  }

  if ( master->xprism->environment->output_path != NULL )
  {
    fprintf(fp,"-outdir %s\n", master->xprism->environment->output_path);
  }

/*
   ANNOTATION SUBFORM FILE PANE
*/
  if ( master->xvoverlay->ovfile->ov_input != NULL )
  {
    fprintf(fp,"-anin %s\n", master->xvoverlay->ovfile->ov_input);
  }

  if ( master->xvoverlay->ovfile->ov_output != NULL )
  {
    fprintf(fp,"-anout %s\n", master->xvoverlay->ovfile->ov_output);
  }

/*
   OUTPUT SUBFORM FILES PANE
*/

  if ( master->output->file->expl_filename != NULL )
  {
    fprintf(fp,"-expifile %s\n", master->output->file->expl_filename);
  }

  if ( master->output->file->impl_filename != NULL )
  {
    fprintf(fp,"-impifile %s\n", master->output->file->impl_filename);
  }

  if ( master->output->file->cm_filename != NULL )
  {
    fprintf(fp,"-cmifile %s\n", master->output->file->cm_filename);
  }

  if ( master->output->file->dump_filename != NULL )
  {
    fprintf(fp,"-sdumpfile %s\n", master->output->file->dump_filename);
  }

/*
   OUTPUT SUBFORM POSTSCRIPT PANE
*/

  if ( master->output->postscr->printer != NULL )
  {
    fprintf(fp,"-pslp %s\n", master->output->postscr->printer);
  }

  if ( master->output->postscr->filename != NULL )
  {
    fprintf(fp,"-psfile %s\n", master->output->postscr->filename);
  }

  fprintf(fp,"-psflush %d\n", master->output->postscr->flush);

  fprintf(fp,"-psinvert %d\n", master->output->postscr->invert);

  fprintf(fp,"-pslandscape %d\n", master->output->postscr->landscape);

  fprintf(fp,"-psmono %d\n", master->output->postscr->mono);

  fprintf(fp,"-psw %g\n", master->output->postscr->width);

  fprintf(fp,"-psh %g\n", master->output->postscr->height);

  fprintf(fp,"-psx %g\n", master->output->postscr->x_offset);

  fprintf(fp,"-psy %g\n", master->output->postscr->y_offset);

  fprintf(fp,"-psotype %d\n", master->output->postscr->output_type_val);

/*
   OUTPUT SUBFORM IMAGEN PANE
*/

  if ( master->output->imagen->printer != NULL )
  {
    fprintf(fp,"-imlp %s\n", master->output->imagen->printer);
  }

  if ( master->output->imagen->filename != NULL )
  {
    fprintf(fp,"-imfile %s\n", master->output->imagen->filename);
  }

  fprintf(fp,"-imflush %d\n", master->output->imagen->flush);

  fprintf(fp,"-iminvert %d\n", master->output->imagen->invert);

  fprintf(fp,"-imw %g\n", master->output->imagen->width);

  fprintf(fp,"-imh %g\n", master->output->imagen->height);

  fprintf(fp,"-imx %g\n", master->output->imagen->x_offset);

  fprintf(fp,"-imy %g\n", master->output->imagen->y_offset);

  fprintf(fp,"-imotype %d\n", master->output->imagen->output_type_val);

/*
   OUTPUT SUBFORM HPGL PANE
*/

  if ( master->output->hpgl->printer != NULL )
  {
    fprintf(fp,"-hpgllp %s\n", master->output->hpgl->printer);
  }

  if ( master->output->hpgl->filename != NULL )
  {
    fprintf(fp,"-hpglfile %s\n", master->output->hpgl->filename);
  }

  fprintf(fp,"-hpglflush %d\n", master->output->hpgl->flush);

  fprintf(fp,"-hpgllandscape %d\n", master->output->hpgl->landscape);

  fprintf(fp,"-hpglw %g\n", master->output->hpgl->width);

  fprintf(fp,"-hpglh %g\n", master->output->hpgl->height);

  fprintf(fp,"-hpglx %g\n", master->output->hpgl->x_offset);

  fprintf(fp,"-hpgly %g\n", master->output->hpgl->y_offset);

/*
   OUTPUT SUBFORM LN03 PANE
*/

  if ( master->output->ln03->printer != NULL )
  {
    fprintf(fp,"-ln03lp %s\n", master->output->ln03->printer);
  }

  if ( master->output->ln03->filename != NULL )
  {
    fprintf(fp,"-ln03file %s\n", master->output->ln03->filename);
  }

  fprintf(fp,"-ln03invert %d\n", master->output->ln03->invert);

/*
   Until the rain stop failing on the earth below and the galaxies stop
   moving through teh universe, this is the kludge for multiple areas.
*/
  number_areas = 1;

  for ( plot_area = 1 ; plot_area <= number_areas ; plot_area++ )
  {

    inquire_gwin_attr(plot_area, &title, &xaxis, &yaxis, &zaxis, fonts, colors,
			 &clear_labels, &grid, &box, &legend, &axes, &numlabels,
			 &auto_scale, &rescale_relabel, &scale, &minor_tics,
			 &disp_label_min, &disp_label_max, &disp_label_intv,
			 &disp_scale_min, &disp_scale_max, &disp_scale_intv,
			 &fdummy, &fdummy, &fdummy, &fdummy);

	/* fonts */

    fprintf(fp,"-tf%d %d\n", plot_area, fonts[TITLE]);
    fprintf(fp,"-xalf%d %d\n", plot_area, fonts[XAXIS]);
    fprintf(fp,"-yalf%d %d\n", plot_area, fonts[YAXIS]);
    fprintf(fp,"-lf%d %d\n", plot_area, fonts[LEGEND]);
    fprintf(fp,"-numf%d %d\n", plot_area, fonts[NUMBERS]);

	/* labels */

    if ( title != NULL )
    {
      fprintf(fp,"-title%d %s\n", plot_area, title);
      free(title);
      title = NULL;
    }

    if ( xaxis != NULL )
    {
      fprintf(fp,"-xaxis%d %s\n", plot_area, xaxis);
      free(xaxis);
      xaxis = NULL;
    }

    if ( yaxis != NULL )
    {
      fprintf(fp,"-yaxis%d %s\n", plot_area, yaxis);
      free(yaxis);
      yaxis = NULL;
    }

    free(zaxis);
    zaxis = NULL;

	/* colors for labels, axes, grid, etc */

    fprintf(fp,"-tc%d %d\n", plot_area, colors[TITLE_COLOR]);
    fprintf(fp,"-xalc%d %d\n", plot_area, colors[XTITLE_COLOR]);
    fprintf(fp,"-yalc%d %d\n", plot_area, colors[YTITLE_COLOR]);
    fprintf(fp,"-xac%d %d\n", plot_area, colors[XAXIS_COLOR]);
    fprintf(fp,"-yac%d %d\n", plot_area, colors[YAXIS_COLOR]);
    fprintf(fp,"-nxac%d %d\n", plot_area, colors[XNUMS_COLOR]);
    fprintf(fp,"-nyac%d %d\n", plot_area, colors[YNUMS_COLOR]);
    fprintf(fp,"-gc%d %d\n", plot_area, colors[GRID_COLOR]);
    fprintf(fp,"-lc%d %d\n", plot_area, colors[LEGEND_COLOR]);

    fprintf(fp,"-box%d %d\n", plot_area, box);

    fprintf(fp,"-numlabels%d %d\n", plot_area, numlabels);

    fprintf(fp,"-rsrl%d %d\n", plot_area, rescale_relabel);

    fprintf(fp,"-clrls%d %d\n", plot_area, clear_labels);

    fprintf(fp,"-axes%d %d\n", plot_area, axes);

    fprintf(fp,"-legend%d %d\n", plot_area, legend);

    fprintf(fp,"-grid%d %d\n", plot_area, grid);

    fprintf(fp,"-autoscale%d %d\n", plot_area, auto_scale);

/* all axes scale code is commented out until it can be reworked
    fprintf(fp,"-xscale%d %d\n", plot_area, scale.x);
    fprintf(fp,"-yscale%d %d\n", plot_area, scale.y);
*/

    fprintf(fp,"-xtics%d %g\n", plot_area, minor_tics.x);
    fprintf(fp,"-ytics%d %g\n", plot_area, minor_tics.y);

    fprintf(fp,"-xlmin%d %g\n", plot_area, disp_label_min.x);
    fprintf(fp,"-ylmin%d %g\n", plot_area, disp_label_min.y);

    fprintf(fp,"-xlmax%d %g\n", plot_area, disp_label_max.x);
    fprintf(fp,"-ylmax%d %g\n", plot_area, disp_label_max.y);

    fprintf(fp,"-xlint%d %g\n", plot_area, disp_label_intv.x);
    fprintf(fp,"-ylint%d %g\n", plot_area, disp_label_intv.y);

    fprintf(fp,"-xsmin%d %g\n", plot_area, disp_scale_min.x);
    fprintf(fp,"-ysmin%d %g\n", plot_area, disp_scale_min.y);

    fprintf(fp,"-xsmax%d %g\n", plot_area, disp_scale_max.x);
    fprintf(fp,"-ysmax%d %g\n", plot_area, disp_scale_max.y);

    fprintf(fp,"-xsint%d %g\n", plot_area, disp_scale_intv.x);
    fprintf(fp,"-ysint%d %g\n", plot_area, disp_scale_intv.y);

    inquire_gwin_plots(plot_area, &number_plots);

     /*
      * Hard code the number of plots to be 0. In init_xprism2()
      * if the number of plots is zero and we are using an answer file
      * then other plots on the command line and in Cantata can be
      * specified. init_xprism2() was changed for the special
      * case of when the -np1 option is set to 0. This fixes one
      * bug and creates who know how many more!!!
      */

/*
    fprintf(fp,"-np%d %d\n", plot_area, number_plots);
*/


    fprintf(fp,"-np%d %d\n", plot_area, 0);

    /* note: fix by Danielle => previous code
       made false assumption that plots were numbered incrementally */

    plot_number = 1;
    plotptr = gwin->plist;
    while (plotptr != NULL)
    {
      inquire_plot_2D(plotptr->id, plot_area, &active, &plot_type, &data_type,
		      &data_format, &filename, &function, &xrange,
		      &legend_str, &marker_type, &line_type, &plot_color, 
		      &begin_point, &end_point, &step_size, &machtype,
		      &band, &cmplx, &input_type);

      if ( filename != NULL )
      {
        fprintf(fp,"-i%d%d %s\n", plot_area, plot_number, filename);
	free(filename);
	filename = NULL;

        if ( data_type == VFF_TYP_FLOAT )
        {
          fprintf(fp,"-dt%d%d %d\n", plot_area, plot_number, MAX_DATA_TYPE);
        }
        else if ( data_type ==  VFF_TYP_4_BYTE )
        {
        fprintf(fp,"-dt%d%d %d\n", plot_area, plot_number, (MAX_DATA_TYPE - 1));
        }
        else
        {
          fprintf(fp,"-dt%d%d %d\n", plot_area, plot_number, data_type);
        }

        if ( data_format != NO_FORMAT )
        {
          if ( data_format == Y_ONLY )
          {
            fprintf(fp,"-df%d%d %d\n", plot_area, plot_number, MAX_DATA_FORMAT);
          }
          else
          {
            fprintf(fp,"-df%d%d %d\n", plot_area, plot_number, XY_PAIRS);
          }
        }
	if (input_type == XVIFF_IMPL || input_type == XVIFF_EXP)
	{
	   if (band != -1)
		fprintf(fp,"-band%d%d %d\n", plot_area, plot_number, band);
	   if (cmplx > 0)
		fprintf(fp,"-cmplx%d%d %d\n", plot_area, plot_number, cmplx);
	}
      }

      if ( function != NULL )
      {
	sscanf(function, " %[^=]%*[ =\t\n]%[^\n]", dummy, func);
        fprintf(fp,"-func%d%d %s\n", plot_area, plot_number, func);
	free(function);
	function = NULL;

	if ( xrange != NULL )
	{
	  func_xmin = strchr(xrange,'(');
	  func_xmin++;
	  ptr1 = strchr(func_xmin,',');

	  func_xmax = strchr(xrange,',');
	  func_xmax++;
	  ptr2 = strchr(func_xmax,',');

	  func_xptnum = strrchr(xrange,',');
	  func_xptnum++;
	  ptr3 = strchr(func_xptnum,')');

	  *ptr1 = '\0';
	  *ptr2 = '\0';
	  *ptr3 = '\0';

          fprintf(fp,"-fxmin%d%d %s\n", plot_area, plot_number, func_xmin);
          fprintf(fp,"-fxmax%d%d %s\n", plot_area, plot_number, func_xmax);
          fprintf(fp,"-fxpts%d%d %s\n", plot_area, plot_number, func_xptnum);
	}
	free(xrange);
	xrange = NULL;
      }

      fprintf(fp,"-xb%d%d %d\n", plot_area, plot_number, begin_point);
      fprintf(fp,"-xe%d%d %d\n", plot_area, plot_number, end_point);
      fprintf(fp,"-xs%d%d %d\n", plot_area, plot_number, step_size);
      fprintf(fp,"-pt%d%d %d\n", plot_area, plot_number, plot_type - PLOT_2D);

      if ( machtype != -1)
      {
	fprintf(fp,"-mach%d%d %d\n", plot_area, plot_number, machtype);
      }

      fprintf(fp,"-mt%d%d %d\n", plot_area, plot_number, marker_type);
      fprintf(fp,"-lt%d%d %d\n", plot_area, plot_number, line_type);
      fprintf(fp,"-pc%d%d %d\n", plot_area, plot_number, plot_color);

      if ( legend_str != NULL )
      {
      fprintf(fp,"-legendstr%d%d %s\n", plot_area, plot_number, legend_str);
	free(legend_str);
	legend_str = NULL;
      }

      fprintf(fp,"-active%d%d %d\n", plot_area, plot_number, active);
      plotptr = plotptr->next;
      plot_number++;
    }
  }
  fclose(fp);
}

