 /*
  * Khoros: $Id: vsvpsf.c,v 1.2 1992/03/20 23:09:40 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vsvpsf.c,v 1.2 1992/03/20 23:09:40 dkhoros Exp $";
#endif

 /*
  * $Log: vsvpsf.c,v $
 * Revision 1.2  1992/03/20  23:09:40  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vsvpsf.c
 >>>>
 >>>>      Program Name: vsvpsf
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform restoration  of  general  space-variant  pointspread
 >>>>	functions
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Jan  6 14:21:35 1992
 >>>>
 >>>>          Routines: main- the main program for vsvpsf
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vsvpsf.h"


/****************************************************************
 *
 * Routine Name:  main program for vsvpsf
 *
 *       Input:  
 *        -i  input (degraded) image 
 *        -psf  quantized SVPSF 
 *        -t  filter threshold   (value >= 0.0)
 *        -o  output (restored) image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img, *psf, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        img = readimage(vsvpsf->i_file);
        if (img == NULL) exit(1);                    

        psf = readimage(vsvpsf->psf_file);
        if (psf == NULL) exit(1);                    

        if (img->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vsvpsf: Input image must be a FLOAT image\n");
            exit(1);
          }
        if ((psf->data_storage_type != VFF_TYP_4_BYTE) ||
            (psf->map_storage_type != VFF_MAPTYP_FLOAT))
          {
            fprintf(stderr,"vsvpsf: PSF image must be an INT image with FLOAT maps\n");
            exit(1);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvsvpsf(img,psf,vsvpsf->t_float) )
        {
            (void) fprintf(stderr, "lvsvpsf Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vsvpsf->o_file, img);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vsvpsf 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vsvpsf :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform restoration  of  general  space-variant  pointspread\n");
	fprintf(stderr, "\tfunctions\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input (degraded) image  (infile)\n");
	fprintf(stderr,"\t-psf  quantized SVPSF  (infile)\n");
	fprintf(stderr,"\t-t  filter threshold  (float, >= 0.0)\n");
	fprintf(stderr,"\t-o  output (restored) image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vsvpsf\n");
	fprintf(stderr, "\t[-U] Gives the usage for vsvpsf\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vsvpsf.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vsvpsf.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vsvpsf
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input (degraded) image \n        {infile}: "; 
char	*psf_pstr = 
	"\nEnter: (psf) quantized SVPSF \n        {infile}: "; 
char	*t_pstr = 
	"\nEnter: (t) filter threshold \n        {float, >= 0.0}: "; 
char	*o_pstr = 
	"\nEnter: (o) output (restored) image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vsvpsf", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vsvpsf.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vsvpsf: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vsvpsf.ans");
		}

	     }

	}

	/*
	 * allocate the vsvpsf structure
	 */
	vsvpsf = (vsvpsf_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vsvpsf_struct));

	/*
	 * get required arguments for vsvpsf
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vsvpsf->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vsvpsf->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsvpsf->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vsvpsf->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vsvpsf->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsvpsf->psf_flag = vget_infile(fid, prompt_flag,
			"-psf", psf_pstr, &(vsvpsf->psf_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsvpsf->psf_flag))
		{
		    fprintf(stderr, "\t\tpsf is required, please re-enter: \n");
		    vsvpsf->psf_flag = vget_infile(fid, prompt_flag,
		    "-psf", psf_pstr, &(vsvpsf->psf_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-psf' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsvpsf->t_flag = vget_float(fid, prompt_flag,
			"-t", t_pstr, &(vsvpsf->t_float),
			0.000000, 1.000000, 1.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsvpsf->t_flag))
		{
		    fprintf(stderr, "\t\tt is required, please re-enter: \n");
		    vsvpsf->t_flag = vget_float(fid, prompt_flag,
		    "-t", t_pstr, &(vsvpsf->t_float),
		    0.000000, 1.000000, 1.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-t' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsvpsf->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vsvpsf->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsvpsf->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vsvpsf->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vsvpsf->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



