 /*
  * Khoros: $Id: vect2row.h,v 1.1 1991/05/10 15:47:09 khoros Exp $
  */

 /*
  * $Log: vect2row.h,v $
 * Revision 1.1  1991/05/10  15:47:09  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vect2row.h
 >>>>            Author: Donna Koechner
 >>>> Date Last Updated: Sun Apr 28 22:35:11 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vect2row_h_
#define _vect2row_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vect2row Argument Structure
*
****************************************************************/

typedef struct _vect2row  {

/*
 *  input data file (Required infile)
 */
char	*i_file;	/* input data file FILENAME */
int	 i_flag;	/* input data file FLAG */

/*
 *  output (vector) file (Required outfile)
 */
char	*o_file;	/* output (vector) file FILENAME */
int	 o_flag;	/* output (vector) file FLAG */

/*
 *  Extract only one vector (1 = yes, 0 = no) (Optional logical)
 */
int	 s_logic;	/* Extract only one vector (1 = yes, 0 = no) LOGIC */
int	 s_flag;  	/* Extract only one vector (1 = yes, 0 = no) FLAG */

/*
 *  horizontal (x) offset of voxel (Optional integer)
 */
int	 x_int; 	/* horizontal (x) offset of voxel INT */
int	 x_flag;	/* horizontal (x) offset of voxel FLAG */

/*
 *  vertical (y) offset of voxel (Optional integer)
 */
int	 y_int; 	/* vertical (y) offset of voxel INT */
int	 y_flag;	/* vertical (y) offset of voxel FLAG */

}  vect2row_struct;

vect2row_struct *vect2row;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE(image) \
        image = readimage(vect2row->i_file);  \
        if (image == NULL) {  \
        (void) fprintf(stderr, "vect2row: Can not read input image \n");  \
        exit(1);  /* Quit if bad image */ \
        } 

#define CHECKTYPE(program, image) \
    if( propertype(program,image,VFF_TYP_BIT, FALSE) ) { \
          fprintf(stderr,"%s: cannot operate on VFF_TYP_BIT data.",program); \
          exit(1); \
    }

#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);  \
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
