 /*
  * Khoros: $Id: lvbpf.c,v 1.2 1992/03/20 23:04:27 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvbpf.c,v 1.2 1992/03/20 23:04:27 dkhoros Exp $";
#endif

 /*
  * $Log: lvbpf.c,v $
 * Revision 1.2  1992/03/20  23:04:27  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvbpf.c
 >>>>
 >>>>      Program Name: vbpf
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:27:46 1991 
 >>>>
 >>>>          Routines: lvbpf - the library call for vbpf
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvbpf - library call for vbpf
*
* Purpose:
*    
*    Perform Band-pass filtering on an  image  in  the  frequency
*    domain.
*    
*    
* Input:
*    
*         1. image -- xvimage structure, input and output image ,br 2.
*         order -- band-pass filter order;
*                     default value is 1
*         3. fcut -- cutoff frequency radius;
*                    default value is 0.5
*         4. width -- Band width in pixels of the filter.
*    
*    
* Output:
*    
*         1. image -- holds the result of the
*                     high-pass filtered image.
*    
*         image is used for both the input xvimage structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*         lvbpf always returns 1.
*    
*    
*
* Written By: Tom Sauer
*    
*    Scott Wilson - 27-Jan-91 - Removed FFT data type processing
*    
*    
****************************************************************/


/* -library_def */
int
lvbpf(image,order,fcut,width)
struct xvimage *image;
int  order, width;
float fcut;
/* -library_def_end */

/* -library_code */
{
    int   i,j,nr,nc;
    int   cutoff,p;
    float *f,e,bbpf();

    nc = image->row_size;
    nr = image->col_size;

/* need to find out what this does and add a check for width */
    if (nr > nc) cutoff = fcut*nr*0.5;
    else cutoff = fcut*nc*0.5;

    p = 0;
    f= (float *)(image->imagedata);

    for (i=0; i<nr; i++)             /* Rows of FFT */
      {
        /* Perform filter operation (multiplication) over the line */
        for (j=0; j<nc; j++)
          {
            e = bbpf(i,j,cutoff,nr,order,width);
            f[p] = f[p]*e; p++; /* Real part */
            f[p] = f[p]*e; p++; /* Imaginary part */
          }
      }
      return(1);
}

float
bbpf(i,j,cutoff,n,order,width)
int i,j,cutoff,n,order,width;
/* Butterworth bandpass filter */
  {
    int x,y;
    double f, dem;

    x = (n/2)-j;
    y = (n/2)-i;
    dem = ( ( (sqrt((double)(x*x+y*y))) * (sqrt((double)(x*x+y*y))) ) - (cutoff * cutoff) );
    if ( dem != 0.0 )
    {
       f = ( sqrt((double)(x*x+y*y)) * width ) / dem;
       f = pow((double)f,(double)(2*order));
       f = 1.0 / (1.0 + f);
       f = -1 * (f - 1.0);
    }
    else f = 0.0;
    return((float)f);
  }
/* -library_code_end */
