 /*
  * Khoros: $Id: lmcovar.c,v 1.1 1991/05/10 15:44:26 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lmcovar.c,v 1.1 1991/05/10 15:44:26 khoros Exp $";
#endif

 /*
  * $Log: lmcovar.c,v $
 * Revision 1.1  1991/05/10  15:44:26  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lmcovar.c
 >>>>
 >>>>      Program Name: mcovar
 >>>>
 >>>> Date Last Updated: Fri Mar 29 18:43:55 1991 
 >>>>
 >>>>          Routines: lmcovar - the library call for mcovar
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lmcovar - library call for mcovar
*
* Purpose:
*    
*    Compute the covariance matrix of a vector image
*    
*    
* Input:
*    
*    image          pointer to xvimage structure to be processed
*    
*    
* Output:
*    
*    covimage       points to the result image.  The data storage type
*                   is FLOAT and the image (actually matrix) is square
*                   symmetric and positive definate.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    
****************************************************************/


/* -library_def */
int
lmcovar(image,covimage)
struct xvimage *image,**covimage;
/* -library_def_end */

/* -library_code */
  {
    /* Compute the covariance matrix for the set of vector pixels in
       the input image */
    int i,j,k,l;
    float *f,*mean,*work;
    float *data;
    struct xvimage *img,*createimage();
    char *malloc();
    unsigned char *c;
    int nc,nr,ndb,vcount;

    nc = image->number_of_cols;
    nr = image->number_of_rows;
    ndb = image->num_data_bands;
    vcount = nr*nc;

    img = createimage(ndb, ndb, VFF_TYP_FLOAT, 1, 1,
                      "Covariance image", 0, 0,
                      VFF_MS_NONE, VFF_MAPTYP_NONE,
                      VFF_LOC_IMPLICIT, 0);
    if (img == NULL)
      {
         fprintf(stderr,"Unable to allocate covariance image\n");
         *covimage = NULL;
         return(0);
      }

    /* Get space for the mean vector */
    mean = (float *)malloc(ndb*sizeof(float));
    if (mean == NULL)
      {
        fprintf(stderr,"Unable to allocate space for mean vector\n");
        freeimage(img);
        return(0);
      }

    /* Find the mean vector */
    bzero(mean,ndb*sizeof(float));
    if (image->data_storage_type == VFF_TYP_FLOAT)
      {
        for (i=0; i<vcount; i++)
          {
            data = (float *)(image->imagedata)+i;
            for (j=0; j<ndb; j++) mean[j] += *(data+j*vcount);
          }
        for (j=0; j<ndb; j++) mean[j] /= vcount;
      }
    else if (image->data_storage_type == VFF_TYP_1_BYTE)
      {
        for (i=0; i<vcount; i++)
          {
            c = (unsigned char *)(image->imagedata)+i;
            for (j=0; j<ndb; j++) mean[j] += *(c+j*vcount);
          }
        for (j=0; j<ndb; j++) mean[j] /= vcount;
      }
    else
      {
        fprintf(stderr,"lmcovar: Unsupported data type\n");
        free(mean);
        freeimage(img);
        return(0);
      }
    
    /* Get space for the work vector */
    work = (float *)malloc(ndb*sizeof(float));
    if (work == NULL)
      {
        fprintf(stderr,"Unable to allocate space for work vector\n");
        free(mean);
        freeimage(img);
        return(0);
      }

    /* Process each vector in turn, forming the sample covariance
       matrix and adding it to the covariance matrix estimate */
    f = (float *)(img->imagedata);
    bzero(f,ndb*ndb*sizeof(float));
    if (image->data_storage_type == VFF_TYP_FLOAT)
      {
        for (i=0; i<vcount; i++)
          {
            data = (float *)(image->imagedata)+i;
            for (j=0; j<ndb; j++) work[j] = *(data+j*vcount)-mean[j];
            for (j=0; j<ndb; j++)
              for(k=j; k<ndb; k++)
                {
                  l = j*ndb+k;
                  f[l] += work[j]*work[k];
                  f[k*ndb+j] = f[l];
                }
          }
        for (i=0; i<ndb*ndb; i++) f[i] /= vcount;
      }
    else if (image->data_storage_type == VFF_TYP_1_BYTE)
      {
        for (i=0; i<vcount; i++)
          {
            c = (unsigned char *)(image->imagedata)+i;
            for (j=0; j<ndb; j++) work[j] = *(c+j*vcount)-mean[j];
            for (j=0; j<ndb; j++)
              for(k=j; k<ndb; k++)
                {
                  l = j*ndb+k;
                  f[l] += work[j]*work[k];
                  f[k*ndb+j] = f[l];
                }
          }
        for (i=0; i<ndb*ndb; i++) f[i] /= vcount;
      }

    *covimage = img;
    free(work);
    free(mean);
    return(1);
  }
/* -library_code_end */
