 /*
  * Khoros: $Id: readascii.c,v 1.1 1991/05/10 15:41:35 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: readascii.c,v 1.1 1991/05/10 15:41:35 khoros Exp $";
#endif

 /*
  * $Log: readascii.c,v $
 * Revision 1.1  1991/05/10  15:41:35  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	readascii.c
# 
# AUTHORS:
#		Mark Young & Tom Sauer
#
# 
# DATE:		11/10/89
# 
# DESCRIPTION:
#	ASCII utilities, for reading and writing ascii data.
#
# 
# MODIFICATIONS:
# 
*/

#include "unmcopyright.h"	 
#include "vinclude.h"	 	

/**************************************************************
*
* MODULE NAME: 		read_ascii
*
*     PURPOSE:		Reads an ascii file passing back a
*			floating point array of values.
*
*       INPUT:		
*
*	file		FILE pointing to the stream in which the ascii
*			data is located
*
*      OUTPUT:
*
*	points		returns the number of points found in the ascii
*			file
*	data		returns the data points found in the ascii file
*
* CALLED FROM: main
*
* ROUTINES CALLED:
*
**************************************************************/

#define ALLOCSIZE 10000


float	*read_ascii(file, points)

FILE 	*file;
int 	*points;
{
	int	i, c, num, size;
	float	*data, *temp;
	char	dummy[512], character;

	/* allocate memory space for data */
	size = ALLOCSIZE; 
	data = (float *) malloc ((unsigned int) size * sizeof(float));

	/* read data and determine number of points */
	i = 0;
	while (!feof(file))
	{
	   if (i == size)
	   {
	      size += ALLOCSIZE;
	      if (!(data = (float *) realloc(data,(unsigned) size*sizeof(float))))
	      {
	         (void) fprintf(stderr,"Not enough memory!  Tried to malloc %d \
floats.", size);
	         return (NULL);
	      }
	   }

	   if ((num = fscanf (file, "%f", &data[i])) == 0)
	   {
	      /*
	       *  Check to see if we encountered a comment.  We do this
	       *  by seeing if the comment begins with a "%" "*" "#" or
	       *  "!".  If no comment was found then print an error message
	       *  and return NULL, otherwise read the rest of line.
	       */
	      if (fscanf(file, "%[#]", &character) == 1)
	      {
		 /*
		  *  Read to the rest of the comment which should be until
		  *  the end of the line.
		  */
		 do
		 {
	            (void) fgets(dummy, 512, file);
		 } while (VStrlen(dummy) >= 512);
	      }
	      else if (fscanf(file, "%[/]%[*]", &character, &character) == 2)
	      {
		 /*
		  *  Read to the end of the comment.
		  */
		 for (;;)
		 {
		    while ((c = fgetc(file)) != '*' && c != EOF && c != '\0')
				;

		    if (c == '*')
		    {
		       if ((c = fgetc(file)) == '/')
			  break;
		    }
		    else
		       break;
		 }
	      }
	      else
	      {
	         (void) fprintf(stderr, "\nError In Input! Non-numerical value \
or comment\nfield found.  (Comments are indicated by either a %% ! * #)\n\n");

	         (void) fgets(dummy, 512, file);
	         (void) fprintf(stderr, "Offending line: %s\n", dummy);

	         free(data);
	         return(NULL);
	      }
	   }
	   else if (num == 1)
	   {
	      i++;
	   }
	}
	*points = i;

	/*
	 *  Finished reading the data points from the file.  Try to malloc
	 *  the final array with the exact number of points.  If we don't
	 *  have enough size then we return data, otherwise we copy data
	 *  to temp, free data, and return temp as the points in the file.
	 */
	if (!(temp = (float *) malloc((unsigned int) i * sizeof(float))))
	{
	   return(data);
	}
	else
	{
	   bcopy(data, temp, i * sizeof(float));
	   free(data);
	   return(temp);
	}
}
