 /*
  * Khoros: $Id: createwid.c,v 1.2 1991/07/15 06:01:17 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: createwid.c,v 1.2 1991/07/15 06:01:17 khoros Exp $";
#endif

 /*
  * $Log: createwid.c,v $
 * Revision 1.2  1991/07/15  06:01:17  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"
#include "trans_tables.h"

#define  MaxNumSize 50

static int toggle_count;
int last_subform_index;
int last_guide_index;

char temp[512];


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>             file name: createwid.c                    <<<<
   >>>>                                                       <<<<
   >>>>		       Widget Creation Routines               <<<<
   >>>>                                                       <<<<
   >>>>       These routines create each basic element        <<<<
   >>>>       that is used to make up the graphical user      <<<<
   >>>>       interface.                                      <<<<
   >>>>                                                       <<<<
   >>>>	     		xvf_create_backplane()		      <<<<
   >>>>	     		xvf_create_master_submenu()	      <<<<
   >>>>	     		xvf_create_subform_sel()	      <<<<
   >>>>	     		xvf_create_psuedosubform_sel()	      <<<<
   >>>>	     		xvf_create_guide_sel()	  	      <<<<
   >>>>	     		xvf_create_quit_master_sel()  	      <<<<
   >>>>	     		xvf_create_quit_subform_sel()  	      <<<<
   >>>>	     		xvf_create_quit_pane_sel()  	      <<<<
   >>>>	     		xvf_create_workspace_sel()  	      <<<<
   >>>>	     		xvf_create_master_action_sel() 	      <<<<
   >>>>	     		xvf_create_subform_action_sel()       <<<<
   >>>>	     		xvf_create_help_sel()       	      <<<<
   >>>>	     		xvf_create_input_sel()       	      <<<<
   >>>>	     		xvf_create_output_sel()       	      <<<<
   >>>>	     		xvf_create_int_sel()       	      <<<<
   >>>>	     		xvf_create_float_sel()       	      <<<<
   >>>>	     		xvf_create_logic_sel()       	      <<<<
   >>>>	     		xvf_create_string_sel()       	      <<<<
   >>>>	     		xvf_create_cycle_sel()       	      <<<<
   >>>>	     		xvf_create_routine_sel()       	      <<<<
   >>>>	     		xvf_create_toggle_sel()       	      <<<<
   >>>>	     		xvf_create_blank_sel()       	      <<<<
   >>>>	     		xvf_create_pane_action_sel()   	      <<<<
   >>>>	     		xvf_form_create_glyph_sel()   	      <<<<
   >>>>	     		xvf_subform_create_glyph_sel()        <<<<
   >>>>	     		xvf_create_form_glyph()               <<<<
   >>>>	     		xvf_create_subform_glyph()            <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */




/************************************************************
*  Routine Name:  xvf_create_backplane
*
*      Purpose:   Creates a backplane widget to contain other widgets
*		  on a form
*
*        Input:   line_info - structure containing information
*			      gained from the knowledge base.
*		  parent    - parent of widget being created.
*
*
*       Output:	  label_widget - pointer to the widget which holds
*				 the backplane label (may be used for
*				 changing label later on)
*
*		  returns: form_back - widget which serves as backplane
*			               for the form.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -M @ gs ps 'l' v */
Widget  xvf_create_backplane(label_widget, line_info,parent,
			back_name,label_name, mapped)

Widget    *label_widget;
Line_Info *line_info;
Widget    parent;
char      **back_name, **label_name;
int       mapped;
{
   Widget back;
   char   widget_name[512];
   int    label_x, label_y, label_width, label_height;
   int    back_x, back_y, back_width, back_height;

   if (line_info->typeflag == StartPane)
      sprintf(widget_name,"%s_back",line_info->variable);
   else
      sprintf(widget_name,"%s", "back");
   *back_name = xvf_strcpy(widget_name);
   
   /* create back widget */
   back_x = line_info->x*xvf_font_width;
   back_y = line_info->y*(xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info->width*xvf_font_width;
   back_height = line_info->height*xvf_font_height;
   back = xvf_create_formback_widget(parent, back_x, back_y, 
				     back_width, back_height, *back_name, 
				     mapped);
   
   *label_name = xvf_strcpy("label");

   /* put in label */
   if (line_info->title != NULL)
   {
      label_x     = line_info->xpos*xvf_font_width;
      label_y     = line_info->ypos*xvf_font_height;
      label_width = xvf_strlen(line_info->title)*xvf_font_width;
      label_height= xvf_font_height;
      *label_widget= xvf_create_label_widget(back, label_x, label_y,
   					label_width, label_height, 
					line_info->title, xvf_font, 
					*label_name, false, true);
   }
   if (line_info->activate == false)
      XtSetSensitive(back, false);

   return(back);
}



/************************************************************
*
*  Routine Name:  xvf_create_master_submenu
*
*      Purpose:   Creates the submenu button widget and submenu for
*		  the master submenu widget.  This is used to bring
*		  up a submenu in which subforms buttons, master actions,
*		  and help button are stored.
*
*        Input:   form      - pointer to the xvf_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created 
*			      (backplane of the master).
*
*       Output:	  guide_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Mark Young & Danielle Argiro
*
*
*************************************************************/

/* -D @ % gs ps 'l' */
Widget xvf_create_master_submenu(form, database, index, parent)

xvf_form *form;
char     *database[];
int      *index;
Widget   parent;
{
   Widget submenu, xvf_create_submenu_widget();
   Line_Info line_info;
   char widget_name[512];
   char *label;
   int button_width, button_height, button_x, button_y;

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_startsubmenu_line(database[*index],&line_info)))
      return(NULL);

   sprintf(widget_name,"%s_submenu", line_info.variable);

   if (line_info.title != NULL)
        label = xvf_strcpy(line_info.title);  
   else
	label = xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;

   submenu = xvf_create_submenu_widget(parent, button_x, button_y, button_width,
			button_height, label, xvf_font, widget_name);

   if (line_info.activate == false)
      XtSetSensitive(submenu, false);

   return(submenu);
}



/************************************************************
*
*  Routine Name:  xvf_create_subform_sel
*
*      Purpose:   Creates the subform button widget for the master form
*		  which will bring up a particular subform.
*
*        Input:   form      - pointer to the xvf_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created 
*			      (backplane of the master).
*
*       Output:	  guide_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -d @ % gs ps 'l' */
Widget xvf_create_subform_sel(form, subform, database, index, parent, 
		button_name, submenu)

xvf_form *form;
xvf_sub_form *subform;
char     *database[];
int      *index, submenu;
Widget   parent;
char     **button_name;
{
   Widget subform_button;
   Callback_Data *cb_data;
   Line_Info line_info, tmp_line_info;
   char widget_name[512];
   char *label;
   int	flag; 
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, NULL, NULL, false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_subformbutton_line(database[*index],&line_info)))
      return(NULL);

   flag = xvf_get_line_type(database[last_subform_index]);
   while (flag != StartSubForm)
   {
	last_subform_index++;
        flag = xvf_get_line_type(database[last_subform_index]);
   }
   xvf_clear_line_info(&tmp_line_info);
   if (!(xvf_parse_startsubform_line(database[last_subform_index],
				     &tmp_line_info)))
   {
	fprintf(stderr, "xvf_create_subform_sel:\n");
	fprintf(stderr, "   ERROR: cannot find [-M] line that matches\n");
        fprintf(stderr, "          the following [-d] line:\n");
	fprintf(stderr, "'%s'\n", database[*index]);
   }
   sprintf(widget_name,"%s_subform_button", tmp_line_info.variable);
   *button_name = xvf_strcpy(widget_name);
   last_subform_index++;


   if (line_info.title != NULL)
        label = xvf_strcpy(line_info.title);  
   else
	label = xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;

   if (submenu)
      subform_button = xvf_create_submenu_button_widget(parent, button_x,
				button_y, button_width, button_height, label,
				xvf_font, *button_name);
   else
      subform_button = xvf_create_button_widget(parent, button_x, button_y,
				button_width, button_height, label, xvf_font,
				*button_name);

   XtAddCallback(subform_button,XtNcallback,xvf_subform_cb,cb_data);


   if (line_info.activate == false)
      XtSetSensitive(subform_button, false);

   return(subform_button);
}



/************************************************************
*
*  Routine Name:  xvf_create_psuedosubform_sel
*
*      Purpose:   Creates the psuedo subform button widget for 
*		  the master form which will => allow the application
*		  to bring up a particular subform.
*
*        Input:   form      - pointer to the xvf_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created 
*			      (backplane of the master).
*
*       Output:	  guide_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Danielle Argiro
*
*
*************************************************************/

/* -d @ % gs ps 'l' */
Widget xvf_create_psuedosubform_sel(form, subform, database, index, parent, 
		button_name, submenu)

xvf_form *form;
xvf_sub_form *subform;
char     *database[];
int      *index, submenu;
Widget   parent;
char     **button_name;
{
   Widget psuedo_subform_button; 
   Callback_Data *cb_data;
   Line_Info line_info, tmp_line_info;
   char widget_name[512];
   char *label;
   int	flag; 
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, NULL, NULL, false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_psuedosubform_line(database[*index],&line_info)))
      return(NULL);

   flag = xvf_get_line_type(database[last_subform_index]);
   while (flag != StartSubForm)
   {
	last_subform_index++;
        flag = xvf_get_line_type(database[last_subform_index]);
   }
   xvf_clear_line_info(&tmp_line_info);
   if (!(xvf_parse_startsubform_line(database[last_subform_index],
				     &tmp_line_info)))
   {
	fprintf(stderr, "xvf_create_psuedosubform_sel:\n");
	fprintf(stderr, "   ERROR: cannot find [-M] line that matches\n");
        fprintf(stderr, "          the following [-u] line:\n");
	fprintf(stderr, "'%s'\n", database[*index]);
   }
   sprintf(widget_name,"%s_subform_button", tmp_line_info.variable);
   *button_name = xvf_strcpy(widget_name);
   last_subform_index++;

   if (line_info.title != NULL)
        label = xvf_strcpy(line_info.title);  
   else
	label = xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;

   if (submenu)
      psuedo_subform_button = xvf_create_submenu_button_widget(parent, button_x,
				button_y, button_width, button_height, label,
				xvf_font, *button_name);
   else
      psuedo_subform_button = xvf_create_button_widget(parent, button_x, button_y,
				button_width, button_height, label, xvf_font,
				*button_name);

   XtAddCallback(psuedo_subform_button, XtNcallback,
	 	  xvf_psuedo_subform_cb, cb_data);

   if (line_info.activate == false)
      XtSetSensitive(psuedo_subform_button, false);

   return(psuedo_subform_button);
}



/************************************************************
*
*  Routine Name:  xvf_create_guide_sel
*
*      Purpose:   Creates the guiding button widget for
*		  the guiding section of the form.
*
*        Input:   form      - pointer to the xvf_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*
*       Output:	  guide_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -g @ % gs ps 'l' */
Widget xvf_create_guide_sel(form, subform, guide, database, index, parent,
		button_name)

xvf_form     *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
char     *database[];
int      *index;
Widget   parent;
char     **button_name;
{
   Widget guide_button;
   Callback_Data *cb_data;
   Line_Info line_info, tmp_line_info;
   char  widget_name[512];
   char  *label; 
   int	flag;
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, guide, NULL, false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_guide_line(database[*index],&line_info)))
      return(NULL);

   if (!(flag = xvf_get_line_type(database[last_guide_index]))) 
   {
	fprintf(stderr, "xvf_create_guide_sel:\n");
	fprintf(stderr, "   ERROR: cannot find [-P] line that matches\n");
        fprintf(stderr, "          the following [-g] line:\n");
	fprintf(stderr, "'%s'\n", database[*index]);
	return(NULL);
   }
   while (flag != StartPane)
   {
	last_guide_index++;
        flag = xvf_get_line_type(database[last_guide_index]);
	if (flag == -1)
	{
	    fprintf(stderr, "xvf_create_guide_sel:\n");
            fprintf(stderr, "   ERROR: cannot find [-P] line that matches\n");
            fprintf(stderr, "          the following [-g] line:\n");
            fprintf(stderr, "'%s'\n", database[*index]);
            return(NULL);
	}
   }
   xvf_clear_line_info(&tmp_line_info);
   xvf_parse_startpane_line(database[last_guide_index], &tmp_line_info);

   sprintf(widget_name,"%s_guide_button", tmp_line_info.variable);
   *button_name = xvf_strcpy(widget_name);
   last_guide_index++;

   if (line_info.title != NULL)
        label =xvf_strcpy(line_info.title); 
   else
      label = xvf_strcpy(" ");				

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;
   guide_button = xvf_create_button_widget(parent, button_x, button_y,
					   button_width, button_height,
					   label, xvf_font, *button_name);
   XtAddCallback(guide_button,XtNcallback,xvf_guide_cb,cb_data);


   if (line_info.activate == false)
      XtSetSensitive(guide_button, false);

   return(guide_button);
}



/************************************************************
*
*  Routine Name:  xvf_create_quit_master_sel
*
*      Purpose:   Creates the quit button widget for a master form.
*
*        Input:   form      - pointer to the xvf_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*       Output:	  quit_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -Q gs ps 'l' */
Widget xvf_create_quit_master_sel(form, subform, database, index,parent, 
		num, button_name)

xvf_form *form;
xvf_sub_form *subform;
char     *database[];
int      *index;
Widget   parent;
int      num;
char     **button_name;
{
   Widget quit_button;
   Callback_Data *cb_data;
   Line_Info line_info;
   char widget_name[512];
   char *label;
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, NULL, NULL, false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_quit_line(database[*index],&line_info)))
      return(NULL);

   sprintf(widget_name,"%d_quit_button",num);
   *button_name = xvf_strcpy(widget_name);
   
   if (line_info.title != NULL)
      label = xvf_strcpy(line_info.title);   	
   else
      label=xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;
   quit_button = xvf_create_button_widget(parent, button_x, button_y,
					  button_width, button_height,
					  label, xvf_font, *button_name);
   XtAddCallback(quit_button, XtNcallback, xvf_quit_master_cb, cb_data);

   return(quit_button);
}


/************************************************************
*
*  Routine Name:  xvf_create_quit_subform_sel
*
*      Purpose:   Creates the quit button widget for a subform.
*
*        Input:   form      - pointer to the xvf_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*       Output:	  quit_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -Q gs ps 'l' */
Widget xvf_create_quit_subform_sel(form, subform, guide, database, index,
		parent, num, button_name)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
char     *database[];
int      *index;
Widget   parent;
int	 num;
char     **button_name;
{
   Widget quit_button;
   Callback_Data *cb_data;
   Line_Info line_info;
   char   widget_name[512];
   char   *label;
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, guide, NULL, false, NULL);
   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_quit_line(database[*index],&line_info)))
      return(NULL);
   
   sprintf(widget_name,"%d_quit_button",num);
   *button_name = xvf_strcpy(widget_name);
   
   if (line_info.title != NULL)
         label=xvf_strcpy(line_info.title);
   else
         label=xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;
   quit_button = xvf_create_button_widget(parent, button_x, button_y,
					  button_width, button_height,
					  label, xvf_font, *button_name);

   XtAddCallback(quit_button, XtNcallback, xvf_quit_subform_cb, cb_data);

   return(quit_button);
}





/************************************************************
*
*  Routine Name:  xvf_create_quit_pane_sel
*
*      Purpose:   Creates the quit button widget for a pane.
*
*        Input:   form      - pointer to the xvf_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*       Output:	  quit_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -Q gs ps 'l' */
Widget xvf_create_quit_pane_sel(form, subform, guide, selection, database,
		index, parent, num, button_name)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection;
char     *database[];
int      *index;
Widget   parent;
int	 num;
char     **button_name;
{
   Widget quit_button;
   Callback_Data *cb_data;
   Line_Info line_info;
   char   widget_name[512];
   char   *label;
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, guide, selection, false, NULL);
   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_quit_line(database[*index],&line_info)))
      return(NULL);
   
   sprintf(widget_name,"%d_quit_button",num);
   *button_name = xvf_strcpy(widget_name);
   
   if (line_info.title != NULL)
         label=xvf_strcpy(line_info.title);
   else
         label=xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;
   quit_button = xvf_create_button_widget(parent, button_x, button_y,
					  button_width, button_height,
					  label, xvf_font, *button_name);

   XtAddCallback(quit_button, XtNcallback, xvf_quit_pane_cb, cb_data);

   return(quit_button);
}



/************************************************************
*
*  Routine Name:  xvf_create_workspace_sel
*
*      Purpose:   Creates a workspace selection for a 
*		  master, subform, or pane.
*
*        Input:   database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of workspace widget being created.
*
*       Output:	  workspace - workspace widget for use by application.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Danielle Argiro
*
*
*************************************************************/

/* -Q gs ps 'l' */
Widget xvf_create_workspace_sel(database, index, subform, 
			         guide, selection, parent)
char             *database[];
int              *index;
xvf_sub_form     *subform;
xvf_guide_button *guide;
xvf_selection    *selection;
Widget           parent;
{ 
   Widget         wksp_back, wksp, wksp_label = NULL; 
   Line_Info      line_info;
   char          *wksp_name, temp[MaxLength];
   int            width, height, label_x, label_y, label_width, label_height;
   int            back_x, back_y, back_width, back_height;

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_workspace_line(database[*index],&line_info)))
      return(NULL);
   
   wksp_name = xvf_strcpy(line_info.variable);

   sprintf(temp, "%s_back", line_info.variable);

   /* create workspace back widget */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info.width;
   back_height = line_info.height;
   wksp_back = xvf_create_selback_widget(parent, back_x, back_y, 
					 back_width, back_height, 
					 temp);
   /* 
    * label for workspace widget 
    */
   if (line_info.title != NULL)
   {
       label_x     = line_info.xpos*xvf_font_width;
       label_y     = line_info.ypos*xvf_font_height;
       label_width = xvf_strlen(line_info.title)*xvf_font_width;
       label_height= xvf_font_height;
       wksp_label  = xvf_create_label_widget(wksp_back, label_x, label_y, 
					     label_width, label_height, 
					     line_info.title, xvf_font, 
					     "label", true, false);
   }

   /* 
    * create workspace widget 
    */
   width  = line_info.width;
   height = line_info.height;
   wksp   = xvf_create_wksp_widget(wksp_back, width, height, wksp_name,
				   wksp_label);
   line_info.workspace = wksp;
   xvf_deparse_workspace_line(&line_info, database, *index);

   /*
    *  set label wid of appropriate structure; the workspace could be
    *  on a master, a subform, or a pane.
    */
    if (subform != NULL) subform->label = wksp_label;
    else if (guide != NULL) guide->label = wksp_label;
    else if (selection != NULL) selection->label_widget = wksp_label;

   return(wksp);
}



/************************************************************
*
*  Routine Name:  xvf_create_master_action_sel
*
*      Purpose:   Creates the master action button widget for
*		  the master form.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*       Output:	  master_action_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -m @ % gs ps 'l' */
Widget xvf_create_master_action_sel(form, subform, database, index,parent,
		                     button_name, submenu)

xvf_form *form;
xvf_sub_form *subform;
char     *database[];
int      *index, submenu;
Widget   parent;
char     **button_name;
{
   Widget master_action_button; 
   Callback_Data *cb_data;
   Line_Info line_info;
   char widget_name[512];
   char *label;
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, NULL, NULL, false, NULL);
   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_master_action_line(database[*index],&line_info)))
      return(NULL);

   sprintf(widget_name,"%s_master_action_button",line_info.variable);
   *button_name = xvf_strcpy(widget_name);

   
   if (line_info.title != NULL)
         label=xvf_strcpy(line_info.title);
   else
         label=xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;

   if (submenu)
      master_action_button = xvf_create_submenu_button_widget(parent, button_x,
				button_y, button_width, button_height, label,
				xvf_font, *button_name);
   else
      master_action_button = xvf_create_button_widget(parent, button_x,
			        button_y, button_width, button_height, label,
				xvf_font, *button_name);

   XtAddCallback(master_action_button,XtNcallback, xvf_master_action_cb,
		 cb_data);


   if (line_info.activate == false)
      XtSetSensitive(master_action_button, false);

   return(master_action_button);
}



/************************************************************
*
*  Routine Name:  xvf_create_subform_action_sel
*
*      Purpose:   Creates the subform action button widget for
*		  the guiding section of the form.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*       Output:	  subform_action_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -m @ % gs ps 'l' */
Widget xvf_create_subform_action_sel(form, subform, guide, database, index,
				      parent,button_name)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
char     *database[];
int      *index;
Widget   parent;
char     **button_name;
{
   Widget subform_action_button;
   Callback_Data *cb_data;
   Line_Info line_info;
   char widget_name[512];
   char *label;
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, guide, NULL, false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_subform_action_line(database[*index],&line_info)))
      return(NULL);

   sprintf(widget_name,"%s_subform_action_button",line_info.variable);
   *button_name = xvf_strcpy(widget_name);
   
   if (line_info.title != NULL)
         label=xvf_strcpy(line_info.title);
   else
         label=xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;
   subform_action_button = xvf_create_button_widget(parent, button_x, button_y,
					  button_width, button_height,
					  label, xvf_font, *button_name);

   XtAddCallback(subform_action_button,XtNcallback,xvf_subform_action_cb,
		  cb_data);


   if (line_info.activate == false)
      XtSetSensitive(subform_action_button, false);

   return(subform_action_button);
}


/************************************************************
*
*  Routine Name:  xvf_create_help_sel
*
*      Purpose:   Creates the help button widget for
*		  the guiding section of the subform.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*       Output:	  help_button - widget which serves as button.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -H @ gs ps 'l' 'des' com h */
Widget xvf_create_help_sel(form, subform, guide, selection,
			    database, index,parent, num,button_name,
			    flag, submenu)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection;
char     *database[];
int      *index;
Widget   parent;
int      num;
char     **button_name;
int      flag, submenu;
{
   Widget help_button; 
   Callback_Data *cb_data;
   Line_Info line_info;
   char   widget_name[512];
   char   *label;
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, guide, selection, false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_help_line(database[*index],&line_info)))
      return(NULL);

   sprintf(widget_name,"%d_help_button",num);
   *button_name = xvf_strcpy(widget_name);
   
   if (line_info.title != NULL)
         label=xvf_strcpy(line_info.title);
   else
         label=xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   if (flag == 3)
      button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
   else
      button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/4));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;

   if (submenu)
      help_button = xvf_create_submenu_button_widget(parent, button_x,
				button_y, button_width, button_height, label,
				xvf_font, *button_name);
   else
      help_button = xvf_create_button_widget(parent, button_x, button_y,
				button_width, button_height, label, xvf_font,
				*button_name);

   if (flag == 1)
     XtAddCallback(help_button,XtNcallback,xvf_master_help_button_cb,cb_data);
   else if (flag == 2)
     XtAddCallback(help_button,XtNcallback,xvf_subform_help_button_cb,cb_data);
   else if (flag == 3)
     XtAddCallback(help_button,XtNcallback,xvf_pane_help_button_cb,cb_data);


   if (line_info.activate == false)
      XtSetSensitive(help_button, false);

   return(help_button);
}



/************************************************************
*
*  Routine Name:  xvf_create_input_sel
*
*      Purpose:   Creates a line to get an input selection
*		  in the options pane.
*
*        Input:   subform      - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*       Output:	  input_back - widget which gets input file.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -I @ % * ! gs ps 'def' 'l' 'des' c v 'val' */
Widget xvf_create_input_sel(form, subform, guide, selection, 
			     database, index,parent, doing_toggle,
			     toggle_start)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection; 
char     *database[];
int      *index;
Widget   parent;
int	 doing_toggle;
xvf_selection *toggle_start;
{
   Widget input_back;
   Widget input_label;
   Widget input_opt_button=NULL;
   Widget input_value;
   Callback_Data *cb_data;
   XtTranslations translations; 
   Line_Info line_info;
   char widget_name[512], *label, temp[MaxLength];
   int   label_x, label_y, label_width, label_height;
   int   back_x, back_y, back_width, back_height;
   int   opt_x, opt_y, opt_width, opt_height;
   int   value_width, value_height, x_position, y_position;


 /* 
  * initialize callback data for this input selection 
  */
   cb_data = xvf_init_cb_data(form, subform, guide, selection, 
			 	doing_toggle, toggle_start);

   /* parse the database line (-I) to get geometry info */
   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_input_line(database[*index],&line_info)))
      return(NULL);

   if (doing_toggle == true)
   {
      sprintf(widget_name,"%d_input_back",toggle_count);
      toggle_count++;
   }
   else
   {
      sprintf(widget_name,"%s_input_back",line_info.variable);
   }

 /* 
  *  get the font for this selection, and the max width & height  
  *  of a character drawn in that font
  */
   selection->back_name = xvf_strcpy(widget_name);
   
 /* 
  * create input selection back widget 
  */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info.width * xvf_font_width;
   back_height = line_info.height * xvf_font_height;
   input_back  = xvf_create_selback_widget(parent, back_x, back_y, 
					  back_width, back_height, 
					  selection->back_name);
   x_position = 0;

 /* 
  * create optional button if database line requests it
  */
   if ((line_info.optional == true)||(doing_toggle == true))
   {
      opt_x      = 0;
      opt_y      = line_info.ypos;
      opt_width  = xvf_font_height;
      opt_height = xvf_font_height;
      input_opt_button = xvf_create_optional_button(input_back, opt_x, opt_y,
						    opt_width, opt_height);
      XtAddCallback(input_opt_button,XtNcallback,xvf_input_opt_cb,
		cb_data); 
     
      x_position += opt_width + xvf_font_width;
   }
   selection->opt_widget = input_opt_button;


 /* 
  * put in label 
  */

   if (doing_toggle == false)
   {
      if (line_info.title != NULL) 
      {
	  label= xvf_strcpy(line_info.title);
          label_width = xvf_strlen(line_info.title)*xvf_font_width;
      }
      else 
      {
          label = xvf_strcpy(" ");
	  label_width = xvf_font_width;
      }
      label_x     = x_position + line_info.xpos*xvf_font_width;
      label_y     = line_info.ypos*xvf_font_height;
      label_height= xvf_font_height;
      input_label = xvf_create_psuedo_label_widget(input_back, label_x,
					    label_y, label_width, label_height,
					    label, xvf_font, true);
      XtAddCallback(input_label,XtNcallback,xvf_input_label_cb, cb_data);

      x_position = label_x + label_width + xvf_font_width;
   }
   else
   {
      label_x     = x_position + line_info.xpos*xvf_font_width;
      label_y     = line_info.ypos*xvf_font_height;
      label_width = xvf_strlen(line_info.title)*xvf_font_width;
      label_height= xvf_font_height;
      input_label = xvf_create_label_widget(input_back, label_x, label_y, 
					    label_width, label_height, 
					    line_info.title, xvf_font, "label", 
					    true, false);
      x_position = label_x + label_width + xvf_font_width;
   }
   selection->label_widget = input_label;


/*
 * set the text buffer for the ascii widget  
 */
   if ((line_info.filename == NULL) && 
       (line_info.file_def == NULL) &&
       (line_info.literal == NULL))
      temp[0] = '\0';
   else if (line_info.literal != NULL)
      sprintf(temp, "%s", line_info.literal);
   else if (line_info.filename != NULL)
      sprintf(temp, "%s", line_info.filename);
   else
      sprintf(temp, "%s", line_info.file_def);

   if (doing_toggle == false)
   {
      /* add actual value widget */
      value_width = line_info.width*xvf_font_width - x_position;
      if (value_width <= 0)
	 value_width = 1; 

       if (line_info.live == true)
	  translations = live_infile_trans;
       else
	  translations = search_trans;

       y_position = line_info.ypos*xvf_font_height;
       value_height = (xvf_font_height+2)*line_info.height;
       input_value = xvf_create_ascii_widget(input_back, x_position, y_position,
				    value_width, value_height, temp, xvf_font,
				    false, translations);

      selection->value_widget = input_value;
      if (line_info.live == true)
      {
	    xvf_update_live_sel_list(input_value, cb_data);
	    (void) xvf_create_cr_pixmap_widget(input_back, input_value);
      }

      selection->value_widget = input_value;
   }
   else
      selection->value_widget = NULL;

   selection->opt_widget = input_opt_button;
   selection->opt_selected = line_info.opt_sel;

   if (line_info.activate == false)
      XtSetSensitive(input_back, false);

   return(input_back);
}


/************************************************************
*
*  Routine Name:  xvf_create_output_sel *
*      Purpose:   Creates a line to get an output selection
*		  in the options pane.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -O @ % * ! gs ps 'def' 'l' 'des' c v 'val' */
Widget xvf_create_output_sel(form, subform, guide, selection,
			      database, index,parent, doing_toggle,
			      toggle_start)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection;
char     *database[];
int      *index;
Widget   parent;
xvf_selection *toggle_start;
int      doing_toggle;
{
   Widget output_back;
   Widget output_label;
   Widget output_opt_button=NULL;
   Widget output_value;
   Callback_Data *cb_data;
   Line_Info line_info;
   XtTranslations translations; 
   char widget_name[512], *label, temp[MaxLength];
   int  label_x, label_y, label_width, label_height;
   int  back_x, back_y, back_width, back_height;
   int  opt_x, opt_y, opt_width, opt_height;
   int	value_width, value_height, x_position, y_position;


   cb_data = xvf_init_cb_data(form, subform, guide, selection, 
				doing_toggle, toggle_start);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_output_line(database[*index],&line_info)))
      return(NULL);
   
   if (doing_toggle == true)
   {
      sprintf(widget_name,"%d_output_back",toggle_count);
      toggle_count++;
   }
   else
   {
      sprintf(widget_name,"%s_output_back",line_info.variable);
   }
   selection->back_name = xvf_strcpy(widget_name);
   
   /* create output selection back widget */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info.width * xvf_font_width;
   back_height = line_info.height * xvf_font_height;
   output_back = xvf_create_selback_widget(parent, back_x, back_y, 
					   back_width, back_height, 
					   selection->back_name);
   x_position = 0;

   /* create optional button */
   if ((line_info.optional == true)||(doing_toggle == true))
   {
      opt_x      = 0;
      opt_y      = line_info.ypos;
      opt_width  = xvf_font_height;
      opt_height = xvf_font_height;
      output_opt_button = xvf_create_optional_button(output_back, opt_x, opt_y,
					             opt_width, opt_height);
      XtAddCallback(output_opt_button,XtNcallback,xvf_output_opt_cb,cb_data); 

      x_position += opt_width + xvf_font_width;
   }

   /* put in label */
   if (doing_toggle == false)
   {
      if (line_info.title != NULL) 
      {
	  label= xvf_strcpy(line_info.title);
          label_width = xvf_strlen(line_info.title)*xvf_font_width;
      }
      else 
      {
          label = xvf_strcpy(" ");
	  label_width = xvf_font_width;
      }
      label_x     = x_position + line_info.xpos*xvf_font_width;
      label_y     = line_info.ypos*xvf_font_height;
      label_height= xvf_font_height;
      output_label = xvf_create_psuedo_label_widget(output_back, label_x,
					    label_y, label_width, label_height,
					    label, xvf_font, true);
      XtAddCallback(output_label,XtNcallback,xvf_output_label_cb, cb_data);

      x_position = label_x + label_width + xvf_font_width;
   }
   else
   {
      label_x     = x_position + line_info.xpos*xvf_font_width;
      label_y     = line_info.ypos*xvf_font_height;
      label_width = xvf_strlen(line_info.title)*xvf_font_width;
      label_height= xvf_font_height;
      output_label = xvf_create_label_widget(output_back, label_x, label_y, 
					     label_width, label_height, 
					     line_info.title, xvf_font, "label", 
					     true, false);
      x_position = label_x + label_width + xvf_font_width;
   }
   selection->label_widget = output_label;


/*
 * set the text buffer for the ascii widget  
 */
   if ((line_info.filename == NULL) && 
       (line_info.file_def == NULL) &&
       (line_info.literal == NULL))
      temp[0] = '\0';
   else if (line_info.literal != NULL)
      sprintf(temp, "%s", line_info.literal);
   else if (line_info.filename != NULL)
      sprintf(temp, "%s", line_info.filename);
   else
      sprintf(temp, "%s", line_info.file_def);

   if (doing_toggle == false)
   {
      value_width = line_info.width*xvf_font_width - x_position;
      if (value_width <= 0)
	 value_width = 1;

      if (line_info.live == true)
	 translations = live_outfile_trans;
      else
	 translations = search_trans;

      y_position = line_info.ypos*xvf_font_height;
      value_height = (xvf_font_height+2)*line_info.height;
      output_value = xvf_create_ascii_widget(output_back, x_position,y_position,
				     value_width, value_height, temp, xvf_font,
				     false, translations);

      selection->value_widget = output_value;
      if (line_info.live == true)
      {
	    xvf_update_live_sel_list(output_value, cb_data);
            (void) xvf_create_cr_pixmap_widget(output_back,output_value);
      }

      selection->value_widget = output_value;
   }
   else
      selection->value_widget = NULL;

   
   selection->opt_widget = output_opt_button;
   selection->opt_selected = line_info.opt_sel;
 
   if (line_info.activate == false)
      XtSetSensitive(output_back, false);

   return(output_back);
}



/************************************************************
*
*  Routine Name:  xvf_create_int_sel
*
*      Purpose:   Creates a line to get an integer selection
*		  in the options pane.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -i @ % * ! gs ps L U def 'l' 'des' c v val */
Widget xvf_create_int_sel(form, subform, guide, selection,
			   database, index,parent,doing_toggle,
			   toggle_start)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection; 
char     *database[];
int      *index;
Widget   parent;
int      doing_toggle;
xvf_selection *toggle_start;
{
   Callback_Data *cb_data;
   IntScroll_Data *int_scroll_data;
   Line_Info line_info;
   Widget int_back,  int_label, int_opt_button=NULL;
   Widget int_value, int_scroll=NULL;
   float percent;
   char  temp[MaxLength], widget_name[512], *label;
   XtTranslations translations;
   int  label_x, label_y, label_width, label_height;
   int  back_x, back_y, back_width, back_height;
   int  opt_x, opt_y, opt_width, opt_height;
   int  position, x_position, y_position, no_scroll;
   int  value_width, value_height, scroll_width, scroll_height, int_length;


   cb_data = xvf_init_cb_data(form, subform, guide, selection, 
				doing_toggle, toggle_start);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_int_line(database[*index],&line_info)))
      return(NULL);

   if (doing_toggle == true)
   {
      sprintf(widget_name,"%d_int_back",toggle_count);
      toggle_count++;
   }
   else
   {
      sprintf(widget_name,"%s_int_back",line_info.variable);
   }
   selection->back_name = xvf_strcpy(widget_name);
   
   /* create integer selection back widget */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info.width * xvf_font_width;
   back_height = line_info.height * xvf_font_height;
   int_back    = xvf_create_selback_widget(parent, back_x, back_y, 
					back_width, back_height, 
					selection->back_name);

   x_position = 0;

   /* create optional button */
   if ((line_info.optional == true)||(doing_toggle == true))
   {
      opt_x      = 0;
      opt_y      = line_info.ypos;
      opt_width  = xvf_font_height;
      opt_height = xvf_font_height;
      int_opt_button = xvf_create_optional_button(int_back, opt_x, opt_y,
						  opt_width, opt_height);
      XtAddCallback(int_opt_button,XtNcallback,xvf_int_opt_cb,cb_data);

      x_position += opt_width + xvf_font_width;
   }

   /* put in label */
  
   if (line_info.title != NULL)
   {
          label= xvf_strcpy(line_info.title);
          label_width = xvf_strlen(line_info.title)*xvf_font_width;
   }
   else
   {
          label = xvf_strcpy(" ");
          label_width = xvf_font_width;
   }
   label_x     = x_position + line_info.xpos*xvf_font_width;
   label_y     = line_info.ypos*xvf_font_height;
   label_height= xvf_font_height;
   int_label = xvf_create_label_widget(int_back, label_x, label_y,
				       label_width, label_height, 
				       label, xvf_font, "label",  
				       true, false);
   x_position = label_x + label_width + xvf_font_width;
   selection->label_widget = int_label;

  /*
   * set the text buffer for the ascii widget  
   */
   if (line_info.literal != NULL) 
   {
       selection->buffer = (char *) malloc (sizeof(char) * 
				(xvf_strlen(line_info.literal)+1));
       sprintf(selection->buffer,"%s", line_info.literal);
   }
   else 
   {
       selection->buffer = (char *) malloc (sizeof(char)*MaxNumSize);
       sprintf(selection->buffer,"%d",line_info.int_val);
   }
   
   if (doing_toggle == false)
   {
      /* add actual value widget */
      if  (line_info.upper_int == line_info.lower_int)
         value_width = line_info.width*xvf_font_width - x_position;
      else
      {
          sprintf(temp, "%d", line_info.upper_int);
          int_length = xvf_strlen(temp);
          sprintf(temp, "%d", line_info.lower_int);
          if (xvf_strlen(temp) > int_length) int_length = xvf_strlen(temp);
          int_length += 2;
          value_width = int_length * xvf_font_width;
      }

      if (value_width <= 0)
	 value_width = 1;

      position = x_position + value_width + 5;
      if (line_info.upper_int != line_info.lower_int)
      {
	 scroll_width = line_info.width*xvf_font_width - position;
	 if (scroll_width > 10)
	    no_scroll = false;
	 else
	    no_scroll = true;
      }
      else
	 no_scroll = true;


      if (line_info.live == true && no_scroll == true)
	 translations = live_int_trans;
      else if (no_scroll == false)
	 translations = int_scroll_trans;
      else
	 translations = search_trans;

      y_position = line_info.ypos*xvf_font_height;
      value_height = (xvf_font_height+2)*line_info.height;
      int_value = xvf_create_ascii_widget(int_back, x_position, y_position,
				  value_width, value_height, selection->buffer, 
				  xvf_font, false, translations);

      x_position = position;
      if (no_scroll == false)
      {
         percent = ((float)line_info.int_val - (float)line_info.lower_int)/
                       ((float)(line_info.upper_int - line_info.lower_int));

         y_position = line_info.ypos*xvf_font_height;
         scroll_height = (xvf_font_height+2)*line_info.height;
         int_scroll = xvf_create_scroll_widget(int_back, x_position, y_position,
			  scroll_width, scroll_height, percent, "int_scroll");
	 int_scroll_data = xvf_init_int_scroll_data( form, subform, 
			       guide, selection,
			       line_info.lower_int, line_info.upper_int,
			       line_info.int_def, int_length, scroll_width,
			       int_value, int_scroll);
         XtAddCallback(int_scroll, XtNscrollProc, xvf_int_incr_scroll_cb,
                           (caddr_t) int_scroll_data);
         XtAddCallback(int_scroll, XtNjumpProc, xvf_int_flow_scroll_cb,
                           (caddr_t) int_scroll_data);
         XawScrollbarSetThumb(int_scroll, percent, 1.0);

	 xvf_update_live_int_list(int_value, int_scroll_data);
      }
      if (line_info.live == true)
      {
	 xvf_update_live_sel_list(int_value, cb_data);
	 if (no_scroll)
             (void) xvf_create_cr_pixmap_widget(int_back, int_value);
	 else
             (void) xvf_create_cr_pixmap_widget(int_back, int_scroll);
      }
      selection->value_widget = int_value;
   }
   else
   {
      selection->value_widget = NULL;
   }

   selection->opt_widget = int_opt_button;
   selection->opt_selected = line_info.opt_sel;
   selection->scroll = int_scroll;

   if (line_info.activate == false)
      XtSetSensitive(int_back, false);

   return(int_back);
}


/************************************************************
*
*  Routine Name:  xvf_create_float_sel
*
*      Purpose:   Creates a line to get an floating point 
*		  selection in the options pane.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -f @ % * ! gs ps L U def 'l' 'des' c v val */
Widget xvf_create_float_sel(form, subform, guide, selection,
			     database, index,parent, doing_toggle,
			     toggle_start)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection; 
char     *database[];
int      *index;
Widget   parent;
int      doing_toggle;
xvf_selection *toggle_start;
{
   Callback_Data *cb_data;
   FloatScroll_Data *float_scroll_data;
   Line_Info line_info;
   Widget float_back, float_label, float_opt_button=NULL;
   Widget float_value, float_scroll = NULL;
   int value_width, value_height, scroll_width, scroll_height, signif_digits;
   int float_length, no_scroll;
   float percent;
   char temp[50], scale[50], widget_name[512], buffer[4*MaxLength], *label;
   XtTranslations translations;
   int   label_x, label_y, label_width, label_height;
   int   back_x, back_y, back_width, back_height;
   int   opt_x, opt_y, opt_width, opt_height;
   int   position, x_position, y_position;


   cb_data = xvf_init_cb_data(form, subform, guide, selection, 
				doing_toggle, toggle_start);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_float_line(database[*index],&line_info)))
      return(NULL);

   if (doing_toggle == true)
   {
      sprintf(widget_name,"%d_float_back",toggle_count);
      toggle_count++;
   }
   else
   {
      sprintf(widget_name,"%s_float_back",line_info.variable);
   }
   selection->back_name = xvf_strcpy(widget_name);
   

   /* create float selection back widget */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info.width * xvf_font_width;
   back_height = line_info.height * xvf_font_height;
   float_back  = xvf_create_selback_widget(parent, back_x, back_y, 
					  back_width, back_height, 
					  selection->back_name);
   x_position = 0;

   /* create optional button */
   if ((line_info.optional == true)||(doing_toggle == true))
   {
      opt_x      = 0;
      opt_y      = line_info.ypos;
      opt_width  = xvf_font_height;
      opt_height = xvf_font_height;
      float_opt_button = xvf_create_optional_button(float_back, opt_x, opt_y,
						    opt_width, opt_height);
      XtAddCallback(float_opt_button,XtNcallback,xvf_float_opt_cb,
		cb_data); 
      x_position += opt_width + xvf_font_width;
   }

   /* put in label */
   if (line_info.title != NULL)
   {
      label= xvf_strcpy(line_info.title);
      label_width = xvf_strlen(line_info.title)*xvf_font_width;
   }
   else
   {
      label = xvf_strcpy(" ");
      label_width = xvf_font_width;
   }
   label_x     = x_position + line_info.xpos*xvf_font_width;
   label_y     = line_info.ypos*xvf_font_height;
   label_height= xvf_font_height;
   float_label = xvf_create_label_widget(float_back, label_x, label_y,
					 label_width, label_height, 
				 	 label, xvf_font, "label", 
					 true, false);
   x_position = label_x + label_width + xvf_font_width;
   selection->label_widget = float_label;

  /*
   * set the text buffer for the ascii widget  
   */
   if (line_info.literal != NULL) 
   {
        sprintf(buffer,"%s", line_info.literal);
   }
   else 
   {
       sprintf(buffer,"%g",line_info.float_val);
   }
   
   if (doing_toggle == false)
   {
      /* add actual value widget */
      if  (line_info.upper_float == line_info.lower_float)
         value_width = line_info.width*xvf_font_width - x_position;
      else
      {
          signif_digits = xvf_def_number_sign_digits(line_info.upper_float
                                                    - line_info.lower_float,
						     line_info.literal);
          sprintf(scale, "%%.%df", signif_digits);
          sprintf(temp, scale, line_info.upper_float);
          float_length = xvf_strlen(temp);
          sprintf(temp, scale, line_info.lower_float);
          if (xvf_strlen(temp) > float_length) float_length = xvf_strlen(temp);
          float_length += 2;
          value_width = float_length * xvf_font_width;
	  sprintf(buffer,scale,line_info.float_val);
      }
      if (value_width <= 0)
	 value_width = 1;

      position = x_position + value_width + 5;
      if (line_info.upper_float != line_info.lower_float)
      {
	 scroll_width = line_info.width*xvf_font_width - position;
	 if (scroll_width > 10)
	    no_scroll = false;
	 else
	    no_scroll = true;
      }
      else
	 no_scroll = true;


      if (line_info.live == true && no_scroll == true)
	 translations = live_float_trans;
      else if (no_scroll == false)
	 translations = float_scroll_trans;
      else
	 translations = search_trans;

      y_position = line_info.ypos*xvf_font_height;
      value_height = (xvf_font_height+2)*line_info.height;
      float_value = xvf_create_ascii_widget(float_back, x_position, y_position,
				    value_width, value_height, buffer,
				    xvf_font, false, translations);

      x_position = position;
      if (no_scroll == false)
      {
         percent = (line_info.float_val - line_info.lower_float)/
                       (line_info.upper_float - line_info.lower_float);

         y_position = line_info.ypos*xvf_font_height;
         scroll_height = (xvf_font_height+2)*line_info.height;
         float_scroll = xvf_create_scroll_widget(float_back, x_position, 
			    y_position, scroll_width, scroll_height,
			    percent, "float_scroll");

	 float_scroll_data = xvf_init_float_scroll_data( form, subform, 
			         guide, selection,
				 line_info.lower_float, line_info.upper_float,
				 line_info.float_def, float_length, 
				 scroll_width, float_value,  float_scroll);

         XtAddCallback(float_scroll, XtNscrollProc,
                           xvf_float_incr_scroll_cb,
                           (caddr_t) float_scroll_data);

         XtAddCallback(float_scroll, XtNjumpProc,
                           xvf_float_flow_scroll_cb,
                           (caddr_t) float_scroll_data);
         XawScrollbarSetThumb(float_scroll, percent, 1.0);


	 xvf_update_live_float_list(float_value, float_scroll_data);

      }
      if (line_info.live == true)
      {
	     xvf_update_live_sel_list(float_value, cb_data);
	     if (no_scroll)
                 (void) xvf_create_cr_pixmap_widget(float_back, float_value);
	     else
                 (void) xvf_create_cr_pixmap_widget(float_back, float_scroll);
      }
      selection->value_widget = float_value;
   }
   else 
      selection->value_widget = NULL;

   selection->buffer = (char *) malloc (sizeof(char)*(xvf_strlen(buffer)+1));
   sprintf(selection->buffer,"%s", buffer);
   selection->opt_widget = float_opt_button;
   selection->opt_selected = line_info.opt_sel;
   selection->scroll = float_scroll;

   if (line_info.activate == false)
      XtSetSensitive(float_back, false);

   return(float_back);
}


/************************************************************
*
*  Routine Name:  xvf_create_logic_sel
*
*      Purpose:   Creates a line to get an logical selection
*		  in the options pane.
*
*        Input:   subform  - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -l @ % gs ps def 'l' 'des' c v val */
Widget xvf_create_logic_sel(form, subform, guide, selection,
			     database, index, parent, doing_toggle,
			     toggle_start)
xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection; 
char     *database[];
int      *index;
Widget   parent;
int      doing_toggle;
xvf_selection *toggle_start;
{
   Widget logic_back;
   Widget logic_label;
   Widget logic_opt_button=NULL;
   Widget logic_value;
   Callback_Data *cb_data;
   Line_Info line_info;
   char widget_name[512], *boolean_label, *label;
   int  label_x, label_y, label_width, label_height;
   int  back_x, back_y, back_width, back_height;
   int  opt_x, opt_y, opt_width, opt_height;
   int	x_position, y_position, value_width, value_height;

  /*
   * initialize callback data for this logical selection
   */

   cb_data = xvf_init_cb_data(form, subform, guide, selection, 
				doing_toggle, toggle_start);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_logic_line(database[*index],&line_info)))
      return(NULL);
   
   if (doing_toggle == true)
   {
      sprintf(widget_name,"%d_logic_back",toggle_count);
      toggle_count++;
   }
   else
   {
      sprintf(widget_name,"%s_logic_back",line_info.variable);
   }
   selection->back_name = xvf_strcpy(widget_name);

  /*
   * create logical selection back widget
   */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info.width * xvf_font_width;
   back_height = line_info.height * xvf_font_height;
   logic_back  = xvf_create_selback_widget(parent, back_x, back_y, 
					  back_width, back_height, 
					  selection->back_name);
   x_position = 0;

  /*
   * create optional button if database line requests it
   */

   if ((line_info.optional == true)||(doing_toggle == true))
   {
       opt_x      = 0;
       opt_y      = line_info.ypos*xvf_font_height;
       opt_width  = xvf_font_height;
       opt_height = xvf_font_height;
       logic_opt_button = xvf_create_optional_button(logic_back, opt_x, opt_y,
    						     opt_width, opt_height);
       XtAddCallback(logic_opt_button,XtNcallback,xvf_logic_opt_cb,cb_data); 
       x_position += opt_width + xvf_font_width;
   }

  /*
   * put in label
   */
   if (line_info.title != NULL)
   {
       label= xvf_strcpy(line_info.title);
       label_width = xvf_strlen(line_info.title)*xvf_font_width;
   }
   else
   {
       label = xvf_strcpy(" ");
       label_width = xvf_font_width;
   }
   label_x     = x_position + line_info.xpos*xvf_font_width;
   label_y     = line_info.ypos*xvf_font_height;
   label_height= xvf_font_height;
   logic_label = xvf_create_label_widget(logic_back, label_x, label_y,
					 label_width, label_height,
					 label, xvf_font, "label", 
					 true, false);
   x_position = label_x + label_width + xvf_font_width;
   selection->label_widget = logic_label;


   if (doing_toggle == false)
   {
      /* add actual value widget */
       if (line_info.logical_val == true)
       {
	  if (line_info.val_labels[1] != NULL)
             boolean_label = xvf_strcpy(line_info.val_labels[1]);
	  else 
	     boolean_label = xvf_strcpy(" ");
       }
       else	
       {
	  if (line_info.val_labels[0] != NULL)
              boolean_label = xvf_strcpy(line_info.val_labels[0]);
	  else
	     boolean_label = xvf_strcpy(" ");
       }

       value_width = xvf_font_width*(xvf_strlen(boolean_label)+2);

       y_position = line_info.ypos*xvf_font_height;
       value_height = (xvf_font_height+2)*line_info.height;
       logic_value = xvf_create_boolean_widget(logic_back, x_position,
                             y_position, value_width, value_height,
                             xvf_font, boolean_label);
       XtAddCallback(logic_value,XtNcallback,xvf_logic_val_cb, cb_data); 

       selection->value_widget = logic_value;
   }
    else
      selection->value_widget = NULL;

   selection->opt_widget = logic_opt_button;
   selection->opt_selected = line_info.opt_sel;

   if (line_info.activate == false)
      XtSetSensitive(logic_back, false);

   return(logic_back);
}


/************************************************************
*
*  Routine Name:  xvf_create_string_sel
*
*      Purpose:   Creates a line to get a string selection
*		  in the options pane.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/


/* -s @ % * ! gs ps 'def' 'l' 'des' c v 'val' */
Widget xvf_create_string_sel(form, subform, guide, selection,
			      database, index, parent, doing_toggle,
			      toggle_start)
xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection; 
char     *database[];
int      *index;
Widget   parent;
int      doing_toggle;
xvf_selection *toggle_start;
{
   Widget string_back, string_label, string_value;
   Widget string_opt_button = NULL;
   int value_width, value_height, spec;
   Callback_Data *cb_data;
   Line_Info line_info;
   XtTranslations translations; 
   char widget_name[512], temp[10*MaxLength], *label;
   int	x_position, y_position;
   int  label_x, label_y, label_width, label_height;
   int  back_x, back_y, back_width, back_height;
   int  opt_x, opt_y, opt_width, opt_height;


   cb_data = xvf_init_cb_data(form, subform, guide, selection, 
				doing_toggle, toggle_start);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_string_line(database[*index],&line_info)))
      return(NULL);
   
   if (doing_toggle == true)
   {
      sprintf(widget_name,"%d_string_back",toggle_count);
      toggle_count++;
   }
   else
   {
      sprintf(widget_name,"%s_string_back",line_info.variable);
   }
   selection->back_name = xvf_strcpy(widget_name);

   /* create string selection back widget */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info.width * xvf_font_width;
   back_height = line_info.height * xvf_font_height;
   string_back = xvf_create_selback_widget(parent, back_x, back_y, 
					   back_width, back_height, 
					   selection->back_name);
   x_position = 0;

   /* create optional button */
   if ((line_info.optional == true)||(doing_toggle == true))
   {
      opt_x      = 0;
      opt_y      = line_info.ypos;
      opt_width  = xvf_font_height;
      opt_height = xvf_font_height;
      string_opt_button = xvf_create_optional_button(string_back, opt_x, opt_y,
						     opt_width, opt_height);
      XtAddCallback(string_opt_button,XtNcallback,xvf_string_opt_cb,
		cb_data); 

      x_position += opt_width + xvf_font_width;
   }

   /* put in label */
   if (line_info.title != NULL)
   {
      label= xvf_strcpy(line_info.title);
      label_width = xvf_strlen(line_info.title)*xvf_font_width;
   }
   else
   {
      label = xvf_strcpy(" ");
      label_width = xvf_font_width;
   }
   label_x     = x_position + line_info.xpos*xvf_font_width;
   label_y     = line_info.ypos*xvf_font_height;
   label_height= xvf_font_height;
   string_label = xvf_create_label_widget(string_back, label_x, label_y,
					  label_width, label_height,
					  label, xvf_font, "label", 
					  true, false);

   x_position = label_x + label_width + xvf_font_width;
   selection->label_widget = string_label;

/*
 * set the text buffer for the ascii widget  
 */
   if ((line_info.string_val == NULL) && 
       (line_info.string_def == NULL) &&
       (line_info.literal == NULL))
      temp[0] = '\0';
   else if (line_info.literal != NULL)
      sprintf(temp, "%s", line_info.literal);
   else if (line_info.string_val != NULL)
      sprintf(temp, "%s", line_info.string_val);
   else
      sprintf(temp, "%s", line_info.string_def);

   if (doing_toggle == false)
   {
      /* add actual value widget */
      value_width = line_info.width*xvf_font_width - x_position;
      if (value_width <= 0)
	 value_width = 1;

      if (line_info.live == true)
	 translations = live_string_trans;
      else if (line_info.height == 1)
	 translations = search_trans;
      else
         translations = NULL;

      if (line_info.height > 1) spec = true; else spec = false;

      y_position = line_info.ypos*xvf_font_height;
      value_height = (xvf_font_height+2)*line_info.height;
      string_value = xvf_create_ascii_widget(string_back, x_position,
				     y_position, value_width, value_height,
				     temp, xvf_font, spec, translations);
      if (line_info.live == true)
      {
	 xvf_update_live_sel_list(string_value, cb_data);

         (void)  xvf_create_cr_pixmap_widget(string_back, string_value);
      }
      selection->value_widget = string_value;
   }
   else
      selection->value_widget = NULL;
   
   selection->opt_widget = string_opt_button;
   selection->opt_selected = line_info.opt_sel;


   if (line_info.activate == false)
      XtSetSensitive(string_back, false);

   return(string_back);
}



/************************************************************
*
*  Routine Name:  xvf_create_cycle_sel
*
*      Purpose:   Creates a cycle selection on a pane.
*
*        Input:   form      - pointer to the form tree
*		  subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Danielle Argiro
*
*
*************************************************************/

/* -l @ % gs ps def 'l' 'des' c v val */
Widget xvf_create_cycle_sel(form, subform, guide, selection,
			     database, index, parent, button_name)
xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection; 
char     *database[];
int      *index;
Widget   parent;
char	**button_name;
{
   Widget cycle_back;
   Widget cycle_label;
   Widget cycle_opt_button=NULL;
   Widget cycle_value;
   Callback_Data *cb_data;
   Line_Info line_info;
   char widget_name[512], *choice_label, *label;
   int  label_x, label_y, label_width, label_height;
   int  back_x, back_y, back_width, back_height;
   int  opt_x, opt_y, opt_width, opt_height;
   int	x_position, y_position, value_width, value_height;

  /*
   * initialize callback data for this cycleal selection
   */

   cb_data = xvf_init_cb_data(form, subform, guide, selection, 
			      false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_cycle_line(database[*index],&line_info)))
      return(NULL);
   
   sprintf(widget_name,"%s_cycle_back",line_info.variable);
   *button_name = xvf_strcpy(widget_name);

  /*
   * create cycle selection back widget
   */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info.width * xvf_font_width;
   back_height = line_info.height * xvf_font_height;
   cycle_back  = xvf_create_selback_widget(parent, back_x, back_y, 
					  back_width, back_height, 
					  selection->back_name);
   x_position = 0;

  /*
   * create optional button if database line requests it
   */

   if (line_info.optional == true)
   {
       opt_x      = 0;
       opt_y      = line_info.ypos*xvf_font_height;
       opt_width  = xvf_font_height;
       opt_height = xvf_font_height;
       cycle_opt_button = xvf_create_optional_button(cycle_back, opt_x, opt_y,
    						     opt_width, opt_height);
       XtAddCallback(cycle_opt_button,XtNcallback,xvf_cycle_opt_cb,cb_data); 
       x_position += opt_width + xvf_font_width;
   }

  /*
   * put in label
   */
   if (line_info.title != NULL)
   {
       label= xvf_strcpy(line_info.title);
       label_width = xvf_strlen(line_info.title)*xvf_font_width;
   }
   else
   {
       label = xvf_strcpy(" ");
       label_width = xvf_font_width;
   }
   label_x     = x_position + line_info.xpos*xvf_font_width;
   label_y     = line_info.ypos*xvf_font_height;
   label_height= xvf_font_height;
   cycle_label = xvf_create_label_widget(cycle_back, label_x, label_y,
					 label_width, label_height,
					 label, xvf_font, "label", 
					 true, false);
   x_position = label_x + label_width + xvf_font_width;
   selection->label_widget = cycle_label;

  /* 
   *  add actual value widget 
   */
   choice_label = xvf_strcpy(line_info.val_labels[line_info.cycle_val]);

   value_width = xvf_font_width*(xvf_strlen(choice_label)+2);

   y_position = line_info.ypos*xvf_font_height;
   value_height = (xvf_font_height+2)*line_info.height;
   cycle_value = xvf_create_boolean_widget(cycle_back, x_position, y_position,
                 value_width, value_height, xvf_font, choice_label);
   XtAddCallback(cycle_value,XtNcallback,xvf_cycle_val_cb, cb_data); 

   selection->value_widget   = cycle_value;
   selection->opt_widget   = cycle_opt_button;
   selection->opt_selected = line_info.opt_sel;

   if (line_info.activate == false)
      XtSetSensitive(cycle_back, false);

   return(cycle_back);
}

/************************************************************
*
*  Routine Name:  xvf_create_routine_sel
*
*      Purpose:   Creates a routine button widget for
*		  the options pane section of the subform.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -R @ gs ps 'l' 'des' com bf */
Widget xvf_create_routine_sel(form, subform, guide, selection, 
			       database, index, parent, button_name)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection;
char     *database[];
int      *index;
Widget   parent;
char	 **button_name;
{
   Widget routine_button;
   Callback_Data *cb_data;
   Line_Info line_info;
   char widget_name[512];
   char *label;
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, guide, selection, false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_routine_line(database[*index],&line_info)))
      return(NULL);

   sprintf(widget_name,"%s_routine_button",line_info.routine);
   *button_name = xvf_strcpy(widget_name);
   
   if (line_info.title != NULL)
         label=xvf_strcpy(line_info.title);
   else
         label=xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;
   routine_button = xvf_create_button_widget(parent, button_x, button_y,
					  button_width, button_height,
					  label, xvf_font, *button_name);

   XtAddCallback(routine_button,XtNcallback,xvf_routine_cb,cb_data);


   if (line_info.activate == false)
      XtSetSensitive(routine_button, false);

   return(routine_button);
}



/************************************************************
*
*  Routine Name:  xvf_create_toggle_sel
*
*      Purpose:   Creates the backplane toggle widget for
*		  holding the rest of the toggle selections.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -T @ % * ! gs ps def n 'l' 'des' */
Widget xvf_create_toggle_sel(form, subform, guide, selection, 
			      database, index, parent)

xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection;
char     *database[];
int      *index;
Widget   parent;
{
   Widget toggle_back;
   Widget toggle_label;
   Widget toggle_opt_button=NULL;
   Callback_Data *cb_data;
   Line_Info line_info;
   char widget_name[512];
   int  label_x, label_y, label_width, label_height;
   int  back_x, back_y, back_width, back_height;
   int  opt_x, opt_y, opt_width, opt_height;
   int  x_position;

   cb_data = xvf_init_cb_data(form, subform, guide, selection, false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_toggle_line(database[*index],&line_info)))
      return(NULL);

   sprintf(widget_name,"%s_toggle_back",line_info.variable);
   selection->back_name = xvf_strcpy(widget_name);
   
   /* create toggle back widget */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + ((int)xvf_font_height/2));
   back_width  = line_info.width * xvf_font_width;
   back_height = line_info.height * xvf_font_height;
   toggle_back = xvf_create_selback_widget(parent, back_x, back_y, 
					   back_width, back_height, 
					   selection->back_name);
   x_position = 0;

   /* create optional button */
   if (line_info.optional == true)
   {
      opt_x      = 0;
      opt_y      = line_info.ypos;
      opt_width  = xvf_font_height;
      opt_height = xvf_font_height;
      toggle_opt_button = xvf_create_optional_button(toggle_back, opt_x, opt_y,
						     opt_width, opt_height);
      XtAddCallback(toggle_opt_button,XtNcallback,xvf_toggle_opt_cb, cb_data); 
	
      x_position += opt_width + xvf_font_width;
   }
   selection->opt_widget = toggle_opt_button;

   /* if the button is either optional & active or not optional, highlight it 
   if ((line_info.opt_sel == true) || (line_info.optional == false))
      xvf_reverse_colors(toggle_opt_button); */


   /* put in label */
   
   label_x     = x_position + line_info.xpos*xvf_font_width;
   label_y     = line_info.ypos*xvf_font_height;
   label_width = xvf_strlen(line_info.title)*xvf_font_width;
   label_height= xvf_font_height;
   toggle_label = xvf_create_label_widget(toggle_back, label_x, label_y,
					  label_width, label_height,
					  line_info.title, xvf_font, "label", 
					  true, false);

   selection->label_widget = toggle_label;
   selection->opt_selected = line_info.opt_sel;
   selection->toggle_int = line_info.toggle_val;


   if (line_info.activate == false)
      XtSetSensitive(toggle_back, false);

   toggle_count = 0;

   return(toggle_back);
}



/************************************************************
*
*  Routine Name:  xvf_create_blank_sel
*
*      Purpose:   Creates a label widget for the subform.
*
*        Input:   line_info - structure containing information
*			      gained from the knowledge base.
*		  parent    - parent of widget being created.
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -b ps 'l' */
Widget xvf_create_blank_sel(database, index, parent, num, button_name, submenu)

char     *database[];
int      *index;
Widget   parent;
int      num;
char     **button_name;
int	 submenu;
{
   Widget blank_label;
   Line_Info line_info;
   char widget_name[512];
   int  label_x, label_y, label_width, label_height;

   Widget xvf_create_submenu_label_widget();

   xvf_clear_line_info(&line_info);
   xvf_parse_blank_line(database[*index],&line_info);

   sprintf(widget_name,"%d_blank_label",num);
   if (button_name != NULL)
      *button_name = xvf_strcpy(widget_name);
   
   /* create label widget */
   label_x     = line_info.xpos*xvf_font_width;
   label_y     = line_info.ypos*(xvf_font_height + ((int)xvf_font_height/2));
   label_width = xvf_strlen(line_info.title)*xvf_font_width;
   label_height= xvf_font_height;
   if (submenu)
      blank_label = xvf_create_submenu_label_widget(parent, label_x, label_y,
					 label_width, label_height,
					 line_info.title, xvf_font, widget_name,
					 true, false);
   else
      blank_label = xvf_create_label_widget(parent, label_x, label_y,
					 label_width, label_height,
					 line_info.title, xvf_font, widget_name,
					 true, false);
   return(blank_label);
}




/************************************************************
*
*  Routine Name:  xvf_create_list_sel
*
*      Purpose:   Creates a list selection on a pane.
*
*        Input:   form      - pointer to the form tree
*		  subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Danielle Argiro
*
*
*************************************************************/

/* -l @ % gs ps def 'l' 'des' c v val */
Widget xvf_create_list_sel(form, subform, guide, selection,
			     database, index, parent, button_name)
xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection; 
char     *database[];
int      *index;
Widget   parent;
char	**button_name;
{
   Widget list_back;
   Widget list_label;
   Widget list_value;
   Widget list_opt_button=NULL;
   Callback_Data *cb_data;
   Line_Info line_info;
   char widget_name[512], *choice_label, *label;
   int  label_x, label_y, label_width, label_height;
   int  back_x, back_y, back_width, back_height;
   int  opt_x, opt_y, opt_width, opt_height;
   int	x_position, y_position, value_width, value_height;

  /*
   * initialize callback data for this list selection
   */

   cb_data = xvf_init_cb_data(form, subform, guide, selection, 
			      false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_list_line(database[*index],&line_info)))
      return(NULL);
   
   sprintf(widget_name,"%s_list_back",line_info.variable);
   *button_name = xvf_strcpy(widget_name);

  /*
   * create list selection back widget
   */
   back_x      = line_info.x * xvf_font_width;
   back_y      = line_info.y * (xvf_font_height + (int)xvf_font_height/2);
   back_width  = line_info.width * xvf_font_width;
   back_height = line_info.height * xvf_font_height;
   list_back  = xvf_create_selback_widget(parent, back_x, back_y, 
					  back_width, back_height, 
					  selection->back_name);
   x_position = 0;

  /*
   * create optional button if database line requests it
   */

   if (line_info.optional == true)
   {
       opt_x      = 0;
       opt_y      = line_info.ypos*xvf_font_height;
       opt_width  = xvf_font_height;
       opt_height = xvf_font_height;
       list_opt_button = xvf_create_optional_button(list_back, opt_x, opt_y,
    						     opt_width, opt_height);
       XtAddCallback(list_opt_button,XtNcallback,xvf_list_opt_cb,cb_data); 
       x_position += opt_width + xvf_font_width;
   }

  /*
   * put in label
   */
   if (line_info.title != NULL)
   {
       label= xvf_strcpy(line_info.title);
       label_width = xvf_strlen(line_info.title)*xvf_font_width;
   }
   else
   {
       label = xvf_strcpy(" ");
       label_width = xvf_font_width;
   }
   label_x     = x_position + line_info.xpos*xvf_font_width;
   label_y     = line_info.ypos*xvf_font_height;
   label_height= xvf_font_height;
   list_label = xvf_create_label_widget(list_back, label_x, label_y,
					 label_width, label_height,
					 label, xvf_font, "label", 
					 true, false);
   x_position += label_width + xvf_font_width;
   selection->label_widget = list_label;

  /* 
   *  add actual value widget 
   */
   choice_label = xvf_strcpy(line_info.val_labels[line_info.list_val-1]);

   if (xvf_strlen(line_info.val_labels[0]) > 
	   (xvf_strlen(line_info.val_labels[1])))
      value_width = ((xvf_font_width +2)*
			   (xvf_strlen(line_info.val_labels[0]))+2);
   else
      value_width = ((xvf_font_width +2)*
			   (xvf_strlen(line_info.val_labels[1]))+2);

    y_position = line_info.ypos*xvf_font_height;
    value_height = (xvf_font_height+2)*line_info.height;
    list_value = xvf_create_boolean_widget(list_back, x_position, y_position,
                 value_width +10, value_height, xvf_font, choice_label);
    XtAddCallback(list_value,XtNcallback,xvf_list_val_cb, cb_data); 

   selection->value_widget   = list_value;
   selection->opt_widget   = list_opt_button;
   selection->opt_selected = line_info.opt_sel;

   if (line_info.activate == false)
      XtSetSensitive(list_back, false);

   return(list_back);
}

/************************************************************
*
*  Routine Name:  xvf_create_pane_action_sel
*
*      Purpose:   Creates the pane action button widget for
*		  the options pane section of the subform.
*
*        Input:   subform   - pointer to the xvf_sub_form structure
*		  database  - the knowledge base being used
*		  index     - index into the database that describes
*			      the guide selection          
*		  parent    - parent of widget being created.
*
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/

/* -a @ % gs ps 'l' 'des' c v */
Widget xvf_create_pane_action_sel(form, subform, guide, selection, 
				   database, index,parent,button_name)

xvf_form 	 *form;
xvf_sub_form 	 *subform;
xvf_guide_button *guide;
xvf_selection    *selection;
char             *database[];
int      	 *index;
Widget   	 parent;
char      	 **button_name;
{
   Widget pane_action_button;
   Callback_Data *cb_data;
   Line_Info line_info;
   char widget_name[512];
   char *label;
   int button_width, button_height, button_x, button_y;

   cb_data = xvf_init_cb_data(form, subform, guide, selection, false, NULL);

   xvf_clear_line_info(&line_info);
   if (!(xvf_parse_pane_action_line(database[*index],&line_info)))
      return(NULL);

   sprintf(widget_name,"%s_pane_action_button",line_info.variable);
   *button_name = xvf_strcpy(widget_name);
   
   if (line_info.title != NULL)
         label=xvf_strcpy(line_info.title);
   else
         label=xvf_strcpy(" ");

   button_x       = line_info.x*xvf_font_width;
   button_y       = line_info.y*(xvf_font_height + ((int)xvf_font_height/2));
   button_width   = line_info.width*xvf_font_width;
   button_height  = line_info.height*xvf_font_height;
   pane_action_button = xvf_create_button_widget(parent, button_x, button_y,
					  button_width, button_height,
					  label, xvf_font, *button_name);

   XtAddCallback(pane_action_button,XtNcallback,xvf_pane_action_cb,cb_data); 

   if (line_info.activate == false)
      XtSetSensitive(pane_action_button, false);

   return(pane_action_button);
}


/************************************************************
*
*  Routine Name:  xvf_form_create_glyph_sel
*
*      Purpose:   Creates the glyph button widget for
*		  the backplane of the FORM.
*
*        Input:   form      - pointer to the xvf_form structure
*
*       Output:	  glyph button
*
*    Called By:	  xvf_create_form()
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/


Widget xvf_form_create_glyph_sel(form)

xvf_form *form;
{
   Widget glyph_button;
   Callback_Data *cb_data; 
   int glyph_x, glyph_y, glyph_width, glyph_height;

   /* When the toplevel is NULL, there is no master form just
    * a subform.  In this case no glyph will be created 
    */
   if (form->toplevel == NULL)
      return(NULL);

   cb_data = xvf_init_cb_data(form, NULL, NULL, NULL, false, NULL);

   /* create glyph widget */
   glyph_x = xvf_font_width;
   glyph_y = xvf_font_width;
   glyph_width  = 7 * xvf_font_width;
   glyph_height = xvf_font_height;
   glyph_button = xvf_create_glyph_widget(form->back, glyph_x, glyph_y,
					  glyph_width, glyph_height, "Glyph", 
					  xvf_font);

   XtAddCallback(glyph_button, XtNcallback, xvf_glyph_cb, cb_data);
   return(glyph_button);
}


/************************************************************
*
*  Routine Name:  xvf_subform_create_glyph_sel
*
*      Purpose:   Creates the glyph button widget for
*		  the backplane of the SUBFORM.
*
*        Input:   form      - pointer to the xvf_form structure
*        	  subform   - pointer to the xvf_sub_form structure
*
*       Output:	  glyph button
*
*    Called By:	  application program
*
*   Written By:   Stephanie Hallett & Danielle Argiro
*
*
*************************************************************/


Widget xvf_subform_create_glyph_sel(form, subform)

xvf_form     *form;
xvf_sub_form *subform;
{
   Widget glyph_button;
   Callback_Data *cb_data; 
   int glyph_x, glyph_y, glyph_width, glyph_height;


   cb_data = xvf_init_cb_data(form, subform, NULL, NULL, false, NULL);

   /* create glyph widget */
   glyph_x = xvf_font_width;
   glyph_y = xvf_font_width;
   glyph_width  = 7 * xvf_font_width;
   glyph_height = xvf_font_height;
   glyph_button = xvf_create_glyph_widget(subform->back,glyph_x,glyph_y,
					  glyph_width, glyph_height, "Glyph", 
					  xvf_font);

   
   XtAddCallback(glyph_button, XtNcallback, xvf_glyph_cb, cb_data);
   return(glyph_button);
}


/************************************************************
*
*  Routine Name:  xvf_create_form_glyph(form, argv, argc, glyph_type)
*
*      Purpose:   create the 
*
*        Input:	  form     - pointer to form tree.
*		  argv	   - command line argument structure
*		  argc	   - number of command line arguments
*		  glyph_type - type of glyph to create
*
*       Output:	  unmaps glyph and maps form.
*		  also uses xvf_change_glyph() to reflect change
*		  in the xvf_list.
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett and Danielle Argiro
*
*
*************************************************************/


caddr_t xvf_create_form_glyph(form, argv, argc, glyph_type)

xvf_form	*form;
char            **argv;
unsigned int    argc;
int		glyph_type;
{
   Arg	   arg[8];
   S_Glyph *glyph_stat;
   Callback_Data *cb_data;
   int	   i, xpos, ypos, width, height;
   char	   name[512], *cap_top_name;


   cb_data = xvf_init_cb_data(form, NULL, NULL, NULL, false, NULL);
   glyph_stat = (S_Glyph *)calloc(1,sizeof(S_Glyph));
   form->glyph_type = glyph_type;

   sprintf(name,"%s_glyph",form->toplevel_name);
   form->glyph_top_name = xvf_strcpy(name);
   cap_top_name = xvf_cap_first_letter(form->glyph_top_name);

   /* creating toplevel widget */
   i = 0;
   XtSetArg(arg[i], XtNscreen, DefaultScreenOfDisplay(display)); i++;
   XtSetArg(arg[i], XtNargc, ac);				 i++;
   XtSetArg(arg[i], XtNargv, av);				 i++;
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);		 i++; 
   form->glyph_toplevel = XtAppCreateShell(form->glyph_top_name,
       cap_top_name, applicationShellWidgetClass, display, arg, i);
   glyph_stat->toplevel  = form->glyph_toplevel;

   if (glyph_type == SIMPLE)
   {
      glyph_stat->label_str = xvf_strcpy(form->form_name);
      xpos   = 0;
      ypos   = 0;
      width  = (xvf_strlen(glyph_stat->label_str) +3) * xvf_font_width;
      height = xvf_font_height * 2;
      glyph_stat->do_form = xvf_create_simple_widget(glyph_stat->toplevel, xpos,
			 ypos, width, height, glyph_stat->label_str, xvf_font);
      XtAddCallback(glyph_stat->do_form, XtNcallback, xvf_unglyph_cb, cb_data);
   }
   xvf_realize_widget(form->glyph_toplevel);
   return(((caddr_t) glyph_stat));
}


/************************************************************
*
*  Routine Name:  xvf_create_subform_glyph(form, subform, argv,argc, glyph_type)
*
*      Purpose:   create the 
*
*        Input:	  form     - pointer to form tree.
*        	  subform  - pointer to subform tree.
*		  argv	   - command line argument structure
*		  argc	   - number of command line arguments
*		  glyph_type - type of glyph to create
*
*       Output:	  unmaps glyph and maps form.
*		  also uses xvf_change_glyph() to reflect change
*		  in the xvf_list.
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett and Danielle Argiro
*
*
*************************************************************/


caddr_t xvf_create_subform_glyph(form, subform, argv, argc, glyph_type)

xvf_form	*form;
xvf_sub_form	*subform;
char            **argv;
unsigned int    argc;
int		glyph_type;
{
   Arg	   arg[8];
   S_Glyph *glyph_stat;
   Callback_Data *cb_data;
   int	   i, xpos, ypos, width, height;
   char	   name[512], *cap_top_name;



   cb_data = xvf_init_cb_data(form, subform, NULL, NULL, false, NULL);
   glyph_stat = (S_Glyph *)calloc(1,sizeof(S_Glyph));
   subform->glyph_type = glyph_type;

   sprintf(name,"%s_glyph", subform->toplevel_name);
   subform->glyph_top_name = xvf_strcpy(name);
   cap_top_name = xvf_cap_first_letter(subform->glyph_top_name);

   /* creating toplevel widget */
   i = 0;
   XtSetArg(arg[i], XtNscreen, DefaultScreenOfDisplay(display)); i++;
   XtSetArg(arg[i], XtNargc, ac);				 i++;
   XtSetArg(arg[i], XtNargv, av);				 i++;
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);		 i++; 
   subform->glyph_toplevel = XtAppCreateShell(subform->glyph_top_name,
       cap_top_name, applicationShellWidgetClass, display, arg, i);
   glyph_stat->toplevel = subform->glyph_toplevel;

   if (glyph_type == SIMPLE)
   {
      glyph_stat->label_str = xvf_strcpy(form->form_name);
      xpos   = 0;
      ypos   = 0;
      width  = xvf_strlen(glyph_stat->label_str) * xvf_font_width;
      height = xvf_font_height;
      glyph_stat->do_form = xvf_create_simple_widget(glyph_stat->toplevel, xpos,
			 ypos, width, height, glyph_stat->label_str, xvf_font);
      XtAddCallback(glyph_stat->do_form, XtNcallback, xvf_unglyph_cb, cb_data);
   }
   xvf_realize_widget(form->glyph_toplevel);

   return(((caddr_t) glyph_stat));
}

