
/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/*******************************************************************88
*
*  File:  cheygraph.c
*
*  Contents:  Device-specific routines for graphing facets 
*             with Cheyenne.
*/

/* Uses Cheyenne package on Sun. */

#include "include.h"
#include "cheyenne.h"

#ifndef TRUE
#define  TRUE 1
#endif

#ifndef FALSE
#define  FALSE 0
#endif

/* colormap */
static float red[256]   = {1.0, 1.0, 0.0, 0.0, 0.0},
             green[256] = {1.0, 0.0, 1.0, 0.0, 0.6},
             blue[256]  = {1.0, 0.0, 0.0, 1.0, 0.0};


/* screen corners */
static float scrx[4],scry[4];

/* PORTING NOTE: You need to have the proper device name for cy_open_devic */
char *device = "sunview";

void init_cheyenne()
{
  char line[100];
  char *name;

  /* initialize graphics */
getname:
  printf("Name of machine to display on (\"local\" for console): ");
  gets(line); name = line;
  if ( strlen(line) == 0 )
    error("Graphics aborted.\n",RECOVERABLE);
  cy_initialize();
  if ( cy_open_device("Evolver",device,name) < 0 )
    { fprintf(stderr,"Cannot open %s. \n",name);
      goto getname;
    }   
 
 
  cy_set_glo_var(CY_DEVICE_UNITS,CY_PIXELS);
  cy_set_glo_var(CY_CANVAS_UNITS,CY_PIXELS);
  cy_open_canvas("evolver",10.0,10.0,600.0,600.0,CY_DEFDEPTH);
  cy_set_cmap_as_0_to_1(0,255,red,green,blue);
  cy_set_loc_var(CY_CLOSEPATH,TRUE);
 
  /* screen corners */
  scrx[0] = scrx[1] = -1.4;
  scrx[2] = scrx[3] =  1.4;
  scry[0] = scry[3] =  1.4;
  scry[1] = scry[2] = -1.4;
  cy_window(1.01*scrx[0],1.01*scry[0],1.01*scrx[2],1.01*scry[2]);
  init_flag = 1;
}    

void chey_init()
{
  if ( init_flag == 0 ) init_cheyenne();
  /* clear screen */

  /* old version of cheyenne */
  /* cy_set_loc_var(CY_FILLING,TRUE); */
  /* cy_polygon(4,scrx,scry,CY_SCR,fillcolor); */

  /* new version */
  cy_set_bitmap(CY_CANVAS_BMAP,0.0,0.0,590.0,590.0,0);

}    


void chey_facet(t)
struct tsort *t;
{  
   int k,color;
   float x[3],y[3];  /* corner coords for Cheyenne */

   for ( k = 0 ; k < 3 ; k++ )
     { x[k] = t->x[k][0];
       y[k] = t->x[k][1];
     }

   /* display */
   color = get_facet_color(t->f_id);
   if ( web.hide_flag && (color != CLEAR) )
     {
       cy_set_loc_var(CY_FILLING,TRUE);
       cy_polygon(3,x,y,CY_SRC,fillcolor);
     }

    color = 1;  /* remove when figured out cheyenne colors */
    cy_set_loc_var(CY_FILLING,FALSE);
    cy_polygon(3,x,y,CY_SRC,color);

}

void chey_edge(g)
struct graphdata *g;
{
  int k,color;
  float x[2],y[2];
  int i,j;
  REAL a[4],b[2][4];

  /* transform */
  a[3] = 1.0;
  for ( i = 0 ; i < 2 ; i++ )
    {
      for ( j = 0 ; j < 3 ; j++ ) a[j] = g[i].x[j];
      matvec_mul(view,a,b[i],4,4);  /* transform */
    } 
  for ( k = 0 ; k < 2 ; k ++ )
   { x[k] = b[k][0];
     y[k] = b[k][1];
   }
  color = g[0].color;
  cy_line(x[0],y[0],x[1],y[1],CY_SRC,color);
}

  
void chey_finish()
{
}

int chey_end()
{
}

torclose()
{
  /* wind up graphics */
#ifdef sun
  cy_terminate();
#endif  
  init_flag = 0;
}


void display()
{
  init_graphics = chey_init;
  finish_graphics = chey_finish;
  graph_edge = chey_edge;
  graph_start = painter_start;
  graph_facet = painter_facet;
  graph_end = painter_end;
  display_facet = chey_facet;
  
  graphgen();
}

int moviefd;
extern int movie_init;

make_movie()
{
  char filename[40];

  if ( movie_init == 0 )
    {
      printf("Enter name of movie file: ");
      gets(filename);
      moviefd = cy_open_bitmap_file(filename,"w");
      movie_init = 1;
    }

  /* save current image */
  cy_save_bitmap(moviefd,CY_CANVAS_BMAP);
}

close_movie()
{
  cy_close_bitmap_file(moviefd);
}

