/* $Id: saol_sfsynth.c,v 1.2 1997/11/20 18:37:28 eds Exp $ */
/* $Log: saol_sfsynth.c,v $
 * Revision 1.2  1997/11/20  18:37:28  eds
 * SASBF integration.
 *
 * Revision 1.5  1997/11/15 00:43:32  luked
 * This is the result of the manual merge from the vendor branch for the
 * release tagged Fribourg_after_integration. I (brian) have probably lost
 * some history, but oh well.
 *
 * This contains the integration work by Eric Scheirer (MIT).
 *
 * Revision 1.3  1997/10/08 02:11:29  luked
 * 10/7/97   Luke Dahl
 * Changed the voice allocation to a more saol-like method.
 * There is now a SynthParam structure in cx (the contect)
 * which points to an array, the length of which is the number
 * of voices used in that note.  Still not sure if NoteExtend is working
 * or not.
 *  Modified Files:
 *  	lex.yy.c saol_interp.h saol_sfsynth.c sf_synth.c sf_wave_def.h
 *  	sf_wave_equ.h y.tab.c
 *
 * Revision 1.2  1997/10/07 23:54:30  luked
 * 10/7/97  Luke Dahl
 * This is the first update since the Stockholm_2nd vendor release.
 * The SF wavetable synthesis code has been added.
 * CUrrently does not work perfectly - does note use saol memory and
 * does not sucessfully extend voices, but it does make sound.
 *
 *
 * ----------------------------------------------------
 *  Modified Files:
 *  	Makefile dpweaiff.h lex.yy.c midifile.c midifile.h saol.lex
 *  	saol.yacc saol_co_imp.c saol_co_imp.h saol_core_opcodes.c
 *  	saol_interp.c saol_interp.h saol_macro.c saol_main.c
 *  	saol_parser.c saol_rates.c saol_sched.c saol_sfsynth.c
 *  	saol_spatial.c saol_syntax.c sf_synth.c sf_wave_def.h y.tab.c
 *  	y.tab.h
 *
 * Revision 1.1  1997/10/03  15:12:10  eds
 * Initial revision
 * */

/*********************************************************************

This software module was originally developed by

Luke Dahl        (Creative Labs / E-Mu Systems, Inc)
Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include <stdio.h>
#ifdef _SASBF
#include "sf_wave_def.h"
#endif
#include "saol_sched.h"
#include "y.tab.h"

void sfsynth(context *cx, long rate, double bank, double note, double vel,
	     char *outbus, char *revbus, char *chorbus,
	     double preset, double channel, double midibank) {

  double pl[2];
  double Left, Right, Rev, Chor;

#ifdef _SASBF
  sf_synth_top(cx, &Left, &Right, &Rev, &Chor, rate, bank, channel, midibank, preset,
	note, vel);
#endif

  if(rate == ASIG)
  {
	pl[0] = Left; 
	pl[1] = Right;
	bus_output(outbus,cx,pl,2);

	pl[0] = Rev;
	if (revbus) bus_output(revbus,cx,pl,1);

	pl[0] = Chor;
	if (chorbus) bus_output(chorbus,cx,pl,1);
  }
}
