/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Naoki Iwakami (NTT)                                                     */
/* and edited by                                                             */
/*   Naoki Iwakami and Satoshi Miki (NTT) on 1996-05-01,                     */
/*   Naoki Iwakami (NTT) on 1996-08-27,                                      */
/*   Naoki Iwakami (NTT) on 1996-12-06,                                      */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Takehiro Moriya (NTT) on 1997-08-01,                                    */
/*   Naoki Iwakami (NTT) on 1997-08-25                                       */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/

/* 06-dec-96   NI   provided 6 kbit/s support */
/* 18-apr-97   NI   included codebook-table-read procedures */
/* 01-aug-97   TM   provided 6 kbit/s support for 8kHz */
/* 25-aug-97   NI   bugfixes */

#include "ntt_conf.h"

void ntt_init()
{
  /*--- Variables ---*/
  int    flag, flag2, flag3, i;
  int    LSP_TBIT;
  int    GAIN_TBIT, GAIN_TBIT_M, GAIN_TBIT_S;
  int    FW_TBIT, FW_TBIT_S, FW_TBIT_M;
  int    IBPS_tmp;
  double BPS_tmp;

  /*--- Set channel mode ---*/
  switch (ntt_CH_MODE){
  case 0:			/* mono */
    ntt_N_SUP=1;
    break;
  case 1:
    ntt_N_SUP=2;
    break;
  default:
    fprintf( stderr, "ntt_CH_MODE number %d is invalid.\n", ntt_CH_MODE );
    exit(1);
  }

  /*--- Set bitrate mode ---*/
  ntt_IBPS /= ntt_N_SUP;
  ntt_BPS = (double)ntt_IBPS * 1000.;

  switch (ntt_ISAMPF){
  case 48:
    if      (ntt_IBPS >= 40) IBPS_tmp = 40;
    else if (ntt_IBPS >= 24) IBPS_tmp = 24;
    else if (ntt_IBPS >=  6) IBPS_tmp = 6;
    else{
      fprintf(stderr, "ntt_init(): %d: invalid bitrate.\n", ntt_IBPS);
      exit(1);
    }
    break;
  case 16:
    if (ntt_IBPS >= 16) IBPS_tmp = 16;
    else{
      fprintf(stderr, "ntt_init(): %d: invalid bitrate.\n", ntt_IBPS);
      exit(1);
    }
    break;
  case 8:
    if (ntt_IBPS >= 6) IBPS_tmp = 6;
    else{
      fprintf(stderr, "ntt_init(): %d: invalid bitrate.\n", ntt_IBPS);
      exit(1);
    }
    break;
  default:
    fprintf(stderr, "ntt_init(): %d: invalid sampling rate.\n",
	    ntt_ISAMPF);
    exit(1);
    break;
  }
    
  BPS_tmp = (double)IBPS_tmp * 1000.;

  /*--- Set mode table ---*/
  flag=0;
  /* 48 kHz sampling */
  if ( ntt_ISAMPF==48 && IBPS_tmp==40 ){
    ntt_cp_mdtbl( ntt_mode_48_40 );
    flag=1;
  }
  if ( ntt_ISAMPF==48 && IBPS_tmp==24 ){
    ntt_cp_mdtbl( ntt_mode_48_24 );
    flag=1;
  }
  if ( ntt_ISAMPF==48 && IBPS_tmp==6 ){
    ntt_cp_mdtbl( ntt_mode_48_06 );
    flag=1;
  }
  if ( ntt_ISAMPF==16 && IBPS_tmp==16 ){
    ntt_cp_mdtbl( ntt_mode_16_16 );
    flag=1;
  }
  if ( ntt_ISAMPF==8 && IBPS_tmp==6 ){
    ntt_cp_mdtbl( ntt_mode_08_06 );
    flag=1;
  }
  if ( flag==0 ){
    fprintf( stderr,
	    "ntt_ISAMPF: %d, IBPS_tmp: %d, IBPS: %d --- Not supported\n", 
	    ntt_ISAMPF, IBPS_tmp, ntt_IBPS );
    exit(1);
  }
    
  /*--- Set other variables ---*/
  /*----------------------------------------------------------------------*/
  /* PROGRAM MODE                                                         */
  /*----------------------------------------------------------------------*/
  ntt_N_FR_S    = ntt_N_FR/ntt_N_SHRT;
  ntt_cnst_chk( ntt_N_FR_S, ntt_N_FR_MAX, "short frame length" );

  ntt_N_FR_M    = ntt_N_FR/ntt_N_MID;
  ntt_cnst_chk( ntt_N_FR_M, ntt_N_FR_M_MAX, "medium frame length" );

  ntt_N_FR_EX   = (int)(log((double)ntt_N_FR)/log(2.0) + 0.1);
  ntt_N_FR_S_EX = (int)(log((double)ntt_N_FR_S)/log(2.0) + 0.1);
  ntt_N_FR_M_EX = (int)(log((double)ntt_N_FR_M)/log(2.0) + 0.1);

  ntt_N_FR_WDW = ntt_N_FR ;
  ntt_N_FR_S_WDW = ntt_N_FR_S ;
  ntt_N_FR_M_WDW = ntt_N_FR_M ;

  /*----------------------------------------------------------------------*/
  /* GAIN QUANTIZATION                                                    */
  /*----------------------------------------------------------------------*/
  ntt_NUM_STEP = 1<<ntt_GAIN_BITS;
  ntt_STEP     = ntt_AMP_MAX / (ntt_NUM_STEP - 1);
  ntt_SUB_NUM_STEP = 1<<ntt_SUB_GAIN_BITS;
  ntt_SUB_STEP     = ntt_SUB_AMP_MAX / (ntt_SUB_NUM_STEP - 1);

  /* number of bits for gain quantization tool */
  GAIN_TBIT = ntt_GAIN_BITS * ntt_N_SUP;
  GAIN_TBIT_M = (ntt_GAIN_BITS + ntt_SUB_GAIN_BITS * ntt_N_MID) * ntt_N_SUP;
  GAIN_TBIT_S = (ntt_GAIN_BITS + ntt_SUB_GAIN_BITS * ntt_N_SHRT) * ntt_N_SUP;
    
  /*----------------------------------------------------------------------*/
  /* LSP QUANTIZATION                                                     */
  /*----------------------------------------------------------------------*/
  /* parameter settings */
  ntt_N_MODE    = (1<<ntt_LSP_BIT0);
  ntt_cnst_chk( ntt_N_MODE, ntt_N_MODE_MAX, "Number of LSP quant. modes" );
  ntt_NC0       = (1<<ntt_LSP_BIT1);
  ntt_cnst_chk( ntt_NC0, ntt_NC0_MAX, "ntt_NC0" );
  ntt_NC1       = (1<<ntt_LSP_BIT2);
  ntt_cnst_chk( ntt_NC1, ntt_NC1_MAX, "ntt_NC1" );

  /* codebook settings */
  ntt_lsp_csize_base[0] = ntt_NC0;
  ntt_lsp_csize_base[1] = ntt_NC1;
  ntt_lsp_cdim_base[0] = ntt_lsp_cdim_base[1] = ntt_N_PR;

  /* codebook memory allocation and reading */
  lsp_code_base =
    (double *)malloc((ntt_NC0+ntt_NC1)*ntt_N_PR_MAX*sizeof(double));
  lsp_fgcode_base = 
    (double *)malloc(ntt_N_MODE*ntt_MA_NP*ntt_N_PR_MAX*sizeof(double));
  ntt_get_code(ntt_LSPCODEBOOK, ntt_LSP_NSTAGE,
	       ntt_lsp_csize_base, ntt_lsp_cdim_base,
	       (double (*)[ntt_N_PR_MAX])lsp_code_base,
	       (double (*)[ntt_MA_NP][ntt_N_PR_MAX])lsp_fgcode_base);

  /* number of bits for LSP quantization tool */
  LSP_TBIT =
    (ntt_LSP_BIT0 + ntt_LSP_BIT1 + ntt_LSP_BIT2 * ntt_LSP_SPLIT) * ntt_N_SUP;

  /*----------------------------------------------------------------------*/
  /* FORWARD ENVELOPE QUANTIZATION                                        */
  /*----------------------------------------------------------------------*/
    
  /*--- Load bark-scale subband tables ---*/
  flag = flag2 = flag3 = 0;

  /* sampling rate == 48 kHz */
  if ((ntt_ISAMPF == 48) && (ntt_N_FR == 2048)){
    if (IBPS_tmp == 6){
      ntt_crb_tbl = ntt_crb_tbl_48_2048_06;
      ntt_N_CRB = ntt_N_CRB_48_2048_06;
    }
    else{
      ntt_crb_tbl = ntt_crb_tbl_48_2048;
      ntt_N_CRB = ntt_N_CRB_48_2048;
    }
    flag = 1;
  }
  if ((ntt_ISAMPF == 48) && (ntt_N_FR_S == 128)){
    ntt_crb_tbl_s = ntt_crb_tbl_s_48_128;
    ntt_N_CRB_S = ntt_N_CRB_S_48_128;
    flag2 = 1;
  }
  if ((ntt_ISAMPF == 48) && (ntt_N_FR_M == 512)){
    switch(IBPS_tmp){
    case 40:
      ntt_crb_tbl_m = ntt_crb_tbl_48_512;
      ntt_N_CRB_M = ntt_N_CRB_48_512;
      break;
    case 24:
      ntt_crb_tbl_m = ntt_crb_tbl_48_512_24;
      ntt_N_CRB_M = ntt_N_CRB_48_512_24;
      break;
    case 6:
      ntt_crb_tbl_m = ntt_crb_tbl_48_512_06;
      ntt_N_CRB_M = ntt_N_CRB_48_512_06;
      break;
    default:
      ntt_crb_tbl_m = ntt_crb_tbl_48_512;
      ntt_N_CRB_M = ntt_N_CRB_48_512;
    }
    flag3 = 1;
  }
    
  /* sampling rate == 16 kHz */
  if ((ntt_ISAMPF == 16) && (ntt_N_FR == 512)){
    ntt_crb_tbl = ntt_crb_tbl_16_512;
    ntt_N_CRB = ntt_N_CRB_16_512;
    flag = 1;
  }
  if ((ntt_ISAMPF == 16) && (ntt_N_FR_S == 64)){
    ntt_crb_tbl_s = ntt_crb_tbl_s_16_64;
    ntt_N_CRB_S = ntt_N_CRB_S_16_64;
    flag2 = 1;
  }
  if ((ntt_ISAMPF == 16) && (ntt_N_FR_M == 256)){
    ntt_crb_tbl_m = ntt_crb_tbl_m_16_256;
    ntt_N_CRB_M = ntt_N_CRB_M_16_256;
    flag3 = 1;
  }
  
  /* sampling rate == 8 kHz */
  if ((ntt_ISAMPF == 8) && (ntt_N_FR == 512)){
    ntt_crb_tbl = ntt_crb_tbl_08_512;
    ntt_N_CRB = ntt_N_CRB_08_512;
    flag = 1;
  }
  if ((ntt_ISAMPF == 8) && (ntt_N_FR_S == 64)){
    ntt_crb_tbl_s = ntt_crb_tbl_s_08_64;
    ntt_N_CRB_S = ntt_N_CRB_S_08_64;
    flag2 = 1;
  }
  if ((ntt_ISAMPF == 8) && (ntt_N_FR_M == 256)){
    ntt_crb_tbl_m = ntt_crb_tbl_m_08_256;
    ntt_N_CRB_M = ntt_N_CRB_M_08_256;
    flag3 = 1;
  }
  if (!flag){
    fprintf(stderr,
	    "ntt_ISAMPF: %d, ntt_N_FR: %d --- No subband table for this mode.\n", 
	    ntt_ISAMPF, ntt_N_FR);
    exit(1);
  }
  if (!flag2){
    fprintf(stderr,
	    "ntt_ISAMPF: %d, ntt_N_FR_S: %d --- No subband table for this mode.\n", 
	    ntt_ISAMPF, ntt_N_FR_S);
    exit(1);
  }
  if (!flag3){
    fprintf(stderr,
	    "ntt_ISAMPF: %d, ntt_N_FR_M: %d --- No subband table for this mode.\n", 
	    ntt_ISAMPF, ntt_N_FR_M);
    exit(1);
  }
    
  /*--- Set variables for envelope coding ---*/
  ntt_FW_CB_SIZE   = (1<<ntt_FW_N_BIT);	/* Envelope codebook size */
  ntt_FW_CB_LEN    = (ntt_N_CRB/ntt_FW_N_DIV); /* Envelope codebook length */
  ntt_cnst_chk( ntt_FW_CB_SIZE, ntt_FW_CB_SIZE_MAX, "ntt_FW_CB_SIZE" );
  ntt_cnst_chk( ntt_FW_CB_LEN, ntt_FW_CB_LEN_MAX, "ntt_FW_CB_LEN" );

  ntt_FW_CB_SIZE_S = (1<<ntt_FW_N_BIT_S); /* Envelope codebook size */
  ntt_FW_CB_LEN_S  = (ntt_N_CRB_S/ntt_FW_N_DIV_S); /* Env. codebook length */
  ntt_cnst_chk( ntt_FW_CB_SIZE_S, ntt_FW_CB_SIZE_S_MAX, "ntt_FW_CB_SIZE_S" );
  ntt_cnst_chk( ntt_FW_CB_LEN_S, ntt_FW_CB_LEN_S_MAX, "ntt_FW_CB_LEN_S" );
    
  ntt_FW_CB_SIZE_M = (1<<ntt_FW_N_BIT_M); /* Envelope codebook size */
  ntt_FW_CB_LEN_M  = (ntt_N_CRB_M/ntt_FW_N_DIV_M); /* Env. codebook length */
  ntt_cnst_chk( ntt_FW_CB_SIZE_M, ntt_FW_CB_SIZE_M_MAX, "ntt_FW_CB_SIZE_M" );
  ntt_cnst_chk( ntt_FW_CB_LEN_M, ntt_FW_CB_LEN_M_MAX, "ntt_FW_CB_LEN_M" );

  if (ntt_FW_N_BIT > 0)
    FW_TBIT =
      (ntt_FW_N_BIT*ntt_FW_N_DIV+ntt_FW_ARQ_NBIT) * ntt_N_SUP;
  else
    FW_TBIT = 0;

  if (ntt_FW_N_BIT_S > 0)
    FW_TBIT_S =
      (ntt_FW_N_BIT_S*ntt_FW_N_DIV_S+ntt_FW_ARQ_NBIT) * ntt_N_SHRT * ntt_N_SUP;
  else
    FW_TBIT_S = 0;

  if (ntt_FW_N_BIT_M > 0)
    FW_TBIT_M =
      (ntt_FW_N_BIT_M*ntt_FW_N_DIV_M+ntt_FW_ARQ_NBIT) * ntt_N_MID * ntt_N_SUP;
  else
    FW_TBIT_M = 0;
    
  /*----------------------------------------------------------------------*/
  /* PITCH FILTER                                                         */
  /*----------------------------------------------------------------------*/
  ntt_TBIT_P     = ntt_PIT_N_BIT*ntt_N_SUP;
  if(ntt_TBIT_P>0){
    ntt_BASF_STEP = (1<<ntt_BASF_BIT)-1;
    ntt_PIT_CB_SIZE = 1<<ntt_MAXBIT_SHAPE_P;
    ntt_PGAIN_NSTEP = (1<<ntt_PGAIN_BIT) - 1;
    ntt_PGAIN_STEP   = ntt_PGAIN_MAX / ntt_PGAIN_NSTEP;
    ntt_N_FR_P     = ntt_PIT_CB_LEN;
    ntt_N_DIV_P    = ((int)((ntt_TBIT_P+ntt_MAXBIT_P*2-1)/(ntt_MAXBIT_P*2)));
    ntt_CB_LEN_P   = ((int)((ntt_N_FR_P*ntt_N_SUP+ntt_N_DIV_P-1)/ntt_N_DIV_P));
    ntt_PIT_TBIT = ntt_TBIT_P + (ntt_BASF_BIT + ntt_PGAIN_BIT) * ntt_N_SUP;
  }
  else{
    ntt_PIT_TBIT = 0;
  }

  /*----------------------------------------------------------------------*/
  /* BANDWIDTH CONTROL                                                    */
  /*----------------------------------------------------------------------*/
  /* Number of bits for bandwidth control */
  ntt_BWID_BITS = (ntt_BLIM_BITS_H + ntt_BLIM_BITS_L)*ntt_N_SUP;
  ntt_BLIM_STEP_H = (1 << ntt_BLIM_BITS_H) - 1;
  ntt_BAND_LOWER = 0.;
#if 0
  ntt_BAND_UPPER = 1.0;

  if (ntt_ISAMPF==48 && IBPS_tmp==40){
    ntt_BAND_UPPER = 1.0;
  }

  if (ntt_ISAMPF==48 && IBPS_tmp==24){
    ntt_BAND_UPPER = 1./2.;
  }

  if (ntt_ISAMPF==48 && IBPS_tmp==6){
    ntt_BAND_UPPER = 1./6.;
  }
#endif


  /*----------------------------------------------------------------------*/
  /* BITRATE CONTROL                                                      */
  /*----------------------------------------------------------------------*/
{
  int available_bits, bitfr_tmp;
  int TSideInfo, TSideInfo_s, TSideInfo_m;
  int ndiv, vq_bits;
  static int used_bits = 0;

  /* Number of bits per frame */
  ntt_NBITS_FR = (int)(ntt_N_FR*ntt_N_SUP*ntt_BPS/ntt_SAMPF);
  bitfr_tmp = (int)(ntt_N_FR*BPS_tmp/ntt_SAMPF);
  /* number of available bits */
  available_bits = ntt_NBITS_FR - used_bits;
  /* Number of bits for normalization tool */
  ntt_NMTOOL_BITS =
    LSP_TBIT + GAIN_TBIT + FW_TBIT + ntt_PIT_TBIT;
  ntt_NMTOOL_BITS_M = LSP_TBIT + GAIN_TBIT_M + FW_TBIT_M;
  ntt_NMTOOL_BITS_S = LSP_TBIT + GAIN_TBIT_S + FW_TBIT_S;
  /* Number of bits for side information */
  TSideInfo   = ntt_SIDE_INF_SW + ntt_PF_SW_BIT;
  TSideInfo_s = ntt_SIDE_INF_SW;
  TSideInfo_m = ntt_SIDE_INF_SW + ntt_PF_SW_BIT;
  /* set VQ codebook length (long) */
  vq_bits = bitfr_tmp - TSideInfo - ntt_NMTOOL_BITS/ntt_N_SUP;
  ntt_NMTOOL_BITS += ntt_BWID_BITS;
  ntt_VQTOOL_BITS =
    available_bits - TSideInfo - ntt_NMTOOL_BITS;
  ndiv    = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
  ntt_CB_LEN_READ   = (int)((ntt_N_FR+(ndiv)-1)/ ndiv);

  /* set VQ codebook length (medium) */
  vq_bits = bitfr_tmp - TSideInfo_m - ntt_NMTOOL_BITS_M/ntt_N_SUP;
  ntt_NMTOOL_BITS_M += ntt_BWID_BITS;
  ntt_VQTOOL_BITS_M =
    available_bits - TSideInfo_m - ntt_NMTOOL_BITS_M;
  ndiv  = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
  ntt_CB_LEN_READ_M = (int)((ntt_N_FR+ndiv-1)/ ndiv);

  /* set VQ codebook length (short) */
  vq_bits = bitfr_tmp - TSideInfo_s - ntt_NMTOOL_BITS_S/ntt_N_SUP;
  ntt_NMTOOL_BITS_S += ntt_BWID_BITS;
  ntt_VQTOOL_BITS_S =
    available_bits - TSideInfo_s - ntt_NMTOOL_BITS_S;
  ndiv  = (int)((vq_bits+ntt_MAXBIT*2-1)/(ntt_MAXBIT*2));
  ntt_CB_LEN_READ_S = (int)((ntt_N_FR+ndiv-1)/ ndiv);

}

  /*----------------------------------------------------------------------*/
  /* READING CODEBOOK TABLES                                              */
  /*----------------------------------------------------------------------*/
{
  int    cb_len_max;
  /*--- Interleaved vector quantization ---*/
  /* long frame */
  cb_len_max = ntt_CB_LEN_READ + ntt_CB_LEN_MGN;
  ntt_codev0 = (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
  ntt_codev1 = (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));

  ntt_get_cdbk(ntt_CB_NAME0, ntt_codev0,
	       ntt_CB_SIZE, ntt_CB_LEN_READ, cb_len_max);
  ntt_get_cdbk(ntt_CB_NAME1, ntt_codev1,
	       ntt_CB_SIZE, ntt_CB_LEN_READ, cb_len_max);
  /* medium frame */
  cb_len_max = ntt_CB_LEN_READ_M + ntt_CB_LEN_MGN;
  ntt_codev0m = (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
  ntt_codev1m = (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
  ntt_get_cdbk(ntt_CB_NAME0m, ntt_codev0m,
	       ntt_CB_SIZE, ntt_CB_LEN_READ_M, cb_len_max);
  ntt_get_cdbk(ntt_CB_NAME1m, ntt_codev1m,
	       ntt_CB_SIZE, ntt_CB_LEN_READ_M, cb_len_max);
  /* short frame */
  cb_len_max = ntt_CB_LEN_READ_S + ntt_CB_LEN_MGN;
  ntt_codev0s = (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
  ntt_codev1s = (double *)malloc(ntt_CB_SIZE*cb_len_max*sizeof(double));
  ntt_get_cdbk(ntt_CB_NAME0s, ntt_codev0s,
	       ntt_CB_SIZE, ntt_CB_LEN_READ_S, cb_len_max);
  ntt_get_cdbk(ntt_CB_NAME1s, ntt_codev1s,
	       ntt_CB_SIZE, ntt_CB_LEN_READ_S, cb_len_max);
  /*--- Bark-scale envelope ---*/
  /* long frame */
  ntt_fwcodev =
    (double *)malloc(ntt_FW_CB_SIZE*ntt_FW_CB_LEN*sizeof(double));
  ntt_get_cdbk(ntt_FW_CB_NAME, ntt_fwcodev,
	       ntt_FW_CB_SIZE, ntt_FW_CB_LEN, ntt_FW_CB_LEN);
  /* medium frame */
  ntt_fwcodevm =
    (double *)malloc(ntt_FW_CB_SIZE_M*ntt_FW_CB_LEN_M*sizeof(double));
  ntt_get_cdbk(ntt_FW_CB_NAME_M, ntt_fwcodevm,
	       ntt_FW_CB_SIZE_M,ntt_FW_CB_LEN_M,ntt_FW_CB_LEN_M);
  /* short frame */
  ntt_fwcodevs =
    (double *)malloc(ntt_FW_CB_SIZE_S*ntt_FW_CB_LEN_S*sizeof(double));
  ntt_get_cdbk(ntt_FW_CB_NAME_S, ntt_fwcodevs,
	       ntt_FW_CB_SIZE_S,ntt_FW_CB_LEN_S,ntt_FW_CB_LEN_S);
}


  /*--- Sin and Cosine table ---*/
  /* There are several kinds of sine and cosine table.
     They should be merged into one later. */
  for ( i=0; i<ntt_N_FR_M; i++ ){
    ntt_sinTwdm[i] = sin(PI*((double)i+0.5)/(double)ntt_N_FR_M_WDW/2.);
  }
  for ( i=0; i<ntt_N_FR_S; i++ ){
    ntt_sinTwds[i] = sin(PI*((double)i+0.5)/(double)ntt_N_FR_S_WDW/2.);
  }
  for ( i=0; i<ntt_N_FR_WDW; i++ ){
    ntt_sinTwdl[i] = sin(PI*((double)i+0.5)/(double)ntt_N_FR_WDW/2);
  }
{
  double dt, theta;
  int    ismp;

  dt = PI/(double)(4*ntt_N_FR);
  for ( ismp=0; ismp<ntt_N_FR*2; ismp++ ){
    theta = dt*ismp;
    ntt_cos_TT[ismp]= cos(theta);
  }
}
    
  /*--- Set the interleaving tables ---*/
  ntt_set_interleave(ntt_INTR_PITCH);
}
