/**************  MIDIInpt Test Program *********************/

// Adapted to test LINUX MIDIInpt by P.J.Leonard 17/8/97

#include "miditabl.h"
#include "MIDIInpt.h"

// PJL Added a timer
#include "JTimer.h"

#define ATOUCHMAX 2

int main(int argc,char *argv[])
{
  long i, j;
  int oneOn = 0;
  int lastTouch = 0;
  int aTouchThin = 0;
  MY_FLOAT temp,temp2;
  MIDIInpt controller;
  int first=1;
  
  if (argc!=1) 	{
    printf("useage: testMIDI\n");
    exit(0);
  }

  
  MY_FLOAT time=0.0;
  MY_FLOAT newtime=0.0;
  MY_FLOAT dt=0.0;

  while(1)	{
    if (controller.nextMessage() > 0)	{

      if (first) {
	JTimer::setNow(0);
	JTimer::start();
	first=0;
      }
      newtime=((MY_FLOAT)JTimer::timeNow())/1000.0;
      dt=newtime-time;
      time=newtime;
      temp2 = controller.getByteThree();
      temp = controller.getByteTwo();
      switch(controller.getType()) {
      case 9:
	if (temp2 < 1.0) {
	  if (oneOn == 1) {
	    printf("NoteOff      %f 1 %f %f\n",dt,temp,64.0);
	  }
	  oneOn -= 1;
	}
	else {
	  printf("NoteOn          %f 1 %f %f\n",dt,temp,temp2);
	  oneOn += 1;
	}

	break;
      
      case 8:
	// Hey what about 2 notes down ???
	if (temp2 < 2.0) temp2 = 64.0;
	if (oneOn == 1) {
	  printf("NoteOff         %f 1 %f %f\n",dt,temp,temp2);
	}
	oneOn -= 1;
	break;

      case 11:
	j = (int) temp;
	printf("ControlChange   %f 1 %i %f\n",dt,j,temp2);
	break;

      case 13:
	printf("AfterTouch      %f 1 %f\n",dt,temp);
	break;

      case 14:
	printf("PitchChange     %f 1 %f\n",dt,temp);
	break;

      case 12:
	j = (int) temp;
	printf("ProgramChange   %f 1 %i\n",dt,j);
	break;

      default:
	printf("Unknown         %f 1 %f %f\n",dt,temp,temp2);
	break;
      }
      fflush(stdout);
    }
  }
}

    





