// P.J.Leonard 17/8/97 (LINUX)
// Singleton static timer class.
// Methods to start/stop/set time and install a timed callback.
// Uses a SIGALRM to interupt at a specified moment and call the installed
// JTimerClient::interuptHandler(int)


#ifndef _JTimer_H
#define _JTimer_H

#include "assert.h"
#include "JSysTime.h"
#include "bool.h"


class JTimerClient;

class JTimer
{

private:

  JTimer(){assert(0);} /// purely static class
  
public:

  // Install a client (only one client)
  // Make a clever client if you want more !
  static void  setClient(JTimerClient *client) {_client=client;}

  // Set the time for calling the client
  // client must call setAlarmAt(future) if it wants more calls.
  // You must start the timer before calling setAlarmAt()
  static void  setAlarmAt(const JTime &when);

  // set the timer
  static void  setNow(const JTime &time); 

  // Querry current time
  static JTime timeNow();

  // Stop the timer running (Timer is stopped by defualt)
  static void  stop();

  // Start the timer running
  static void  start();

  // Query the state
  static bool isStoped() { return _stoped; }
protected:

  // My own interupt handler
  static void  handler(int id);

  static JTimerClient  *  _client;

  // Reference time 
  static JSysTime         _start;

  // Need to know when I was stopped for restart
  static JTime            _timeStoped;

  // Stopped flag
  static bool             _stoped;
};



#endif






