// P.J.Leonard 18/7/97  (LINUX)
// C++ wrappers for struct timval and  itimerval
// mainly for an interface for conversion to JTime.
// Also inlines some horrible arithmetic which arises
// due to the second:mSec system representation.

#ifndef _JSysTime_H
#define _JSysTime_H

#include <sys/time.h>
#include "assert.h"
#include "JTime.h"

#define GLITCHPERSEC 1000

class JSysTime:public timeval
{
public:
  
  JSysTime(){;}       /// Careful here
  JTime timeFrom(const JSysTime &from);
  void subtract(const JTime &t);
};

class JSysInterval:public itimerval
{
public:

  JSysInterval(const JSysTime &now,const JSysTime &start,const JTime &when);
};


inline
JSysInterval::JSysInterval(const JSysTime &now,
			   const JSysTime &start,
			   const JTime &when)
{ 

  it_interval.tv_sec=0;
  it_interval.tv_usec=0;

  long vtv_sec  =
    when/GLITCHPERSEC + start.tv_sec - now.tv_sec-1;

  long vtv_usec = 
    (1000000/GLITCHPERSEC)*(when%GLITCHPERSEC) +
    start.tv_usec - now.tv_usec +1000000;

  vtv_sec += vtv_usec/1000000;
  
  if (vtv_sec < 0 )
    {
      it_value.tv_sec =0;
      it_value.tv_usec=1;
    }
  else if (vtv_sec == 0 && vtv_usec == 0)
    {
      it_value.tv_sec =0;
      it_value.tv_usec=1;
    }
  else
    {
      vtv_usec = vtv_usec%1000000;
      
      it_value.tv_sec =vtv_sec;
      it_value.tv_usec=vtv_usec;
    }
  
} 
  

inline
void
JSysTime::subtract(const JTime &t)
{ 
  tv_usec = tv_usec + 1000000 - (1000000/GLITCHPERSEC)*(t%GLITCHPERSEC);
  tv_sec  = tv_sec  -1 + tv_usec/1000000 - t/GLITCHPERSEC;
  tv_usec  =  tv_usec%1000000;
} 

inline
JTime
JSysTime::timeFrom(const JSysTime &start)
{
  return GLITCHPERSEC*(tv_sec-start.tv_sec) + 
    (tv_usec-start.tv_usec)/(1000000/GLITCHPERSEC); 
}

#endif









