/*******************************************/
/*  Matlab MAT File Output Class,          */
/*  by Tim Stilson, 1996                   */
/*  based on code by Perry R. Cook, 1996   */
/*  This Object opens a Matlab MAT file    */
/*  Creates a Matrix to contain the        */
/*  output samples and fills it with       */
/*  buffers of samples.                    */
/*******************************************/

#include "MatWvOut.h"
#include <stdio.h>

MatWvOut :: MatWvOut(char *infileName)
{
    tmpFile = tmpfile();

	fileName = (char *)malloc(strlen(infileName)*sizeof(char));
	strcpy(fileName,infileName);
	printf("outputfilename: %s\n",fileName);
	
	counter = 0;
	totalCount = 0;
}

MatWvOut :: ~MatWvOut()
{
    MY_FLOAT temp;
    MATFile *fd;
    Matrix *mat;
	int len,i;

    rewind(tmpFile);
	printf("writing mat file: %s\n",fileName);
    fd = matOpen(fileName,"w");
    if (!fd)   {
		printf("Couldn't create matfile %s  !!!!!!!!\n",fileName);
		exit(0);
    }
	mat = mxCreateFull(1,totalCount,REAL); /*Stereo?????*/

/* copy from tempFile into mat */
	fread(mxGetPr(mat),sizeof(double),(size_t)totalCount,tmpFile);
	
	len = strlen(fileName);
	for (i=0; i<len; i++)
		if (fileName[i]=='.') fileName[i]=0;
	mxSetName(mat,fileName);
	matPutMatrix(fd,mat);
    matClose(fd);
	fclose(tmpFile);
	mxFreeMatrix(mat);
	free(fileName);

    temp = (double) totalCount * ONE_OVER_SRATE;
    printf("%f Seconds Computed\n",temp);
    counter = 0;
    totalCount = 0;
}

long MatWvOut :: getCounter()
{
    return totalCount;
}

void MatWvOut :: tick(MY_FLOAT sample)
{
    data[counter++] = (double)(sample);
    totalCount += 1;
    if (counter >= MAT_BUFFER_SIZE) {
		fwrite(data,sizeof(double),MAT_BUFFER_SIZE,tmpFile);
		counter = 0;
    }
}

