#include "QJTrackScore.h"
#include "QJDrawComponents.h"
#include "QJScorePainter.h"

#include "jam/JScoreNotator.h"
#include "jam/JTrack.h"
#include "rep/JStave.h"
#include "jam/JStaveToY.h"
#include "jam/JBeatToX.h"
#include "jam/JFocus.h"
#include "jam/JCursor.h"
#include "jam/JContext.h"
#include "rep/JLRRep.h"

QJTrackScore::QJTrackScore(JBeatToX *beatToX,
			   JContext *context,
			   QWidget *parent,
			   const char *name)
  : QWidget(parent,name),
    _painter(0),
    _track(0),
    _stave(0),
    _beatToX(beatToX),
    _staveToY(0),
    _context(context)
{
  setBackgroundMode(NoBackground);
  setFocusPolicy(QWidget::StrongFocus);    
}

QJTrackScore::~QJTrackScore()
{
   if (_staveToY != 0)  delete _staveToY;
   if (_painter != 0) delete _painter;
   if (_stave != 0) delete _stave;
}

void
QJTrackScore::setTrack(const JTrack *track)
{

  if (_track == track) return;
  _track    = track;

  if (_stave) delete _stave;
  _stave    = 0;
  
  if (_staveToY) delete _staveToY;
  _staveToY = 0;
  
  if (_painter) delete _painter;
  _painter = 0;

  if (track == 0) {
    _pixmap.fill();
    return;
  }

  QJDrawComponents *components=QJDrawComponents::the();

  _stave   = new JStave(_track->staveType());

  _staveToY = new JStaveToY(components->lineSpace(),
			    _stave->firstLine(),
			    y(),
			    height());

  _painter = new QJScorePainter( this,
				 &_pixmap,
				 _stave,
				 _beatToX,
				 _staveToY,
				 components);

}


void 
QJTrackScore::rebuild()
{

  if ( _track == 0 )  return;

  update(_beatToX->lrRep());

}

void
QJTrackScore::assertCursor()
{
  if (!_painter) return;
  if (_context->cursor()->isVisible()) {
    _painter->setCursorAt(_context->cursor()->beat(),
			  _context->cursor()->pitch());
    _painter->cursorOn(true);
  } else {
    _painter->cursorOn(false);
  }
}

void 
QJTrackScore::update(JLRRep lr)
{

  if ( _track == 0 )  return;

  JLRRep lrUpdate=intersect(lr,_beatToX->lrRep());

  JScoreNotator notator(_painter,_context,lrUpdate);
  notator.notateTrack(_track);

  _painter->update();

  assertCursor();

}




void
QJTrackScore::resizeEvent(QResizeEvent *event)
{

  //  debug(" QJTrackScore resize ");

  _pixmap.resize(event->size());

  if ( _track != 0 ) {
    _staveToY->set(y(),height());
    rebuild();
  } else {
    _pixmap.fill();
  }

}


void 
QJTrackScore::paintEvent(QPaintEvent *event)
{
  const QRect &rect=event->rect();
  //  debug(" QJTrackScore  paint %d %d %d %d ",rect.x(),rect.y(),rect.width(),rect.height());
  
  if (_painter != 0) {
    _painter->update();
  }
  
  bitBlt(this,rect.x(),rect.y(),&_pixmap,rect.x(),rect.y(),rect.width(),rect.height(),CopyROP);


  if (_painter != 0) {
    _painter->assertCursor();
  }


}



void
QJTrackScore::mousePressEvent(QMouseEvent *e)
{
  emit aMousePressEvent(e);
}

void
QJTrackScore::keyPressEvent(QKeyEvent *e)
{
  debug("QJTrackScore:keyPress");
  emit aKeyPressEvent(e);
}

void
QJTrackScore::mouseReleaseEvent(QMouseEvent *e)
{
  emit aMouseReleaseEvent(e);
}

void
QJTrackScore::mouseMoveEvent(QMouseEvent *e)
{
  emit aMouseMoveEvent(e);
}





