#ifndef _QJTrackItem_H
#define _QJTrackItem_H

#include <qlistview.h>


class JTrack;
class JContext;


class QJTrackItem: public QObject,
		   public QListViewItem
{
  Q_OBJECT
public:
  QJTrackItem( QListViewItem * parent , JTrack * , JContext * _context);

  QJTrackItem( QListView * parent , JTrack * , JContext * _context);

  ~QJTrackItem();  
  const char * text( int column ) const;

  JTrack * track() { return _track;}
  QString fullName();

  void cycleSelectedColumn(int jmp);

  void selectColumn(int col) { _columnSelected=col; }

  //
  void setOpen( bool );
  void setup();
  void activate();

  void paintCell(QPainter * p,
		const QColorGroup & cg, 
		int col, int w , int align);

private:

  JTrack *   _track;
  JContext * _context;
  int        _columnSelected;
//   bool       _mute;
//   bool       _solo;

};

#endif







