#ifndef _QJPhraseLoopWidget
#define _QJPhraseLoopWidget

#include <qwidget.h>
#include "base/JOSTemplate.h"
#include "jam/JBPT.h"

class JFocus;
class JContext;
class JBPT;
class QJBPTWidget;
class QSpinBox;

class QJPhraseLoopWidget:public QWidget,
			 public JObserver<const JFocus *,void>,
			 public JObserver<const JBPT *,void>
{
Q_OBJECT
public:
  QJPhraseLoopWidget(QWidget *parent,JContext *context);
  ~QJPhraseLoopWidget(){;}
  void handle(const JFocus *focus);
  void handle(const JBPT   *bpt);

  public slots:
  void valueChanged(int);
  void updatePhrase();
  const char *name() const { return QWidget::name(); }
private:

  void          rebuild();
  JContext *   _context;
  JBPT         _leftBPT;
  JBPT         _rightBPT;
  QJBPTWidget *       _left;
  QJBPTWidget *       _right;
  QSpinBox *          _loop;

};



#endif
