#include "JMidiFileProcessor.h"

JMidiFileProcessor::JMidiFileProcessor(const char *filename)
{

	FILE *fp;
	MidiEvent *ev;
	int piped;
	int i, cp;

	output_flags = 0;
	memcpy(&glinfo, &gl_default, sizeof(glinfo));
	glinfo.chorus = glinfo.reverb = -1; /* uninitialized */

	if ((fp = CmpOpenFile(filename, &piped)) == NULL) {
		fprintf(stderr, "can't open midi file %s\n", argv[optind]);
		exit(1);
	}

	ev = ReadMidiFile(fp, &glinfo);
	if (ev == NULL) return FALSE;

	printf("#midievents %d\n", glinfo.nlists);
	printf("#drumflag 0x%x\n", glinfo.drumflag);
	printf("#midimode %d\n", glinfo.midi_mode);
	printf("#multipart %d\n", glinfo.multi_part);

	if (glinfo.chorus >= 0)
		printf("#chorus %d\n", glinfo.chorus);
	if (glinfo.reverb >= 0)
		printf("#reverb %d\n", glinfo.reverb);
	if (glinfo.nlists > 0)
		printf("#totaltime %d\n", ev[glinfo.nlists-1].csec);
	else
		printf("#totaltime 0\n");

}

bool 
JMidiFileProcessor::processFile()
{

	initialize();

	for (i = 0; i < glinfo.nlists; i++) {
	  processEvent(&ev[i]);
	}

}
