#include "JNoteShredder.h"


JNoteShredder::JNoteShredder(const JBeat &beat,const JDuration &duration)
  :_beat(beat),_duration(duration),_resolution(16),_done(false)
{
  _beat.quantize(_resolution);
}


bool 
JNoteShredder::next(JBeat &b,JDuration &d)
{
  if (_done) return false;

  b=_beat;
  d=JDuration(0,1,_resolution);

  int n = 2;

  while( JDuration(0,n,_resolution)  < _duration ) {
    n *= 2;
  }

  d = JDuration(0,n,_resolution);
  _beat += d;
  _duration -= d;
  
  if (_duration < d) _done=true;
  return true;
}
